/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.print.Legend;
import nl.b3p.viewer.print.PrintExtraInfo;
import nl.b3p.viewer.print.PrintInfo;
import nl.b3p.viewer.stripes.CombineImageActionBean;
import nl.b3p.viewer.stripes.PrintActionBean;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/print")
@StrictBinding
public class PrintActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(PrintActionBean.class);
    protected static Logger fopLogger = Logger.getLogger((String)"org.apache.fop");
    public static final String A5_Landscape = "A5_Landscape.xsl";
    public static final String A5_Portrait = "A5_Portrait.xsl";
    public static final String A4_Landscape = "A4_Landscape.xsl";
    public static final String A4_Portrait = "A4_Portrait.xsl";
    public static final String A3_Landscape = "A3_Landscape.xsl";
    public static final String A3_Portrait = "A3_Portrait.xsl";
    public static final String A0_Landscape = "A0_Landscape.xsl";
    public static final String A0_Portrait = "A0_Portrait.xsl";
    public static final String DEFAULT_TEMPLATE_PATH = "/WEB-INF/xsl/print/";
    public static final String A5 = "a5";
    public static final String A4 = "a4";
    public static final String A3 = "a3";
    public static final String A0 = "a0";
    public static final String LANDSCAPE = "landscape";
    public static final String PORTRAIT = "portrait";
    public static SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy", new Locale("NL"));
    @Validate
    private String params;
    private ActionBeanContext context;

    @DefaultHandler
    public Resolution print() throws JSONException, Exception {
        String templateUrl;
        String mimeType;
        boolean mailprint = false;
        JSONObject jRequest = new JSONObject(this.params);
        Long appId = jRequest.optLong("appId");
        Application app = (Application)Stripersist.getEntityManager().find(Application.class, (Object)appId);
        String imageUrl = this.getImageUrl(this.params);
        PrintInfo info = new PrintInfo();
        if (jRequest.has("title")) {
            info.setTitle(jRequest.getString("title"));
        }
        if (jRequest.has("subtitle")) {
            info.setSubtitle(jRequest.getString("subtitle"));
        }
        info.setDate(df.format(new Date()));
        info.setImageUrl(imageUrl);
        if (jRequest.has("bbox")) {
            info.setBbox(jRequest.getString("bbox"));
        }
        if (jRequest.has("overview")) {
            String url = this.getOverviewUrl(this.params);
            info.setOverviewUrl(url);
        }
        if (jRequest.has("extraTekst")) {
            info.setRemark(jRequest.getString("extraTekst"));
        }
        if (jRequest.has("quality")) {
            info.setQuality(jRequest.getInt("quality"));
        }
        if (jRequest.has("includeLegend") && jRequest.getBoolean("includeLegend")) {
            if (jRequest.has("legendUrl")) {
                JSONArray jarray = null;
                Object o = jRequest.get("legendUrl");
                if (o instanceof JSONArray) {
                    jarray = (JSONArray)o;
                } else if (o instanceof String) {
                    jarray = new JSONArray();
                    jarray.put(o);
                }
                for (int i = 0; i < jarray.length(); ++i) {
                    JSONObject legendJson;
                    try {
                        legendJson = jarray.getJSONObject(i);
                    }
                    catch (JSONException jse) {
                        legendJson = new JSONObject(jarray.getString(i));
                    }
                    Legend legend = new Legend(legendJson);
                    info.getLegendUrls().add(legend);
                }
            }
            info.cacheLegendImagesAndReadDimensions();
        }
        if (jRequest.has("angle")) {
            int angle = jRequest.getInt("angle");
            angle %= 360;
            angle = 360 - angle;
            info.setAngle(angle);
        }
        if (jRequest.has("action") && jRequest.getString("action").equalsIgnoreCase("savePDF")) {
            mimeType = "application/pdf";
        } else if (jRequest.has("action") && jRequest.getString("action").equalsIgnoreCase("mailPDF")) {
            mimeType = "application/pdf";
            mailprint = true;
        } else {
            throw new Exception("Unidentified action: " + jRequest.getString("action"));
        }
        if (jRequest.has("extra")) {
            log.debug((Object)"Print Parse 'extra'");
            JSONArray jarray = jRequest.getJSONArray("extra");
            ArrayList<PrintExtraInfo> peis = new ArrayList<PrintExtraInfo>();
            for (int i = 0; i < jarray.length(); ++i) {
                JSONObject extraObj = jarray.getJSONObject(i);
                PrintExtraInfo pei = new PrintExtraInfo();
                String className = extraObj.getString("className");
                String componentName = extraObj.getString("componentName");
                JSONObject infoString = extraObj.getJSONObject("info");
                pei.setClassName(className);
                pei.setComponentName(componentName);
                pei.setInfoText(infoString);
                peis.add(pei);
            }
            info.setExtra(peis);
        }
        String pageFormat = jRequest.has("pageformat") ? jRequest.getString("pageformat") : A4;
        String orientation = jRequest.has("orientation") ? jRequest.getString("orientation") : PORTRAIT;
        String xsltemplate = jRequest.has("xsltemplate") ? jRequest.getString("xsltemplate") : null;
        String templateName = xsltemplate != null ? xsltemplate : this.getTemplateName(pageFormat, orientation);
        boolean useMailer = mailprint;
        if (app != null && app.getDetails() != null && app.getDetails().get("stylesheetPrint") != null) {
            ClobElement ce = (ClobElement)app.getDetails().get("stylesheetPrint");
            templateUrl = ce.getValue() + templateName;
        } else {
            templateUrl = this.context.getServletContext().getRealPath(DEFAULT_TEMPLATE_PATH + templateName);
        }
        String toMail = jRequest.getString("mailTo");
        String fromMail = jRequest.has("fromAddress") ? jRequest.getString("fromAddress") : "";
        String fromName = jRequest.has("fromName") ? jRequest.getString("fromName") : "";
        1 res = new /* Unavailable Anonymous Inner Class!! */;
        return res;
    }

    private String getOverviewUrl(String params) throws JSONException, Exception {
        JSONObject info = new JSONObject(params);
        info.remove("requests");
        info.remove("geometries");
        info.remove("quality");
        JSONObject overview = info.getJSONObject("overview");
        info.put("bbox", overview.get("extent"));
        JSONArray reqs = new JSONArray();
        JSONObject image = new JSONObject();
        image.put("protocol", (Object)overview.optString("protocol", "WMS"));
        image.put("url", overview.get("overviewUrl"));
        image.put("extent", overview.get("extent"));
        reqs.put((Object)image);
        info.put("requests", (Object)reqs);
        String overviewUrl = this.getImageUrl(info.toString());
        return overviewUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getImageUrl(String param) throws Exception {
        RedirectResolution cia = new RedirectResolution(CombineImageActionBean.class);
        RedirectResolution pa = new RedirectResolution(PrintActionBean.class);
        String url = this.context.getRequest().getRequestURL().toString();
        url = url.replace(pa.getUrl(new Locale("NL")), cia.getUrl(new Locale("NL")));
        HttpClient client = new HttpClient();
        PostMethod method = null;
        try {
            method = new PostMethod(url);
            method.addParameter("params", param);
            method.addParameter("JSESSIONID", this.context.getRequest().getSession().getId());
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                throw new Exception("Error connecting to server. HTTP status code: " + statusCode);
            }
            JSONObject response = new JSONObject(method.getResponseBodyAsString());
            if (!response.getBoolean("success")) {
                throw new Exception("Error getting image: " + response.getString("error"));
            }
            String string = response.getString("imageUrl");
            return string;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private String getTemplateName(String pageFormat, String orientation) {
        if (A5.equalsIgnoreCase(pageFormat) && LANDSCAPE.equalsIgnoreCase(orientation)) {
            return A5_Landscape;
        }
        if (A5.equalsIgnoreCase(pageFormat) && PORTRAIT.equalsIgnoreCase(orientation)) {
            return A5_Portrait;
        }
        if (A4.equalsIgnoreCase(pageFormat) && LANDSCAPE.equalsIgnoreCase(orientation)) {
            return A4_Landscape;
        }
        if (A3.equalsIgnoreCase(pageFormat) && PORTRAIT.equalsIgnoreCase(orientation)) {
            return A3_Portrait;
        }
        if (A3.equalsIgnoreCase(pageFormat) && LANDSCAPE.equalsIgnoreCase(orientation)) {
            return A3_Landscape;
        }
        if (A0.equalsIgnoreCase(pageFormat) && PORTRAIT.equalsIgnoreCase(orientation)) {
            return A0_Portrait;
        }
        if (A0.equalsIgnoreCase(pageFormat) && LANDSCAPE.equalsIgnoreCase(orientation)) {
            return A0_Landscape;
        }
        return A4_Portrait;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    private String printInfoToString(PrintInfo info) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{PrintInfo.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter sw = new StringWriter();
        m.marshal((Object)info, (Writer)sw);
        String s = sw.toString();
        return s;
    }

    static /* synthetic */ ActionBeanContext access$000(PrintActionBean x0) {
        return x0.context;
    }

    static /* synthetic */ Log access$100() {
        return log;
    }
}

