/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.util;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.app.ConfiguredAttribute;
import nl.b3p.viewer.config.services.AttributeDescriptor;
import nl.b3p.viewer.config.services.FeatureTypeRelation;
import nl.b3p.viewer.config.services.FeatureTypeRelationKey;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.ibis.util.WorkflowStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.SortedSimpleFeatureCollection;
import org.geotools.filter.text.cql2.CQL;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public class IbisFeatureToJson {
    private static final Log LOG = LogFactory.getLog(IbisFeatureToJson.class);
    public static final int MAX_FEATURES = 1000;
    private boolean arrays = false;
    private boolean edit = false;
    private boolean graph = false;
    private boolean aliases = true;
    private List<Long> attributesToInclude = new ArrayList();
    private static final int TIMEOUT = 5000;
    HashMap<Long, List<String>> propertyNamesQueryCache = new HashMap();
    HashMap<Long, Boolean> haveInvisiblePropertiesCache = new HashMap();
    HashMap<Long, List<String>> propertyNamesReturnCache = new HashMap();
    private final DateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");

    public IbisFeatureToJson(boolean arrays, boolean edit, boolean graph, List<Long> attributesToInclude) {
        this.arrays = arrays;
        this.edit = edit;
        this.graph = graph;
        this.attributesToInclude = attributesToInclude;
    }

    public IbisFeatureToJson(boolean arrays, boolean edit, boolean graph, boolean aliases, List<Long> attributesToInclude) {
        this.arrays = arrays;
        this.edit = edit;
        this.graph = graph;
        this.attributesToInclude = attributesToInclude;
        this.aliases = aliases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray getWorkflowJSONFeatures(ApplicationLayer al, SimpleFeatureType ft, FeatureSource fs, Query q) throws IOException, JSONException, Exception {
        boolean offsetSupported;
        List<String> propertyNames;
        LOG.debug((Object)("Ophalen workflow json features met query: " + q));
        Filter f = q.getFilter();
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        f = ff.and(f, (Filter)ff.or((Filter)ff.equal((Expression)ff.property("workflow_status"), (Expression)ff.literal((Object)WorkflowStatus.definitief.name()), false), (Filter)ff.equal((Expression)ff.property("workflow_status"), (Expression)ff.literal((Object)WorkflowStatus.bewerkt.name()), false)));
        q.setFilter(f);
        q.setMaxFeatures(2 * q.getMaxFeatures());
        LOG.debug((Object)("Ophalen workflow json features met aangepaste query: " + q));
        HashMap<String, String> attributeAliases = new HashMap<String, String>();
        if (!this.edit) {
            for (AttributeDescriptor ad : ft.getAttributes()) {
                if (ad.getAlias() == null) continue;
                attributeAliases.put(ad.getName(), ad.getAlias());
            }
        }
        if (al != null) {
            propertyNames = this.setPropertyNames(al, q, ft, this.edit);
        } else {
            propertyNames = new ArrayList();
            for (AttributeDescriptor ad : ft.getAttributes()) {
                propertyNames.add(ad.getName());
            }
        }
        boolean shouldRemoveID_FIELDbeforeJSONify = false;
        if (!propertyNames.contains("ibis_id")) {
            shouldRemoveID_FIELDbeforeJSONify = propertyNames.add("ibis_id");
        }
        q.setPropertyNames(propertyNames);
        Integer start = q.getStartIndex();
        if (start == null) {
            start = 0;
        }
        if (!(offsetSupported = fs.getQueryCapabilities().isOffsetSupported()) && q.getMaxFeatures() < 1000) {
            q.setMaxFeatures(q.getMaxFeatures() + start);
        }
        JSONArray features = new JSONArray();
        try {
            SimpleFeatureCollection feats = (SimpleFeatureCollection)fs.getFeatures(q);
            Function uniq = ff.function("Collection_Unique", new Expression[]{ff.property("ibis_id")});
            Set idlist = (Set)uniq.evaluate((Object)feats);
            DefaultFeatureCollection inMem = DataUtilities.collection((FeatureCollection)feats);
            ArrayList<SimpleFeature> actueel = new ArrayList<SimpleFeature>();
            SortBy[] sortBy = new SortBy[]{ff.sort("workflow_status", SortOrder.ASCENDING), ff.sort("datummutatie", SortOrder.DESCENDING)};
            if (idlist != null && idlist.size() > 0) {
                for (Object id : idlist) {
                    And filter = ff.and((Filter)ff.equals((Expression)ff.property("ibis_id"), (Expression)ff.literal(id)), (Filter)ff.or((Filter)ff.equal((Expression)ff.property("workflow_status"), (Expression)ff.literal((Object)WorkflowStatus.definitief.name()), false), (Filter)ff.equal((Expression)ff.property("workflow_status"), (Expression)ff.literal((Object)WorkflowStatus.bewerkt.name()), false)));
                    SortedSimpleFeatureCollection sorted = new SortedSimpleFeatureCollection(inMem.subCollection((Filter)filter), sortBy);
                    LOG.debug((Object)("aantal gevonden: " + sorted.size()));
                    if (LOG.isDebugEnabled()) {
                        SimpleFeatureIterator sfi = sorted.features();
                        while (sfi.hasNext()) {
                            LOG.debug((Object)("gevonden feature: " + sfi.next()));
                        }
                    }
                    SimpleFeature actFeat = (SimpleFeature)DataUtilities.first((FeatureCollection)sorted);
                    LOG.debug((Object)("actuele feature: " + actFeat));
                    if (actFeat == null) continue;
                    actueel.add(actFeat);
                }
                int featureIndex = 0;
                if (shouldRemoveID_FIELDbeforeJSONify) {
                    propertyNames.remove("ibis_id");
                }
                for (SimpleFeature feature : actueel) {
                    if (offsetSupported || featureIndex >= start) {
                        JSONObject j = this.toJSONFeature(new JSONObject(), feature, ft, al, propertyNames, attributeAliases, 0);
                        features.put((Object)j);
                    }
                    ++featureIndex;
                }
            }
        }
        finally {
            fs.getDataStore().dispose();
        }
        return features;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray getDefinitiefJSONFeatures(ApplicationLayer al, SimpleFeatureType ft, FeatureSource fs, Query q) throws IOException, JSONException, Exception {
        boolean offsetSupported;
        List<String> propertyNames;
        LOG.debug((Object)("Ophalen definitief json features met: " + q));
        HashMap<String, String> attributeAliases = new HashMap<String, String>();
        if (!this.edit) {
            for (AttributeDescriptor ad : ft.getAttributes()) {
                if (ad.getAlias() == null) continue;
                attributeAliases.put(ad.getName(), ad.getAlias());
            }
        }
        if (al != null) {
            propertyNames = this.setPropertyNames(al, q, ft, this.edit);
        } else {
            propertyNames = new ArrayList();
            for (AttributeDescriptor ad : ft.getAttributes()) {
                propertyNames.add(ad.getName());
            }
        }
        Integer start = q.getStartIndex();
        if (start == null) {
            start = 0;
        }
        if (!(offsetSupported = fs.getQueryCapabilities().isOffsetSupported()) && q.getMaxFeatures() < 1000) {
            q.setMaxFeatures(q.getMaxFeatures() + start);
        }
        JSONArray features = new JSONArray();
        try {
            SimpleFeatureCollection feats = (SimpleFeatureCollection)fs.getFeatures(q);
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
            PropertyIsEqualTo definitief = ff.equal((Expression)ff.property("workflow_status"), (Expression)ff.literal((Object)WorkflowStatus.definitief.name()), false);
            DefaultFeatureCollection defSFC = DataUtilities.collection((FeatureCollection)feats.subCollection((Filter)definitief));
            int featureIndex = 0;
            try (SimpleFeatureIterator defs = defSFC.features();){
                while (defs.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)defs.next();
                    if (offsetSupported || featureIndex >= start) {
                        JSONObject j = this.toJSONFeature(new JSONObject(), feature, ft, al, propertyNames, attributeAliases, 0);
                        features.put((Object)j);
                    }
                    ++featureIndex;
                }
            }
        }
        finally {
            fs.getDataStore().dispose();
        }
        return features;
    }

    private JSONObject toJSONFeature(JSONObject j, SimpleFeature f, SimpleFeatureType ft, ApplicationLayer al, List<String> propertyNames, Map<String, String> attributeAliases, int index) throws JSONException, Exception {
        if (this.arrays) {
            for (String name : propertyNames) {
                Object value = f.getAttribute(name);
                j.put("c" + index++, this.formatValue(value));
            }
        } else {
            for (String name : propertyNames) {
                if (!this.aliases) {
                    j.put(name, this.formatValue(f.getAttribute(name)));
                    continue;
                }
                String alias = null;
                if (attributeAliases != null) {
                    alias = attributeAliases.get(name);
                }
                j.put(alias != null ? alias : name, this.formatValue(f.getAttribute(name)));
            }
        }
        if (j.optString("__fid", null) == null) {
            String id = f.getID();
            j.put("__fid", (Object)id);
        }
        if (ft.hasRelations()) {
            j = this.populateWithRelatedFeatures(j, f, ft, al, index);
        }
        return j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject populateWithRelatedFeatures(JSONObject j, SimpleFeature feature, SimpleFeatureType ft, ApplicationLayer al, int index) throws Exception {
        if (ft.hasRelations()) {
            JSONArray related_featuretypes = new JSONArray();
            for (FeatureTypeRelation rel : ft.getRelations()) {
                boolean isJoin = rel.getType().equals("join");
                if (isJoin) {
                    FeatureSource foreignFs = rel.getForeignFeatureType().openGeoToolsFeatureSource(5000);
                    FeatureIterator foreignIt = null;
                    try {
                        List<String> propertyNames;
                        Query foreignQ = new Query(foreignFs.getName().toString());
                        Filter filter = this.createFilter(feature, rel);
                        if (filter == null) continue;
                        foreignQ.setMaxFeatures(1);
                        foreignQ.setFilter(filter);
                        if (al != null) {
                            propertyNames = this.setPropertyNames(al, foreignQ, rel.getForeignFeatureType(), this.edit);
                        } else {
                            propertyNames = new ArrayList();
                            for (Object ad : rel.getForeignFeatureType().getAttributes()) {
                                propertyNames.add(ad.getName());
                            }
                        }
                        if (propertyNames.isEmpty()) continue;
                        HashMap<String, String> attributeAliases = new HashMap<String, String>();
                        if (!this.edit) {
                            Object ad;
                            ad = rel.getForeignFeatureType().getAttributes().iterator();
                            while (ad.hasNext()) {
                                AttributeDescriptor ad2 = (AttributeDescriptor)ad.next();
                                if (ad2.getAlias() == null) continue;
                                attributeAliases.put(ad2.getName(), ad2.getAlias());
                            }
                        }
                        foreignIt = foreignFs.getFeatures(foreignQ).features();
                        while (foreignIt.hasNext()) {
                            SimpleFeature foreignFeature = (SimpleFeature)foreignIt.next();
                            j = this.toJSONFeature(j, foreignFeature, rel.getForeignFeatureType(), al, propertyNames, attributeAliases, index);
                        }
                        continue;
                    }
                    finally {
                        if (foreignIt != null) {
                            foreignIt.close();
                        }
                        foreignFs.getDataStore().dispose();
                        continue;
                    }
                }
                Filter filter = this.createFilter(feature, rel);
                if (filter == null) continue;
                JSONObject related_ft = new JSONObject();
                related_ft.put("filter", (Object)CQL.toCQL((Filter)filter));
                related_ft.put("id", (Object)rel.getForeignFeatureType().getId());
                related_featuretypes.put((Object)related_ft);
            }
            if (related_featuretypes.length() > 0) {
                j.put("related_featuretypes", (Object)related_featuretypes);
            }
        }
        return j;
    }

    private List<String> setPropertyNames(ApplicationLayer appLayer, Query q, SimpleFeatureType sft, boolean edit) {
        ArrayList<String> propertyNames = new ArrayList<String>();
        boolean haveInvisibleProperties = false;
        if (this.propertyNamesQueryCache.containsKey(sft.getId())) {
            haveInvisibleProperties = (Boolean)this.haveInvisiblePropertiesCache.get(sft.getId());
            if (haveInvisibleProperties) {
                q.setPropertyNames((List)this.propertyNamesQueryCache.get(sft.getId()));
            }
            return (List)this.propertyNamesReturnCache.get(sft.getId());
        }
        for (ConfiguredAttribute ca : appLayer.getAttributes(sft)) {
            if (!edit && !this.graph && ca.isVisible() || edit && ca.isEditable() || this.graph && this.attributesToInclude.contains(ca.getId())) {
                propertyNames.add(ca.getAttributeName());
                continue;
            }
            haveInvisibleProperties = true;
        }
        this.haveInvisiblePropertiesCache.put(sft.getId(), haveInvisibleProperties);
        this.propertyNamesReturnCache.put(sft.getId(), propertyNames);
        this.propertyNamesQueryCache.put(sft.getId(), propertyNames);
        if (haveInvisibleProperties) {
            q.setPropertyNames(propertyNames);
            if (sft.getRelations() != null) {
                ArrayList<String> withRelations = new ArrayList<String>();
                withRelations.addAll(propertyNames);
                for (FeatureTypeRelation ftr : sft.getRelations()) {
                    if (ftr.getRelationKeys() == null) continue;
                    for (FeatureTypeRelationKey key : ftr.getRelationKeys()) {
                        if (withRelations.contains(key.getLeftSide().getName())) continue;
                        withRelations.add(key.getLeftSide().getName());
                    }
                }
                this.propertyNamesQueryCache.put(sft.getId(), withRelations);
                q.setPropertyNames(withRelations);
            }
        }
        this.propertyNamesReturnCache.put(sft.getId(), propertyNames);
        return propertyNames;
    }

    private Object formatValue(Object value) {
        if (value instanceof Date) {
            return this.dateFormat.format((Date)value);
        }
        return value;
    }

    private Filter createFilter(SimpleFeature feature, FeatureTypeRelation rel) {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        ArrayList<Object> filters = new ArrayList<Object>();
        for (FeatureTypeRelationKey key : rel.getRelationKeys()) {
            AttributeDescriptor rightSide = key.getRightSide();
            AttributeDescriptor leftSide = key.getLeftSide();
            Object value = feature.getAttribute(leftSide.getName());
            if (value == null) continue;
            if (AttributeDescriptor.GEOMETRY_TYPES.contains(rightSide.getType()) && AttributeDescriptor.GEOMETRY_TYPES.contains(leftSide.getType())) {
                filters.add(ff.not((Filter)ff.isNull((Expression)ff.property(rightSide.getName()))));
                filters.add(ff.intersects((Expression)ff.property(rightSide.getName()), (Expression)ff.literal(value)));
                continue;
            }
            filters.add(ff.equals((Expression)ff.property(rightSide.getName()), (Expression)ff.literal(value)));
        }
        if (filters.size() > 1) {
            return ff.and(filters);
        }
        if (filters.size() == 1) {
            return (Filter)filters.get(0);
        }
        return null;
    }
}

