/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.image;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import nl.b3p.viewer.image.Bbox;
import nl.b3p.viewer.image.CombineArcServerUrl;
import nl.b3p.viewer.image.CombineImageUrl;
import nl.b3p.viewer.image.CombineXMLBodyUrl;
import nl.b3p.viewer.image.ImageBbox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CombineArcIMSUrl
extends CombineXMLBodyUrl {
    private static final Log log = LogFactory.getLog(CombineArcServerUrl.class);
    private static XPathExpression xPathEnvelope;
    private static XPathExpression xPathImageSize;

    public CombineArcIMSUrl() {
    }

    private CombineArcIMSUrl(CombineArcIMSUrl caiu) {
        super((CombineXMLBodyUrl)caiu);
    }

    public List<CombineImageUrl> calculateNewUrl(ImageBbox bbox) {
        Integer width = bbox.getWidth();
        Integer height = bbox.getHeight();
        Bbox bb = bbox.getBbox();
        CombineArcIMSUrl ciu = new CombineArcIMSUrl(this);
        try {
            Document doc = this.bodyAsDocument();
            Node root = doc.getFirstChild();
            Node envelope = (Node)xPathEnvelope.evaluate(root, XPathConstants.NODE);
            NamedNodeMap nnm = envelope.getAttributes();
            nnm.getNamedItem("minx").setNodeValue("" + bb.getMinx());
            nnm.getNamedItem("maxx").setNodeValue("" + bb.getMaxx());
            nnm.getNamedItem("miny").setNodeValue("" + bb.getMiny());
            nnm.getNamedItem("maxy").setNodeValue("" + bb.getMaxy());
            Node imageSize = (Node)xPathImageSize.evaluate(root, XPathConstants.NODE);
            nnm = imageSize.getAttributes();
            nnm.getNamedItem("width").setNodeValue(width.toString());
            nnm.getNamedItem("height").setNodeValue(height.toString());
            ciu.setBody(doc);
        }
        catch (Exception e) {
            log.warn((Object)"Error while changing body fragment", (Throwable)e);
        }
        ArrayList<CombineImageUrl> list = new ArrayList<CombineImageUrl>();
        list.add((CombineImageUrl)ciu);
        return list;
    }

    static {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        try {
            xPathEnvelope = xPath.compile("//ENVELOPE");
            xPathImageSize = xPath.compile("//IMAGESIZE");
        }
        catch (Exception ex) {
            log.error((Object)"Error while creating xpath expr", (Throwable)ex);
        }
    }
}

