/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.ibis.util.IbisConstants;
import nl.b3p.viewer.ibis.util.WorkflowStatus;
import nl.b3p.viewer.ibis.util.WorkflowUtil;
import nl.b3p.viewer.stripes.EditFeatureActionBean;
import nl.b3p.viewer.stripes.IbisEditFeatureActionBean;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.identity.FeatureIdImpl;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.identity.FeatureId;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/feature/ibisedit")
@StrictBinding
public class IbisEditFeatureActionBean
extends EditFeatureActionBean
implements IbisConstants {
    private static final Log log = LogFactory.getLog(IbisEditFeatureActionBean.class);

    protected String addNewFeature() throws Exception {
        String kavelID = super.addNewFeature();
        String terreinID = this.getJsonFeature().optString("terreinid", null);
        WorkflowStatus status = WorkflowStatus.valueOf((String)this.getJsonFeature().optString("workflow_status", WorkflowStatus.bewerkt.name()));
        if (terreinID != null) {
            WorkflowUtil.updateTerreinGeometry((Integer)Integer.parseInt(terreinID.toString()), (Layer)this.getLayer(), (WorkflowStatus)status, (Application)this.getApplication(), (EntityManager)Stripersist.getEntityManager());
        }
        return kavelID;
    }

    protected void deleteFeature(String fid) throws IOException, Exception {
        log.debug((Object)("ibis deleteFeature: " + fid));
        DefaultTransaction transaction = new DefaultTransaction("ibis_delete");
        this.getStore().setTransaction((Transaction)transaction);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        Id filter = ff.id(new FeatureId[]{new FeatureIdImpl(fid)});
        try {
            this.getStore().modifyFeatures("workflow_status", (Object)WorkflowStatus.afgevoerd, (Filter)filter);
            SimpleFeature original = (SimpleFeature)this.getStore().getFeatures((Filter)filter).features().next();
            transaction.commit();
            Object terreinID = original.getAttribute("terreinid");
            if (terreinID != null) {
                WorkflowUtil.updateTerreinGeometry((Integer)Integer.parseInt(terreinID.toString()), (Layer)this.getLayer(), (WorkflowStatus)WorkflowStatus.afgevoerd, (Application)this.getApplication(), (EntityManager)Stripersist.getEntityManager());
            }
        }
        catch (Exception e) {
            transaction.rollback();
            throw e;
        }
        finally {
            transaction.close();
        }
    }

    protected void editFeature(String fid) throws Exception {
        log.debug((Object)("ibis editFeature:" + fid));
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        Id fidFilter = ff.id(new FeatureId[]{new FeatureIdImpl(fid)});
        ArrayList<String> attributes = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        WorkflowStatus incomingWorkflowStatus = null;
        Iterator it = this.getJsonFeature().keys();
        while (it.hasNext()) {
            String attribute = (String)it.next();
            if (this.getFID().equals(attribute)) continue;
            AttributeDescriptor ad = ((SimpleFeatureType)this.getStore().getSchema()).getDescriptor(attribute);
            if (ad != null) {
                if (!this.isAttributeUserEditingDisabled(attribute)) {
                    attributes.add(attribute);
                    if (ad.getType() instanceof GeometryType) {
                        String wkt = this.getJsonFeature().getString(ad.getLocalName());
                        Geometry g = null;
                        if (wkt != null) {
                            g = new WKTReader().read(wkt);
                        }
                        values.add(g);
                        continue;
                    }
                    String v = this.getJsonFeature().getString(attribute);
                    values.add(StringUtils.defaultIfBlank((CharSequence)v, null));
                    if (!attribute.equals("workflow_status")) continue;
                    incomingWorkflowStatus = WorkflowStatus.valueOf((String)v);
                    continue;
                }
                log.info((Object)String.format("Attribute \"%s\" not user editable; ignoring", attribute));
                continue;
            }
            log.warn((Object)String.format("Attribute \"%s\" not in feature type; ignoring", attribute));
        }
        log.debug((Object)String.format("Modifying feature source #%d fid=%s, attributes=%s, values=%s", this.getLayer().getFeatureType().getId(), fid, ((Object)attributes).toString(), ((Object)values).toString()));
        DefaultTransaction editTransaction = new DefaultTransaction("ibis_edit");
        this.getStore().setTransaction((Transaction)editTransaction);
        try {
            if (incomingWorkflowStatus == null) {
                throw new IllegalArgumentException("Workflow status van edit feature is null, dit wordt niet ondersteund.");
            }
            SimpleFeature original = (SimpleFeature)this.getStore().getFeatures((Filter)fidFilter).features().next();
            Object terreinID = original.getAttribute("terreinid");
            WorkflowStatus originalWorkflowStatus = WorkflowStatus.valueOf((String)original.getAttribute("workflow_status").toString());
            SimpleFeature editedNewFeature = this.createCopy(original);
            for (int i = 0; i < attributes.size(); ++i) {
                editedNewFeature.setAttribute((String)attributes.get(i), values.get(i));
            }
            And definitief = ff.and((Filter)ff.equals((Expression)ff.property("ibis_id"), (Expression)ff.literal(original.getAttribute("ibis_id"))), (Filter)ff.equal((Expression)ff.property("workflow_status"), (Expression)ff.literal((Object)WorkflowStatus.definitief.name()), false));
            boolean definitiefExists = this.getStore().getFeatures((Filter)definitief).size() > 0;
            And bewerkt = ff.and((Filter)ff.equals((Expression)ff.property("ibis_id"), (Expression)ff.literal(original.getAttribute("ibis_id"))), (Filter)ff.equal((Expression)ff.property("workflow_status"), (Expression)ff.literal((Object)WorkflowStatus.bewerkt.name()), false));
            int aantalBewerkt = this.getStore().getFeatures((Filter)bewerkt).size();
            boolean bewerktExists = aantalBewerkt > 0;
            switch (1.$SwitchMap$nl$b3p$viewer$ibis$util$WorkflowStatus[incomingWorkflowStatus.ordinal()]) {
                case 1: {
                    if (originalWorkflowStatus.equals((Object)WorkflowStatus.definitief)) {
                        if (bewerktExists) {
                            this.getStore().removeFeatures((Filter)bewerkt);
                        }
                        this.getStore().addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)editedNewFeature));
                        break;
                    }
                    if (originalWorkflowStatus.equals((Object)WorkflowStatus.bewerkt)) {
                        if (aantalBewerkt > 1) {
                            log.error((Object)("Er is meer dan 1 bewerkt kavel/terrein voor ibis_id=" + original.getAttribute("ibis_id")));
                            this.getStore().modifyFeatures("workflow_status", (Object)WorkflowStatus.archief, (Filter)bewerkt);
                        }
                        this.getStore().modifyFeatures(attributes.toArray(new String[attributes.size()]), values.toArray(), (Filter)fidFilter);
                        break;
                    }
                    throw new IllegalArgumentException(String.format("Niet ondersteunde workflow stap van %s naar %s", originalWorkflowStatus.label(), incomingWorkflowStatus.label()));
                }
                case 2: {
                    if (definitiefExists) {
                        this.getStore().modifyFeatures("workflow_status", (Object)WorkflowStatus.archief, (Filter)definitief);
                    }
                    if (originalWorkflowStatus.equals((Object)WorkflowStatus.definitief)) {
                        this.getStore().addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)editedNewFeature));
                        break;
                    }
                    if (originalWorkflowStatus.equals((Object)WorkflowStatus.bewerkt)) {
                        this.getStore().modifyFeatures(attributes.toArray(new String[attributes.size()]), values.toArray(), (Filter)fidFilter);
                        break;
                    }
                    throw new IllegalArgumentException(String.format("Niet ondersteunde workflow stap van %s naar %s", originalWorkflowStatus.label(), incomingWorkflowStatus.label()));
                }
                case 3: {
                    if (definitiefExists) {
                        this.getStore().modifyFeatures("workflow_status", (Object)WorkflowStatus.archief, (Filter)definitief);
                    }
                    this.getStore().modifyFeatures(attributes.toArray(new String[attributes.size()]), values.toArray(), (Filter)fidFilter);
                    if (terreinID != null) break;
                    PropertyIsEqualTo kavelFilter = ff.equals((Expression)ff.property("terreinid"), (Expression)ff.literal(original.getAttribute("ibis_id")));
                    this.updateKavelWorkflowForTerrein((Filter)kavelFilter, WorkflowStatus.afgevoerd);
                    break;
                }
                case 4: {
                    this.getStore().modifyFeatures(attributes.toArray(new String[attributes.size()]), values.toArray(), (Filter)fidFilter);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Workflow status van edit feature is null, dit wordt niet ondersteund.");
                }
            }
            editTransaction.commit();
            editTransaction.close();
            if (terreinID != null) {
                WorkflowUtil.updateTerreinGeometry((Integer)Integer.parseInt(terreinID.toString()), (Layer)this.getLayer(), (WorkflowStatus)incomingWorkflowStatus, (Application)this.getApplication(), (EntityManager)Stripersist.getEntityManager());
            }
        }
        catch (IOException | IllegalArgumentException | NoSuchElementException e) {
            editTransaction.rollback();
            log.error((Object)"Ibis editFeature error", (Throwable)e);
            throw e;
        }
    }

    private SimpleFeature createCopy(SimpleFeature copyFrom) {
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(copyFrom.getFeatureType());
        builder.init(copyFrom);
        return builder.buildFeature(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateKavelWorkflowForTerrein(Filter kavelFilter, WorkflowStatus newStatus) {
        SimpleFeatureStore kavelStore = null;
        try (DefaultTransaction kavelTransaction = new DefaultTransaction("get-related-kavel-geom");){
            EntityManager em = Stripersist.getEntityManager();
            log.debug((Object)("updating kavels voor terrein met filter: " + kavelFilter));
            ApplicationLayer kavelAppLyr = null;
            List lyrs = this.getApplication().loadTreeCache(em).getApplicationLayers();
            ListIterator it = lyrs.listIterator();
            while (it.hasNext() && !(kavelAppLyr = (ApplicationLayer)it.next()).getLayerName().equalsIgnoreCase("bedrijvenkavels")) {
            }
            Layer l = kavelAppLyr.getService().getLayer("bedrijvenkavels", em);
            kavelStore = (SimpleFeatureStore)l.getFeatureType().openGeoToolsFeatureSource();
            kavelStore.setTransaction((Transaction)kavelTransaction);
            kavelStore.modifyFeatures("workflow_status", (Object)newStatus, kavelFilter);
            kavelTransaction.commit();
            kavelTransaction.close();
        }
        catch (Exception e) {
            log.error((Object)String.format("Bijwerken van kavel workflow status naar %s voor terrein met %s is mislukt.", newStatus, kavelFilter), (Throwable)e);
        }
        finally {
            if (kavelStore != null) {
                kavelStore.getDataStore().dispose();
            }
        }
    }

    protected boolean isAttributeUserEditingDisabled(String attrName) {
        boolean isAttributeUserEditingDisabled = super.isAttributeUserEditingDisabled(attrName);
        if (attrName.equalsIgnoreCase("workflow_status")) {
            isAttributeUserEditingDisabled = false;
        }
        return isAttributeUserEditingDisabled;
    }

    private boolean isSameMutatiedatum(Object datum1, Object datum2) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd");
        return sdf.format(datum1).equals(sdf.format(datum2));
    }
}

