/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.DateTypeConverter;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ConfiguredAttribute;
import nl.b3p.viewer.config.security.Authorizations;
import nl.b3p.viewer.config.services.AttributeDescriptor;
import nl.b3p.viewer.config.services.JDBCFeatureSource;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.features.CSVDownloader;
import nl.b3p.viewer.features.ExcelDownloader;
import nl.b3p.viewer.features.ShapeDownloader;
import nl.b3p.viewer.ibis.util.IbisConstants;
import nl.b3p.viewer.stripes.IbisReportsActionBean;
import nl.b3p.web.stripes.ErrorMessageResolution;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/ibisreports")
@StrictBinding
public class IbisReportsActionBean
implements ActionBean,
IbisConstants {
    private static final Log log = LogFactory.getLog(IbisReportsActionBean.class);
    private static final String JSON_METADATA = "metaData";
    private ActionBeanContext context;
    @Validate(converter=DateTypeConverter.class)
    private Date fromDate;
    @Validate(converter=DateTypeConverter.class)
    private Date toDate;
    @Validate
    private String regio;
    @Validate
    private String gemeente;
    @Validate
    private String type;
    @Validate
    private String report;
    @Validate
    private Application application;
    @Validate
    private JDBCFeatureSource attrSource;
    @Validate
    private String params;
    private boolean unauthorized;

    @Before(stages={LifecycleStage.EventHandling})
    public void checkAuthorization() {
        EntityManager em = Stripersist.getEntityManager();
        if (this.application == null || !Authorizations.isApplicationReadAuthorized((Application)this.application, (HttpServletRequest)this.context.getRequest(), (EntityManager)em)) {
            this.unauthorized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution download() throws Exception {
        JSONObject json = new JSONObject();
        if (this.unauthorized) {
            json.put("success", (Object)Boolean.FALSE);
            json.put("message", (Object)"Not authorized");
            return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
        }
        File output = null;
        try {
            SimpleFeatureType sft = this.attrSource.getFeatureType(this.report);
            Filter f = this.createFilters(sft);
            List attrs = sft.getAttributes();
            SimpleFeatureSource fs = (SimpleFeatureSource)sft.openGeoToolsFeatureSource();
            Query q = new Query(fs.getName().toString());
            q.setFilter(this.createFilters(sft));
            log.debug((Object)q);
            HashMap<String, AttributeDescriptor> featureTypeAttributes = new HashMap<String, AttributeDescriptor>();
            ArrayList<ConfiguredAttribute> attributes = new ArrayList<ConfiguredAttribute>();
            for (AttributeDescriptor ad : attrs) {
                featureTypeAttributes.put(ad.getName(), ad);
                ConfiguredAttribute ca = new ConfiguredAttribute();
                ca.setVisible(true);
                ca.setAttributeName(ad.getName());
                attributes.add(ca);
            }
            output = this.convert(sft, (FeatureSource)fs, q, attributes, featureTypeAttributes);
            json.put("success", true);
        }
        catch (Exception e) {
            log.error((Object)"Error loading features", (Throwable)e);
            json.put("success", false);
            String message = "Fout bij ophalen features: " + e.toString();
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                message = message + "; " + cause.toString();
            }
            json.put("message", (Object)message);
        }
        if (json.getBoolean("success")) {
            FileInputStream fis = new FileInputStream(output);
            try {
                1 res = new /* Unavailable Anonymous Inner Class!! */;
                String name = output.getName();
                String extension = name.substring(name.lastIndexOf("."));
                SimpleDateFormat today = new SimpleDateFormat("yyyy_MM_dd");
                String newName = "download-" + this.report + "-" + today.format(new Date()) + extension;
                res.setFilename(newName);
                res.setAttachment(true);
                1 var9_10 = res;
                return var9_10;
            }
            finally {
                output.delete();
            }
        }
        return new ErrorMessageResolution(json.getString("message"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DefaultHandler
    public Resolution execute() throws Exception {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        JSONObject metadata = new JSONObject().put("root", (Object)"data").put("totalProperty", (Object)"total").put("successProperty", (Object)"success").put("messageProperty", (Object)"message").put("idProperty", (Object)"rownum");
        json.put(JSON_METADATA, (Object)metadata);
        String error = null;
        if (this.attrSource == null) {
            error = "Invalid parameters.";
        } else if (this.unauthorized) {
            error = "Not authorized.";
        } else if (this.report == null) {
            error = "Report type is required.";
        }
        SimpleFeatureType sft = this.attrSource.getFeatureType(this.report);
        List attrs = sft.getAttributes();
        SimpleFeatureSource fs = null;
        try {
            fs = (SimpleFeatureSource)sft.openGeoToolsFeatureSource();
            Query q = new Query(fs.getName().toString());
            q.setFilter(this.createFilters(sft));
            log.debug((Object)q);
            SimpleFeatureCollection sfc = fs.getFeatures(q);
            this.featuresToJson(sfc, json, attrs);
            json.put("message", (Object)"OK");
            json.put("success", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            log.error((Object)"Error generating report data.", (Throwable)e);
            error = e.getLocalizedMessage();
        }
        finally {
            if (fs != null) {
                fs.getDataStore().dispose();
            }
        }
        if (error != null) {
            json.put("success", (Object)Boolean.FALSE);
            json.put("message", (Object)error);
        }
        log.debug((Object)("returning json:" + json));
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    private Filter createFilters(SimpleFeatureType sft) {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        ArrayList<Object> filters = new ArrayList<Object>();
        if (this.regio != null && sft.getAttribute("vvr_naam") != null) {
            filters.add(ff.equals((Expression)ff.property("vvr_naam"), (Expression)ff.literal((Object)this.regio)));
        }
        if (this.gemeente != null && sft.getAttribute("gemeentenaam") != null) {
            filters.add(ff.equals((Expression)ff.property("gemeentenaam"), (Expression)ff.literal((Object)this.gemeente)));
        }
        if (this.toDate != null && sft.getAttribute("datum") != null) {
            filters.add(ff.before((Expression)ff.property("datum"), (Expression)ff.literal((Object)this.toDate)));
        }
        if (this.fromDate != null && sft.getAttribute("datum") != null) {
            filters.add(ff.after((Expression)ff.property("datum"), (Expression)ff.literal((Object)this.fromDate)));
        }
        if (filters.size() > 1) {
            return ff.and(filters);
        }
        if (filters.size() == 1) {
            return (Filter)filters.get(0);
        }
        return Filter.INCLUDE;
    }

    private void featuresToJson(SimpleFeatureCollection sfc, JSONObject json, List<AttributeDescriptor> featureTypeAttributes) throws JSONException {
        JSONArray fields = new JSONArray();
        JSONArray columns = new JSONArray();
        JSONArray datas = new JSONArray();
        boolean getMetadataFromFirstFeature = true;
        try (SimpleFeatureIterator sfIter = sfc.features();){
            while (sfIter.hasNext()) {
                SimpleFeature feature = (SimpleFeature)sfIter.next();
                JSONObject fData = new JSONObject();
                for (AttributeDescriptor attr : featureTypeAttributes) {
                    String name = attr.getName();
                    if (getMetadataFromFirstFeature) {
                        JSONObject field = new JSONObject().put("name", (Object)name).put("type", (Object)attr.getExtJSType());
                        if (attr.getType().equals("date")) {
                            field.put("dateFormat", (Object)"Y-m");
                        }
                        fields.put((Object)field);
                        columns.put((Object)new JSONObject().put("text", (Object)(attr.getAlias() != null ? attr.getAlias() : name)).put("dataIndex", (Object)name));
                    }
                    fData.put(attr.getName(), feature.getAttribute(attr.getName()));
                }
                datas.put((Object)fData);
                getMetadataFromFirstFeature = false;
            }
            json.getJSONObject(JSON_METADATA).put("fields", (Object)fields);
            json.getJSONObject(JSON_METADATA).put("columns", (Object)columns);
            json.put("data", (Object)datas);
            json.put("total", datas.length());
        }
    }

    private File convert(SimpleFeatureType ft, FeatureSource fs, Query q, List<ConfiguredAttribute> attributes, Map<String, AttributeDescriptor> featureTypeAttributes) throws IOException {
        HashMap<String, String> attributeAliases = new HashMap<String, String>();
        for (AttributeDescriptor ad : ft.getAttributes()) {
            if (ad.getAlias() != null) {
                attributeAliases.put(ad.getName(), ad.getAlias());
                continue;
            }
            attributeAliases.put(ad.getName(), ad.getName());
        }
        SimpleFeatureCollection fc = (SimpleFeatureCollection)fs.getFeatures(q);
        File f = null;
        StringBuilder autosizeAttr = new StringBuilder(",autoSize=");
        for (ConfiguredAttribute configuredAttribute : attributes) {
            autosizeAttr.append(configuredAttribute.getAttributeName()).append("|");
        }
        this.params = this.params + autosizeAttr;
        ShapeDownloader downloader = null;
        if (this.type.equalsIgnoreCase("SHP")) {
            downloader = new ShapeDownloader(attributes, (SimpleFeatureSource)fs, featureTypeAttributes, attributeAliases, this.params);
        } else if (this.type.equalsIgnoreCase("XLS")) {
            downloader = new ExcelDownloader(attributes, (SimpleFeatureSource)fs, featureTypeAttributes, attributeAliases, this.params);
        } else if (this.type.equals("CSV")) {
            downloader = new CSVDownloader(attributes, (SimpleFeatureSource)fs, featureTypeAttributes, attributeAliases, this.params);
        } else {
            throw new IllegalArgumentException("No suitable type given: " + this.type);
        }
        try {
            downloader.init();
            try (SimpleFeatureIterator it = fc.features();){
                while (it.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)it.next();
                    downloader.processFeature(feature);
                }
            }
            f = downloader.write();
        }
        catch (IOException ex) {
            log.error((Object)"Cannot create outputfile: ", (Throwable)ex);
            throw ex;
        }
        finally {
            fs.getDataStore().dispose();
        }
        log.debug((Object)("returning file " + f));
        return f;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public String getRegio() {
        return this.regio;
    }

    public void setRegio(String regio) {
        this.regio = regio;
    }

    public String getGemeente() {
        return this.gemeente;
    }

    public void setGemeente(String gemeente) {
        this.gemeente = gemeente;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getReport() {
        return this.report;
    }

    public void setReport(String report) {
        this.report = report;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public JDBCFeatureSource getAttrSource() {
        return this.attrSource;
    }

    public void setAttrSource(JDBCFeatureSource attrSource) {
        this.attrSource = attrSource;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }
}

