/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.csw.client.CswClient;
import nl.b3p.csw.client.CswRequestCreator;
import nl.b3p.csw.client.FilterCreator;
import nl.b3p.csw.client.InputBySearch;
import nl.b3p.csw.client.OutputBySearch;
import nl.b3p.csw.client.OwsException;
import nl.b3p.csw.jaxb.csw.GetRecords;
import nl.b3p.csw.jaxb.filter.And;
import nl.b3p.csw.jaxb.filter.BinaryLogicOpType;
import nl.b3p.csw.jaxb.filter.FilterType;
import nl.b3p.csw.jaxb.filter.Or;
import nl.b3p.csw.jaxb.filter.PropertyIsEqualTo;
import nl.b3p.csw.jaxb.filter.PropertyIsLike;
import nl.b3p.csw.jaxb.filter.SortBy;
import nl.b3p.csw.server.CswServable;
import nl.b3p.csw.server.GeoNetworkCswServer;
import nl.b3p.csw.util.OnlineResource;
import nl.b3p.csw.util.Protocol;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.app.Level;
import nl.b3p.viewer.config.services.GeoService;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.stripes.ApplicationActionBean;
import nl.b3p.viewer.stripes.LocalizableApplicationActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.util.Version;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

/*
 * Exception performing whole class analysis ignored.
 */
@UrlBinding(value="/action/csw/search")
@StrictBinding
public class CatalogSearchActionBean
extends LocalizableApplicationActionBean
implements ActionBean {
    private ActionBeanContext context;
    private static final Log log = LogFactory.getLog(CatalogSearchActionBean.class);
    private static final String defaultWildCard = "*";
    private BigInteger maxRecords = new BigInteger("1000");
    @Validate
    private String url;
    @Validate
    private String q;
    @Validate
    private String advancedString;
    @Validate
    private String advancedProperty;
    @Validate
    private Application application;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public String getAdvancedString() {
        return this.advancedString;
    }

    public void setAdvancedString(String advancedString) {
        this.advancedString = advancedString;
    }

    public String getAdvancedProperty() {
        return this.advancedProperty;
    }

    public void setAdvancedProperty(String advancedProperty) {
        this.advancedProperty = advancedProperty;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    @DefaultHandler
    public Resolution search() throws JSONException {
        String error;
        JSONObject json;
        block5: {
            json = new JSONObject();
            json.put("success", (Object)Boolean.FALSE);
            error = null;
            Resolution r = ApplicationActionBean.checkRestriction((ActionBeanContext)this.context, (Application)this.application, (EntityManager)Stripersist.getEntityManager());
            if (r != null) {
                error = this.getBundle().getString("viewer.catalogsearchactionbean.1");
            } else {
                try {
                    GeoNetworkCswServer server = new GeoNetworkCswServer(null, this.url, null, null);
                    CswClient client = new CswClient((CswServable)server);
                    InputBySearch input = new InputBySearch(this.q);
                    OutputBySearch output = client.search(input);
                    List map = output.getResourcesFlattened();
                    JSONArray results = this.getResults(map, output);
                    json.put("results", (Object)results);
                    json.put("success", (Object)Boolean.TRUE);
                }
                catch (Exception e) {
                    error = MessageFormat.format(this.getBundle().getString("viewer.catalogsearchactionbean.2"), e.toString());
                    log.error((Object)"Error searching:", (Throwable)e);
                    if (e.getCause() == null) break block5;
                    error = error + "; cause: " + e.getCause().toString();
                }
            }
        }
        if (error != null) {
            json.put("error", (Object)error);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
    }

    public Resolution advancedSearch() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        Resolution r = ApplicationActionBean.checkRestriction((ActionBeanContext)this.context, (Application)this.application, (EntityManager)Stripersist.getEntityManager());
        if (r != null) {
            json.put("message", (Object)this.getBundle().getString("viewer.general.noauth"));
            return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
        }
        GeoNetworkCswServer server = new GeoNetworkCswServer(null, this.url, null, null);
        CswClient client = new CswClient((CswServable)server);
        try {
            OutputBySearch output = client.search(new InputBySearch((JAXBElement)CatalogSearchActionBean.createAdvancedCswRequest((String)this.q, (String)this.advancedString, (String)this.advancedProperty, null, (BigInteger)this.maxRecords, null)));
            List els = output.getSearchResults();
            ArrayList<Protocol> prots = new ArrayList<Protocol>();
            prots.add(Protocol.WMS);
            ArrayList list = new ArrayList();
            for (Element element : els) {
                Map orMap = output.getResourcesMap(element, prots);
                Set uris = orMap.keySet();
                for (URI uri : uris) {
                    List orList = (List)orMap.get(uri);
                    list.addAll(orList);
                }
            }
            HashMap descriptionsByLayer = new HashMap();
            List layers = this.getLayers(list, descriptionsByLayer, output);
            HashMap descriptionsByApplayer = new HashMap();
            List appLayers = this.getAppLayers(layers, descriptionsByApplayer, descriptionsByLayer);
            HashMap descriptionsByLevel = new HashMap();
            List levels = this.getLevels(appLayers, descriptionsByApplayer, descriptionsByLevel);
            JSONArray found = new JSONArray();
            for (Level level : levels) {
                JSONObject obj = level.toJSONObject(false, this.application, this.context.getRequest(), em);
                found.put((Object)obj);
            }
            List children = this.application.getRoot().getChildren();
            JSONArray childs = new JSONArray();
            for (Level child : children) {
                childs.put((Object)child.toJSONObject(false, this.application, this.context.getRequest(), em));
            }
            Set levelDesc = descriptionsByLevel.keySet();
            JSONObject descriptions = new JSONObject();
            for (Level level : levelDesc) {
                JSONObject obj = new JSONObject();
                obj.put("level", (Object)level.getId());
                obj.put("description", descriptionsByLevel.get(level));
                descriptions.put("" + level.getId(), (Object)obj);
            }
            JSONObject results = new JSONObject();
            results.put("found", (Object)found);
            results.put("children", (Object)childs);
            results.put("descriptions", (Object)descriptions);
            json.put("results", (Object)results);
            json.put("success", (Object)Boolean.TRUE);
        }
        catch (IOException ex) {
            log.error((Object)"Fout bij zoeken in csw:", (Throwable)ex);
        }
        catch (JDOMException ex) {
            log.error((Object)"Fout bij zoeken in csw:", (Throwable)ex);
        }
        catch (JAXBException ex) {
            log.error((Object)"Fout bij zoeken in csw:", (Throwable)ex);
        }
        catch (OwsException ex) {
            log.error((Object)"Fout bij zoeken in csw:", (Throwable)ex);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
    }

    private List<Level> getLevels(List<ApplicationLayer> appLayers, Map<ApplicationLayer, String> descriptionsByApplayer, Map<Level, String> descriptionsByLevel) {
        ArrayList<Level> foundLevels = new ArrayList<Level>();
        Level root = this.application.getRoot();
        for (ApplicationLayer applicationLayer : appLayers) {
            Level l = root.getParentInSubtree(applicationLayer);
            if (l == null) continue;
            foundLevels.add(l);
            if (!descriptionsByApplayer.containsKey(applicationLayer)) continue;
            descriptionsByLevel.put(l, descriptionsByApplayer.get(applicationLayer));
        }
        return foundLevels;
    }

    private List<ApplicationLayer> getAppLayers(List<Layer> layers, Map<ApplicationLayer, String> descriptionsByApplayer, Map<Layer, String> descriptionsByLayer) {
        EntityManager em = Stripersist.getEntityManager();
        ArrayList<ApplicationLayer> foundAppLayers = new ArrayList<ApplicationLayer>();
        Level root = this.application.getRoot();
        for (Layer layer : layers) {
            List appLayers = em.createQuery("FROM ApplicationLayer WHERE service = :geoservice and layerName = :name", ApplicationLayer.class).setParameter("geoservice", (Object)layer.getService()).setParameter("name", (Object)layer.getName()).getResultList();
            for (ApplicationLayer applicationLayer : appLayers) {
                if (!root.containsLayerInSubtree(applicationLayer)) continue;
                foundAppLayers.add(applicationLayer);
                if (!descriptionsByLayer.containsKey(layer)) continue;
                descriptionsByApplayer.put(applicationLayer, descriptionsByLayer.get(layer));
            }
        }
        return foundAppLayers;
    }

    private List<Layer> getLayers(List<OnlineResource> lijst, Map<Layer, String> descriptions, OutputBySearch output) {
        EntityManager em = Stripersist.getEntityManager();
        ArrayList<Layer> foundLayers = new ArrayList<Layer>();
        for (OnlineResource resource : lijst) {
            String protocol;
            String rurl = resource.getUrl() != null ? resource.getUrl().toString() : null;
            String layerName = resource.getName();
            String string = protocol = resource.getProtocol() != null ? resource.getProtocol().getName() : null;
            if (rurl == null || protocol == null || protocol.toLowerCase().indexOf("wms") == -1) continue;
            List foundServices = em.createQuery("FROM GeoService WHERE url = :url", GeoService.class).setParameter("url", (Object)rurl).getResultList();
            for (GeoService geoService : foundServices) {
                List layers = geoService.loadLayerTree(em);
                for (Layer layer : layers) {
                    if (layer.isVirtual() || !layer.getName().equalsIgnoreCase(layerName)) continue;
                    try {
                        String abstractText = output.getAbstractText(resource.getMetadata());
                        descriptions.put(layer, abstractText);
                    }
                    catch (JDOMException jDOMException) {
                        // empty catch block
                    }
                    foundLayers.add(layer);
                }
            }
        }
        return foundLayers;
    }

    private JSONArray getResults(List<OnlineResource> resourceList, OutputBySearch output) throws JDOMException, JSONException {
        JSONArray results = new JSONArray();
        for (OnlineResource resource : resourceList) {
            String protocol;
            String title = output.getTitle(resource.getMetadata());
            String rurl = resource.getUrl() != null ? resource.getUrl().toString() : null;
            String layer = resource.getName();
            String string = protocol = resource.getProtocol() != null ? resource.getProtocol().getName() : null;
            if (title == null || rurl == null || protocol == null || protocol.toLowerCase().indexOf("wms") == -1) continue;
            JSONObject result = new JSONObject();
            result.put("label", (Object)(title + (layer != null ? " (laag: " + layer + ")" : "")));
            result.put("url", (Object)rurl);
            result.put("protocol", (Object)"wms");
            results.put((Object)result);
        }
        return results;
    }

    private static GetRecords createAdvancedCswRequest(String queryString, String advancedValue, String propertyName, BigInteger startPosition, BigInteger maxRecords, SortBy sortBy) throws IOException {
        FilterType filterType = new FilterType();
        boolean emptySearchStrings = true;
        ArrayList<Object> andList = new ArrayList<Object>();
        Or queryOr = null;
        Or typeringOr = null;
        if (queryString != null) {
            emptySearchStrings = false;
            queryOr = CatalogSearchActionBean.createOrFilter((String)queryString, null);
            andList.add(queryOr);
        }
        if (advancedValue != null) {
            emptySearchStrings = false;
            PropertyIsEqualTo propertyIsEqualTo = FilterCreator.createPropertyIsEqualTo((String)advancedValue, (String)propertyName);
            ArrayList<PropertyIsEqualTo> orList = new ArrayList<PropertyIsEqualTo>();
            orList.add(propertyIsEqualTo);
            typeringOr = new Or(new BinaryLogicOpType(orList));
            andList.add(propertyIsEqualTo);
        }
        if (emptySearchStrings) {
            return CswRequestCreator.createCswRequest((String)"*", (String)propertyName, (BigInteger)startPosition, (BigInteger)maxRecords, (SortBy)sortBy, null, null, null);
        }
        And and = new And(new BinaryLogicOpType(andList));
        if (queryOr != null && typeringOr != null) {
            filterType.setLogicOps((JAXBElement)and);
        } else if (queryOr != null) {
            filterType.setLogicOps((JAXBElement)queryOr);
        } else if (typeringOr != null) {
            filterType.setLogicOps(typeringOr);
        }
        return CswRequestCreator.createCswRequest((FilterType)filterType, (BigInteger)startPosition, (BigInteger)maxRecords, (SortBy)sortBy);
    }

    private static Or createOrFilter(String queryString, String propertyName) {
        ArrayList<Object> orList = new ArrayList<Object>();
        if ((queryString = CswRequestCreator.createQueryString((String)queryString, (boolean)false)) != null && !queryString.trim().equals("*")) {
            propertyName = CswRequestCreator.createPropertyName((String)propertyName);
            PropertyIsEqualTo propertyIsEqualTo = FilterCreator.createPropertyIsEqualTo((String)queryString, (String)propertyName);
            StandardAnalyzer standardAnalyzer = new StandardAnalyzer(Version.LUCENE_46, DutchAnalyzer.getDefaultStopSet());
            orList.add(propertyIsEqualTo);
            try {
                TokenStream tokenStream = standardAnalyzer.tokenStream("", queryString);
                OffsetAttribute offsetAttribute = (OffsetAttribute)tokenStream.addAttribute(OffsetAttribute.class);
                CharTermAttribute charTermAttribute = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
                tokenStream.reset();
                while (tokenStream.incrementToken()) {
                    int startOffset = offsetAttribute.startOffset();
                    int endOffset = offsetAttribute.endOffset();
                    String term = charTermAttribute.toString();
                    PropertyIsLike propertyIsLike = FilterCreator.createPropertyIsLike((String)term, (String)propertyName);
                    orList.add(propertyIsLike);
                }
                tokenStream.close();
            }
            catch (IOException e) {
                PropertyIsLike propertyIsLike = FilterCreator.createPropertyIsLike((String)queryString, (String)propertyName);
                orList.add(propertyIsLike);
            }
        }
        Or or = new Or(new BinaryLogicOpType(orList));
        return or;
    }
}

