/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.audit.AuditMessageObject;
import nl.b3p.viewer.audit.Auditable;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.security.Authorizations;
import nl.b3p.viewer.config.services.FeatureTypeRelation;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.stripes.LocalizableApplicationActionBean;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureSource;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.identity.FeatureIdImpl;
import org.json.JSONException;
import org.json.JSONObject;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/feature/edit")
@StrictBinding
public class EditFeatureActionBean
extends LocalizableApplicationActionBean
implements Auditable {
    private static final Log log = LogFactory.getLog(EditFeatureActionBean.class);
    private static final String FID = "__fid";
    private ActionBeanContext context;
    @Validate
    private Application application;
    @Validate
    private String feature;
    @Validate
    private ApplicationLayer appLayer;
    protected Layer layer;
    protected SimpleFeatureStore store;
    protected JSONObject jsonFeature;
    private AuditMessageObject auditMessageObject;
    private final SimpleDateFormat datetime = new SimpleDateFormat("dd-MM-yyy HH:mm:ss");
    private final SimpleDateFormat date = new SimpleDateFormat("dd-MM-yyy");

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public String getFeature() {
        return this.feature;
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }

    public ApplicationLayer getAppLayer() {
        return this.appLayer;
    }

    public void setAppLayer(ApplicationLayer appLayer) {
        this.appLayer = appLayer;
    }

    public SimpleFeatureStore getStore() {
        return this.store;
    }

    public JSONObject getJsonFeature() {
        return this.jsonFeature;
    }

    public void setJsonFeature(JSONObject jsonFeature) {
        this.jsonFeature = jsonFeature;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public String getFID() {
        return FID;
    }

    public AuditMessageObject getAuditMessageObject() {
        return this.auditMessageObject;
    }

    @Before(stages={LifecycleStage.EventHandling})
    public void initAudit() {
        this.auditMessageObject = new AuditMessageObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DefaultHandler
    public Resolution edit() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        String error = null;
        FeatureSource fs = null;
        EntityManager em = Stripersist.getEntityManager();
        try {
            if (this.appLayer == null) {
                error = this.getBundle().getString("viewer.editfeatureactionbean.1");
            } else if (!Authorizations.isAppLayerWriteAuthorized((Application)this.application, (ApplicationLayer)this.appLayer, (HttpServletRequest)this.context.getRequest(), (EntityManager)em)) {
                error = this.getBundle().getString("viewer.editfeatureactionbean.2");
            } else {
                this.layer = this.appLayer.getService().getLayer(this.appLayer.getLayerName(), em);
                if (this.layer == null) {
                    error = this.getBundle().getString("viewer.editfeatureactionbean.3");
                } else if (this.layer.getFeatureType() == null) {
                    error = this.getBundle().getString("viewer.editfeatureactionbean.4");
                } else {
                    fs = this.layer.getFeatureType().openGeoToolsFeatureSource();
                    if (!(fs instanceof SimpleFeatureStore)) {
                        error = this.getBundle().getString("viewer.editfeatureactionbean.5");
                    } else {
                        this.store = (SimpleFeatureStore)fs;
                        this.jsonFeature = this.getJsonFeature(this.feature);
                        if (!this.isFeatureWriteAuthorized(this.appLayer, this.jsonFeature, this.context.getRequest())) {
                            error = this.getBundle().getString("viewer.editfeatureactionbean.6");
                        } else {
                            String fid = this.jsonFeature.optString(FID, null);
                            if (fid == null) {
                                json.put(FID, (Object)this.addNewFeature());
                            } else {
                                this.editFeature(fid);
                                json.put(FID, (Object)fid);
                            }
                            json.put("success", (Object)Boolean.TRUE);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception editing feature", (Throwable)e);
            error = this.getBundle().getString("viewer.editfeatureactionbean.19");
            if (e.getCause() != null) {
                if (e.getCause().getMessage().contains("numeric field overflow") || e.getCause().getMessage().contains("Value too large for column") || e.getCause().getMessage().contains("overflow error")) {
                    error = error + " " + this.getBundle().getString("viewer.editfeatureactionbean.20");
                }
                error = error + "<br/><samp>" + e.getCause().getMessage() + "</samp>";
            } else {
                error = error + e.getLocalizedMessage();
            }
        }
        finally {
            if (fs != null) {
                fs.getDataStore().dispose();
            }
        }
        if (error != null) {
            json.put("error", (Object)error);
            log.error((Object)("Returned error message editing feature: " + error));
        }
        this.auditMessageObject.addMessage((Object)json);
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution saveRelatedFeatures() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        String error = null;
        FeatureSource fs = null;
        EntityManager em = Stripersist.getEntityManager();
        if (this.appLayer == null) {
            error = this.getBundle().getString("viewer.editfeatureactionbean.7");
        }
        if (!Authorizations.isAppLayerWriteAuthorized((Application)this.application, (ApplicationLayer)this.appLayer, (HttpServletRequest)this.context.getRequest(), (EntityManager)em)) {
            error = this.getBundle().getString("viewer.editfeatureactionbean.8");
        }
        this.layer = this.appLayer.getService().getLayer(this.appLayer.getLayerName(), em);
        if (this.layer.getFeatureType().hasRelations()) {
            for (FeatureTypeRelation rel : this.layer.getFeatureType().getRelations()) {
                if (!rel.getType().equals("relate")) continue;
                try {
                    nl.b3p.viewer.config.services.SimpleFeatureType fType = rel.getForeignFeatureType();
                    String label = fType.getDescription() == null ? fType.getTypeName() : fType.getDescription();
                    fs = fType.openGeoToolsFeatureSource(5000);
                    this.store = (SimpleFeatureStore)fs;
                    this.jsonFeature = new JSONObject(this.feature);
                    String fid = this.jsonFeature.optString(FID, null);
                    if (fid == null || fid.equals("")) {
                        json.put(FID, (Object)this.addNewFeature());
                    } else {
                        this.jsonFeature.remove("rel_id");
                        DefaultTransaction transaction = new DefaultTransaction("edit");
                        this.store.setTransaction((Transaction)transaction);
                        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
                        Id filter = ff.id(new FeatureId[]{new FeatureIdImpl(fid)});
                        ArrayList<String> attributes = new ArrayList<String>();
                        ArrayList<CharSequence> values = new ArrayList<CharSequence>();
                        Iterator it = this.jsonFeature.keys();
                        while (it.hasNext()) {
                            AttributeDescriptor ad;
                            String attribute = (String)it.next();
                            if (FID.equals(attribute) || (ad = ((SimpleFeatureType)this.store.getSchema()).getDescriptor(attribute)) == null) continue;
                            attributes.add(attribute);
                            String v = this.jsonFeature.getString(attribute);
                            values.add(StringUtils.defaultIfBlank((CharSequence)v, null));
                        }
                        log.debug((Object)String.format("Modifying feature source #%d fid=%s, attributes=%s, values=%s", this.layer.getFeatureType().getId(), fid, ((Object)attributes).toString(), ((Object)values).toString()));
                        try {
                            this.store.modifyFeatures(attributes.toArray(new String[0]), values.toArray(), (Filter)filter);
                            transaction.commit();
                        }
                        catch (Exception e) {
                            transaction.rollback();
                            throw e;
                        }
                        finally {
                            transaction.close();
                        }
                        json.put(FID, (Object)fid);
                    }
                    json.put("success", (Object)Boolean.TRUE);
                }
                catch (Exception ex) {
                    log.error((Object)"cannot save relatedFeature Exception: ", (Throwable)ex);
                }
                finally {
                    if (fs == null) continue;
                    fs.getDataStore().dispose();
                }
            }
        }
        this.auditMessageObject.addMessage((Object)json);
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution delete() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        String error = null;
        FeatureSource fs = null;
        EntityManager em = Stripersist.getEntityManager();
        try {
            if (this.appLayer == null) {
                error = this.getBundle().getString("viewer.editfeatureactionbean.9");
            } else if (!Authorizations.isAppLayerWriteAuthorized((Application)this.application, (ApplicationLayer)this.appLayer, (HttpServletRequest)this.context.getRequest(), (EntityManager)em)) {
                error = this.getBundle().getString("viewer.editfeatureactionbean.10");
            } else {
                this.layer = this.appLayer.getService().getLayer(this.appLayer.getLayerName(), em);
                if (this.layer == null) {
                    error = this.getBundle().getString("viewer.editfeatureactionbean.11");
                } else if (!Authorizations.isLayerGeomWriteAuthorized((Layer)this.layer, (HttpServletRequest)this.context.getRequest(), (EntityManager)em)) {
                    error = this.getBundle().getString("viewer.editfeatureactionbean.12");
                } else if (this.layer.getFeatureType() == null) {
                    error = "No feature type";
                } else {
                    fs = this.layer.getFeatureType().openGeoToolsFeatureSource();
                    if (!(fs instanceof SimpleFeatureStore)) {
                        error = this.getBundle().getString("viewer.editfeatureactionbean.13");
                    } else {
                        this.store = (SimpleFeatureStore)fs;
                        this.jsonFeature = new JSONObject(this.feature);
                        if (!this.isFeatureWriteAuthorized(this.appLayer, this.jsonFeature, this.context.getRequest())) {
                            error = this.getBundle().getString("viewer.editfeatureactionbean.14");
                        } else {
                            String fid = this.jsonFeature.optString(FID, null);
                            if (fid == null) {
                                error = this.getBundle().getString("viewer.editfeatureactionbean.15");
                            } else {
                                this.deleteFeature(fid);
                                json.put("success", (Object)Boolean.TRUE);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)String.format("Exception editing feature", e));
            error = e.toString();
            if (e.getCause() != null) {
                error = error + "; cause: " + e.getCause().toString();
            }
        }
        finally {
            if (fs != null) {
                fs.getDataStore().dispose();
            }
        }
        if (error != null) {
            json.put("error", (Object)error);
            log.error((Object)("Returned error message editing feature: " + error));
        }
        this.auditMessageObject.addMessage((Object)json);
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
    }

    protected JSONObject getJsonFeature(String feature) {
        return new JSONObject(feature);
    }

    public Resolution removeRelatedFeatures() throws JSONException, Exception {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        String error = null;
        FeatureSource fs = null;
        EntityManager em = Stripersist.getEntityManager();
        if (this.appLayer == null) {
            error = this.getBundle().getString("viewer.editfeatureactionbean.16");
        }
        if (!Authorizations.isAppLayerWriteAuthorized((Application)this.application, (ApplicationLayer)this.appLayer, (HttpServletRequest)this.context.getRequest(), (EntityManager)em)) {
            error = this.getBundle().getString("viewer.editfeatureactionbean.17");
        }
        this.layer = this.appLayer.getService().getLayer(this.appLayer.getLayerName(), em);
        if (this.layer.getFeatureType().hasRelations()) {
            for (FeatureTypeRelation rel : this.layer.getFeatureType().getRelations()) {
                if (!rel.getType().equals("relate")) continue;
                nl.b3p.viewer.config.services.SimpleFeatureType fType = rel.getForeignFeatureType();
                String label = fType.getDescription() == null ? fType.getTypeName() : fType.getDescription();
                fs = fType.openGeoToolsFeatureSource(5000);
                this.store = (SimpleFeatureStore)fs;
                this.jsonFeature = new JSONObject(this.feature);
                String fid = this.jsonFeature.optString(FID, null);
                if (fid == null || fid.equals("")) {
                    error = this.getBundle().getString("viewer.editfeatureactionbean.18");
                    break;
                }
                this.deleteFeature(fid);
                json.put("success", (Object)Boolean.TRUE);
            }
            fs.getDataStore().dispose();
        }
        this.auditMessageObject.addMessage((Object)json);
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
    }

    protected String addNewFeature() throws Exception {
        SimpleFeature f = DataUtilities.template((SimpleFeatureType)((SimpleFeatureType)this.store.getSchema()));
        DefaultTransaction transaction = new DefaultTransaction("create");
        this.store.setTransaction((Transaction)transaction);
        for (AttributeDescriptor ad : ((SimpleFeatureType)this.store.getSchema()).getAttributeDescriptors()) {
            String v;
            if (ad.getType() instanceof GeometryType) {
                String wkt = this.jsonFeature.optString(ad.getLocalName(), null);
                Geometry g = null;
                if (wkt != null) {
                    g = new WKTReader().read(wkt);
                }
                f.setDefaultGeometry(g);
                continue;
            }
            if (ad.getType().getBinding().equals(Date.class) || ad.getType().getBinding().equals(Timestamp.class)) {
                v = this.jsonFeature.optString(ad.getLocalName());
                java.util.Date d = null;
                if (v != null && !v.isEmpty()) {
                    d = ad.getType().getBinding().equals(Timestamp.class) ? this.datetime.parse(v) : this.date.parse(v);
                }
                f.setAttribute(ad.getLocalName(), d);
                continue;
            }
            v = this.jsonFeature.optString(ad.getLocalName());
            f.setAttribute(ad.getLocalName(), (Object)StringUtils.defaultIfBlank((CharSequence)v, null));
        }
        log.debug((Object)String.format("Creating new feature in feature source source #%d: %s", this.layer.getFeatureType().getId(), f.toString()));
        try {
            List ids = this.store.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)f));
            transaction.commit();
            String string = ((FeatureId)ids.get(0)).getID();
            return string;
        }
        catch (Exception e) {
            transaction.rollback();
            throw e;
        }
        finally {
            transaction.close();
        }
    }

    protected void deleteFeature(String fid) throws IOException, Exception {
        DefaultTransaction transaction = new DefaultTransaction("edit");
        this.store.setTransaction((Transaction)transaction);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        Id filter = ff.id(new FeatureId[]{new FeatureIdImpl(fid)});
        try {
            this.store.removeFeatures((Filter)filter);
            transaction.commit();
        }
        catch (Exception e) {
            transaction.rollback();
            throw e;
        }
        finally {
            transaction.close();
        }
    }

    protected void editFeature(String fid) throws Exception {
        DefaultTransaction transaction = new DefaultTransaction("edit");
        this.store.setTransaction((Transaction)transaction);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        Id filter = ff.id(new FeatureId[]{new FeatureIdImpl(fid)});
        ArrayList<String> attributes = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        Iterator it = this.jsonFeature.keys();
        while (it.hasNext()) {
            String attribute = (String)it.next();
            if (FID.equals(attribute)) continue;
            AttributeDescriptor ad = ((SimpleFeatureType)this.store.getSchema()).getDescriptor(attribute);
            if (ad != null) {
                if (!this.isAttributeUserEditingDisabled(attribute)) {
                    attributes.add(attribute);
                    if (ad.getType() instanceof GeometryType) {
                        String wkt = this.jsonFeature.getString(ad.getLocalName());
                        Geometry g = null;
                        if (wkt != null) {
                            g = new WKTReader().read(wkt);
                        }
                        values.add(g);
                        continue;
                    }
                    if (ad.getType().getBinding().getCanonicalName().equals("byte[]")) {
                        Object ba = this.jsonFeature.get(attribute);
                        values.add(ba);
                        continue;
                    }
                    String v = this.jsonFeature.optString(attribute);
                    values.add(StringUtils.defaultIfBlank((CharSequence)v, null));
                    continue;
                }
                log.info((Object)String.format("Attribute \"%s\" not user editable; ignoring", attribute));
                continue;
            }
            log.warn((Object)String.format("Attribute \"%s\" not in feature type; ignoring", attribute));
        }
        log.debug((Object)String.format("Modifying feature source #%d fid=%s, attributes=%s, values=%s", this.layer.getFeatureType().getId(), fid, ((Object)attributes).toString(), ((Object)values).toString()));
        try {
            this.store.modifyFeatures(attributes.toArray(new String[0]), values.toArray(), (Filter)filter);
            transaction.commit();
        }
        catch (Exception e) {
            transaction.rollback();
            throw e;
        }
        finally {
            transaction.close();
        }
    }

    protected boolean isAttributeUserEditingDisabled(String attrName) {
        return this.getAppLayer().getAttribute(this.getLayer().getFeatureType(), attrName).isDisableUserEdit();
    }

    private boolean isFeatureWriteAuthorized(ApplicationLayer appLayer, JSONObject jsonFeature, HttpServletRequest request) {
        if (appLayer.getDetails() != null && appLayer.getDetails().containsKey("editfeature.usernameAttribute")) {
            String attr = ((ClobElement)appLayer.getDetails().get("editfeature.usernameAttribute")).getValue();
            String featureUsername = jsonFeature.optString(attr);
            return featureUsername != null && featureUsername.equals(request.getRemoteUser());
        }
        return true;
    }
}

