/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.security.Authorizations;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.ibis.util.IbisConstants;
import nl.b3p.viewer.stripes.FeatureInfoActionBean;
import nl.b3p.viewer.util.FeatureToJson;
import nl.b3p.viewer.util.IbisFeatureToJson;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.json.JSONArray;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/ibisfeatureinfo")
@StrictBinding
public class IbisFeatureInfoActionBean
extends FeatureInfoActionBean
implements IbisConstants {
    private static final Log log = LogFactory.getLog(IbisFeatureInfoActionBean.class);
    @Validate
    private boolean historisch;

    protected JSONArray executeQuery(ApplicationLayer al, SimpleFeatureType ft, FeatureSource fs, Query q) throws Exception {
        JSONArray features;
        if (this.getLayer().getName().equalsIgnoreCase("bedrijvenkavels") || this.getLayer().getName().equalsIgnoreCase("bedrijventerrein")) {
            IbisFeatureToJson ftjson = new IbisFeatureToJson(this.isArrays(), this.isEdit(), this.isGraph(), this.getAttributesToInclude());
            if (Authorizations.isAppLayerWriteAuthorized((Application)this.getApplication(), (ApplicationLayer)al, (HttpServletRequest)this.getContext().getRequest(), (EntityManager)Stripersist.getEntityManager())) {
                if (this.historisch) {
                    log.debug((Object)("Executing custom 'historisch' IBIS featureinfo for write-authorized user on layer " + this.getLayer().getName()));
                    features = ftjson.getHistorischeJSONFeatures(al, this.getLayer().getFeatureType(), fs, q);
                } else {
                    log.debug((Object)("Executing custom IBIS featureinfo for write-authorized user on layer " + this.getLayer().getName()));
                    features = ftjson.getWorkflowJSONFeatures(al, this.getLayer().getFeatureType(), fs, q);
                }
            } else {
                log.debug((Object)("Executing custom IBIS featureinfo for non-write-authorized user on layer " + this.getLayer().getName()));
                features = ftjson.getDefinitiefJSONFeatures(al, this.getLayer().getFeatureType(), fs, q);
            }
        } else {
            log.debug((Object)("Executing default IBIS featureinfo for 'any' user on layer " + this.getLayer().getName()));
            FeatureToJson ftjson = new FeatureToJson(this.isArrays(), this.isEdit(), this.isGraph(), this.getAttributesToInclude());
            features = ftjson.getJSONFeatures(al, this.getLayer().getFeatureType(), fs, q, null, null, Stripersist.getEntityManager(), this.getApplication(), this.getContext().getRequest());
        }
        return features;
    }

    public boolean isHistorisch() {
        return this.historisch;
    }

    public void setHistorisch(boolean historisch) {
        this.historisch = historisch;
    }
}

