/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.i18n.LocalizableActionBean;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.services.FeatureTypeRelation;
import nl.b3p.viewer.config.services.FeatureTypeRelationKey;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.print.Legend;
import nl.b3p.viewer.print.PrintExtraInfo;
import nl.b3p.viewer.print.PrintInfo;
import nl.b3p.viewer.print.PrintUtil;
import nl.b3p.viewer.stripes.FileUploadActionBean;
import nl.b3p.viewer.stripes.PrintActionBean;
import nl.b3p.viewer.util.FeaturePropertiesArrayHelper;
import nl.b3p.viewer.util.FeatureToJson;
import nl.b3p.viewer.util.FlamingoCQL;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/print")
@StrictBinding
public class PrintActionBean
extends LocalizableActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(PrintActionBean.class);
    protected static Logger fopLogger = Logger.getLogger((String)"org.apache.fop");
    public static final String A5_Landscape = "A5_Landscape.xsl";
    public static final String A5_Portrait = "A5_Portrait.xsl";
    public static final String A4_Landscape = "A4_Landscape.xsl";
    public static final String A4_Portrait = "A4_Portrait.xsl";
    public static final String A3_Landscape = "A3_Landscape.xsl";
    public static final String A3_Portrait = "A3_Portrait.xsl";
    public static final String A2_Landscape = "A2_Landscape.xsl";
    public static final String A2_Portrait = "A2_Portrait.xsl";
    public static final String A1_Landscape = "A1_Landscape.xsl";
    public static final String A1_Portrait = "A1_Portrait.xsl";
    public static final String A0_Landscape = "A0_Landscape.xsl";
    public static final String A0_Portrait = "A0_Portrait.xsl";
    public static final String DEFAULT_TEMPLATE_PATH = "/WEB-INF/xsl/print/";
    public static final String A5 = "a5";
    public static final String A4 = "a4";
    public static final String A3 = "a3";
    public static final String A2 = "a2";
    public static final String A1 = "a1";
    public static final String A0 = "a0";
    public static final String LANDSCAPE = "landscape";
    public static final String PORTRAIT = "portrait";
    public static SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy", new Locale("NL"));
    public static final String FID = "__fid";
    private static final int TIMEOUT = 5000;
    @Validate
    private int maxrelatedfeatures = 10;
    @Validate
    private int maxFeatures = 500;
    @Validate
    private String params;
    private ActionBeanContext context;

    @DefaultHandler
    public Resolution print() throws JSONException, Exception {
        String templateUrl;
        String mimeType;
        String username;
        boolean mailprint = false;
        JSONObject jRequest = new JSONObject(this.params);
        Long appId = jRequest.optLong("appId");
        EntityManager em = Stripersist.getEntityManager();
        Application app = (Application)em.find(Application.class, (Object)appId);
        String baseUrl = this.context.getRequest().getRequestURL().toString();
        Cookie[] cookies = this.context.getRequest().getCookies();
        String ssojsessionid = null;
        String ssokey = "JSESSIONIDSSO";
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie == null || !cookie.getName().equalsIgnoreCase(ssokey)) continue;
                ssojsessionid = cookie.getValue();
                break;
            }
        }
        String imageUrl = PrintUtil.getImageUrl((String)this.params, (String)baseUrl, (String)this.context.getRequest().getSession().getId(), ssojsessionid);
        PrintInfo info = new PrintInfo();
        RedirectResolution to = new RedirectResolution(FileUploadActionBean.class, "view");
        RedirectResolution from = new RedirectResolution(PrintActionBean.class);
        String viewUploadURL = baseUrl.replace(from.getUrl(new Locale("NL")), to.getUrl(new Locale("NL")));
        info.setUploadURL(viewUploadURL);
        if (jRequest.has("title")) {
            info.setTitle(jRequest.getString("title"));
        }
        if (jRequest.has("subtitle")) {
            info.setSubtitle(jRequest.getString("subtitle"));
        }
        if (!StringUtils.isEmpty((String)(username = this.context.getRequest().getRemoteUser()))) {
            info.setUsername(username);
        }
        info.setDate(df.format(new Date()));
        info.setImageUrl(imageUrl);
        if (jRequest.has("bbox")) {
            info.setBbox(jRequest.getString("bbox"));
        }
        if (jRequest.has("overview")) {
            String url = PrintUtil.getOverviewUrl((String)this.params, (String)this.context.getRequest().getRequestURL().toString(), (String)this.context.getRequest().getSession().getId(), (String)ssojsessionid);
            info.setOverviewUrl(url);
        }
        if (jRequest.has("extraTekst")) {
            info.setRemark(jRequest.getString("extraTekst"));
        }
        if (jRequest.has("quality")) {
            info.setQuality(jRequest.getInt("quality"));
        }
        if (jRequest.has("scale")) {
            info.setScale(jRequest.optString("scale"));
        }
        if (jRequest.has("units")) {
            info.setUnits(jRequest.getString("units"));
        }
        if (jRequest.has("includeLegend") && jRequest.getBoolean("includeLegend")) {
            if (jRequest.has("legendUrl")) {
                JSONArray jarray = null;
                Object o = jRequest.get("legendUrl");
                if (o instanceof JSONArray) {
                    jarray = (JSONArray)o;
                } else if (o instanceof String) {
                    jarray = new JSONArray();
                    jarray.put(o);
                }
                for (int i = 0; i < jarray.length(); ++i) {
                    JSONObject legendJson;
                    try {
                        legendJson = jarray.getJSONObject(i);
                    }
                    catch (JSONException jse) {
                        legendJson = new JSONObject(jarray.getString(i));
                    }
                    Legend legend = new Legend(legendJson);
                    info.getLegendUrls().add(legend);
                }
            }
            info.cacheLegendImagesAndReadDimensions(this.context, em);
        }
        if (jRequest.has("includeAttributes") && jRequest.getBoolean("includeAttributes")) {
            if (!jRequest.has("extra")) {
                jRequest.put("extra", (Object)new JSONArray());
            }
            if (jRequest.has("attributesObject")) {
                this.processAttributes(jRequest, em, jRequest, app, this.context.getRequest());
            }
        }
        if (jRequest.has("angle")) {
            int angle = jRequest.getInt("angle");
            angle %= 360;
            angle = 360 - angle;
            info.setAngle(angle);
        }
        if (jRequest.has("action") && jRequest.getString("action").equalsIgnoreCase("savePDF")) {
            mimeType = "application/pdf";
        } else if (jRequest.has("action") && jRequest.getString("action").equalsIgnoreCase("mailPDF")) {
            mimeType = "application/pdf";
            mailprint = true;
        } else {
            throw new Exception("Unidentified action: " + jRequest.getString("action"));
        }
        if (jRequest.has("extra")) {
            log.debug((Object)"Print Parse 'extra'");
            JSONArray jarray = jRequest.getJSONArray("extra");
            ArrayList<PrintExtraInfo> peis = new ArrayList<PrintExtraInfo>();
            for (int i = 0; i < jarray.length(); ++i) {
                JSONObject extraObj = jarray.getJSONObject(i);
                PrintExtraInfo pei = new PrintExtraInfo();
                String className = extraObj.getString("className");
                String componentName = extraObj.getString("componentName");
                Object infoObject = extraObj.get("info");
                pei.setClassName(className);
                if (componentName != null) {
                    componentName = componentName.replaceAll("_", " ");
                }
                pei.setComponentName(componentName);
                if (infoObject instanceof JSONArray) {
                    pei.setInfoArray((JSONArray)infoObject);
                } else if (infoObject instanceof JSONObject) {
                    pei.setInfoText((JSONObject)infoObject);
                }
                peis.add(pei);
            }
            info.setExtra(peis);
        }
        String pageFormat = jRequest.has("pageformat") ? jRequest.getString("pageformat") : A4;
        String orientation = jRequest.has("orientation") ? jRequest.getString("orientation") : PORTRAIT;
        String xsltemplate = jRequest.has("xsltemplate") ? jRequest.getString("xsltemplate") : null;
        String templateName = xsltemplate != null ? xsltemplate : this.getTemplateName(pageFormat, orientation);
        log.debug((Object)String.format("Request for print using pageFormat: %s, orientation %s with output format %s", pageFormat, orientation, mimeType));
        boolean useMailer = mailprint;
        if (app != null && app.getDetails() != null && app.getDetails().get("stylesheetPrint") != null) {
            ClobElement ce = (ClobElement)app.getDetails().get("stylesheetPrint");
            templateUrl = ce.getValue() + templateName;
        } else {
            templateUrl = this.context.getServletContext().getRealPath(DEFAULT_TEMPLATE_PATH + templateName);
        }
        String toMail = jRequest.getString("mailTo");
        String fromMail = jRequest.has("fromAddress") ? jRequest.getString("fromAddress") : "";
        String fromName = jRequest.has("fromName") ? jRequest.getString("fromName") : "";
        1 res = new /* Unavailable Anonymous Inner Class!! */;
        return res;
    }

    private String getTemplateName(String pageFormat, String orientation) {
        if (A5.equalsIgnoreCase(pageFormat) && LANDSCAPE.equalsIgnoreCase(orientation)) {
            return A5_Landscape;
        }
        if (A5.equalsIgnoreCase(pageFormat) && PORTRAIT.equalsIgnoreCase(orientation)) {
            return A5_Portrait;
        }
        if (A4.equalsIgnoreCase(pageFormat) && LANDSCAPE.equalsIgnoreCase(orientation)) {
            return A4_Landscape;
        }
        if (A3.equalsIgnoreCase(pageFormat) && PORTRAIT.equalsIgnoreCase(orientation)) {
            return A3_Portrait;
        }
        if (A3.equalsIgnoreCase(pageFormat) && LANDSCAPE.equalsIgnoreCase(orientation)) {
            return A3_Landscape;
        }
        if (A2.equalsIgnoreCase(pageFormat) && PORTRAIT.equalsIgnoreCase(orientation)) {
            return A2_Portrait;
        }
        if (A2.equalsIgnoreCase(pageFormat) && LANDSCAPE.equalsIgnoreCase(orientation)) {
            return A2_Landscape;
        }
        if (A1.equalsIgnoreCase(pageFormat) && PORTRAIT.equalsIgnoreCase(orientation)) {
            return A1_Portrait;
        }
        if (A1.equalsIgnoreCase(pageFormat) && LANDSCAPE.equalsIgnoreCase(orientation)) {
            return A1_Landscape;
        }
        if (A0.equalsIgnoreCase(pageFormat) && PORTRAIT.equalsIgnoreCase(orientation)) {
            return A0_Portrait;
        }
        if (A0.equalsIgnoreCase(pageFormat) && LANDSCAPE.equalsIgnoreCase(orientation)) {
            return A0_Landscape;
        }
        return A4_Portrait;
    }

    private void processAttributes(JSONObject req, EntityManager em, JSONObject jRequest, Application application, HttpServletRequest request) {
        JSONArray attrsObj = req.getJSONArray("attributesObject");
        JSONObject info = new JSONObject();
        for (int i = 0; i < attrsObj.length(); ++i) {
            JSONObject result = new JSONObject();
            result.put("className", (Object)"attributes");
            JSONObject obj = attrsObj.getJSONObject(i);
            Long appLayerId = obj.getLong("appLayer");
            try {
                String filter = obj.optString("filter");
                filter = filter.isEmpty() ? null : filter;
                ApplicationLayer appLayer = (ApplicationLayer)em.find(ApplicationLayer.class, (Object)appLayerId);
                Layer layer = appLayer.getService().getSingleLayer(appLayer.getLayerName(), em);
                SimpleFeatureType ft = layer.getFeatureType();
                String l = appLayer.getDisplayName(em);
                result.put("componentName", (Object)l);
                JSONArray features = this.getFeatures(appLayer, layer, filter, em, jRequest, application, request);
                info.put("al_" + appLayerId, (Object)features);
                result.put("info", (Object)info);
                jRequest.getJSONArray("extra").put((Object)result);
                continue;
            }
            catch (Exception e) {
                log.error((Object)("Cannot retrieve attributes for appLayerId " + appLayerId), (Throwable)e);
            }
        }
    }

    private JSONArray getFeatures(ApplicationLayer appLayer, Layer layer, String f, EntityManager em, JSONObject params, Application application, HttpServletRequest request) throws Exception {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        FeatureSource fs = layer.getFeatureType().openGeoToolsFeatureSource(5000);
        ArrayList attributesToInclude = new ArrayList();
        List attrs = appLayer.getAttributes(layer.getFeatureType(), true);
        String geomAttribute = fs.getSchema().getGeometryDescriptor().getLocalName();
        attrs.forEach(attr -> attributesToInclude.add(attr.getId()));
        Query q = null;
        if (f != null) {
            Filter filter = FlamingoCQL.toFilter((String)f, (EntityManager)em);
            q = new Query(fs.getName().toString(), filter);
        } else {
            q = new Query(fs.getName().toString());
        }
        q.setMaxFeatures(this.maxFeatures);
        q.setHandle("PrintActionBean_attributes");
        FeatureToJson ftjson = new FeatureToJson(false, false, false, true, false, attributesToInclude, true);
        JSONArray features = ftjson.getJSONFeatures(appLayer, layer.getFeatureType(), fs, q, em, application, request);
        fs.getDataStore().dispose();
        for (int i = 0; i < features.length(); ++i) {
            JSONArray jFeat = features.getJSONArray(i);
            FeaturePropertiesArrayHelper.removeKey((JSONArray)jFeat, (String)FID);
            FeaturePropertiesArrayHelper.removeKey((JSONArray)jFeat, (String)geomAttribute);
            FeaturePropertiesArrayHelper.removeKey((JSONArray)jFeat, (String)"related_featuretypes");
            if (!layer.getFeatureType().hasRelations()) continue;
            ftjson = new FeatureToJson(false, false, false, true, true, attributesToInclude, true);
            for (FeatureTypeRelation rel : layer.getFeatureType().getRelations()) {
                if (!rel.getType().equals("relate")) continue;
                SimpleFeatureType fType = rel.getForeignFeatureType();
                String label = fType.getDescription() == null ? fType.getTypeName() : fType.getDescription();
                log.debug((Object)("Processing related featuretype: " + label));
                List keys = rel.getRelationKeys();
                String leftSide = ((FeatureTypeRelationKey)keys.get(0)).getLeftSide().getName();
                String rightSide = ((FeatureTypeRelationKey)keys.get(0)).getRightSide().getName();
                JSONObject info = new JSONObject();
                if (FeaturePropertiesArrayHelper.containsKey((JSONArray)jFeat, (String)leftSide)) {
                    int featureCount;
                    String type = ((FeatureTypeRelationKey)keys.get(0)).getLeftSide().getExtJSType();
                    String query = rightSide + "=";
                    query = type.equalsIgnoreCase("string") || type.equalsIgnoreCase("date") || type.equalsIgnoreCase("auto") ? query + "'" + FeaturePropertiesArrayHelper.getByKey((JSONArray)jFeat, (String)leftSide) + "'" : query + FeaturePropertiesArrayHelper.getByKey((JSONArray)jFeat, (String)leftSide);
                    q = new Query(fType.getTypeName(), FlamingoCQL.toFilter((String)query, (EntityManager)em));
                    q.setMaxFeatures(this.maxrelatedfeatures + 1);
                    q.setHandle("FeatureReportActionBean_related_attributes");
                    log.debug((Object)("Related features query: " + q));
                    fs = fType.openGeoToolsFeatureSource(5000);
                    JSONArray relatedFeatures = ftjson.getJSONFeatures(appLayer, fType, fs, q, em, application, request);
                    JSONArray jsonFeats = new JSONArray();
                    int colCount = 0;
                    int numFeats = relatedFeatures.length();
                    int maxFeatures = Math.min(numFeats, this.maxrelatedfeatures);
                    for (featureCount = 0; featureCount < maxFeatures; ++featureCount) {
                        JSONArray feat = relatedFeatures.getJSONArray(featureCount);
                        FeaturePropertiesArrayHelper.removeKey((JSONArray)feat, (String)FID);
                        colCount = feat.length();
                        jsonFeats.put((Object)feat);
                    }
                    info.put("features", (Object)jsonFeats);
                    info.putOnce("colCount", (Object)colCount);
                    info.putOnce("rowCount", (Object)featureCount);
                    if (numFeats > this.maxrelatedfeatures) {
                        String msg = MessageFormat.format(this.getBundle().getString("viewer.printactionbean.moreitems"), this.maxrelatedfeatures);
                        info.putOnce("moreMessage", (Object)msg);
                    }
                } else {
                    String msg = MessageFormat.format(this.getBundle().getString("viewer.printactionbean.columnmissing"), leftSide);
                    info.putOnce("errorMessage", (Object)msg);
                }
                JSONObject related = new JSONObject();
                related.put("related_features", (Object)info);
                info.put("title", (Object)label);
                jFeat.put((Object)related);
                log.debug((Object)("extra data: " + info));
                fs.getDataStore().dispose();
            }
        }
        return features;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public int getMaxrelatedfeatures() {
        return this.maxrelatedfeatures;
    }

    public void setMaxrelatedfeatures(int maxrelatedfeatures) {
        this.maxrelatedfeatures = maxrelatedfeatures;
    }

    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    public void setMaxFeatures(int maxFeatures) {
        this.maxFeatures = maxFeatures;
    }

    static /* synthetic */ ActionBeanContext access$000(PrintActionBean x0) {
        return x0.context;
    }

    static /* synthetic */ Log access$100() {
        return log;
    }
}

