/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.audit.AuditMessageObject;
import nl.b3p.viewer.audit.Auditable;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.security.Authorizations;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.stripes.LocalizableApplicationActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureSource;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.util.GeometryTypeConverterFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.util.Converter;
import org.json.JSONException;
import org.json.JSONObject;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.LineStringExtracter;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.operation.polygonize.Polygonizer;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/feature/split")
@StrictBinding
public class SplitFeatureActionBean
extends LocalizableApplicationActionBean
implements Auditable {
    private static final Log log = LogFactory.getLog(SplitFeatureActionBean.class);
    private static final String FID = "__fid";
    private ActionBeanContext context;
    @Validate
    private Application application;
    @Validate
    private ApplicationLayer appLayer;
    @Validate
    private String toSplitWithFeature;
    @Validate
    private String strategy;
    @Validate
    private String extraData;
    @Validate
    private String splitFeatureFID;
    private SimpleFeatureStore store;
    private Layer layer = null;
    private boolean unauthorized;
    private AuditMessageObject auditMessageObject;

    @After(stages={LifecycleStage.BindingAndValidation})
    public void loadLayer() {
        this.layer = this.appLayer.getService().getSingleLayer(this.appLayer.getLayerName(), Stripersist.getEntityManager());
    }

    @Before(stages={LifecycleStage.EventHandling})
    public void checkAuthorization() {
        if (this.application == null || this.appLayer == null || !Authorizations.isLayerGeomWriteAuthorized((Layer)this.layer, (HttpServletRequest)this.context.getRequest(), (EntityManager)Stripersist.getEntityManager())) {
            this.unauthorized = true;
        }
        this.auditMessageObject = new AuditMessageObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution split() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        String error = null;
        if (this.appLayer == null) {
            error = "Invalid parameters";
        } else if (this.unauthorized) {
            error = "Not authorized";
        } else {
            FeatureSource fs = null;
            try {
                if (this.splitFeatureFID == null) {
                    throw new IllegalArgumentException(this.getBundle().getString("viewer.splitfeatureactionbean.1"));
                }
                if (this.toSplitWithFeature == null) {
                    throw new IllegalArgumentException(this.getBundle().getString("viewer.splitfeatureactionbean.2"));
                }
                fs = this.layer.getFeatureType().openGeoToolsFeatureSource();
                if (!(fs instanceof SimpleFeatureStore)) {
                    throw new IllegalArgumentException(this.getBundle().getString("viewer.splitfeatureactionbean.3"));
                }
                this.store = (SimpleFeatureStore)fs;
                List ids = this.splitFeature();
                if (ids.size() < 2) {
                    throw new IllegalArgumentException(this.getBundle().getString("viewer.splitfeatureactionbean.4"));
                }
                json.put("fids", (Collection)ids);
                json.put("success", (Object)Boolean.TRUE);
            }
            catch (IllegalArgumentException e) {
                log.warn((Object)"Split error", (Throwable)e);
                error = e.getLocalizedMessage();
            }
            catch (Exception e) {
                log.error((Object)String.format("Exception splitting feature %s", this.splitFeatureFID), (Throwable)e);
                error = e.toString();
                if (e.getCause() != null) {
                    error = error + "; cause: " + e.getCause().toString();
                }
            }
            finally {
                if (fs != null) {
                    fs.getDataStore().dispose();
                }
            }
        }
        if (error != null) {
            json.put("error", (Object)error);
        }
        this.auditMessageObject.addMessage((Object)json);
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    protected List<SimpleFeature> handleExtraData(List<SimpleFeature> features) throws Exception {
        return features;
    }

    protected SimpleFeature handleExtraData(SimpleFeature feature) throws Exception {
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        features.add(feature);
        return (SimpleFeature)this.handleExtraData(features).get(0);
    }

    private List<FeatureId> splitFeature() throws Exception {
        ArrayList<FeatureId> ids = new ArrayList();
        try (DefaultTransaction transaction = new DefaultTransaction("split");){
            this.store.setTransaction((Transaction)transaction);
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
            Id filter = ff.id(new FeatureId[]{new FeatureIdImpl(this.splitFeatureFID)});
            SimpleFeatureCollection fc = this.store.getFeatures((Filter)filter);
            SimpleFeature f = null;
            if (!fc.features().hasNext()) {
                throw new IllegalArgumentException(MessageFormat.format(this.getBundle().getString("viewer.splitfeatureactionbean.5"), this.splitFeatureFID));
            }
            f = (SimpleFeature)fc.features().next();
            String geomAttribute = ((SimpleFeatureType)this.store.getSchema()).getGeometryDescriptor().getLocalName();
            Geometry toSplit = (Geometry)f.getProperty(geomAttribute).getValue();
            Geometry splitWith = new WKTReader().read(this.toSplitWithFeature);
            List geoms = null;
            switch (toSplit.getDimension()) {
                case 1: {
                    geoms = this.splitLine(toSplit, splitWith);
                    break;
                }
                case 2: {
                    geoms = this.splitPolygon(toSplit, splitWith);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MessageFormat.format(this.getBundle().getString("viewer.splitfeatureactionbean.6"), toSplit.getDimension()));
                }
            }
            ids = this.handleStrategy(f, geoms, (Filter)filter, this.store, this.strategy);
            transaction.commit();
            this.afterSplit(ids);
        }
        if (this.strategy.equalsIgnoreCase("replace")) {
            ids.add(0, (FeatureId)new FeatureIdImpl(this.splitFeatureFID));
        }
        return ids;
    }

    protected void afterSplit(List<FeatureId> ids) {
    }

    protected List<FeatureId> handleStrategy(SimpleFeature feature, List<? extends Geometry> geoms, Filter filter, SimpleFeatureStore localStore, String localStrategy) throws Exception {
        List<SimpleFeature> newFeats = new ArrayList();
        GeometryTypeConverterFactory cf = new GeometryTypeConverterFactory();
        Converter c = cf.createConverter(Geometry.class, ((SimpleFeatureType)localStore.getSchema()).getGeometryDescriptor().getType().getBinding(), null);
        GeometryType type = ((SimpleFeatureType)localStore.getSchema()).getGeometryDescriptor().getType();
        String geomAttribute = ((SimpleFeatureType)localStore.getSchema()).getGeometryDescriptor().getLocalName();
        boolean firstFeature = true;
        for (Geometry geometry : geoms) {
            if (firstFeature) {
                if (localStrategy == null || localStrategy.equalsIgnoreCase("replace")) {
                    feature.setAttribute(geomAttribute, c.convert((Object)geometry, type.getBinding()));
                    feature = this.handleExtraData(feature);
                    Object[] attributevalues = feature.getAttributes().toArray(new Object[feature.getAttributeCount()]);
                    String[] attributes = DataUtilities.attributeNames((SimpleFeatureType)feature.getFeatureType());
                    localStore.modifyFeatures(attributes, attributevalues, filter);
                    firstFeature = false;
                    continue;
                }
                if (localStrategy.equalsIgnoreCase("add")) {
                    localStore.removeFeatures(filter);
                    firstFeature = false;
                } else {
                    throw new IllegalArgumentException(MessageFormat.format(this.getBundle().getString("viewer.splitfeatureactionbean.7"), localStrategy));
                }
            }
            SimpleFeature newFeat = DataUtilities.createFeature((SimpleFeatureType)feature.getType(), (String)DataUtilities.encodeFeature((SimpleFeature)feature, (boolean)false));
            newFeat.setAttribute(geomAttribute, c.convert((Object)geometry, type.getBinding()));
            newFeats.add(newFeat);
        }
        newFeats = this.handleExtraData(newFeats);
        return localStore.addFeatures((FeatureCollection)DataUtilities.collection(newFeats));
    }

    private void geometrySorter(List<? extends Geometry> geoms) {
        Collections.sort(geoms, new /* Unavailable Anonymous Inner Class!! */);
    }

    protected List<LineString> splitLine(Geometry toSplit, Geometry line) {
        ArrayList<LineString> output = new ArrayList<LineString>();
        Geometry lines = toSplit.union(line);
        Geometry bufferedToSplit = toSplit.buffer(1.0);
        for (int i = 0; i < lines.getNumGeometries(); ++i) {
            LineString l = (LineString)lines.getGeometryN(i);
            if (!bufferedToSplit.contains((Geometry)l)) continue;
            output.add(l);
        }
        this.geometrySorter(output);
        return output;
    }

    protected List<Polygon> splitPolygon(Geometry poly, Geometry line) {
        ArrayList<Polygon> output = new ArrayList<Polygon>();
        Geometry nodedLinework = poly.getBoundary().union(line);
        Geometry polys = this.polygonize(nodedLinework);
        for (int i = 0; i < polys.getNumGeometries(); ++i) {
            Polygon candpoly = (Polygon)polys.getGeometryN(i);
            if (!poly.contains((Geometry)candpoly.getInteriorPoint())) continue;
            output.add(candpoly);
        }
        this.geometrySorter(output);
        return output;
    }

    private Geometry polygonize(Geometry geometry) {
        List lines = LineStringExtracter.getLines((Geometry)geometry);
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add((Collection)lines);
        Collection polys = polygonizer.getPolygons();
        Polygon[] polyArray = GeometryFactory.toPolygonArray((Collection)polys);
        return geometry.getFactory().createGeometryCollection((Geometry[])polyArray);
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public ApplicationLayer getAppLayer() {
        return this.appLayer;
    }

    public void setAppLayer(ApplicationLayer appLayer) {
        this.appLayer = appLayer;
    }

    public String getToSplitWithFeature() {
        return this.toSplitWithFeature;
    }

    public void setToSplitWithFeature(String toSplitWithFeature) {
        this.toSplitWithFeature = toSplitWithFeature;
    }

    public String getSplitFeatureFID() {
        return this.splitFeatureFID;
    }

    public void setSplitFeatureFID(String splitFeatureFID) {
        this.splitFeatureFID = splitFeatureFID;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public String getExtraData() {
        return this.extraData;
    }

    public void setExtraData(String extraData) {
        this.extraData = extraData;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public AuditMessageObject getAuditMessageObject() {
        return this.auditMessageObject;
    }
}

