/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.ibis.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.persistence.EntityManager;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.ibis.util.IbisConstants;
import nl.b3p.viewer.ibis.util.WorkflowStatus;
import nl.b3p.viewer.ibis.util.WorkflowUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.overlay.snap.GeometrySnapper;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;

public class WorkflowUtil
implements IbisConstants {
    private static final Log log = LogFactory.getLog(WorkflowUtil.class);

    private WorkflowUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTerreinGeometry(Integer terreinID, Layer layer, WorkflowStatus kavelStatus, Application application, EntityManager em) {
        log.debug((Object)("Updating terrein geometry for " + terreinID));
        SimpleFeatureStore terreinStore = null;
        SimpleFeatureStore kavelStore = null;
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        DefaultTransaction terreinTransaction = new DefaultTransaction("edit-terrein-geom");
        DefaultTransaction kavelTransaction = new DefaultTransaction("get-kavel-geom");
        try {
            Geometry newTerreinGeom;
            ExcludeFilter kavelFilter = Filter.EXCLUDE;
            switch (2.$SwitchMap$nl$b3p$viewer$ibis$util$WorkflowStatus[kavelStatus.ordinal()]) {
                case 1: {
                    kavelFilter = ff.and((Filter)ff.equals((Expression)ff.property("terreinid"), (Expression)ff.literal((Object)terreinID)), (Filter)ff.or((Filter)ff.equal((Expression)ff.property("workflow_status"), (Expression)ff.literal((Object)WorkflowStatus.bewerkt.toString()), false), (Filter)ff.equal((Expression)ff.property("workflow_status"), (Expression)ff.literal((Object)WorkflowStatus.definitief.toString()), false)));
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    kavelFilter = ff.and((Filter)ff.equals((Expression)ff.property("terreinid"), (Expression)ff.literal((Object)terreinID)), (Filter)ff.equal((Expression)ff.property("workflow_status"), (Expression)ff.literal((Object)WorkflowStatus.definitief.toString()), false));
                    break;
                }
            }
            log.debug((Object)("Looking for kavel(s) with filter: " + kavelFilter));
            kavelStore = (SimpleFeatureStore)layer.getFeatureType().openGeoToolsFeatureSource();
            kavelStore.setTransaction((Transaction)kavelTransaction);
            SimpleFeatureCollection kavels = kavelStore.getFeatures((Filter)kavelFilter);
            ArrayList kavelGeoms = new ArrayList();
            kavels.accepts((FeatureVisitor)new /* Unavailable Anonymous Inner Class!! */, null);
            log.debug((Object)("Kavels found for this terrein: " + kavelGeoms.size()));
            if (kavelGeoms.size() == 1) {
                newTerreinGeom = (Geometry)kavelGeoms.get(0);
            } else {
                GeometryFactory factory = JTSFactoryFinder.getGeometryFactory(null);
                GeometryCollection geometryCollection = (GeometryCollection)factory.buildGeometry(kavelGeoms);
                newTerreinGeom = geometryCollection.union();
            }
            log.debug((Object)("terrein geom : " + newTerreinGeom));
            newTerreinGeom = newTerreinGeom.buffer(0.001, 1);
            log.trace((Object)("buffer+.001   : " + newTerreinGeom));
            newTerreinGeom = newTerreinGeom.buffer(-0.001, 1);
            log.trace((Object)("buffer-.001   : " + newTerreinGeom));
            newTerreinGeom = GeometrySnapper.snapToSelf((Geometry)newTerreinGeom, (double)0.01, (boolean)true);
            log.debug((Object)("snapped+clean: " + newTerreinGeom));
            if (!newTerreinGeom.getGeometryType().equalsIgnoreCase("MultiPolygon")) {
                GeometryFactory f = JTSFactoryFinder.getGeometryFactory();
                newTerreinGeom = f.createMultiPolygon(new Polygon[]{(Polygon)newTerreinGeom});
            }
            ApplicationLayer terreinAppLyr = null;
            List lyrs = application.loadTreeCache(em).getApplicationLayers();
            ListIterator it = lyrs.listIterator();
            while (it.hasNext() && !(terreinAppLyr = (ApplicationLayer)it.next()).getLayerName().equalsIgnoreCase("bedrijventerrein")) {
            }
            Layer l = terreinAppLyr.getService().getLayer("bedrijventerrein", em);
            terreinStore = (SimpleFeatureStore)l.getFeatureType().openGeoToolsFeatureSource();
            terreinStore.setTransaction((Transaction)terreinTransaction);
            ExcludeFilter terreinFilter = Filter.EXCLUDE;
            switch (2.$SwitchMap$nl$b3p$viewer$ibis$util$WorkflowStatus[kavelStatus.ordinal()]) {
                case 1: {
                    terreinFilter = ff.and((Filter)ff.equals((Expression)ff.property("ibis_id"), (Expression)ff.literal((Object)terreinID)), (Filter)ff.equal((Expression)ff.property("workflow_status"), (Expression)ff.literal((Object)WorkflowStatus.bewerkt.name()), false));
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    terreinFilter = ff.and((Filter)ff.equals((Expression)ff.property("ibis_id"), (Expression)ff.literal((Object)terreinID)), (Filter)ff.equal((Expression)ff.property("workflow_status"), (Expression)ff.literal((Object)WorkflowStatus.definitief.name()), false));
                    break;
                }
            }
            if (kavelStatus.equals((Object)WorkflowStatus.definitief)) {
                And perOngelukFilter = ff.and((Filter)ff.equals((Expression)ff.property("ibis_id"), (Expression)ff.literal((Object)terreinID)), (Filter)ff.equal((Expression)ff.property("workflow_status"), (Expression)ff.literal((Object)WorkflowStatus.afgevoerd.name()), false));
                log.debug((Object)("Herstel 'per ongeluk' 'afgevoerd' terrein naar 'definitief' met filter: " + terreinFilter));
                terreinStore.modifyFeatures("workflow_status", (Object)WorkflowStatus.definitief.name(), (Filter)perOngelukFilter);
            }
            log.debug((Object)("Update terrein geom for kavels filtered by: " + terreinFilter));
            String geomAttrName = ((SimpleFeatureType)terreinStore.getSchema()).getGeometryDescriptor().getLocalName();
            terreinStore.modifyFeatures(geomAttrName, (Object)newTerreinGeom, (Filter)terreinFilter);
            terreinTransaction.commit();
            log.debug((Object)("Done updating terrein geometry for " + terreinFilter + " with new geom: " + newTerreinGeom + " on attribute " + geomAttrName));
        }
        catch (Exception e) {
            log.error((Object)String.format("Update van terrein geometrie %s is mislukt", terreinID), (Throwable)e);
        }
        finally {
            try {
                terreinTransaction.close();
            }
            catch (IOException io) {
                log.warn((Object)"Error closing terrein transaction", (Throwable)io);
            }
            if (terreinStore != null) {
                terreinStore.getDataStore().dispose();
            }
            try {
                kavelTransaction.close();
            }
            catch (IOException io) {
                log.warn((Object)"Error closing kavel transaction", (Throwable)io);
            }
            if (kavelStore != null) {
                kavelStore.getDataStore().dispose();
            }
        }
    }
}

