/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.image;

public class Bbox {
    private Double minx;
    private Double maxx;
    private Double miny;
    private Double maxy;

    public Bbox(double[] b) {
        this.setBbox(b);
    }

    public Bbox(double minx, double miny, double maxx, double maxy) {
        this.minx = minx;
        this.maxx = maxx;
        this.miny = miny;
        this.maxy = maxy;
    }

    public Bbox(Bbox b) {
        this.setBbox(b.toDoubleArray());
    }

    public Bbox(String bbox) throws Exception {
        String[] b = bbox.split(",");
        if (b.length != 4) {
            throw new Exception("Constructor needs 4 coords.");
        }
        this.minx = Double.parseDouble(b[0]);
        this.miny = Double.parseDouble(b[1]);
        this.maxx = Double.parseDouble(b[2]);
        this.maxy = Double.parseDouble(b[3]);
    }

    public void setBbox(double[] b) {
        if (b == null || b.length != 4) {
            return;
        }
        this.minx = b[0];
        this.miny = b[1];
        this.maxx = b[2];
        this.maxy = b[3];
    }

    public double getMinx() {
        return this.minx;
    }

    public void setMinx(double minx) {
        this.minx = minx;
    }

    public double getMaxx() {
        return this.maxx;
    }

    public void setMaxx(double maxx) {
        this.maxx = maxx;
    }

    public double getMiny() {
        return this.miny;
    }

    public void setMiny(double miny) {
        this.miny = miny;
    }

    public double getMaxy() {
        return this.maxy;
    }

    public void setMaxy(double maxy) {
        this.maxy = maxy;
    }

    public double getCenterX() {
        return (this.maxx + this.minx) / 2.0;
    }

    public double getCenterY() {
        return (this.maxy + this.miny) / 2.0;
    }

    public double getWidth() {
        return this.maxx - this.minx;
    }

    public double getHeight() {
        return this.maxy - this.miny;
    }

    double[] toDoubleArray() {
        if (this.minx == null || this.miny == null || this.maxx == null || this.maxy == null) {
            return null;
        }
        double[] r = new double[]{this.minx, this.miny, this.maxx, this.maxy};
        return r;
    }

    public void transform(double transformX, double transformY) {
        this.minx = this.minx + transformX;
        this.maxx = this.maxx + transformX;
        this.miny = this.miny + transformY;
        this.maxy = this.maxy + transformY;
    }

    public String toString() {
        String returnValue = "";
        returnValue = returnValue + this.getMinx();
        returnValue = returnValue + ",";
        returnValue = returnValue + this.getMiny();
        returnValue = returnValue + ",";
        returnValue = returnValue + this.getMaxx();
        returnValue = returnValue + ",";
        returnValue = returnValue + this.getMaxy();
        return returnValue;
    }

    public String toWKT() {
        String s = "POLYGON((";
        s = s + this.getMinx() + " " + this.getMiny() + ",";
        s = s + this.getMinx() + " " + this.getMaxy() + ",";
        s = s + this.getMaxx() + " " + this.getMaxy() + ",";
        s = s + this.getMaxx() + " " + this.getMiny() + ",";
        s = s + this.getMinx() + " " + this.getMiny();
        s = s + "))";
        return s;
    }
}

