/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.geotools.filter.visitor.RemoveDistanceUnit;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.app.ConfiguredAttribute;
import nl.b3p.viewer.config.security.Authorizations;
import nl.b3p.viewer.config.services.GeoService;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.config.services.WFSFeatureSource;
import nl.b3p.viewer.stripes.LocalizableApplicationActionBean;
import nl.b3p.viewer.util.ChangeMatchCase;
import nl.b3p.viewer.util.FeatureToJson;
import nl.b3p.viewer.util.FlamingoCQL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.stripesstuff.stripersist.Stripersist;

/*
 * Exception performing whole class analysis ignored.
 */
@UrlBinding(value="/action/attributes")
@StrictBinding
public class AttributesActionBean
extends LocalizableApplicationActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(AttributesActionBean.class);
    private ActionBeanContext context;
    @Validate
    private Application application;
    @Validate
    private ApplicationLayer appLayer;
    @Validate
    private SimpleFeatureType featureType;
    protected Layer layer = null;
    @Validate
    private int limit;
    @Validate
    private int page;
    @Validate
    private int start;
    @Validate
    private String dir;
    @Validate
    private String sort;
    @Validate
    private boolean arrays;
    @Validate
    private boolean edit = false;
    @Validate
    private String filter;
    @Validate
    private boolean clearTotalCountCache = false;
    @Validate
    private boolean aliases = true;
    @Validate
    private boolean includeRelations = true;
    @Validate
    private boolean debug;
    @Validate
    private boolean noCache;
    private boolean unauthorized;
    private boolean userAllowedToEditGeom = true;
    @Validate
    private List<Long> attributesToInclude = new ArrayList();
    @Validate
    private List<Long> attributesNotNull = new ArrayList();
    @Validate
    private boolean graph = false;
    private static final String CACHE_APPLAYER = "total_count_cache_applayer";
    private static final String CACHE_FILTER = "total_count_cache_filter";
    private static final String CACHE_TIME = "total_count_cache_time";
    private static final String CACHE_COUNT = "total_count_cache";
    private static final int CACHE_MAX_AGE = 600000;
    private static final int MAX_CACHE_SIZE = 50;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public ApplicationLayer getAppLayer() {
        return this.appLayer;
    }

    public void setAppLayer(ApplicationLayer appLayer) {
        this.appLayer = appLayer;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public boolean isArrays() {
        return this.arrays;
    }

    public void setArrays(boolean arrays) {
        this.arrays = arrays;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(SimpleFeatureType ft) {
        this.featureType = ft;
    }

    public boolean isEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public boolean isClearTotalCountCache() {
        return this.clearTotalCountCache;
    }

    public void setClearTotalCountCache(boolean clearTotalCountCache) {
        this.clearTotalCountCache = clearTotalCountCache;
    }

    public List<Long> getAttributesToInclude() {
        return this.attributesToInclude;
    }

    public void setAttributesToInclude(List<Long> attributesToInclude) {
        this.attributesToInclude = attributesToInclude;
    }

    public boolean isGraph() {
        return this.graph;
    }

    public void setGraph(boolean graph) {
        this.graph = graph;
    }

    public List<Long> getAttributesNotNull() {
        return this.attributesNotNull;
    }

    public void setAttributesNotNull(List<Long> attributesNotNull) {
        this.attributesNotNull = attributesNotNull;
    }

    public boolean isAliases() {
        return this.aliases;
    }

    public void setAliases(boolean aliases) {
        this.aliases = aliases;
    }

    public boolean isIncludeRelations() {
        return this.includeRelations;
    }

    public void setIncludeRelations(boolean includeRelations) {
        this.includeRelations = includeRelations;
    }

    @After(stages={LifecycleStage.BindingAndValidation})
    public void loadLayer() {
        this.layer = this.appLayer.getService().getSingleLayer(this.appLayer.getLayerName(), Stripersist.getEntityManager());
    }

    @Before(stages={LifecycleStage.EventHandling})
    public void checkAuthorization() {
        EntityManager em = Stripersist.getEntityManager();
        if (this.application == null || this.appLayer == null || !Authorizations.isApplicationReadAuthorized((Application)this.application, (HttpServletRequest)this.context.getRequest(), (EntityManager)em) || !Authorizations.isAppLayerReadAuthorized((Application)this.application, (ApplicationLayer)this.appLayer, (HttpServletRequest)this.context.getRequest(), (EntityManager)em)) {
            this.unauthorized = true;
        }
        this.userAllowedToEditGeom = Authorizations.isLayerGeomWriteAuthorized((Layer)this.layer, (HttpServletRequest)this.context.getRequest(), (EntityManager)em);
    }

    public Resolution attributes() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        String error = null;
        if (this.appLayer == null) {
            error = this.getBundle().getString("viewer.attributesactionbean.1");
        } else if (this.unauthorized) {
            error = this.getBundle().getString("viewer.attributesactionbean.2");
        } else {
            this.appLayer.addAttributesJSON(json, true, Stripersist.getEntityManager());
            if (!this.userAllowedToEditGeom) {
                JSONArray attr = json.getJSONArray("attributes");
                if (json.has("geometryAttributeIndex")) {
                    JSONObject geomAttr = attr.getJSONObject(json.getInt("geometryAttributeIndex"));
                    geomAttr.put("userAllowedToEditGeom", this.userAllowedToEditGeom);
                }
            }
            json.put("success", (Object)Boolean.TRUE);
        }
        if (error != null) {
            json.put("error", (Object)error);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    public static void clearTotalCountCache(ActionBeanContext context) {
        HttpSession sess = context.getRequest().getSession();
        sess.removeAttribute("total_count_cache_applayer");
        sess.removeAttribute("total_count_cache_filter");
        sess.removeAttribute("total_count_cache_time");
        sess.removeAttribute("total_count_cache");
    }

    private int lookupTotalCountCache(Callable<Integer> countProducer) throws Exception {
        Long time;
        HttpSession session = this.context.getRequest().getSession();
        Integer total = null;
        Long age = null;
        if (this.clearTotalCountCache) {
            AttributesActionBean.clearTotalCountCache((ActionBeanContext)this.context);
        }
        Long cacheAppLayerId = (Long)session.getAttribute("total_count_cache_applayer");
        if (this.appLayer.getId().equals(cacheAppLayerId) && (this.filter == null && session.getAttribute("total_count_cache_filter") == null || this.filter != null && this.filter.equals(session.getAttribute("total_count_cache_filter"))) && (time = (Long)session.getAttribute("total_count_cache_time")) != null && (age = Long.valueOf(System.currentTimeMillis() - time)) <= 600000L) {
            total = (Integer)session.getAttribute("total_count_cache");
        }
        if (total != null) {
            log.debug((Object)String.format("Returning cached total count value %d which was cached %s ms ago for app layer id %d", total, age, this.appLayer.getId()));
            return total;
        }
        long startTime = System.currentTimeMillis();
        total = countProducer.call();
        log.debug((Object)String.format("Caching total count value %d which took %d ms to get for app layer id %d", total, System.currentTimeMillis() - startTime, this.appLayer.getId()));
        session.setAttribute("total_count_cache_applayer", (Object)this.appLayer.getId());
        session.setAttribute("total_count_cache_filter", (Object)this.filter);
        session.setAttribute("total_count_cache_time", (Object)System.currentTimeMillis());
        session.setAttribute("total_count_cache", (Object)total);
        return total;
    }

    protected void setFilter(Query q, SimpleFeatureType ft, ApplicationLayer al, EntityManager em) throws Exception {
        if (this.filter != null && this.filter.trim().length() > 0) {
            Filter f = FlamingoCQL.toFilter((String)this.filter, (EntityManager)em);
            f = (Filter)f.accept((FilterVisitor)new RemoveDistanceUnit(), null);
            f = (Filter)f.accept((FilterVisitor)new ChangeMatchCase(false), null);
            f = FeatureToJson.reformatFilter((Filter)f, (SimpleFeatureType)ft, (boolean)this.includeRelations);
            q.setFilter(f);
        }
        this.applyUserLayerFilter(q, this.appLayer, ft, em);
    }

    private void applyUserLayerFilter(Query q, ApplicationLayer appLayer, SimpleFeatureType mainSft, EntityManager em) throws CQLException {
        GeoService gs = appLayer.getService();
        Layer l = gs.getLayer(appLayer.getLayerName(), em);
        if (l != null && l.isUserlayer() != null && l.isUserlayer().booleanValue() && !mainSft.getId().equals(l.getFeatureType().getId())) {
            String cql = ((ClobElement)l.getDetails().get("userlayer_filter")).getValue();
            String relatedLayerFilter = "RELATED_FEATURE(" + mainSft.getId() + ", " + l.getFeatureType().getId() + ", (" + cql + "))";
            Filter ulFilter = FlamingoCQL.toFilter((String)relatedLayerFilter, (EntityManager)em);
            FilterFactory2 ff2 = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
            Filter f = q.getFilter() != null ? ff2.and(q.getFilter(), ulFilter) : ulFilter;
            q.setFilter(f);
        }
    }

    public Resolution store() throws JSONException, Exception {
        JSONObject json = new JSONObject();
        if (this.unauthorized) {
            json.put("success", false);
            json.put("message", (Object)this.getBundle().getString("viewer.general.noauth"));
            return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
        }
        json = this.executeStore(Stripersist.getEntityManager());
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
    }

    protected JSONObject executeStore(EntityManager em) {
        JSONObject json = new JSONObject();
        try {
            int total = 0;
            if (this.featureType != null || this.layer != null && this.layer.getFeatureType() != null) {
                FeatureSource fs;
                SimpleFeatureType ft = this.featureType;
                if (ft == null) {
                    ft = this.layer.getFeatureType();
                }
                if (this.isDebug() && ft.getFeatureSource() instanceof WFSFeatureSource) {
                    HashMap<String, Boolean> extraDataStoreParams = new HashMap<String, Boolean>();
                    extraDataStoreParams.put(WFSDataStoreFactory.TRY_GZIP.key, Boolean.FALSE);
                    fs = ((WFSFeatureSource)ft.getFeatureSource()).openGeoToolsFeatureSource(ft, extraDataStoreParams);
                } else {
                    fs = ft.openGeoToolsFeatureSource();
                }
                boolean startIndexSupported = fs.getQueryCapabilities().isOffsetSupported();
                Query q = new Query(fs.getName().toString());
                this.setFilter(q, ft, this.appLayer, em);
                this.setAttributesNotNullFilters(q, this.appLayer, ft, em);
                FeatureSource fs2 = fs;
                total = this.lookupTotalCountCache((Callable)new /* Unavailable Anonymous Inner Class!! */);
                if (total == -1) {
                    json.put("virtualtotal", true);
                    total = 1000;
                }
                q.setStartIndex(Integer.valueOf(this.start));
                q.setMaxFeatures(Math.min(this.limit, 1000));
                FeatureToJson ftoj = new FeatureToJson(this.arrays, this.edit, this.graph, this.aliases, this.attributesToInclude);
                JSONArray features = ftoj.getJSONFeatures(this.appLayer, ft, fs, q, this.sort, this.dir, em, null, null);
                if (!startIndexSupported && features.length() < this.limit) {
                    total = this.start + features.length();
                }
                json.put("success", true);
                json.put("features", (Object)features);
            }
            json.put("total", total);
        }
        catch (Exception e) {
            log.error((Object)"Error loading features", (Throwable)e);
            json.put("success", false);
            String message = MessageFormat.format(this.getBundle().getString("viewer.attributesactionbean.ff"), e.toString());
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                message = message + "; " + cause.toString();
            }
            json.put("message", (Object)message);
        }
        return json;
    }

    private void setAttributesNotNullFilters(Query q, ApplicationLayer al, SimpleFeatureType ft, EntityManager em) throws CQLException {
        FilterFactory2 ff2 = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        List attrs = al.getAttributes(ft);
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (ConfiguredAttribute attr : attrs) {
            if (!this.attributesNotNull.contains(attr.getId())) continue;
            Filter f = FlamingoCQL.toFilter((String)(attr.getAttributeName() + " is not null"), (EntityManager)em);
            filters.add(f);
        }
        if (q.getFilter() != null) {
            filters.add(q.getFilter());
        }
        And and = ff2.and(filters);
        q.setFilter((Filter)and);
    }
}

