/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.File;
import java.io.IOException;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.components.ComponentRegistry;
import nl.b3p.viewer.components.ViewerComponent;
import nl.b3p.web.stripes.ErrorMessageResolution;
import org.apache.tika.Tika;

@UrlBinding(value="/action/componentresource")
@StrictBinding
public class ComponentResourceActionBean
implements ActionBean {
    private ActionBeanContext context;
    @Validate
    private String className;
    @Validate
    private String resource;
    @Validate
    private String mimeType;

    public Resolution resource() throws IOException {
        if (this.className == null || this.getResource() == null) {
            return new ErrorMessageResolution("Both 'className' and 'resource' are required.");
        }
        ViewerComponent comp = ComponentRegistry.getInstance().getViewerComponent(this.className);
        String path = comp.getPath();
        File file = new File(path = path + File.separator + this.getResource());
        if (!file.canRead()) {
            return new ErrorResolution(404, "Resource not found");
        }
        String check = file.getCanonicalPath();
        if (!check.startsWith(comp.getPath())) {
            return new ErrorResolution(403, "Not allowed to access file");
        }
        String contentType = this.getMimeType() == null ? this.getContentType(file) : this.getMimeType();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private String getContentType(File f) {
        Tika tika = new Tika();
        try {
            return tika.detect(f);
        }
        catch (IOException e) {
            return "plain/text";
        }
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }
}

