/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.security.Authorizations;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.ibis.util.DateUtils;
import nl.b3p.viewer.ibis.util.IbisConstants;
import nl.b3p.viewer.stripes.IbisEditFeatureActionBean;
import nl.b3p.viewer.stripes.LocalizableApplicationActionBean;
import nl.b3p.viewer.util.IbisFeatureToJson;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.feature.FeatureVisitor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/ibisfeatureinfoutil")
@StrictBinding
public class IbisFeatureInfoUtilsActionBean
extends LocalizableApplicationActionBean
implements IbisConstants {
    private static final Log LOG = LogFactory.getLog(IbisEditFeatureActionBean.class);
    private static final String FID = "__fid";
    @Validate
    private Application application;
    @Validate
    private ApplicationLayer appLayer;
    @Validate
    private String fid;
    @Validate
    private String ibisId;
    private Layer layer;
    private ActionBeanContext context;
    private boolean unauthorized;

    @After(stages={LifecycleStage.BindingAndValidation})
    public void loadLayer() {
        this.layer = this.appLayer.getService().getSingleLayer(this.appLayer.getLayerName(), Stripersist.getEntityManager());
    }

    @Before(stages={LifecycleStage.EventHandling})
    public void checkAuthorization() {
        if (this.appLayer == null || !Authorizations.isLayerReadAuthorized((Layer)this.layer, (HttpServletRequest)this.context.getRequest(), (EntityManager)Stripersist.getEntityManager())) {
            this.unauthorized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution minmaxDate() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        String error = null;
        if (this.appLayer == null) {
            error = "appLayer parameter ontbreekt";
        } else if (this.unauthorized) {
            error = "actie niet toegestaan";
        } else {
            FeatureSource fs = null;
            try {
                fs = this.layer.getFeatureType().openGeoToolsFeatureSource();
                FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
                this.executeQuery(fs, ff, json);
                json.put("success", (Object)Boolean.TRUE);
            }
            catch (IOException ex) {
                error = ex.getLocalizedMessage();
                LOG.error((Object)error, (Throwable)ex);
            }
            catch (Exception ex) {
                error = ex.getLocalizedMessage();
                LOG.error((Object)error, (Throwable)ex);
            }
            finally {
                if (fs != null) {
                    fs.getDataStore().dispose();
                }
            }
        }
        if (error != null) {
            json.put("error", (Object)error);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    private void executeQuery(FeatureSource fs, FilterFactory2 ff, JSONObject json) throws IOException, CQLException {
        Filter f = ECQL.toFilter((String)("ibis_id=" + this.ibisId), (FilterFactory)ff);
        Query q = new Query(fs.getName().toString(), f, new String[]{"ibis_id", "datummutatie"});
        q.setSortBy(new SortBy[]{ff.sort("datummutatie", SortOrder.ASCENDING)});
        q.setHandle("date-query");
        LOG.debug((Object)q);
        SimpleFeatureCollection sfc = (SimpleFeatureCollection)fs.getFeatures(q);
        ArrayList dateList = new ArrayList();
        Date[] perceelDate = new Date[1];
        sfc.accepts((FeatureVisitor)new /* Unavailable Anonymous Inner Class!! */, null);
        json.put("featdate", (Object)IbisFeatureToJson.dateFormat.format(perceelDate[0]));
        json.put("mindate", (Object)IbisFeatureToJson.dateFormat.format(DateUtils.getBeforeDate(dateList, (Date)perceelDate[0])));
        json.put("maxdate", (Object)IbisFeatureToJson.dateFormat.format(DateUtils.getAfterDate(dateList, (Date)perceelDate[0])));
        LOG.debug((Object)json);
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public ApplicationLayer getAppLayer() {
        return this.appLayer;
    }

    public void setAppLayer(ApplicationLayer appLayer) {
        this.appLayer = appLayer;
    }

    public String getFid() {
        return this.fid;
    }

    public void setFid(String fid) {
        this.fid = fid;
    }

    public String getIbisId() {
        return this.ibisId;
    }

    public void setIbisId(String ibisId) {
        this.ibisId = ibisId;
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }
}

