/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.ibis.util.IbisConstants;
import nl.b3p.viewer.ibis.util.WorkflowStatus;
import nl.b3p.viewer.ibis.util.WorkflowUtil;
import nl.b3p.viewer.stripes.MergeFeaturesActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.util.GeometryTypeConverterFactory;
import org.geotools.feature.FeatureCollection;
import org.geotools.util.Converter;
import org.json.JSONException;
import org.json.JSONObject;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/feature/ibismerge")
@StrictBinding
public class IbisMergeFeaturesActionBean
extends MergeFeaturesActionBean
implements IbisConstants {
    private static final Log log = LogFactory.getLog(IbisMergeFeaturesActionBean.class);
    private Object terreinID = null;
    private WorkflowStatus newWorkflowStatus = WorkflowStatus.definitief;

    protected List<SimpleFeature> handleExtraData(List<SimpleFeature> features) throws JSONException {
        JSONObject json = new JSONObject(this.getExtraData());
        Iterator items = json.keys();
        while (items.hasNext()) {
            String key = (String)items.next();
            for (SimpleFeature f : features) {
                log.debug((Object)String.format("Setting value: %s for attribute: %s on feature %s", json.get(key), key, f.getID()));
                f.setAttribute(key, json.get(key));
                if (!key.equalsIgnoreCase("workflow_status")) continue;
                this.newWorkflowStatus = WorkflowStatus.valueOf((String)json.getString(key));
            }
        }
        return features;
    }

    protected List<FeatureId> handleStrategy(SimpleFeature featureA, SimpleFeature featureB, Geometry newGeom, Filter filterA, Filter filterB, SimpleFeatureStore localStore, String localStrategy) throws Exception {
        ArrayList<FeatureId> ids = new ArrayList();
        if (!this.getLayer().getName().equalsIgnoreCase("bedrijvenkavels")) {
            throw new IllegalArgumentException("Aborting as merge layer is not bedrijvenkavels");
        }
        String geomAttrName = ((SimpleFeatureType)localStore.getSchema()).getGeometryDescriptor().getLocalName();
        GeometryType type = ((SimpleFeatureType)localStore.getSchema()).getGeometryDescriptor().getType();
        GeometryTypeConverterFactory cf = new GeometryTypeConverterFactory();
        Converter c = cf.createConverter(Geometry.class, ((SimpleFeatureType)localStore.getSchema()).getGeometryDescriptor().getType().getBinding(), null);
        if (!this.getStrategy().equalsIgnoreCase("new")) {
            throw new IllegalArgumentException("Unknown merge strategy '" + this.getStrategy() + "', cannot merge.");
        }
        localStore.modifyFeatures("workflow_status", (Object)WorkflowStatus.archief, filterA);
        String[] fields = new String[]{"workflow_status", "terreinid"};
        Object[] values = new Object[]{WorkflowStatus.afgevoerd, null};
        localStore.modifyFeatures(fields, values, filterB);
        SimpleFeature newAfeat = DataUtilities.createFeature((SimpleFeatureType)featureA.getType(), (String)DataUtilities.encodeFeature((SimpleFeature)featureA, (boolean)false));
        newAfeat.setAttribute(geomAttrName, c.convert((Object)newGeom, type.getBinding()));
        this.terreinID = newAfeat.getAttribute("terreinid");
        List<Object> newFeats = new ArrayList<SimpleFeature>();
        newFeats.add(newAfeat);
        newFeats = this.handleExtraData(newFeats);
        ids = localStore.addFeatures((FeatureCollection)DataUtilities.collection(newFeats));
        return ids;
    }

    protected void afterMerge(List<FeatureId> ids) {
        if (this.terreinID != null) {
            WorkflowUtil.updateTerreinGeometry((Integer)Integer.parseInt(this.terreinID.toString()), (Layer)this.getLayer(), (WorkflowStatus)this.newWorkflowStatus, (Application)this.getApplication(), (EntityManager)Stripersist.getEntityManager());
        }
    }
}

