/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.web.stripes.ErrorMessageResolution;
import nl.opengeogroep.SafetyConnectProxy;
import nl.opengeogroep.SafetymapsApi;
import nl.opengeogroep.SafetymapsUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@StrictBinding
@UrlBinding(value="/action/safetymaps/api/{path}")
public class SafetymapsComponentActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(SafetymapsComponentActionBean.class);
    private ActionBeanContext context;
    public static final String ROLE_ADMIN = "Admin";
    static final String ROLE = "safetyct";
    private String JNDI_NAME = "java:/comp/env/jdbc/safetymaps-server";
    private static final String FEATURES = "features.json";
    private static final String OBJECT = "object/";
    private static final String STYLES = "styles.json";
    private static final String PROXY = "proxy";
    private static final String MEDIA = "media";
    @Validate
    private String path;
    @Validate
    private int version = 3;
    @Validate
    private int indent = 0;
    @Validate
    private int srid = 28992;
    @Validate
    private Application app;

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public int getSrid() {
        return this.srid;
    }

    public void setSrid(int srid) {
        this.srid = srid;
    }

    public Application getApp() {
        return this.app;
    }

    public void setApp(Application app) {
        this.app = app;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Resolution api() throws Exception {
        if (!this.context.getRequest().isUserInRole(ROLE) && !this.context.getRequest().isUserInRole(ROLE_ADMIN)) {
            return new ErrorMessageResolution(403, "Gebruiker heeft geen toegang tot webservice");
        }
        try (Connection c = this.getConnection();){
            if (this.path != null) {
                if (FEATURES.equals(this.path)) {
                    Resolution resolution = SafetymapsApi.features((Connection)c, (ActionBeanContext)this.context, (int)this.version, (int)this.indent, (int)this.srid);
                    return resolution;
                }
                if (STYLES.equals(this.path)) {
                    Resolution resolution = SafetymapsApi.styles((Connection)c, (int)this.indent);
                    return resolution;
                }
                if (this.path.indexOf(PROXY) == 0) {
                    String proxyPath = this.path.split("/")[1];
                    String authorization = this.getSetting("safetyconnect_webservice_authorization");
                    String url = this.getSetting("safetyconnect_webservice_url");
                    Resolution resolution = SafetyConnectProxy.proxy((ActionBeanContext)this.context, (String)authorization, (String)url, (String)proxyPath);
                    return resolution;
                }
                if (this.path.indexOf(MEDIA) == 0) {
                    String fileName = this.path.split("/")[1];
                    String mediaPath = this.getSetting(MEDIA);
                    Resolution resolution = SafetymapsApi.media((String)fileName, (String)mediaPath);
                    return resolution;
                }
                if (this.path.indexOf(OBJECT) == 0) {
                    Resolution resolution = SafetymapsApi.object((Connection)c, (int)this.version, (int)this.indent, (String)this.path);
                    return resolution;
                }
            }
            ErrorResolution errorResolution = new ErrorResolution(404, "Not found: /api/" + this.path);
            return errorResolution;
        }
        catch (Exception e) {
            return new StreamingResolution("application/json", SafetymapsUtils.logExceptionAndReturnJSONObject((Log)log, (String)("Error on /api/" + this.path), (Exception)e).toString(this.indent));
        }
    }

    private DataSource getDataSource(String jndiName) throws NamingException {
        InitialContext cxt = new InitialContext();
        DataSource ds = (DataSource)cxt.lookup(jndiName);
        if (ds == null) {
            throw new NamingException("Data source " + jndiName + " not found, please configure the webapp container correctly according to the installation instructions");
        }
        return ds;
    }

    private String getSetting(String name) throws NamingException, SQLException {
        String value = (String)this.qr().query("select value from safetymaps.settings where name=?", (ResultSetHandler)new ScalarHandler(), new Object[]{name});
        return value;
    }

    private QueryRunner qr() throws NamingException {
        return new QueryRunner(this.getDataSource(this.JNDI_NAME));
    }

    private Connection getConnection() throws NamingException, SQLException {
        return this.getDataSource(this.JNDI_NAME).getConnection();
    }
}

