/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.admin.stripes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import nl.b3p.i18n.LocalizableActionBean;
import nl.b3p.viewer.admin.stripes.ConfigureSolrActionBean;
import nl.b3p.viewer.config.services.ArcGISFeatureSource;
import nl.b3p.viewer.config.services.ArcXMLFeatureSource;
import nl.b3p.viewer.config.services.FeatureSource;
import nl.b3p.viewer.config.services.FeatureSourceUpdateResult;
import nl.b3p.viewer.config.services.JDBCFeatureSource;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.config.services.SolrConf;
import nl.b3p.viewer.config.services.UpdatableFeatureSource;
import nl.b3p.viewer.config.services.UpdateResult;
import nl.b3p.viewer.config.services.WFSFeatureSource;
import nl.b3p.viewer.solr.SolrInitializer;
import nl.b3p.web.WaitPageStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServer;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.plugin.waitpage.WaitPage;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/attributesource/{$event}")
@StrictBinding
@RolesAllowed(value={"Admin", "RegistryAdmin"})
public class AttributeSourceActionBean
extends LocalizableActionBean {
    private static final Log log = LogFactory.getLog(AttributeSourceActionBean.class);
    private ActionBeanContext context;
    private static final String JSP = "/WEB-INF/jsp/services/attributesource.jsp";
    private static final String EDITJSP = "/WEB-INF/jsp/services/editattributesource.jsp";
    @Validate
    private int page;
    @Validate
    private int start;
    @Validate
    private int limit;
    @Validate
    private String sort;
    @Validate
    private String dir;
    @Validate
    private JSONArray filter;
    @Validate(on={"save", "saveEdit"}, required=true, label="Naam")
    private String name;
    @Validate
    private String url;
    @Validate(on={"save"}, required=true)
    private String protocol = "jdbc";
    @Validate
    private String username;
    @Validate
    private String password;
    @Validate(on={"save"})
    private String host;
    @Validate(on={"save"})
    private String port;
    @Validate(on={"save"})
    private String dbtype;
    @Validate(on={"save"})
    private String database;
    @Validate(on={"save"})
    private String schema;
    private WaitPageStatus status = new WaitPageStatus();
    @Validate
    private FeatureSource featureSource;
    private boolean updatable;
    @Validate
    private Map<UpdateResult.Status, List<SimpleFeatureType>> changedFeatureTypes;
    @Validate
    private Long changedFeatureSourceId;

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution(JSP);
    }

    public Resolution edit() {
        if (this.featureSource != null) {
            this.protocol = this.featureSource.getProtocol();
            this.name = this.featureSource.getName();
            this.url = this.featureSource.getUrl();
            this.username = this.featureSource.getUsername();
            this.password = this.featureSource.getPassword();
        }
        return new ForwardResolution(EDITJSP);
    }

    public Resolution newAttributeSource() {
        return new ForwardResolution(EDITJSP);
    }

    public Resolution cancel() {
        return new ForwardResolution(EDITJSP);
    }

    public Resolution delete() {
        EntityManager em = Stripersist.getEntityManager();
        this.deleteFeatureSource(em, SolrInitializer.getServerInstance());
        this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.attributesourceactionbean.asremoved"), new Object[0]));
        return new ForwardResolution(EDITJSP);
    }

    protected void deleteFeatureSource(EntityManager em, SolrServer server) {
        if (!this.featureSource.getFeatureTypes().isEmpty()) {
            em.createQuery("update Layer set featureType = null where featureType in :fts").setParameter("fts", (Object)this.featureSource.getFeatureTypes()).executeUpdate();
            em.createQuery("update ConfiguredAttribute set featureType=null where featureType in :fts").setParameter("fts", (Object)this.featureSource.getFeatureTypes()).executeUpdate();
            em.createQuery("update ConfiguredAttribute set valueListFeatureType=null where valueListFeatureType in :fts").setParameter("fts", (Object)this.featureSource.getFeatureTypes()).executeUpdate();
            List confs = em.createQuery("FROM SolrConf where simpleFeatureType in :fts", SolrConf.class).setParameter("fts", (Object)this.featureSource.getFeatureTypes()).getResultList();
            for (SolrConf conf : confs) {
                ConfigureSolrActionBean.deleteSolrConfiguration((EntityManager)em, (SolrConf)conf, (SolrServer)server);
            }
        }
        em.createQuery("update ConfiguredAttribute set valueListFeatureSource=null, valueListLabelName=null,valueListValueName=null where valueListFeatureSource in :fs").setParameter("fs", (Object)this.featureSource).executeUpdate();
        em.remove((Object)this.featureSource);
        em.getTransaction().commit();
    }

    @WaitPage(path="/WEB-INF/jsp/waitpage.jsp", delay=2000, refresh=1000, ajax="/WEB-INF/jsp/waitpageajax.jsp")
    public Resolution save() throws JSONException, Exception {
        try {
            this.addService(Stripersist.getEntityManager());
        }
        catch (Exception e) {
            log.error((Object)"Error loading new feauture source", (Throwable)e);
            String s = e.toString();
            if (e.getCause() != null) {
                s = s + "; cause: " + e.getCause().toString();
            }
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.attributesourceactionbean.errorload"), new Object[]{s}));
        }
        return new ForwardResolution(EDITJSP);
    }

    protected void addService(EntityManager em) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.protocol.equals("jdbc")) {
            params.put("dbtype", this.dbtype);
            params.put("host", this.host);
            params.put("port", this.port);
            params.put("database", this.database);
            params.put("schema", this.schema);
            params.put("user", this.username);
            params.put("passwd", this.password);
            JDBCFeatureSource fs = new JDBCFeatureSource(params);
            fs.setName(this.name);
            fs.loadFeatureTypes(this.status);
            em.persist((Object)fs);
            em.getTransaction().commit();
            this.featureSource = fs;
            this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.attributesourceactionbean.asloaded"), new Object[0]));
        } else if (this.protocol.equals("wfs")) {
            params.put(WFSDataStoreFactory.URL.key, this.url);
            params.put(WFSDataStoreFactory.USERNAME.key, this.username);
            params.put(WFSDataStoreFactory.PASSWORD.key, this.password);
            WFSFeatureSource fs = new WFSFeatureSource(params);
            fs.setName(this.name);
            fs.loadFeatureTypes(this.status);
            em.persist((Object)fs);
            em.getTransaction().commit();
            this.featureSource = fs;
            this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.attributesourceactionbean.asloaded"), new Object[0]));
        } else {
            this.getContext().getValidationErrors().add("protocol", (ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.attributesourceactionbean.invalid"), new Object[0]));
        }
    }

    public Resolution saveEdit() {
        this.featureSource.setName(this.name);
        this.featureSource.setUsername(this.username);
        if (this.password != null) {
            this.featureSource.setPassword(this.password);
        }
        if (this.username == null && this.password == null) {
            this.featureSource.setPassword(this.password);
        }
        Stripersist.getEntityManager().persist((Object)this.featureSource);
        Stripersist.getEntityManager().getTransaction().commit();
        this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.attributesourceactionbean.asloaded"), new Object[0]));
        return this.edit();
    }

    public Resolution update() throws Exception {
        if (!this.isUpdatable()) {
            this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.attributesourceactionbean.noupdate"), new Object[]{this.featureSource.getProtocol()}));
            return new ForwardResolution(EDITJSP);
        }
        EntityManager em = Stripersist.getEntityManager();
        FeatureSourceUpdateResult result = ((UpdatableFeatureSource)this.featureSource).update(em);
        if (result.getStatus() == UpdateResult.Status.FAILED) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError(result.getMessage(), new Object[0]));
            em.getTransaction().rollback();
            return new ForwardResolution(EDITJSP);
        }
        Map byStatus = result.getLayerNamesByStatus();
        log.info((Object)String.format("Update featuretypes stats: unmodified %d, updated %d, new %d, missing %d", ((List)byStatus.get(UpdateResult.Status.UNMODIFIED)).size(), ((List)byStatus.get(UpdateResult.Status.UPDATED)).size(), ((List)byStatus.get(UpdateResult.Status.NEW)).size(), ((List)byStatus.get(UpdateResult.Status.MISSING)).size()));
        log.info((Object)("Unmodified featuretypes: " + byStatus.get(UpdateResult.Status.UNMODIFIED)));
        log.info((Object)("Updated featuretypes: " + byStatus.get(UpdateResult.Status.UPDATED)));
        log.info((Object)("New featuretypes: " + byStatus.get(UpdateResult.Status.NEW)));
        log.info((Object)("Missing featuretypes: " + byStatus.get(UpdateResult.Status.MISSING)));
        this.changedFeatureTypes = result.getFeatureTypeByStatus();
        this.changedFeatureSourceId = this.featureSource.getId();
        this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.attributesourceactionbean.aschanged"), new Object[]{((List)byStatus.get(UpdateResult.Status.UPDATED)).size(), ((List)byStatus.get(UpdateResult.Status.UNMODIFIED)).size(), ((List)byStatus.get(UpdateResult.Status.NEW)).size(), ((List)byStatus.get(UpdateResult.Status.MISSING)).size()}));
        em.persist((Object)this.featureSource);
        em.getTransaction().commit();
        return new ForwardResolution(EDITJSP);
    }

    @ValidationMethod(on={"save", "saveEdit"})
    public void validate(ValidationErrors errors) throws Exception {
        if (this.name == null) {
            errors.add("name", (ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.attributesourceactionbean.nameobl"), new Object[0]));
            return;
        }
        if (this.featureSource == null) {
            try {
                Object o = Stripersist.getEntityManager().createQuery("select 1 from FeatureSource where name = :name").setMaxResults(1).setParameter("name", (Object)this.name).getSingleResult();
                errors.add("name", (ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.attributesourceactionbean.uniquename"), new Object[0]));
                return;
            }
            catch (NoResultException o) {}
        } else {
            try {
                Object o = Stripersist.getEntityManager().createQuery("select 1 from FeatureSource where name = :name and id != :id").setMaxResults(1).setParameter("name", (Object)this.name).setParameter("id", (Object)this.featureSource.getId()).getSingleResult();
                errors.add("name", (ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.attributesourceactionbean.uniquename"), new Object[0]));
                return;
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
        }
    }

    public Resolution getGridData() throws JSONException {
        JSONArray jsonData = new JSONArray();
        String filterName = "";
        String filterUrl = "";
        String filterType = "";
        if (this.getFilter() != null) {
            for (int k = 0; k < this.getFilter().length(); ++k) {
                JSONObject j = this.getFilter().getJSONObject(k);
                String property = j.getString("property");
                String value = j.getString("value");
                if (property.equals("name")) {
                    filterName = value;
                }
                if (property.equals("url")) {
                    filterUrl = value;
                }
                if (!property.equals("protocol")) continue;
                filterType = value;
            }
        }
        Session sess = (Session)Stripersist.getEntityManager().getDelegate();
        Criteria c = sess.createCriteria(FeatureSource.class);
        if (this.sort != null && this.dir != null) {
            Order order;
            if (!this.sort.equals("status") && !this.sort.equals("protocol")) {
                order = null;
                order = this.dir.equals("ASC") ? Order.asc((String)this.sort) : Order.desc((String)this.sort);
                order.ignoreCase();
                c.addOrder(order);
            } else if (this.sort.equals("protocol")) {
                order = null;
                order = this.dir.equals("ASC") ? Order.asc((String)"class") : Order.desc((String)"class");
                order.ignoreCase();
                c.addOrder(order);
            }
        }
        if (filterName != null && filterName.length() > 0) {
            Criterion nameCrit = Restrictions.ilike((String)"name", (String)filterName, (MatchMode)MatchMode.ANYWHERE);
            c.add(nameCrit);
        }
        if (filterUrl != null && filterUrl.length() > 0) {
            Criterion urlCrit = Restrictions.ilike((String)"url", (String)filterUrl, (MatchMode)MatchMode.ANYWHERE);
            c.add(urlCrit);
        }
        if (filterType != null && filterType.length() > 0) {
            Criterion protocolCrit = Restrictions.ilike((String)"class", (String)filterType, (MatchMode)MatchMode.ANYWHERE);
            c.add(protocolCrit);
        }
        int rowCount = c.list().size();
        c.setMaxResults(this.limit);
        c.setFirstResult(this.start);
        List sources = c.list();
        for (FeatureSource source : sources) {
            String protocolType = "";
            if (source instanceof WFSFeatureSource) {
                protocolType = "WFS";
            } else if (source instanceof JDBCFeatureSource) {
                protocolType = "JDBC";
            } else if (source instanceof ArcGISFeatureSource) {
                protocolType = "ArcGIS";
            } else if (source instanceof ArcXMLFeatureSource) {
                protocolType = "ArcXML";
            }
            JSONObject j = this.getGridRow(source.getId().intValue(), source.getName(), source.getUrl(), protocolType);
            jsonData.put((Object)j);
        }
        JSONObject grid = new JSONObject();
        grid.put("totalCount", rowCount);
        grid.put("gridrows", (Object)jsonData);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private JSONObject getGridRow(int id, String name, String url, String type) throws JSONException {
        JSONObject j = new JSONObject();
        j.put("id", id);
        j.put("status", (Object)"ok");
        j.put("name", (Object)("#" + id + " " + name));
        j.put("url", (Object)url);
        j.put("protocol", (Object)type);
        return j;
    }

    @Before
    public void setUpdatable() {
        this.updatable = this.featureSource instanceof UpdatableFeatureSource;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public JSONArray getFilter() {
        return this.filter;
    }

    public void setFilter(JSONArray filter) {
        this.filter = filter;
    }

    public FeatureSource getFeatureSource() {
        return this.featureSource;
    }

    public void setFeatureSource(FeatureSource featureSource) {
        this.featureSource = featureSource;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDbtype() {
        return this.dbtype;
    }

    public void setDbtype(String dbtype) {
        this.dbtype = dbtype;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public WaitPageStatus getStatus() {
        return this.status;
    }

    public void setStatus(WaitPageStatus status) {
        this.status = status;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public Map<UpdateResult.Status, List<SimpleFeatureType>> getChangedFeatureTypes() {
        return this.changedFeatureTypes;
    }

    public void setChangedFeatureTypes(Map<UpdateResult.Status, List<SimpleFeatureType>> changedFeatureTypes) {
        this.changedFeatureTypes = changedFeatureTypes;
    }

    public Long getChangedFeatureSourceId() {
        return this.changedFeatureSourceId;
    }

    public void setChangedFeatureSourceId(Long changedFeatureSourceId) {
        this.changedFeatureSourceId = changedFeatureSourceId;
    }
}

