/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.security.Authorizations;
import nl.b3p.viewer.config.services.FeatureTypeRelation;
import nl.b3p.viewer.config.services.FeatureTypeRelationKey;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.stripes.LocalizableApplicationActionBean;
import nl.b3p.viewer.stripes.PrintActionBean;
import nl.b3p.viewer.util.FeaturePropertiesArrayHelper;
import nl.b3p.viewer.util.FeatureToJson;
import nl.b3p.viewer.util.FlamingoCQL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.BoundsVisitor;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.json.JSONArray;
import org.json.JSONObject;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.opengis.geometry.BoundingBox;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/featurereport")
@StrictBinding
public class FeatureReportActionBean
extends LocalizableApplicationActionBean
implements ActionBean {
    private static final Log LOG = LogFactory.getLog(FeatureReportActionBean.class);
    public static final String FID = "__fid";
    private static final int TIMEOUT = 5000;
    @Validate
    private ApplicationLayer appLayer;
    private Layer layer = null;
    private boolean unauthorized;
    private ActionBeanContext context;
    @Validate
    private String fid;
    @Validate
    private Application application;
    @Validate
    private int maxrelatedfeatures = 10;
    @Validate
    private String printparams;

    @Before(stages={LifecycleStage.EventHandling})
    public void checkAuthorization() {
        if (this.appLayer == null || !Authorizations.isLayerReadAuthorized((Layer)this.layer, (HttpServletRequest)this.context.getRequest(), (EntityManager)Stripersist.getEntityManager())) {
            this.unauthorized = true;
        }
    }

    @After(stages={LifecycleStage.BindingAndValidation})
    public void loadLayer() {
        this.layer = this.appLayer.getService().getSingleLayer(this.appLayer.getLayerName(), Stripersist.getEntityManager());
    }

    @DefaultHandler
    public Resolution print() throws URISyntaxException, IOException, Exception {
        LOG.debug((Object)("Start processing feature report request voor FID: " + this.fid));
        if (this.appLayer == null) {
            return new ErrorResolution(500, "Invalid parameters");
        }
        if (this.unauthorized) {
            return new ErrorResolution(403, "Not authorized");
        }
        JSONObject params = new JSONObject(this.printparams);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        FeatureSource fs = this.layer.getFeatureType().openGeoToolsFeatureSource(5000);
        String geomAttribute = fs.getSchema().getGeometryDescriptor().getLocalName();
        Id fidFilter = ff.id(new FeatureId[]{new FeatureIdImpl(this.fid)});
        BoundingBox b = this.getExtent(fs, (Filter)fidFilter);
        params.put("bbox", (Object)(b.getMinX() + "," + b.getMinY() + "," + b.getMaxX() + "," + b.getMaxY()));
        Geometry geom = this.getGeometry(fs, (Filter)fidFilter);
        if (geom != null) {
            double simplify;
            JSONObject wktGeom = new JSONObject();
            String geomTxt = geom.toText();
            Geometry bbox = geom.getEnvelope();
            int megabytes = 1994752;
            String geomModified = "";
            for (simplify = 1.0; geomTxt.getBytes("UTF-8").length > megabytes && simplify < 9999.0; simplify = 10.0 * simplify) {
                LOG.debug((Object)("Simplify selected feature geometry with distance of: " + simplify));
                geomModified = this.getBundle().getString("viewer.featurereportactionbean.modified");
                geom = TopologyPreservingSimplifier.simplify((Geometry)geom, (double)simplify);
                geomTxt = geom.toText();
            }
            if (simplify > 9999.0) {
                wktGeom.put("_wktgeom", (Object)bbox.toText());
            } else {
                wktGeom.put("_wktgeom", (Object)geomTxt);
            }
            wktGeom.put("color", (Object)"FF00FF");
            wktGeom.put("label", (Object)MessageFormat.format(this.getBundle().getString("viewer.featurereportactionbean.mm"), this.fid.replace(this.layer.getFeatureType().getTypeName() + ".", ""), geomModified));
            wktGeom.put("strokeWidth", 8);
            params.getJSONArray("geometries").put((Object)wktGeom);
        }
        ArrayList attributesToInclude = new ArrayList();
        List attrs = this.appLayer.getAttributes(this.layer.getFeatureType(), true);
        attrs.forEach(attr -> attributesToInclude.add(attr.getId()));
        Query q = new Query(fs.getName().toString(), (Filter)fidFilter);
        q.setMaxFeatures(1);
        q.setHandle("FeatureReportActionBean_attributes");
        EntityManager em = Stripersist.getEntityManager();
        FeatureToJson ftjson = new FeatureToJson(false, false, false, true, false, attributesToInclude, true);
        JSONArray features = ftjson.getJSONFeatures(this.appLayer, this.layer.getFeatureType(), fs, q, em, this.application, this.context.getRequest());
        JSONArray jFeat = features.getJSONArray(0);
        FeaturePropertiesArrayHelper.removeKey((JSONArray)jFeat, (String)FID);
        FeaturePropertiesArrayHelper.removeKey((JSONArray)jFeat, (String)geomAttribute);
        FeaturePropertiesArrayHelper.removeKey((JSONArray)jFeat, (String)"related_featuretypes");
        JSONObject extra = new JSONObject();
        extra.put("className", (Object)"feature").put("componentName", (Object)"report").put("info", (Object)jFeat);
        params.getJSONArray("extra").put((Object)extra);
        fs.getDataStore().dispose();
        if (this.layer.getFeatureType().hasRelations()) {
            ftjson = new FeatureToJson(false, false, false, true, true, attributesToInclude, true);
            for (FeatureTypeRelation rel : this.layer.getFeatureType().getRelations()) {
                if (!rel.getType().equals("relate")) continue;
                SimpleFeatureType fType = rel.getForeignFeatureType();
                String label = fType.getDescription() == null ? fType.getTypeName() : fType.getDescription();
                LOG.debug((Object)("Processing related featuretype: " + label));
                List keys = rel.getRelationKeys();
                String leftSide = ((FeatureTypeRelationKey)keys.get(0)).getLeftSide().getName();
                String rightSide = ((FeatureTypeRelationKey)keys.get(0)).getRightSide().getName();
                JSONObject info = new JSONObject();
                if (FeaturePropertiesArrayHelper.containsKey((JSONArray)jFeat, (String)leftSide)) {
                    int featureCount;
                    String type = ((FeatureTypeRelationKey)keys.get(0)).getLeftSide().getExtJSType();
                    String query = rightSide + "=";
                    query = type.equalsIgnoreCase("string") || type.equalsIgnoreCase("date") || type.equalsIgnoreCase("auto") ? query + "'" + FeaturePropertiesArrayHelper.getByKey((JSONArray)jFeat, (String)leftSide) + "'" : query + FeaturePropertiesArrayHelper.getByKey((JSONArray)jFeat, (String)leftSide);
                    q = new Query(fType.getTypeName(), FlamingoCQL.toFilter((String)query, (EntityManager)em));
                    q.setMaxFeatures(this.maxrelatedfeatures + 1);
                    q.setHandle("FeatureReportActionBean_related_attributes");
                    LOG.debug((Object)("Related features query: " + q));
                    fs = fType.openGeoToolsFeatureSource(5000);
                    features = ftjson.getJSONFeatures(this.appLayer, fType, fs, q, em, this.application, this.context.getRequest());
                    JSONArray jsonFeats = new JSONArray();
                    int colCount = 0;
                    int numFeats = features.length();
                    int maxFeatures = Math.min(numFeats, this.maxrelatedfeatures);
                    for (featureCount = 0; featureCount < maxFeatures; ++featureCount) {
                        JSONArray feat = features.getJSONArray(featureCount);
                        FeaturePropertiesArrayHelper.removeKey((JSONArray)feat, (String)FID);
                        colCount = feat.length();
                        jsonFeats.put((Object)feat);
                    }
                    info.put("features", (Object)jsonFeats);
                    info.putOnce("colCount", (Object)colCount);
                    info.putOnce("rowCount", (Object)featureCount);
                    if (numFeats > this.maxrelatedfeatures) {
                        String msg = MessageFormat.format(this.getBundle().getString("viewer.featurereportactionbean.moreitems"), this.maxrelatedfeatures);
                        info.putOnce("moreMessage", (Object)msg);
                    }
                } else {
                    String msg = MessageFormat.format(this.getBundle().getString("viewer.featurereportactionbean.columnmissing"), leftSide);
                    info.putOnce("errorMessage", (Object)msg);
                }
                extra = new JSONObject().put("className", (Object)"related").put("componentName", (Object)label).put("info", (Object)info);
                params.getJSONArray("extra").put((Object)extra);
                LOG.debug((Object)("extra data: " + extra));
                fs.getDataStore().dispose();
            }
        }
        LOG.debug((Object)("Forwarding feature report request to print using params: " + params));
        return new ForwardResolution(PrintActionBean.class, "print").addParameter("params", new Object[]{params.toString()});
    }

    private BoundingBox getExtent(FeatureSource fs, Filter f) throws CQLException, IOException {
        Query q = new Query(fs.getName().toString(), f);
        q.setHandle("FeatureReportActionBean_extent-query");
        q.setMaxFeatures(1);
        q.setPropertyNames(new String[]{fs.getSchema().getGeometryDescriptor().getName().toString()});
        SimpleFeatureCollection feats = (SimpleFeatureCollection)fs.getFeatures(q);
        BoundsVisitor bounds = new BoundsVisitor();
        feats.accepts((FeatureVisitor)bounds, null);
        ReferencedEnvelope extent = bounds.getBounds();
        LOG.debug((Object)("feature extent: " + extent));
        double buffer = Math.max(50.0, 0.1 * Math.max(extent.getWidth(), extent.getHeight()));
        Geometry geom = JTS.toGeometry((BoundingBox)extent).buffer(buffer);
        extent = new ReferencedEnvelope(geom.getEnvelopeInternal(), extent.getCoordinateReferenceSystem());
        LOG.debug((Object)("enlarged extent" + extent + "was buffered with: " + buffer));
        return extent;
    }

    private Geometry getGeometry(FeatureSource fs, Filter f) throws CQLException, IOException {
        Geometry geom = null;
        Query q = new Query(fs.getName().toString(), f);
        q.setHandle("FeatureReportActionBean_geom-query");
        q.setMaxFeatures(1);
        q.setPropertyNames(new String[]{fs.getSchema().getGeometryDescriptor().getName().toString()});
        SimpleFeatureCollection feats = (SimpleFeatureCollection)fs.getFeatures(q);
        if (feats.features().hasNext()) {
            geom = (Geometry)((SimpleFeature)feats.features().next()).getDefaultGeometry();
        }
        return geom;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public ApplicationLayer getAppLayer() {
        return this.appLayer;
    }

    public void setAppLayer(ApplicationLayer appLayer) {
        this.appLayer = appLayer;
    }

    public String getFid() {
        return this.fid;
    }

    public void setFid(String fid) {
        this.fid = fid;
    }

    public String getPrintparams() {
        return this.printparams;
    }

    public void setPrintparams(String printparams) {
        this.printparams = printparams;
    }

    public int getMaxrelatedfeatures() {
        return this.maxrelatedfeatures;
    }

    public void setMaxrelatedfeatures(int maxrelatedfeatures) {
        this.maxrelatedfeatures = maxrelatedfeatures;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }
}

