/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.Principal;
import java.util.Calendar;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.stripes.EditFeatureActionBean;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataAccess;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureSource;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.filter.text.ecql.ECQL;
import org.json.JSONObject;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.identity.FeatureId;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/mob/feature/edit")
@StrictBinding
public class MOBEditActionBean
extends EditFeatureActionBean {
    private static final Log log = LogFactory.getLog(MOBEditActionBean.class);
    @Validate
    private String METING_ID;
    @Validate
    private String meting;
    private boolean overrideUserEditableMethod = false;
    @Validate
    private FileBean UPLOAD;
    @Validate
    private Integer CV_ID;
    @Validate
    private Integer AGM_ID;
    @Validate
    private Double uitgifte;

    public String getMETING_ID() {
        return this.METING_ID;
    }

    public void setMETING_ID(String METING_ID) {
        this.METING_ID = METING_ID;
    }

    public String getMeting() {
        return this.meting;
    }

    public void setMeting(String meting) {
        this.meting = meting;
    }

    public FileBean getUPLOAD() {
        return this.UPLOAD;
    }

    public void setUPLOAD(FileBean UPLOAD) {
        this.UPLOAD = UPLOAD;
    }

    public Integer getCV_ID() {
        return this.CV_ID;
    }

    public void setCV_ID(Integer CV_ID) {
        this.CV_ID = CV_ID;
    }

    public Integer getAGM_ID() {
        return this.AGM_ID;
    }

    public void setAGM_ID(Integer AGM_ID) {
        this.AGM_ID = AGM_ID;
    }

    public Double getUitgifte() {
        return this.uitgifte;
    }

    public void setUitgifte(Double uitgifte) {
        this.uitgifte = uitgifte;
    }

    private boolean isAuthorized() {
        HttpServletRequest req = this.getContext().getRequest();
        Principal geb = req.getUserPrincipal();
        return geb != null && (req.isUserInRole("gemeente") || req.isUserInRole("provincie"));
    }

    public Resolution editFeature() {
        if (!this.isAuthorized()) {
            log.error((Object)"Unauthorized access");
            return new ErrorResolution(401, "Geen toegang");
        }
        this.setFeature(this.meting);
        this.edit();
        return new StreamingResolution("text/xml", (Reader)new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?><message success=\"true\"></message>"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution retrieveVariables() {
        StreamingResolution streamingResolution;
        if (!this.isAuthorized()) {
            log.error((Object)"Unauthorized access");
            return new ErrorResolution(401, "Geen toegang");
        }
        JSONObject json = new JSONObject();
        json.put("success", false);
        EntityManager em = Stripersist.getEntityManager();
        Layer l = this.getAppLayer().getService().getLayer(this.getAppLayer().getLayerName(), em);
        FeatureSource mainFs = l.getFeatureType().openGeoToolsFeatureSource();
        try {
            Calendar mobNow;
            DataAccess da = mainFs.getDataStore();
            String username = this.getContext().getRequest().getUserPrincipal().getName();
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
            FeatureSource fs = da.getFeatureSource((Name)new NameImpl("GEBRUIKERSAUTORISATIE"));
            SimpleFeatureStore d = (SimpleFeatureStore)fs;
            Filter f = ECQL.toFilter((String)("GEBRUIKERSNAAM = '" + username + "'"));
            SimpleFeatureCollection fc = d.getFeatures(f);
            SimpleFeatureIterator it = fc.features();
            SimpleFeature feature = null;
            while (it.hasNext()) {
                feature = (SimpleFeature)it.next();
            }
            if (feature != null) {
                json.put("GEM_CODE_CBS", feature.getAttribute("GEM_CODE_CBS"));
                json.put("AG_ID", feature.getAttribute("AG_ID"));
            }
            fs = da.getFeatureSource((Name)new NameImpl("METINGEN"));
            d = (SimpleFeatureStore)fs;
            Calendar ibisNow = Calendar.getInstance();
            ibisNow.set(2, 0);
            ibisNow.set(5, 1);
            ibisNow.set(10, 0);
            ibisNow.set(12, 0);
            ibisNow.set(13, 0);
            ibisNow.set(9, 0);
            PropertyIsEqualTo f2 = ff.equals((Expression)ff.property("PEILDATUM"), (Expression)ff.literal((Object)ibisNow.getTime()));
            SimpleFeatureCollection fc2 = d.getFeatures((Filter)f2);
            SimpleFeatureIterator it2 = fc2.features();
            SimpleFeature feature2 = null;
            while (it2.hasNext()) {
                feature2 = (SimpleFeature)it2.next();
            }
            if (feature2 != null) {
                json.put("IBIS_MTG_ID", feature2.getAttribute("MTG_ID"));
                json.put("IBIS_PEILDATUM", feature2.getAttribute("PEILDATUM"));
            }
            mobNow.set(2, (mobNow = Calendar.getInstance()).get(2) > 6 ? 6 : 0);
            mobNow.set(5, 1);
            mobNow.set(10, 0);
            mobNow.set(12, 0);
            mobNow.set(13, 0);
            mobNow.set(9, 0);
            PropertyIsEqualTo mobFilter = ff.equals((Expression)ff.property("PEILDATUM"), (Expression)ff.literal((Object)mobNow.getTime()));
            SimpleFeatureCollection mobFc = d.getFeatures((Filter)mobFilter);
            SimpleFeatureIterator mobIterator = mobFc.features();
            SimpleFeature mobFeature = null;
            while (mobIterator.hasNext()) {
                mobFeature = (SimpleFeature)mobIterator.next();
            }
            if (mobFeature != null) {
                json.put("MOB_MTG_ID", mobFeature.getAttribute("MTG_ID"));
                json.put("MOB_PEILDATUM", mobFeature.getAttribute("PEILDATUM"));
            }
            if (json.has("AG_ID")) {
                fs = da.getFeatureSource((Name)new NameImpl("AFSPRAAKGEB_METINGEN"));
                d = (SimpleFeatureStore)fs;
                f = ECQL.toFilter((String)("METING_ID = " + json.get("MOB_MTG_ID") + " AND AFSPRAAKGEBIED_ID = " + json.get("AG_ID")));
                fc = d.getFeatures(f);
                it = fc.features();
                feature = null;
                while (it.hasNext()) {
                    feature = (SimpleFeature)it.next();
                }
                if (feature != null) {
                    json.put("AGM_ID", feature.getAttribute("AGM_ID"));
                    json.put("IND_IBIS_INGEDIEND_JN", feature.getAttribute("IND_IBIS_INGEDIEND_JN"));
                    json.put("IND_CORRECTIES_INGEDIEND_JN", feature.getAttribute("IND_CORRECTIES_INGEDIEND_JN"));
                    json.put("VERWACHTE_UITGIFTE", feature.getAttribute("VERWACHTE_UITGIFTE"));
                }
            }
            json.put("success", true);
            streamingResolution = new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
        }
        catch (Exception ex) {
            ErrorResolution errorResolution;
            try {
                log.error((Object)"Cannot retrieve variables: ", (Throwable)ex);
                errorResolution = new ErrorResolution(500, "Kan gegevens niet ophalen " + ex.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                try {
                    mainFs.getDataStore().dispose();
                    throw throwable;
                }
                catch (Exception ex2) {
                    log.error((Object)"Kan gegevens niet ophalen ", (Throwable)ex2);
                    return new ErrorResolution(500, "Kan gegevens niet ophalen" + ex2.getLocalizedMessage());
                }
            }
            mainFs.getDataStore().dispose();
            return errorResolution;
        }
        mainFs.getDataStore().dispose();
        return streamingResolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution submitExpectedAllotment() {
        if (!this.isAuthorized()) {
            log.error((Object)"Unauthorized access");
            return new ErrorResolution(401, "Geen toegang");
        }
        try {
            JSONObject json = new JSONObject();
            json.put("success", false);
            EntityManager em = Stripersist.getEntityManager();
            Layer l = this.getAppLayer().getService().getLayer(this.getAppLayer().getLayerName(), em);
            FeatureSource mainFs = l.getFeatureType().openGeoToolsFeatureSource();
            DataAccess da = mainFs.getDataStore();
            FeatureSource fs = da.getFeatureSource((Name)new NameImpl("AFSPRAAKGEB_METINGEN"));
            SimpleFeatureStore d = (SimpleFeatureStore)fs;
            d.setTransaction((Transaction)transaction);
            try (DefaultTransaction transaction = new DefaultTransaction("edit");){
                FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
                Id f = ff.id(new FeatureId[]{new FeatureIdImpl(this.AGM_ID.toString())});
                d.modifyFeatures("VERWACHTE_UITGIFTE", (Object)this.uitgifte, (Filter)f);
                transaction.commit();
                json.put("success", true);
            }
            return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
        }
        catch (Exception ex) {
            log.error((Object)"Cannot submit ibis: ", (Throwable)ex);
            return new ErrorResolution(500, "Kan ibisgegevens niet indienen " + ex.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution submitIbis() {
        if (!this.isAuthorized()) {
            log.error((Object)"Unauthorized access");
            return new ErrorResolution(401, "Geen toegang");
        }
        try {
            JSONObject json = new JSONObject();
            json.put("success", false);
            EntityManager em = Stripersist.getEntityManager();
            Layer l = this.getAppLayer().getService().getLayer(this.getAppLayer().getLayerName(), em);
            FeatureSource mainFs = l.getFeatureType().openGeoToolsFeatureSource();
            DataAccess da = mainFs.getDataStore();
            FeatureSource fs = da.getFeatureSource((Name)new NameImpl("AFSPRAAKGEB_METINGEN"));
            SimpleFeatureStore d = (SimpleFeatureStore)fs;
            d.setTransaction((Transaction)transaction);
            try (DefaultTransaction transaction = new DefaultTransaction("edit");){
                FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
                Id f = ff.id(new FeatureId[]{new FeatureIdImpl(this.AGM_ID.toString())});
                d.modifyFeatures("IND_IBIS_INGEDIEND_JN", (Object)"J", (Filter)f);
                transaction.commit();
                json.put("success", true);
            }
            return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
        }
        catch (Exception ex) {
            log.error((Object)"Cannot submit ibis: ", (Throwable)ex);
            return new ErrorResolution(500, "Kan ibisgegevens niet indienen " + ex.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution submitCorrections() {
        if (!this.isAuthorized()) {
            log.error((Object)"Unauthorized access");
            return new ErrorResolution(401, "Geen toegang");
        }
        try {
            JSONObject json = new JSONObject();
            json.put("success", false);
            EntityManager em = Stripersist.getEntityManager();
            Layer l = this.getAppLayer().getService().getLayer(this.getAppLayer().getLayerName(), em);
            FeatureSource fs = l.getFeatureType().openGeoToolsFeatureSource();
            SimpleFeatureStore d = (SimpleFeatureStore)fs;
            try {
                if (this.submitCorrectieVoorstellen(d, json)) {
                    json.put("success", this.submitAfspraakgebiedMetingen(d, json));
                }
            }
            finally {
                fs.getDataStore().dispose();
            }
            return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
        }
        catch (Exception ex) {
            log.error((Object)"Cannot update corrections: ", (Throwable)ex);
            return new ErrorResolution(500, "Cannot update corrections: " + ex.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean submitCorrectieVoorstellen(SimpleFeatureStore d, JSONObject json) throws IOException {
        d.setTransaction((Transaction)transaction);
        try (DefaultTransaction transaction = new DefaultTransaction("edit");){
            Filter f = ECQL.toFilter((String)("CORRECTIE_STATUS_ID = 1 and AGM_ID = " + this.AGM_ID));
            d.modifyFeatures("CORRECTIE_STATUS_ID", (Object)2, f);
            transaction.commit();
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean submitAfspraakgebiedMetingen(SimpleFeatureStore mainFs, JSONObject json) throws IOException {
        DataAccess da = mainFs.getDataStore();
        FeatureSource fs = da.getFeatureSource((Name)new NameImpl("AFSPRAAKGEB_METINGEN"));
        SimpleFeatureStore d = (SimpleFeatureStore)fs;
        d.setTransaction((Transaction)transaction);
        try (DefaultTransaction transaction = new DefaultTransaction("edit");){
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
            Id f = ff.id(new FeatureId[]{new FeatureIdImpl(this.AGM_ID.toString())});
            d.modifyFeatures("IND_CORRECTIES_INGEDIEND_JN", (Object)"J", (Filter)f);
            transaction.commit();
            json.put("success", true);
            boolean bl = true;
            return bl;
        }
    }

    public Resolution downloadAttachment() {
        if (!this.isAuthorized()) {
            log.error((Object)"Unauthorized access");
            return new ErrorResolution(401, "Geen toegang");
        }
        try {
            EntityManager em = Stripersist.getEntityManager();
            Layer l = this.getAppLayer().getService().getLayer(this.getAppLayer().getLayerName(), em);
            FeatureSource fs = l.getFeatureType().openGeoToolsFeatureSource();
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
            Id f = ff.id(new FeatureId[]{new FeatureIdImpl(this.CV_ID.toString())});
            FeatureCollection fc = fs.getFeatures((Filter)f);
            FeatureIterator it = fc.features();
            SimpleFeature feature = null;
            while (it.hasNext()) {
                feature = (SimpleFeature)it.next();
            }
            if (feature != null) {
                byte[] ar = (byte[])feature.getAttribute("UPLOAD");
                String filename = (String)feature.getAttribute("BESTANDSNAAM");
                String mimetype = (String)feature.getAttribute("MIMETYPE");
                return new StreamingResolution(mimetype, (InputStream)new ByteArrayInputStream(ar)).setFilename(filename).setAttachment(true);
            }
            return new ErrorResolution(500, "Upload not found");
        }
        catch (Exception ex) {
            log.error((Object)"Cannot retrieve upload: ", (Throwable)ex);
            return new ErrorResolution(500, "Cannot retrieve upload: " + ex.getLocalizedMessage());
        }
    }

    public Resolution saveIbis() {
        if (!this.isAuthorized()) {
            log.error((Object)"Unauthorized access");
            return new ErrorResolution(401, "Geen toegang");
        }
        this.saveBedrijventerrein();
        this.setFeature(this.meting);
        return this.edit();
    }

    private void saveBedrijventerrein() {
        try {
            JSONObject bedrijventerrein;
            EntityManager em = Stripersist.getEntityManager();
            Layer l = this.getAppLayer().getService().getLayer(this.getAppLayer().getLayerName(), em);
            FeatureSource mainFs = l.getFeatureType().openGeoToolsFeatureSource();
            DataAccess da = mainFs.getDataStore();
            FeatureSource fs = da.getFeatureSource((Name)new NameImpl("BEDRIJVENTERREINEN"));
            this.store = (SimpleFeatureStore)fs;
            Layer prev = this.layer;
            this.layer = l;
            JSONObject orig = new JSONObject(this.meting);
            this.jsonFeature = bedrijventerrein = orig.optJSONObject("BEDRIJVENTERREIN");
            this.overrideUserEditableMethod = true;
            this.editFeature(bedrijventerrein.optString("__fid"));
            this.layer = prev;
            this.overrideUserEditableMethod = false;
        }
        catch (Exception ex) {
            log.error((Object)"Cannot save bedrijventerrein", (Throwable)ex);
        }
    }

    protected boolean isAttributeUserEditingDisabled(String attrName) {
        if (this.overrideUserEditableMethod) {
            return false;
        }
        return super.isAttributeUserEditingDisabled(attrName);
    }

    protected JSONObject getJsonFeature(String feature) {
        JSONObject f = new JSONObject(feature);
        if (this.UPLOAD != null) {
            try (InputStream is = this.UPLOAD.getInputStream();){
                byte[] bytes = IOUtils.toByteArray((InputStream)is);
                f.put("UPLOAD", (Object)bytes);
                f.put("BESTANDSNAAM", (Object)this.UPLOAD.getFileName());
                f.put("MIMETYPE", (Object)this.UPLOAD.getContentType());
            }
            catch (IOException ex) {
                log.error((Object)"Cannot read upload: ", (Throwable)ex);
            }
        }
        return f;
    }
}

