/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.security.Principal;
import java.util.Collection;
import java.util.NoSuchElementException;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.services.FeatureSource;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.stripes.LocalizableApplicationActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.text.ecql.ECQL;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/mob/store")
@StrictBinding
public class MOBStoreActionBean
extends LocalizableApplicationActionBean {
    private static final Log log = LogFactory.getLog(MOBStoreActionBean.class);
    private ActionBeanContext context;
    private FeatureSource fs;
    @Validate
    private String featureTypeName;
    @Validate
    private Application application;
    @Validate
    private ApplicationLayer appLayer;
    @Validate(on={"metingen"})
    private Integer GEM_CODE_CBS;
    @Validate(on={"metingen"})
    private Integer METING_ID;
    @Validate
    private String sort;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public FeatureSource getFs() {
        return this.fs;
    }

    public void setFs(FeatureSource fs) {
        this.fs = fs;
    }

    public String getFeatureTypeName() {
        return this.featureTypeName;
    }

    public void setFeatureTypeName(String featureTypeName) {
        this.featureTypeName = featureTypeName;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public ApplicationLayer getAppLayer() {
        return this.appLayer;
    }

    public void setAppLayer(ApplicationLayer appLayer) {
        this.appLayer = appLayer;
    }

    public Integer getGEM_CODE_CBS() {
        return this.GEM_CODE_CBS;
    }

    public void setGEM_CODE_CBS(Integer GEM_CODE_CBS) {
        this.GEM_CODE_CBS = GEM_CODE_CBS;
    }

    public Integer getMETING_ID() {
        return this.METING_ID;
    }

    public void setMETING_ID(Integer METING_ID) {
        this.METING_ID = METING_ID;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    private boolean isAuthorized() {
        HttpServletRequest req = this.getContext().getRequest();
        Principal geb = req.getUserPrincipal();
        return geb != null && (req.isUserInRole("gemeente") || req.isUserInRole("provincie"));
    }

    @DefaultHandler
    public Resolution store() {
        if (!this.isAuthorized()) {
            log.error((Object)"Unauthorized access");
            return new ErrorResolution(401, "Geen toegang");
        }
        return this.readFeatures(this.featureTypeName, null);
    }

    public Resolution metingen() {
        if (!this.isAuthorized()) {
            log.error((Object)"Unauthorized access");
            return new ErrorResolution(401, "Geen toegang");
        }
        return this.readFeatures("BEDR_TERREIN_METINGEN", String.format("METING_ID = %d AND GEM_CODE_CBS = %d", this.METING_ID, this.GEM_CODE_CBS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resolution readFeatures(String featureTypeName, String filter) {
        if (!this.isAuthorized()) {
            log.error((Object)"Unauthorized access");
            return new ErrorResolution(401, "Geen toegang");
        }
        JSONObject response = new JSONObject();
        EntityManager em = Stripersist.getEntityManager();
        Layer layer = this.appLayer.getService().getLayer(this.appLayer.getLayerName(), em);
        if (layer == null) {
            String error = this.getBundle().getString("viewer.editfeatureactionbean.3");
            return new StreamingResolution("application/json", (Reader)new StringReader(error));
        }
        if (layer.getFeatureType() == null) {
            String error = this.getBundle().getString("viewer.editfeatureactionbean.4");
            return new StreamingResolution("application/json", (Reader)new StringReader(error));
        }
        this.fs = layer.getFeatureType().getFeatureSource();
        SimpleFeatureType sft = this.fs.getFeatureType(featureTypeName);
        try {
            org.geotools.data.FeatureSource source = sft.openGeoToolsFeatureSource();
            Filter ff = null;
            Query q = new Query(this.fs.getName());
            this.setSortBy(q, this.sort, null, CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints()));
            if (filter != null) {
                ff = ECQL.toFilter((String)filter);
                q.setFilter(ff);
            }
            FeatureCollection fc = source.getFeatures(q);
            FeatureIterator it = null;
            JSONArray features = new JSONArray();
            response.put("features", (Object)features);
            try {
                it = fc.features();
                boolean featureIndex = false;
                while (it.hasNext()) {
                    SimpleFeature f = (SimpleFeature)it.next();
                    features.put((Object)this.featureToJSON(f));
                }
            }
            catch (NoSuchElementException e) {
                log.error((Object)"Cannot get feature:", (Throwable)e);
            }
            finally {
                if (it != null) {
                    it.close();
                }
                source.getDataStore().dispose();
            }
        }
        catch (Exception ex) {
            log.error((Object)"Cannot open featuresource:", (Throwable)ex);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(response.toString(4)));
    }

    private void setSortBy(Query q, String sort, String dir, FilterFactory2 ff2) {
        if (sort != null) {
            q.setSortBy(new SortBy[]{ff2.sort(sort, "DESC".equals(dir) ? SortOrder.DESCENDING : SortOrder.ASCENDING)});
        }
    }

    private JSONObject featureToJSON(SimpleFeature sf) {
        JSONObject obj = new JSONObject();
        Collection props = sf.getProperties();
        for (Property prop : props) {
            obj.put(prop.getName().getLocalPart(), prop.getValue());
        }
        return obj;
    }
}

