/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.solr;

import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import nl.b3p.viewer.solr.SolrUpdateJob;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class SolrUpdaterListener
implements ServletContextListener {
    private static final String PARAM_SOLR_UPDATE_INTERVAL = "flamingo.solr.schedule";
    private static final Log log = LogFactory.getLog(SolrUpdaterListener.class);
    private ServletContext context;
    private Scheduler scheduler;
    private String interval;

    public void contextInitialized(ServletContextEvent sce) {
        this.init(sce);
        if (this.interval.equalsIgnoreCase("-1") || this.interval == null) {
            return;
        }
        Properties props = new Properties();
        props.put("org.quartz.scheduler.instanceName", "MonitoringScheduler");
        props.put("org.quartz.threadPool.threadCount", "1");
        props.put("org.quartz.scheduler.interruptJobsOnShutdownWithWait", "true");
        props.put("org.quartz.jobStore.class", "org.quartz.simpl.RAMJobStore");
        try {
            this.scheduler = new StdSchedulerFactory(props).getScheduler();
            this.scheduler.startDelayed(60);
            JobDetail job = JobBuilder.newJob(SolrUpdateJob.class).withIdentity("SolrUpdateJob", "solrupdategroup").build();
            log.info((Object)("Scheduling indexing job for expression " + this.interval + " minutes"));
            CronScheduleBuilder cronSchedule = CronScheduleBuilder.cronSchedule((String)this.interval);
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity("solrupdatejob", "solrupdategroup").startNow().withSchedule((ScheduleBuilder)cronSchedule).build();
            this.scheduler.scheduleJob(job, trigger);
        }
        catch (SchedulerException ex) {
            log.error((Object)"Cannot create scheduler. ", (Throwable)ex);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.scheduler != null) {
            try {
                this.scheduler.shutdown(true);
            }
            catch (SchedulerException ex) {
                log.error((Object)"Cannot shutdown quartz scheduler. ", (Throwable)ex);
            }
        }
    }

    private void init(ServletContextEvent sce) {
        this.context = sce.getServletContext();
        this.interval = this.context.getInitParameter(PARAM_SOLR_UPDATE_INTERVAL);
    }
}

