/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.solr;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import nl.b3p.viewer.config.services.AttributeDescriptor;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.config.services.SolrConf;
import nl.b3p.viewer.config.services.WFSFeatureSource;
import nl.b3p.viewer.solr.SolrInitializer;
import nl.b3p.web.WaitPageStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrInputDocument;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.jdbc.JDBCFeatureSource;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.stripesstuff.stripersist.Stripersist;

public class SolrUpdateJob
implements Job {
    private static final Log log = LogFactory.getLog(SolrUpdateJob.class);
    private SolrServer server;
    public static int MAX_FEATURES = 5000;
    public static int BATCH_SIZE = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext jec) throws JobExecutionException {
        log.info((Object)"Starting updating of the solr index.");
        this.server = SolrInitializer.getServerInstance();
        if (this.server == null) {
            log.error((Object)"Could not locate solr server. Terminate updating of index.");
            return;
        }
        try {
            Stripersist.requestInit();
            EntityManager em = Stripersist.getEntityManager();
            WaitPageStatus status = new WaitPageStatus(){

                public void setCurrentAction(String currentAction) {
                    this.currentAction.set(currentAction);
                }

                public void addLog(String message) {
                    this.logs.add(message);
                }
            };
            List configs = em.createQuery("FROM SolrConf", SolrConf.class).getResultList();
            for (SolrConf solrConfiguration : configs) {
                SolrUpdateJob.removeSolrConfigurationFromIndex(solrConfiguration, em, this.server);
                SolrUpdateJob.insertSolrConfigurationIntoIndex(solrConfiguration, em, status, this.server);
            }
            em.getTransaction().commit();
            log.info((Object)"Updating index complete.");
        }
        catch (Exception e) {
            log.error((Object)"Error", (Throwable)e);
        }
        finally {
            Stripersist.requestComplete();
        }
    }

    public static void removeSolrConfigurationFromIndex(SolrConf config, EntityManager em, SolrServer solrServer) {
        log.info((Object)("Remove documents from SolrConfiguration " + config.getName() + " from index."));
        try {
            solrServer.deleteByQuery("searchConfig:" + config.getId());
            solrServer.commit();
            Date now = new Date();
            config.setLastUpdated(now);
        }
        catch (SolrServerException ex) {
            log.error((Object)("Could not delete documents for solr configuration: " + config.getName() + " - id: " + config.getId()), (Throwable)ex);
        }
        catch (IOException ex) {
            log.error((Object)("Could not delete documents for solr configuration: " + config.getName() + " - id: " + config.getId()), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertSolrConfigurationIntoIndex(SolrConf config, EntityManager em, WaitPageStatus status, SolrServer solrServer, Filter filter) {
        log.info((Object)("Insert SolrConfiguration " + config.getName() + " into index."));
        FeatureSource fs = null;
        try {
            FeatureCollection fc;
            if (solrServer == null) {
                throw new Exception("No solr server initialized.");
            }
            status.setCurrentAction("Initialiseren...");
            status.setProgress(10);
            List indexAttributesConfig = config.getIndexAttributes();
            List resultAttributesConfig = config.getResultAttributes();
            SimpleFeatureType sft = config.getSimpleFeatureType();
            fs = sft.openGeoToolsFeatureSource();
            Query q = new Query();
            if (filter != null) {
                q.setFilter(filter);
            }
            if (sft.getFeatureSource() instanceof WFSFeatureSource) {
                q.setMaxFeatures(MAX_FEATURES);
                fc = fs.getFeatures(q);
                FeatureIterator iterator = fc.features();
                SolrUpdateJob.processFeatures((FeatureIterator<SimpleFeature>)iterator, indexAttributesConfig, resultAttributesConfig, config.getId(), solrServer, status, 70.0);
            } else {
                status.setCurrentAction("Aantal features berekenen...");
                status.setProgress(15);
                if (fs instanceof JDBCFeatureSource) {
                    ArrayList<String> propertyNames = new ArrayList<String>();
                    for (AttributeDescriptor ad : sft.getAttributes()) {
                        propertyNames.add(ad.getName());
                    }
                    if (!propertyNames.isEmpty()) {
                        SolrUpdateJob.setSortBy(q, (String)propertyNames.get(0));
                    }
                }
                fc = fs.getFeatures(q);
                int total = fc.size();
                status.setCurrentAction("Begin toevoegen");
                status.setProgress(20);
                int numIterations = (int)Math.ceil((double)total / (double)BATCH_SIZE);
                double percentagePerBatch = 70.0 / (double)numIterations;
                int currentProgress = 20;
                for (int i = 0; i < numIterations; ++i) {
                    int start = i * BATCH_SIZE;
                    q.setStartIndex(Integer.valueOf(start));
                    int max = (i + 1) * BATCH_SIZE > total ? total : BATCH_SIZE;
                    q.setMaxFeatures(max);
                    status.setCurrentAction("Bezig met verwerken features " + start + " - " + (start + max) + " van de " + total);
                    currentProgress = (int)((double)currentProgress + percentagePerBatch);
                    status.setProgress(currentProgress);
                    fc = fs.getFeatures(q);
                    SolrUpdateJob.processFeatures((FeatureIterator<SimpleFeature>)fc.features(), indexAttributesConfig, resultAttributesConfig, config.getId(), solrServer, status, percentagePerBatch);
                }
            }
            Date now = new Date();
            config.setLastUpdated(now);
            em.persist((Object)config);
            status.setProgress(100);
            status.setFinished(true);
        }
        catch (Exception ex) {
            log.error((Object)"Cannot add configuration to index", (Throwable)ex);
            status.setCurrentAction("Mislukt.");
        }
        finally {
            if (fs != null && fs.getDataStore() != null) {
                fs.getDataStore().dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processFeatures(FeatureIterator<SimpleFeature> iterator, List<String> indexAttributesConfig, List<String> resultAttributesConfig, Long id, SolrServer solrServer, WaitPageStatus status, double percentage) {
        try {
            ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>();
            try {
                while (iterator.hasNext()) {
                    String field;
                    Object col;
                    String attributeName;
                    SimpleFeature feature = (SimpleFeature)iterator.next();
                    SolrInputDocument doc = new SolrInputDocument();
                    boolean hasAllRequiredFields = true;
                    Iterator<String> iterator2 = indexAttributesConfig.iterator();
                    while (iterator2.hasNext()) {
                        String attr;
                        attributeName = attr = iterator2.next();
                        col = feature.getAttribute(attributeName);
                        field = "values";
                        if (col != null) {
                            doc.addField("columns", (Object)attributeName);
                            doc.addField(field, col);
                            continue;
                        }
                        hasAllRequiredFields = false;
                    }
                    if (!hasAllRequiredFields) continue;
                    iterator2 = resultAttributesConfig.iterator();
                    while (iterator2.hasNext()) {
                        String attributeDescriptor;
                        attributeName = attributeDescriptor = iterator2.next();
                        col = feature.getAttribute(attributeName);
                        field = "resultValues";
                        if (col == null) continue;
                        doc.addField("resultColumns", (Object)attributeName);
                        doc.addField(field, col);
                    }
                    Object obj = feature.getDefaultGeometry();
                    Geometry g = (Geometry)obj;
                    if (g != null) {
                        Envelope env = SolrUpdateJob.featureToEnvelope(g);
                        doc.addField("minx", (Object)env.getMinX());
                        doc.addField("miny", (Object)env.getMinY());
                        doc.addField("maxx", (Object)env.getMaxX());
                        doc.addField("maxy", (Object)env.getMaxY());
                    }
                    doc.addField("id", (Object)feature.getID());
                    doc.addField("searchConfig", (Object)id);
                    docs.add(doc);
                }
            }
            finally {
                iterator.close();
            }
            solrServer.add(docs);
            solrServer.commit();
        }
        catch (SolrServerException ex) {
            log.error((Object)"Cannot add configuration to index", (Throwable)ex);
        }
        catch (IOException ex) {
            log.error((Object)"Cannot add configuration to index", (Throwable)ex);
        }
    }

    public static void insertSolrConfigurationIntoIndex(SolrConf config, EntityManager em, WaitPageStatus status, SolrServer solrServer) {
        SolrUpdateJob.insertSolrConfigurationIntoIndex(config, em, status, solrServer, null);
    }

    private static Envelope featureToEnvelope(Geometry g) {
        Envelope env;
        HashMap bbox = new HashMap();
        if (g instanceof Point) {
            Point p = (Point)g;
            Geometry buffer = p.buffer(200.0);
            env = buffer.getEnvelopeInternal();
        } else {
            env = g.getEnvelopeInternal();
        }
        return env;
    }

    private static void setSortBy(Query q, String sort) {
        FilterFactory2 ff2 = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        if (sort != null) {
            q.setSortBy(new SortBy[]{ff2.sort(sort, SortOrder.ASCENDING)});
        }
    }
}

