/*
 * Copyright (C) 2013 B3Partners B.V.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package nl.b3p.viewer.admin.stripes;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.app.Level;
import nl.b3p.viewer.config.security.Group;
import nl.b3p.viewer.config.services.FeatureSource;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 *
 * @author Roy Braam
 */
@StrictBinding
@UrlBinding("/action/serviceUsageMatrix/{$event}")
@RolesAllowed({Group.ADMIN,Group.REGISTRY_ADMIN})
public class ServiceUsageMatrixActionBean implements ActionBean {
    private static final Log log = LogFactory.getLog(ServiceUsageMatrixActionBean.class);
    private static final String JSP = "/WEB-INF/jsp/services/serviceusagematrix.jsp";
    private static final String xslPath="/WEB-INF/classes/xsl/ServiceUsageMatrix.xsl";
    private ActionBeanContext context;

    @Validate
    private String xml;
    @Validate
    private ApplicationLayer applicationLayer;
    @Validate
    private Application application;
    @Validate
    private FeatureSource featureSource;
    @Validate
    private String changedFeatureTypes;
    @Validate
    private String output_format;

    private JSONObject data;

    private void createData() throws Exception {
        List<Application> applications = Stripersist.getEntityManager().createQuery("FROM Application order by name,version").getResultList();
        JSONArray jsonApps = new JSONArray();
        EntityManager em = Stripersist.getEntityManager();
        for (Application app: applications){
            JSONObject json = new JSONObject(app.toJSON(this.context.getRequest(),true,true,em));
            jsonApps.put(json);
        }
        //add the featureSources to the JSON.
        List <FeatureSource> featureSources;
        if (this.featureSource==null){
            featureSources = em.createQuery("FROM FeatureSource").getResultList();
        }else{
            featureSources = new ArrayList<FeatureSource>();
            featureSources.add(this.featureSource);
        }
        JSONArray featureSourcesJson = new JSONArray();
        for (FeatureSource fs : featureSources){
            JSONObject fsJson = fs.toJSONObject();
            featureSourcesJson.put(fsJson);

            JSONObject featuretypesRoot = new JSONObject();
            JSONArray ftJsonArray = new JSONArray();
            featuretypesRoot.put("featureType",ftJsonArray);
            fsJson.put("featuretypes", featuretypesRoot);

            List<SimpleFeatureType> featureTypes = fs.getFeatureTypes();
            for (SimpleFeatureType sft : featureTypes){
                JSONObject ftJson= new JSONObject();
                ftJson.put("id",sft.getId());
                ftJson.put("name", sft.getTypeName());
                ftJson.put("description",sft.getDescription());
                ftJsonArray.put(ftJson);
            }
        }
        //format a json for the xml output.
        JSONObject fs = new JSONObject();
        fs.put("featureSource",featureSourcesJson);

        JSONObject appl = new JSONObject();
        appl.put("application",jsonApps);
        //make root elements for applicatons and featuresources
        JSONObject firstChild = new JSONObject();
        firstChild.put("applications",appl);
        firstChild.put("featureSources",fs);

        data = new JSONObject();
        data.put("root",firstChild);
    }

    @DefaultHandler
    public Resolution view() throws JSONException, TransformerConfigurationException, TransformerException, Exception {

        //make xml
        createData();
        String rawXml = org.json.XML.toString(data);

        this.xml = transformXml(rawXml);
        Date nowDate = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = (SimpleDateFormat) SimpleDateFormat.getDateInstance();
        sdf.applyPattern("HH-mm_dd-MM-yyyy");
        String now = sdf.format(nowDate);
        final String fileName = "UsageMatrix_" + now;
        if (output_format!=null || "XLS".equalsIgnoreCase(output_format)){
            final XSSFWorkbook workbook= createWorkBook(this.xml);
            return new StreamingResolution("application/vnd.ms-excel"){
                public void stream(final HttpServletResponse response){
                    try{
                        workbook.write(response.getOutputStream());
                    }catch(IOException ioe){
                        log.error("Error while writing workbook",ioe);
                    }
                }
            }.setAttachment(true).setFilename(fileName + ".xls");
        }
        return new ForwardResolution(JSP);
    }

    public Resolution json() throws Exception {
        createData();
        return new StreamingResolution("application/json", new StringReader(data.toString(4)));
    }

    public Resolution xml() throws Exception {
        createData();
        return new StreamingResolution("text/xml", new StringReader(org.json.XML.toString(data)));
    }

    public Resolution xmlTransformed() throws Exception {
        createData();
        return new StreamingResolution("text/xml", new StringReader(transformXml(org.json.XML.toString(data))));
    }

    public Resolution deleteApplicationLayer() throws JSONException{
        JSONObject json = new JSONObject();
        try{
            json.put("success",false);
            if (this.applicationLayer!=null && this.application!=null){
                json.put("id",this.applicationLayer.getId());
                json.put("name",this.applicationLayer.getDisplayName(Stripersist.getEntityManager()));

                Level parent=this.application.getRoot().getParentInSubtree(applicationLayer);
                if (parent==null){
                    json.put("message", "No parent Level for given application layer: "+this.applicationLayer.getId()+
                            " in application: "+this.getApplication().getId());
                }else{
                    parent.getLayers().remove(this.applicationLayer);
                    Stripersist.getEntityManager().remove(this.applicationLayer);
                    Stripersist.getEntityManager().getTransaction().commit();
                    json.put("success",true);
                }
            }else{
                json.put("message","No applicationlayer found");
            }
        }catch (Exception e){
            log.error("Error while deleting applicationlayer",e);
            json.put("message",e.getLocalizedMessage());
        }
        return new StreamingResolution("text/html", new StringReader(json.toString()));
    }

    private String transformXml(String rawXml) throws TransformerConfigurationException, TransformerException {
        StringReader reader = new StringReader(rawXml);
        StringWriter writer = new StringWriter();

        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(
            new javax.xml.transform.stream.StreamSource(this.getContext().getServletContext().getRealPath(xslPath)));

        transformer.transform(
            new javax.xml.transform.stream.StreamSource(reader),
            new javax.xml.transform.stream.StreamResult(writer));

        return writer.toString();
    }

    //<editor-fold defaultstate="collapsed" desc="Getters setters">

    @Override
    public void setContext(ActionBeanContext context) {
        this.context=context;
    }

    @Override
    public ActionBeanContext getContext() {
        return this.context;
    }
    public String getXml() {
        return xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public ApplicationLayer getApplicationLayer() {
        return applicationLayer;
    }

    public void setApplicationLayer(ApplicationLayer applicationLayer) {
        this.applicationLayer = applicationLayer;
    }

    public Application getApplication() {
        return application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public FeatureSource getFeatureSource() {
        return featureSource;
    }

    public void setFeatureSource(FeatureSource featureSource) {
        this.featureSource = featureSource;
    }

    public String getChangedFeatureTypes() {
        return changedFeatureTypes;
    }

    public void setChangedFeatureTypes(String changedFeatureTypes) {
        this.changedFeatureTypes = changedFeatureTypes;
    }

    public String getOutput_format() {
        return output_format;
    }

    public void setOutput_format(String output_format) {
        this.output_format = output_format;
    }
    //</editor-fold>

    public static XSSFWorkbook createWorkBook(String theXml) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException, XPathFactoryConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc=builder.parse(new InputSource(new StringReader(theXml)));

        XSSFWorkbook workbook = new XSSFWorkbook();
        String tempProperty=null;
        try{            Element root = doc.getDocumentElement();
            /* JSTL XML is setting the system property to use the jstl xpath facotry.
             * Remove the setting temporary:
             * see: https://java.net/jira/browse/JSTL-1
             */
            tempProperty =  System.getProperty(XPathFactory.DEFAULT_PROPERTY_NAME +
                ":" + XPathFactory.DEFAULT_OBJECT_MODEL_URI);
            if (tempProperty!=null){
                System.clearProperty(XPathFactory.DEFAULT_PROPERTY_NAME +
                ":" + XPathFactory.DEFAULT_OBJECT_MODEL_URI);
            }

            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            XPathExpression exprFeatureSource = xpath.compile("//featureSource");
            XPathExpression exprFeatureType = xpath.compile("featureType");
            XPathExpression exprApplication = xpath.compile("applications/application");
            XPathExpression exprLayer = xpath.compile("layers/layer");
            XPathExpression exprAppLayer = xpath.compile("applayers/applayer");
            XPathExpression exprId = xpath.compile("id/text()");
            XPathExpression exprAlias = xpath.compile("alias/text()");
            XPathExpression exprName = xpath.compile("name/text()");
            XPathExpression exprVersion = xpath.compile("version/text()");
            XPathExpression exprProtocol = xpath.compile("protocol/text()");
            XPathExpression exprUrl = xpath.compile("url/text()");

            XSSFSheet sheet = workbook.createSheet("Sheet 1");
            int rowNum=0;

            Row head = sheet.createRow(rowNum++);
            String[] headValues = {"Bron","Featuretype","Applicatie","Layernaam van service","Application layer (kaart)"};
            for (int c = 0; c < headValues.length; c++){
                Cell cell = head.createCell(c);
                cell.setCellValue(headValues[c]);
            }
            List<String> columns=  new ArrayList<String>();
            for (int i=0; i < headValues.length; i++){
                columns.add("");
            }
            NodeList featureSources = (NodeList) exprFeatureSource.evaluate(root,XPathConstants.NODESET);

            for (int fs=0; fs < featureSources.getLength(); fs++){
                Node featureSource = featureSources.item(fs);

                String fsString=(String) exprName.evaluate(featureSource,XPathConstants.STRING);
                fsString+=" ("+(String) exprProtocol.evaluate(featureSource,XPathConstants.STRING);
                fsString+=":: "+(String) exprUrl.evaluate(featureSource,XPathConstants.STRING);
                fsString+=" id: "+(String) exprId.evaluate(featureSource,XPathConstants.STRING);
                fsString+=")";
                columns.set(0,fsString);
                NodeList featureTypes = (NodeList) exprFeatureType.evaluate(featureSource,XPathConstants.NODESET);
                for (int ft=0; ft < featureTypes.getLength(); ft++){
                    Node featureType = featureTypes.item(ft);
                    //String ftId = (String) exprId.evaluate(featureType,XPathConstants.STRING);
                    String ftName = (String) exprName.evaluate(featureType,XPathConstants.STRING);
                    //String ftString = ""+ftName;
                    columns.set(1,ftName);
                    NodeList applications = (NodeList) exprApplication.evaluate(featureType, XPathConstants.NODESET);
                    for (int app=0; app< applications.getLength(); app++){
                        Node application = applications.item(app);
                        String appVersion= (String) exprVersion.evaluate(application,XPathConstants.STRING);

                        String appString = (String) exprName.evaluate(application,XPathConstants.STRING);
                        if (appVersion!=null){
                            appString += ", version: "+appVersion;
                        }
                        appString+=" ("+(String) exprId.evaluate(application,XPathConstants.STRING)+")";
                        columns.set(2,appString);
                        NodeList layers = (NodeList) exprLayer.evaluate(application,XPathConstants.NODESET);
                        for (int lay=0; lay < layers.getLength(); lay++){
                            Node layer = layers.item(lay);
                            String layerString = "";
                            layerString += (String) exprName.evaluate(layer,XPathConstants.STRING);
                            columns.set(3,layerString);
                            NodeList appLayers = (NodeList) exprAppLayer.evaluate(layer,XPathConstants.NODESET);
                            for (int al=0; al < appLayers.getLength(); al++){
                                Node appLayer = appLayers.item(al);
                                String alString=(String) exprAlias.evaluate(appLayer,XPathConstants.STRING);
                                alString+=" ("+(String) exprId.evaluate(appLayer,XPathConstants.STRING)+")";
                                columns.set(4,alString);
                                Row row=sheet.createRow(rowNum++);
                                for (int c=0; c < columns.size(); c++){
                                    Cell cell = row.createCell(c);
                                    cell.setCellValue(columns.get(c));
                                }
                            }
                        }
                    }
                }
            }
        }finally{
            if (tempProperty!=null){
                System.setProperty(XPathFactory.DEFAULT_PROPERTY_NAME +
                ":" + XPathFactory.DEFAULT_OBJECT_MODEL_URI, tempProperty);
            }
        }
        return workbook;
    }

    public static void main (String[] args) throws Exception{
    //        String xml="<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><featureSources><featureSource><id>2</id><name>Gemeentes (CBS 2010)</name><protocol>wfs</protocol><url>http://mapserver.openwion.nl/cgi-bin/mapserv?map=/srv/b3p-wion/maps/gemeentes_cbs_2010.map</url><featureType><id>1</id><name>gemeentes</name><description/><applications><application><id>3</id><name>ol</name><version>2</version><layers><layer><serviceId>2</serviceId><name>gemeentes</name><applayers><applayer><id>48</id><alias>gemeentes</alias></applayer></applayers></layer></layers></application><application><id>1</id><name>default</name><version/><layers><layer><serviceId>2</serviceId><name>gemeentes</name><applayers><applayer><id>3</id><alias>gemeentes</alias></applayer></applayers></layer></layers></application><application><id>5</id><name>ol</name><version>3</version><layers><layer><serviceId>2</serviceId><name>gemeentes</name><applayers><applayer><id>71</id><alias>gemeentes</alias></applayer></applayers></layer></layers></application><application><id>2</id><name>ol</name><version/><layers><layer><serviceId>2</serviceId><name>gemeentes</name><applayers><applayer><id>31</id><alias>gemeentes</alias></applayer></applayers></layer></layers></application><application><id>30</id><name>ol22</name><version/><layers><layer><serviceId>2</serviceId><name>gemeentes</name><applayers><applayer><id>443</id><alias>gemeentes</alias></applayer></applayers></layer></layers></application></applications></featureType></featureSource><featureSource><id>3</id><name>Oracle</name><protocol>jdbc</protocol><url>{\"port\":\"1521\",\"dbtype\":\"oracle\",\"host\":\"localhost\",\"database\":\"orcl\"}</url><featureType><id>2</id><name>BESTEMMINGSPLANNEN_MV</name><description/><applications/></featureType><featureType><id>3</id><name>BOY_WION_L</name><description/><applications/></featureType><featureType><id>4</id><name>BOY_WION_P</name><description/><applications/></featureType><featureType><id>5</id><name>BOY_WION_V</name><description/><applications/></featureType><featureType><id>6</id><name>CHTERLAND_POLY</name><description/><applications/></featureType><featureType><id>7</id><name>CHTERLAND_POLY_MV</name><description/><applications/></featureType><featureType><id>8</id><name>DELING_HELMOND</name><description/><applications/></featureType><featureType><id>9</id><name>DELING_HELMOND_V</name><description/><applications/></featureType><featureType><id>10</id><name>EDAMVOLENDAMOVERVIEWS_MV</name><description/><applications/></featureType><featureType><id>11</id><name>EDAMVOLENDAM_MV</name><description/><applications/></featureType><featureType><id>12</id><name>EMMINGSPLANNEN_MV</name><description/><applications/></featureType><featureType><id>13</id><name>LIMBURG</name><description/><applications/></featureType><featureType><id>14</id><name>N888NUWION_L</name><description/><applications/></featureType><featureType><id>15</id><name>N888NUWION_P</name><description/><applications/></featureType><featureType><id>16</id><name>N888NUWION_V</name><description/><applications/></featureType><featureType><id>17</id><name>WIJKINDELING_HELMOND_V</name><description/><applications/></featureType><featureType><id>18</id><name>WION_20110331_L</name><description/><applications/></featureType><featureType><id>19</id><name>WION_20110331_P</name><description/><applications/></featureType><featureType><id>20</id><name>WION_20110331_TST_L</name><description/><applications/></featureType><featureType><id>21</id><name>WION_20110331_TST_P</name><description/><applications/></featureType><featureType><id>22</id><name>WION_20110331_TST_V</name><description/><applications/></featureType><featureType><id>23</id><name>WION_20110331_V</name><description/><applications/></featureType><featureType><id>24</id><name>WION_TST_L</name><description/><applications/></featureType><featureType><id>25</id><name>WION_TST_P</name><description/><applications/></featureType><featureType><id>26</id><name>WION_TST_V</name><description/><applications/></featureType><featureType><id>27</id><name>V_ANNOTATIE_L</name><description/><applications/></featureType><featureType><id>28</id><name>V_ANNOTATIE_T</name><description/><applications/></featureType><featureType><id>29</id><name>V_ANNOTATIE_V</name><description/><applications/></featureType><featureType><id>30</id><name>V_DUIKERS_L</name><description/><applications/></featureType><featureType><id>31</id><name>V_DUIKERS_V</name><description/><applications/></featureType><featureType><id>32</id><name>V_LAAGSPANNING_L</name><description/><applications/></featureType><featureType><id>33</id><name>V_LAAGSPANNING_P</name><description/><applications/></featureType><featureType><id>34</id><name>V_LAAGSPANNING_V</name><description/><applications/></featureType><featureType><id>35</id><name>V_LUSSEN_V</name><description/><applications/></featureType><featureType><id>36</id><name>V_MANTELBUIS_L</name><description/><applications/></featureType><featureType><id>37</id><name>V_MANTELBUIS_V</name><description/><applications/></featureType><featureType><id>38</id><name>V_RIOLERING_VRIJVERVAL_L</name><description/><applications/></featureType><featureType><id>39</id><name>V_RIOLERING_VRIJVERVAL_V</name><description/><applications/></featureType></featureSource><featureSource><id>4</id><name>openwion</name><protocol>jdbc</protocol><url>{\"port\":\"5432\",\"dbtype\":\"postgis\",\"host\":\"localhost\",\"database\":\"openwion\"}</url><featureType><id>40</id><name>beheerdersinformatie</name><description/><applications/></featureType><featureType><id>41</id><name>beheerdersinformatie_bijlagen</name><description/><applications/></featureType><featureType><id>42</id><name>beheerdersinformatie_themas</name><description/><applications/></featureType><featureType><id>43</id><name>bijlage</name><description/><applications/></featureType><featureType><id>44</id><name>gebruiker</name><description/><applications/></featureType><featureType><id>45</id><name>gebruiker_roles</name><description/><applications/></featureType><featureType><id>46</id><name>graafbericht</name><description/><applications/></featureType><featureType><id>47</id><name>graafbericht_huisaansluitschetsen</name><description/><applications/></featureType><featureType><id>48</id><name>graafbericht_request</name><description/><applications/></featureType><featureType><id>49</id><name>graafbericht_request_attachment</name><description/><applications/></featureType><featureType><id>50</id><name>graafbericht_request_attachments</name><description/><applications/></featureType><featureType><id>51</id><name>graafbericht_request_tags</name><description/><applications/></featureType><featureType><id>52</id><name>graafbericht_soort_werk</name><description/><applications/></featureType><featureType><id>53</id><name>netbeheerder</name><description/><applications/></featureType><featureType><id>54</id><name>netbeheerder_bijlagen</name><description/><applications/></featureType><featureType><id>55</id><name>netbeheerder_huisaansluitschetsen</name><description/><applications/></featureType><featureType><id>56</id><name>netbeheerder_intersect_tag_configs</name><description/><applications/></featureType><featureType><id>57</id><name>netbeheerder_notificaties</name><description/><applications/></featureType><featureType><id>58</id><name>opdrachtgever</name><description/><applications/></featureType><featureType><id>59</id><name>themakaart</name><description/><applications/></featureType><featureType><id>60</id><name>themakaart_bijlagen</name><description/><applications/></featureType><featureType><id>61</id><name>v_map_calamiteiten</name><description/><applications/></featureType><featureType><id>62</id><name>v_map_graafmeldingen</name><description/><applications/></featureType><featureType><id>63</id><name>v_map_orientatieverzoeken</name><description/><applications/></featureType></featureSource><featureSource><id>5</id><name>waterveiligheid</name><protocol>jdbc</protocol><url>{\"port\":\"5432\",\"dbtype\":\"postgis\",\"host\":\"localhost\",\"database\":\"waterveiligheid\"}</url><featureType><id>64</id><name>functie</name><description/><applications/></featureType><featureType><id>65</id><name>gebruiker</name><description/><applications/></featureType><featureType><id>66</id><name>gemeente</name><description/><applications/></featureType><featureType><id>67</id><name>mortaliteit_classificatie</name><description/><applications/></featureType><featureType><id>68</id><name>plan</name><description/><applications/></featureType><featureType><id>69</id><name>plan_object</name><description/><applications/></featureType><featureType><id>70</id><name>rol</name><description/><applications/></featureType><featureType><id>71</id><name>subfunctie</name><description/><applications/></featureType></featureSource><featureSource><id>10</id><name>KSFields</name><protocol>arcgis</protocol><url>http://sampleserver3.arcgisonline.com/ArcGIS/rest/services/Petroleum/KSFields/MapServer</url><featureType><id>195</id><name>0</name><description>Current Kansas Field Production</description><applications/></featureType></featureSource><featureSource><id>12</id><name>carnavalskaart</name><protocol>arcgis</protocol><url>http://atlas.brabant.nl/ArcGIS/rest/services/carnavalskaart/MapServer</url><featureType><id>200</id><name>0</name><description>plaatsen</description><applications><application><id>3</id><name>ol</name><version>2</version><layers><layer><serviceId>18</serviceId><name>0</name><applayers><applayer><id>53</id><alias>plaatsen</alias></applayer></applayers></layer></layers></application><application><id>1</id><name>default</name><version/><layers><layer><serviceId>18</serviceId><name>0</name><applayers><applayer><id>8</id><alias>plaatsen</alias></applayer></applayers></layer></layers></application><application><id>5</id><name>ol</name><version>3</version><layers><layer><serviceId>18</serviceId><name>0</name><applayers><applayer><id>76</id><alias>plaatsen</alias></applayer></applayers></layer></layers></application><application><id>2</id><name>ol</name><version/><layers><layer><serviceId>18</serviceId><name>0</name><applayers><applayer><id>36</id><alias>plaatsen</alias></applayer></applayers></layer></layers></application><application><id>30</id><name>ol22</name><version/><layers><layer><serviceId>18</serviceId><name>0</name><applayers><applayer><id>448</id><alias>plaatsen</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>201</id><name>1</name><description>plaatsen</description><applications><application><id>3</id><name>ol</name><version>2</version><layers><layer><serviceId>18</serviceId><name>1</name><applayers><applayer><id>52</id><alias>plaatsen</alias></applayer></applayers></layer></layers></application><application><id>1</id><name>default</name><version/><layers><layer><serviceId>18</serviceId><name>1</name><applayers><applayer><id>7</id><alias>plaatsen</alias></applayer></applayers></layer></layers></application><application><id>5</id><name>ol</name><version>3</version><layers><layer><serviceId>18</serviceId><name>1</name><applayers><applayer><id>75</id><alias>plaatsen</alias></applayer></applayers></layer></layers></application><application><id>2</id><name>ol</name><version/><layers><layer><serviceId>18</serviceId><name>1</name><applayers><applayer><id>35</id><alias>plaatsen</alias></applayer></applayers></layer></layers></application><application><id>30</id><name>ol22</name><version/><layers><layer><serviceId>18</serviceId><name>1</name><applayers><applayer><id>447</id><alias>plaatsen</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>202</id><name>2</name><description>plaatsen</description><applications><application><id>3</id><name>ol</name><version>2</version><layers><layer><serviceId>18</serviceId><name>2</name><applayers><applayer><id>51</id><alias>plaatsen</alias></applayer></applayers></layer></layers></application><application><id>1</id><name>default</name><version/><layers><layer><serviceId>18</serviceId><name>2</name><applayers><applayer><id>6</id><alias>plaatsen</alias></applayer></applayers></layer></layers></application><application><id>5</id><name>ol</name><version>3</version><layers><layer><serviceId>18</serviceId><name>2</name><applayers><applayer><id>74</id><alias>plaatsen</alias></applayer></applayers></layer></layers></application><application><id>2</id><name>ol</name><version/><layers><layer><serviceId>18</serviceId><name>2</name><applayers><applayer><id>34</id><alias>plaatsen</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>203</id><name>3</name><description>Provincie</description><applications><application><id>3</id><name>ol</name><version>2</version><layers><layer><serviceId>18</serviceId><name>3</name><applayers><applayer><id>50</id><alias>Provincie</alias></applayer></applayers></layer></layers></application><application><id>1</id><name>default</name><version/><layers><layer><serviceId>18</serviceId><name>3</name><applayers><applayer><id>5</id><alias>Provincie</alias></applayer></applayers></layer></layers></application><application><id>27</id><name>brabant-test</name><version>1</version><layers><layer><serviceId>18</serviceId><name>3</name><applayers><applayer><id>414</id><alias>Provincie</alias></applayer></applayers></layer></layers></application><application><id>5</id><name>ol</name><version>3</version><layers><layer><serviceId>18</serviceId><name>3</name><applayers><applayer><id>73</id><alias>Provincie</alias></applayer></applayers></layer></layers></application><application><id>2</id><name>ol</name><version/><layers><layer><serviceId>18</serviceId><name>3</name><applayers><applayer><id>33</id><alias>Provincie</alias></applayer></applayers></layer></layers></application></applications></featureType></featureSource><featureSource><id>13</id><name>Gebiedsgrenzen</name><protocol>arcgis</protocol><url>http://gisopenbaar.toverijs3.nl/ArcGIS/rest/services/GISDATA/Gebiedsgrenzen/MapServer</url><featureType><id>204</id><name>0</name><description>Rayon indeling Provincie Overijssel</description><applications><application><id>3</id><name>ol</name><version>2</version><layers><layer><serviceId>20</serviceId><name>0</name><applayers><applayer><id>54</id><alias>Rayon indeling Provincie Overijssel</alias></applayer></applayers></layer></layers></application><application><id>1</id><name>default</name><version/><layers><layer><serviceId>20</serviceId><name>0</name><applayers><applayer><id>9</id><alias>Rayon indeling Provincie Overijssel</alias></applayer></applayers></layer></layers></application><application><id>5</id><name>ol</name><version>3</version><layers><layer><serviceId>20</serviceId><name>0</name><applayers><applayer><id>77</id><alias>Rayon indeling Provincie Overijssel</alias></applayer></applayers></layer></layers></application><application><id>2</id><name>ol</name><version/><layers><layer><serviceId>20</serviceId><name>0</name><applayers><applayer><id>37</id><alias>Rayon indeling Provincie Overijssel</alias></applayer></applayers></layer></layers></application><application><id>30</id><name>ol22</name><version/><layers><layer><serviceId>20</serviceId><name>0</name><applayers><applayer><id>449</id><alias>Rayon indeling Provincie Overijssel</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>205</id><name>1</name><description>Provinciegrens</description><applications/></featureType><featureType><id>206</id><name>2</name><description>Gemeentegrenzen</description><applications/></featureType><featureType><id>207</id><name>3</name><description>COROP-gebieden</description><applications/></featureType><featureType><id>208</id><name>4</name><description>Waterschappen</description><applications/></featureType><featureType><id>209</id><name>5</name><description>Wijkgrenzen</description><applications/></featureType><featureType><id>210</id><name>6</name><description>Buurtgrenzen</description><applications/></featureType><featureType><id>211</id><name>7</name><description>Regio- indeling RTV- Oost</description><applications/></featureType></featureSource><featureSource><id>15</id><name>atlasoverijssel</name><protocol>arcxml</protocol><url>http://gisopenbaar.toverijs3.nl/GeoJuli2008/ims</url><featureType><id>220</id><name>dummy_layer</name><description>dummy_layer</description><applications/></featureType><featureType><id>221</id><name>regio_tvoost</name><description>B1.regio_tv_oost_polygon</description><applications/></featureType><featureType><id>222</id><name>corop</name><description>COROP gebieden</description><applications/></featureType><featureType><id>223</id><name>watschap_ned_polygon</name><description>B0.watschap_ned_polygon</description><applications/></featureType><featureType><id>224</id><name>geomorfologie</name><description>Geomorfologische kaart</description><applications/></featureType><featureType><id>225</id><name>grwbes_polygon</name><description>Grondwaterbeschermingsgebied</description><applications><application><id>3</id><name>ol</name><version>2</version><layers><layer><serviceId>22</serviceId><name>grwbes_polygon</name><applayers><applayer><id>55</id><alias>Grondwaterbeschermingsgebied</alias></applayer></applayers></layer></layers></application><application><id>1</id><name>default</name><version/><layers><layer><serviceId>22</serviceId><name>grwbes_polygon</name><applayers><applayer><id>16</id><alias>Grondwaterbeschermingsgebied</alias></applayer></applayers></layer></layers></application><application><id>5</id><name>ol</name><version>3</version><layers><layer><serviceId>22</serviceId><name>grwbes_polygon</name><applayers><applayer><id>78</id><alias>Grondwaterbeschermingsgebied</alias></applayer></applayers></layer></layers></application><application><id>2</id><name>ol</name><version/><layers><layer><serviceId>22</serviceId><name>grwbes_polygon</name><applayers><applayer><id>38</id><alias>Grondwaterbeschermingsgebied</alias></applayer></applayers></layer></layers></application><application><id>30</id><name>ol22</name><version/><layers><layer><serviceId>22</serviceId><name>grwbes_polygon</name><applayers><applayer><id>450</id><alias>Grondwaterbeschermingsgebied</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>226</id><name>salland</name><description>Boringsvrije zones</description><applications/></featureType><featureType><id>227</id><name>boringvrij</name><description>Boringsvrije zones</description><applications/></featureType><featureType><id>228</id><name>intrekgebied</name><description>Intrekgebied</description><applications/></featureType><featureType><id>229</id><name>waterwin_polygon</name><description>Waterwingebied</description><applications/></featureType><featureType><id>230</id><name>nat2000</name><description>Natura2000</description><applications/></featureType><featureType><id>231</id><name>habitattypen_id</name><description>B4.habitattypen_polygon</description><applications/></featureType><featureType><id>232</id><name>hemelhelderheid_polygon</name><description>Hemelhelderheid</description><applications/></featureType><featureType><id>233</id><name>sterrenwachten</name><description>sterrenwachten</description><applications><application><id>3</id><name>ol</name><version>2</version><layers><layer><serviceId>22</serviceId><name>sterrenwachten</name><applayers><applayer><id>56</id><alias>sterrenwachten</alias></applayer></applayers></layer></layers></application><application><id>1</id><name>default</name><version/><layers><layer><serviceId>22</serviceId><name>sterrenwachten</name><applayers><applayer><id>19</id><alias>sterrenwachten</alias></applayer></applayers></layer></layers></application><application><id>5</id><name>ol</name><version>3</version><layers><layer><serviceId>22</serviceId><name>sterrenwachten</name><applayers><applayer><id>79</id><alias>sterrenwachten</alias></applayer></applayers></layer></layers></application><application><id>2</id><name>ol</name><version/><layers><layer><serviceId>22</serviceId><name>sterrenwachten</name><applayers><applayer><id>39</id><alias>sterrenwachten</alias></applayer></applayers></layer></layers></application><application><id>28</id><name>m_ol (kopie)</name><version/><layers><layer><serviceId>22</serviceId><name>sterrenwachten</name><applayers><applayer><id>429</id><alias>sterrenwachten arcims</alias></applayer></applayers></layer></layers></application><application><id>11</id><name>m_ol</name><version/><layers><layer><serviceId>22</serviceId><name>sterrenwachten</name><applayers><applayer><id>418</id><alias>sterrenwachten arcims</alias></applayer></applayers></layer></layers></application><application><id>30</id><name>ol22</name><version/><layers><layer><serviceId>22</serviceId><name>sterrenwachten</name><applayers><applayer><id>451</id><alias>sterrenwachten</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>234</id><name>overijssel_geluid_lden_rijksw_2006</name><description>Geluidsbelasting rijkswegen</description><applications/></featureType><featureType><id>235</id><name>overijssel_geluid_lnight_rijksw_2006</name><description>Geluidsbelasting rijkswegen</description><applications/></featureType><featureType><id>236</id><name>overijssel_geluid_lden_provw_2006</name><description>Geluidsbelasting provinciale wegen</description><applications/></featureType><featureType><id>237</id><name>overijssel_geluid_lnight_provw_2006</name><description>Geluidsbelasting provinciale wegen</description><applications/></featureType><featureType><id>238</id><name>recon_zone_polygon</name><description>Reconstructie zonering</description><applications/></featureType><featureType><id>239</id><name>wbe_polygon</name><description>wbe_polygon</description><applications/></featureType><featureType><id>240</id><name>natpark</name><description>natpark</description><applications/></featureType><featureType><id>241</id><name>natlands</name><description>nationale_landschappen</description><applications/></featureType><featureType><id>242</id><name>rayonwk_polygon</name><description>rayonwk</description><applications/></featureType><featureType><id>243</id><name>ehs</name><description>EHS</description><applications/></featureType><featureType><id>244</id><name>rvz</name><description>RVZ</description><applications/></featureType><featureType><id>245</id><name>evz</name><description>EVZ</description><applications/></featureType><featureType><id>246</id><name>wav_polygon</name><description>B4.wav_polygon</description><applications/></featureType><featureType><id>247</id><name>ibis</name><description>ibis</description><applications/></featureType><featureType><id>248</id><name>nb_wet</name><description>B4.nb_wet_polygon</description><applications/></featureType><featureType><id>249</id><name>provwegen</name><description>provwegen</description><applications/></featureType><featureType><id>250</id><name>rijkswegen</name><description>rijkswegen</description><applications/></featureType><featureType><id>251</id><name>vaarwegen</name><description>vaarwegen</description><applications/></featureType><featureType><id>252</id><name>froutenetwerk</name><description>froutenetwerk</description><applications/></featureType><featureType><id>253</id><name>lfroute</name><description>lfroute_arc</description><applications/></featureType><featureType><id>254</id><name>lawroute</name><description>lawroute_arc</description><applications/></featureType><featureType><id>255</id><name>mtbroute</name><description>mtbroute</description><applications/></featureType><featureType><id>256</id><name>raamplan</name><description>raamplan fietspaden</description><applications/></featureType><featureType><id>257</id><name>kanoroute</name><description>kanoroute</description><applications/></featureType><featureType><id>258</id><name>top</name><description>TOP</description><applications/></featureType><featureType><id>259</id><name>law_knelpt</name><description>B5.law_knelpunten_arc</description><applications/></featureType><featureType><id>260</id><name>lf_knelpt</name><description>lf_knelpunten_arc</description><applications/></featureType><featureType><id>261</id><name>rec_camping</name><description>rec_camping</description><applications><application><id>3</id><name>ol</name><version>2</version><layers><layer><serviceId>22</serviceId><name>rec_camping</name><applayers><applayer><id>57</id><alias>rec_camping</alias></applayer></applayers></layer></layers></application><application><id>1</id><name>default</name><version/><layers><layer><serviceId>22</serviceId><name>rec_camping</name><applayers><applayer><id>20</id><alias>rec_camping</alias></applayer></applayers></layer></layers></application><application><id>5</id><name>ol</name><version>3</version><layers><layer><serviceId>22</serviceId><name>rec_camping</name><applayers><applayer><id>80</id><alias>rec_camping</alias></applayer></applayers></layer></layers></application><application><id>2</id><name>ol</name><version/><layers><layer><serviceId>22</serviceId><name>rec_camping</name><applayers><applayer><id>40</id><alias>rec_camping</alias></applayer></applayers></layer></layers></application><application><id>30</id><name>ol22</name><version/><layers><layer><serviceId>22</serviceId><name>rec_camping</name><applayers><applayer><id>452</id><alias>rec_camping</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>262</id><name>rec_bungalowpark</name><description>rec_bungalowpark</description><applications/></featureType><featureType><id>263</id><name>rec_jachthaven</name><description>rec_jachthaven</description><applications/></featureType><featureType><id>264</id><name>rec_groepsaccommodatie</name><description>rec_groepsaccommodatie</description><applications/></featureType><featureType><id>265</id><name>kulturhus_mfa</name><description>Kulturhus en MFA</description><applications/></featureType><featureType><id>266</id><name>strooi_prov</name><description>B2.strooiroutes_provincie</description><applications/></featureType><featureType><id>267</id><name>stortplaats</name><description>stpl</description><applications/></featureType><featureType><id>268</id><name>asbest_loc</name><description>Locaties met informatie omtrent asbest</description><applications><application><id>3</id><name>ol</name><version>2</version><layers><layer><serviceId>22</serviceId><name>asbest_loc</name><applayers><applayer><id>58</id><alias>Locaties met informatie omtrent asbest</alias></applayer></applayers></layer></layers></application><application><id>1</id><name>default</name><version/><layers><layer><serviceId>22</serviceId><name>asbest_loc</name><applayers><applayer><id>24</id><alias>Locaties met informatie omtrent asbest</alias></applayer></applayers></layer></layers></application><application><id>5</id><name>ol</name><version>3</version><layers><layer><serviceId>22</serviceId><name>asbest_loc</name><applayers><applayer><id>81</id><alias>Locaties met informatie omtrent asbest</alias></applayer></applayers></layer></layers></application><application><id>2</id><name>ol</name><version/><layers><layer><serviceId>22</serviceId><name>asbest_loc</name><applayers><applayer><id>41</id><alias>Locaties met informatie omtrent asbest</alias></applayer></applayers></layer></layers></application><application><id>30</id><name>ol22</name><version/><layers><layer><serviceId>22</serviceId><name>asbest_loc</name><applayers><applayer><id>453</id><alias>Locaties met informatie omtrent asbest</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>269</id><name>bouwarchief_niet_gem</name><description>Bouwarchief niet rechtstreekse gemeenten (steekproef)</description><applications/></featureType><featureType><id>270</id><name>bouwarchief_gem</name><description>Bouwarchief rechtstreekse gemeenten (steekproef)</description><applications/></featureType><featureType><id>271</id><name>bodemarchief</name><description>Bodemarchief</description><applications/></featureType><featureType><id>272</id><name>luchtkwaliteit_2008_P</name><description>B4.luchtkwaliteit_2008_point</description><applications/></featureType><featureType><id>273</id><name>luchtkwaliteit_2008_N</name><description>B4.luchtkwaliteit_2008_point</description><applications/></featureType><featureType><id>274</id><name>zwemwater_o</name><description>zwemwater_o</description><applications/></featureType><featureType><id>275</id><name>zwemwater_o_krw</name><description>zwemwater_o_krw</description><applications/></featureType><featureType><id>276</id><name>zwemwater_o_lbl</name><description>zwemwater_o_lbl</description><applications/></featureType><featureType><id>277</id><name>zwemwater_no</name><description>zwemwater_no</description><applications/></featureType><featureType><id>278</id><name>zwemwater_no_krw</name><description>zwemwater_no_krw</description><applications/></featureType><featureType><id>279</id><name>zwemwater_no_lbl</name><description>zwemwater_no_lbl</description><applications/></featureType><featureType><id>280</id><name>zwemwater_kand_o</name><description>zwemwater_kand_o</description><applications/></featureType><featureType><id>281</id><name>zwemwater_kand_o_krw</name><description>zwemwater_kand_o_krw</description><applications/></featureType><featureType><id>282</id><name>zwemwater_kand_o_lbl</name><description>zwemwater_kand_o_lbl</description><applications/></featureType><featureType><id>283</id><name>zwemwater_kand_no</name><description>zwemwater_kand_no</description><applications/></featureType><featureType><id>284</id><name>zwemwater_kand_no_krw</name><description>zwemwater_kand_no_krw</description><applications/></featureType><featureType><id>285</id><name>zwemwater_kand_no_lbl</name><description>zwemwater_kand_no_lbl</description><applications/></featureType><featureType><id>286</id><name>zwemwater_no_q</name><description>zwemwater_no_q</description><applications/></featureType><featureType><id>287</id><name>zwemwater_o_q</name><description>zwemwater_o_q</description><applications/></featureType><featureType><id>288</id><name>station</name><description>station</description><applications/></featureType><featureType><id>289</id><name>kwo2</name><description>kwo</description><applications/></featureType><featureType><id>290</id><name>kwo1</name><description>kwo</description><applications/></featureType><featureType><id>291</id><name>fknooppunt</name><description>fietsroute knooppunt</description><applications/></featureType><featureType><id>292</id><name>N340_1</name><description>N340</description><applications/></featureType><featureType><id>293</id><name>N340_2</name><description>N340</description><applications/></featureType><featureType><id>294</id><name>N340_3</name><description>N340</description><applications/></featureType><featureType><id>295</id><name>N340_4</name><description>N340</description><applications/></featureType><featureType><id>296</id><name>N340_5</name><description>N340</description><applications/></featureType><featureType><id>297</id><name>N340_6</name><description>N340</description><applications/></featureType><featureType><id>298</id><name>N340_7</name><description>N340</description><applications/></featureType><featureType><id>299</id><name>N340_8</name><description>N340</description><applications/></featureType><featureType><id>300</id><name>N340_9</name><description>N340</description><applications/></featureType><featureType><id>301</id><name>N340_10</name><description>N340</description><applications/></featureType><featureType><id>302</id><name>N340_11</name><description>N340</description><applications/></featureType><featureType><id>303</id><name>N340_12</name><description>N340</description><applications/></featureType><featureType><id>304</id><name>N340_13</name><description>N340</description><applications/></featureType><featureType><id>305</id><name>N340_14</name><description>N340</description><applications/></featureType><featureType><id>306</id><name>N340_15</name><description>N340</description><applications/></featureType><featureType><id>307</id><name>N340_16</name><description>N340</description><applications/></featureType><featureType><id>308</id><name>N340_17</name><description>N340</description><applications/></featureType><featureType><id>309</id><name>N340_18</name><description>N340</description><applications/></featureType><featureType><id>310</id><name>N340_19</name><description>N340</description><applications/></featureType><featureType><id>311</id><name>biro2010</name><description>werkgelegenheid_2010</description><applications/></featureType><featureType><id>312</id><name>streetview</name><description>streetview</description><applications/></featureType><featureType><id>313</id><name>streetview_prov</name><description>streetview_prov</description><applications/></featureType><featureType><id>314</id><name>wegen_largescale_g</name><description>wegen_largescale_g</description><applications/></featureType><featureType><id>315</id><name>wegen_largescale_hoofdweg</name><description>wegen_largescale_hoofdweg</description><applications/></featureType><featureType><id>316</id><name>wegen_largescale_snelweg</name><description>wegen_largescale_snelweg</description><applications/></featureType><featureType><id>317</id><name>wegen_smallscale_hoofdweg</name><description>wegen_smallscale_hoofdweg</description><applications/></featureType><featureType><id>318</id><name>autosnelwegen_smallscale</name><description>autosnelwegen_smallscale</description><applications/></featureType><featureType><id>319</id><name>buurten</name><description>B8.buurtindeling_polygon</description><applications/></featureType><featureType><id>320</id><name>buurten_label</name><description>B8.buurtindeling_polygon</description><applications/></featureType><featureType><id>321</id><name>gem_overlay</name><description>gem_overlay</description><applications/></featureType><featureType><id>322</id><name>gem_label</name><description>gem_label</description><applications/></featureType><featureType><id>323</id><name>prov_overlay</name><description>B1.prov_overlay</description><applications/></featureType><featureType><id>324</id><name>weg_labels</name><description>weg_labels</description><applications/></featureType><featureType><id>325</id><name>top50_namen</name><description>top50_namen</description><applications><application><id>3</id><name>ol</name><version>2</version><layers><layer><serviceId>22</serviceId><name>top50_namen</name><applayers><applayer><id>59</id><alias>top50_namen</alias></applayer></applayers></layer></layers></application><application><id>1</id><name>default</name><version/><layers><layer><serviceId>22</serviceId><name>top50_namen</name><applayers><applayer><id>25</id><alias>top50_namen</alias></applayer></applayers></layer></layers></application><application><id>5</id><name>ol</name><version>3</version><layers><layer><serviceId>22</serviceId><name>top50_namen</name><applayers><applayer><id>82</id><alias>top50_namen</alias></applayer></applayers></layer></layers></application><application><id>2</id><name>ol</name><version/><layers><layer><serviceId>22</serviceId><name>top50_namen</name><applayers><applayer><id>42</id><alias>top50_namen</alias></applayer></applayers></layer></layers></application><application><id>30</id><name>ol22</name><version/><layers><layer><serviceId>22</serviceId><name>top50_namen</name><applayers><applayer><id>454</id><alias>top50_namen</alias></applayer></applayers></layer></layers></application></applications></featureType></featureSource><featureSource><id>14</id><name>ondergrond_lf</name><protocol>arcxml</protocol><url>http://gisopenbaar.toverijs3.nl/GeoJuli2008/ims</url><featureType><id>212</id><name>1</name><description>weg_labels</description><applications/></featureType><featureType><id>213</id><name>2</name><description>wegen_largescale_g</description><applications/></featureType><featureType><id>214</id><name>3</name><description>wegen_smallscale_hoofdweg</description><applications/></featureType><featureType><id>215</id><name>4</name><description>wegen_largescale_hoofdweg</description><applications/></featureType><featureType><id>216</id><name>5</name><description>wegen_largescale_snelweg</description><applications/></featureType><featureType><id>217</id><name>6</name><description>autosnelwegen_smallscale</description><applications/></featureType><featureType><id>218</id><name>7</name><description>TOP50_NAMEN</description><applications/></featureType><featureType><id>219</id><name>8</name><description>provned_polygon</description><applications/></featureType></featureSource><featureSource><id>16</id><name>Ondergrond_kleur</name><protocol>arcgis</protocol><url>http://geowebtest.gelderland.nl/ArcGIS/rest/services/Algemeen/Ondergrond_kleur/MapServer</url><featureType><id>326</id><name>2</name><description>Provinciegrens Gelderland</description><applications/></featureType><featureType><id>327</id><name>3</name><description>Afdeklaag buiten Gelderland</description><applications/></featureType><featureType><id>328</id><name>4</name><description>Gemeenten</description><applications/></featureType><featureType><id>329</id><name>5</name><description>Gemeentegrenzen_Gelderland</description><applications/></featureType><featureType><id>330</id><name>7</name><description>Infrastructuur</description><applications/></featureType><featureType><id>331</id><name>8</name><description>Straatnamen</description><applications/></featureType><featureType><id>332</id><name>9</name><description>Huizen</description><applications/></featureType><featureType><id>333</id><name>10</name><description>Bodemgebruik_1</description><applications/></featureType><featureType><id>334</id><name>12</name><description>Infrastructuur_1</description><applications/></featureType><featureType><id>335</id><name>13</name><description>Infrastructuur_2</description><applications/></featureType><featureType><id>336</id><name>14</name><description>Infrastructuur_3</description><applications/></featureType><featureType><id>337</id><name>15</name><description>Bodemgebruik</description><applications/></featureType><featureType><id>338</id><name>17</name><description>Infrastructuur</description><applications/></featureType><featureType><id>339</id><name>18</name><description>Vlakken</description><applications/></featureType><featureType><id>340</id><name>19</name><description>Plaatsnamen</description><applications/></featureType><featureType><id>341</id><name>20</name><description>Bebouwde kommen</description><applications/></featureType></featureSource><featureSource><id>17</id><name>Milieu</name><protocol>arcgis</protocol><url>http://geowebtest.gelderland.nl/ArcGIS/rest/services/Standaard/Milieu/MapServer</url><featureType><id>342</id><name>1</name><description>Verdachte activiteiten</description><applications/></featureType><featureType><id>343</id><name>3</name><description>Locaties bodemonderzoek punten</description><applications/></featureType><featureType><id>344</id><name>5</name><description>Saneringslocaties gasfabrieken</description><applications><application><id>6</id><name>m</name><version/><layers><layer><serviceId>24</serviceId><name>5</name><applayers><applayer><id>85</id><alias>Saneringslocaties gasfabrieken</alias></applayer></applayers></layer></layers></application><application><id>17</id><name>gelderland_gasfabrieken_ol</name><version>1</version><layers><layer><serviceId>24</serviceId><name>5</name><applayers><applayer><id>269</id><alias>Saneringslocaties gasfabrieken</alias></applayer></applayers></layer></layers></application><application><id>13</id><name>m_update</name><version>1</version><layers><layer><serviceId>24</serviceId><name>5</name><applayers><applayer><id>211</id><alias>Saneringslocaties gasfabrieken</alias></applayer></applayers></layer></layers></application><application><id>15</id><name>gelderland_gasfabrieken</name><version>1</version><layers><layer><serviceId>24</serviceId><name>5</name><applayers><applayer><id>229</id><alias>Saneringslocaties gasfabrieken</alias></applayer></applayers></layer></layers></application><application><id>19</id><name>m</name><version>1</version><layers><layer><serviceId>24</serviceId><name>5</name><applayers><applayer><id>304</id><alias>Saneringslocaties gasfabrieken</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>345</id><name>7</name><description>Woningen 63 dB of hoger</description><applications/></featureType><featureType><id>346</id><name>9</name><description>Immissie fijn stof</description><applications/></featureType><featureType><id>347</id><name>10</name><description>Immissie stikstofdioxide</description><applications><application><id>6</id><name>m</name><version/><layers><layer><serviceId>24</serviceId><name>10</name><applayers><applayer><id>95</id><alias>Immissie stikstofdioxide</alias></applayer></applayers></layer></layers></application><application><id>28</id><name>m_ol (kopie)</name><version/><layers><layer><serviceId>24</serviceId><name>10</name><applayers><applayer><id>426</id><alias>Immissie stikstofdioxide</alias></applayer></applayers></layer></layers></application><application><id>11</id><name>m_ol</name><version/><layers><layer><serviceId>24</serviceId><name>10</name><applayers><applayer><id>182</id><alias>Immissie stikstofdioxide</alias></applayer></applayers></layer></layers></application><application><id>13</id><name>m_update</name><version>1</version><layers><layer><serviceId>24</serviceId><name>10</name><applayers><applayer><id>214</id><alias>Immissie stikstofdioxide</alias></applayer></applayers></layer></layers></application><application><id>19</id><name>m</name><version>1</version><layers><layer><serviceId>24</serviceId><name>10</name><applayers><applayer><id>307</id><alias>Immissie stikstofdioxide</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>348</id><name>11</name><description>Meetlocaties projecten luchtkwaliteit</description><applications/></featureType><featureType><id>349</id><name>12</name><description>Meetlocaties landelijk meetnet luchtkwaliteit</description><applications/></featureType><featureType><id>350</id><name>13</name><description>Projecten luchtkwaliteit RSL</description><applications/></featureType><featureType><id>351</id><name>15</name><description>Luchtvaartterrein</description><applications/></featureType><featureType><id>352</id><name>17</name><description>Milieuklachten</description><applications/></featureType><featureType><id>353</id><name>19</name><description>Baggerdepots</description><applications/></featureType><featureType><id>354</id><name>20</name><description>Inpassing voormalige stortplaatsen</description><applications/></featureType><featureType><id>355</id><name>21</name><description>Stortplaatsen (wet Milieubeheer)</description><applications/></featureType><featureType><id>356</id><name>23</name><description>Provinciale inrichtingen</description><applications/></featureType><featureType><id>357</id><name>25</name><description>Water wegen leiding</description><applications/></featureType><featureType><id>358</id><name>27</name><description>Geluidsschermen en -wallen</description><applications/></featureType><featureType><id>359</id><name>28</name><description>Stil asfalt provinciale weg</description><applications/></featureType><featureType><id>360</id><name>30</name><description>Asbestkansen</description><applications/></featureType><featureType><id>361</id><name>32</name><description>Grondwaterverontreinigingen</description><applications/></featureType><featureType><id>362</id><name>33</name><description>Waterbodemverontreinigingen</description><applications/></featureType><featureType><id>363</id><name>34</name><description>Vastebodemverontreinigingen</description><applications/></featureType><featureType><id>364</id><name>35</name><description>Bodemsaneringen</description><applications><application><id>6</id><name>m</name><version/><layers><layer><serviceId>24</serviceId><name>35</name><applayers><applayer><id>87</id><alias>Bodemsaneringen</alias></applayer></applayers></layer></layers></application><application><id>28</id><name>m_ol (kopie)</name><version/><layers><layer><serviceId>24</serviceId><name>35</name><applayers><applayer><id>425</id><alias>Bodemsaneringen</alias></applayer></applayers></layer></layers></application><application><id>11</id><name>m_ol</name><version/><layers><layer><serviceId>24</serviceId><name>35</name><applayers><applayer><id>181</id><alias>Bodemsaneringen</alias></applayer></applayers></layer></layers></application><application><id>13</id><name>m_update</name><version>1</version><layers><layer><serviceId>24</serviceId><name>35</name><applayers><applayer><id>213</id><alias>Bodemsaneringen</alias></applayer></applayers></layer></layers></application><application><id>19</id><name>m</name><version>1</version><layers><layer><serviceId>24</serviceId><name>35</name><applayers><applayer><id>306</id><alias>Bodemsaneringen</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>365</id><name>36</name><description>Locaties bodemonderzoek vlakken</description><applications/></featureType><featureType><id>366</id><name>37</name><description>Historisch bodembestand gebieden</description><applications/></featureType><featureType><id>367</id><name>38</name><description>Arnhem en Nijmegen beheren zelf alle bodeminformatie</description><applications/></featureType><featureType><id>368</id><name>40</name><description>Saneringsterreinen gasfabrieken</description><applications><application><id>6</id><name>m</name><version/><layers><layer><serviceId>24</serviceId><name>40</name><applayers><applayer><id>86</id><alias>Saneringsterreinen gasfabrieken</alias></applayer></applayers></layer></layers></application><application><id>17</id><name>gelderland_gasfabrieken_ol</name><version>1</version><layers><layer><serviceId>24</serviceId><name>40</name><applayers><applayer><id>270</id><alias>Saneringsterreinen gasfabrieken</alias></applayer></applayers></layer></layers></application><application><id>13</id><name>m_update</name><version>1</version><layers><layer><serviceId>24</serviceId><name>40</name><applayers><applayer><id>212</id><alias>Saneringsterreinen gasfabrieken</alias></applayer></applayers></layer></layers></application><application><id>15</id><name>gelderland_gasfabrieken</name><version>1</version><layers><layer><serviceId>24</serviceId><name>40</name><applayers><applayer><id>230</id><alias>Saneringsterreinen gasfabrieken</alias></applayer></applayers></layer></layers></application><application><id>19</id><name>m</name><version>1</version><layers><layer><serviceId>24</serviceId><name>40</name><applayers><applayer><id>305</id><alias>Saneringsterreinen gasfabrieken</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>369</id><name>42</name><description>Geluidszone rijks en provinciaal wegverkeer</description><applications/></featureType><featureType><id>370</id><name>43</name><description>Geluidzones spoorlijn</description><applications/></featureType><featureType><id>371</id><name>44</name><description>Geluidszone vliegveld</description><applications/></featureType><featureType><id>372</id><name>46</name><description>Geluidbelasting provinciale wegen</description><applications/></featureType><featureType><id>373</id><name>47</name><description>Geluidbelasting provinciale wegen nacht</description><applications/></featureType><featureType><id>374</id><name>49</name><description>Contour vergunde geurimmissie</description><applications/></featureType><featureType><id>375</id><name>51</name><description>Bijdrage industrie fijn stof</description><applications/></featureType><featureType><id>376</id><name>52</name><description>Bijdrage industrie stikstofdioxide</description><applications/></featureType><featureType><id>377</id><name>54</name><description>Laagvlieggebied en laagvliegroute</description><applications/></featureType><featureType><id>378</id><name>56</name><description>Stiltegebied</description><applications/></featureType><featureType><id>379</id><name>57</name><description>Stiltebeleidsgebied</description><applications/></featureType><featureType><id>380</id><name>59</name><description>Voormalige stortplaatsen (NAVOS)</description><applications/></featureType><featureType><id>381</id><name>61</name><description>Terreingrens provinciale inrichtingen</description><applications/></featureType></featureSource><featureSource><id>19</id><name>Gemeentes (CBS 2010) (1)</name><protocol>wfs</protocol><url>http://mapserver.openwion.nl/cgi-bin/mapserv?map=/srv/b3p-wion/maps/gemeentes_cbs_2010.map</url><featureType><id>383</id><name>gemeentes</name><description/><applications/></featureType></featureSource><featureSource><id>33</id><name>Flamingo Gis x13</name><protocol>jdbc</protocol><url>{\"port\":\"5432\",\"dbtype\":\"postgis\",\"host\":\"x13.b3p.nl\",\"database\":\"flamingo-gis\"}</url><featureType><id>532</id><name>buurten_2011</name><description/><applications><application><id>4</id><name>gelderland</name><version>1</version><layers><layer><serviceId>53</serviceId><name>Flamingo:buurten</name><applayers><applayer><id>195</id><alias>Buurten 2011</alias></applayer></applayers></layer></layers></application><application><id>12</id><name>gelderland_ol</name><version>1</version><layers><layer><serviceId>53</serviceId><name>Flamingo:buurten</name><applayers><applayer><id>206</id><alias>Buurten 2011</alias></applayer></applayers></layer></layers></application><application><id>14</id><name>boy</name><version>1</version><layers><layer><serviceId>53</serviceId><name>Flamingo:buurten</name><applayers><applayer><id>433</id><alias>Buurten 2011</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>533</id><name>gemeentes_2011</name><description/><applications><application><id>4</id><name>gelderland</name><version>1</version><layers><layer><serviceId>53</serviceId><name>Flamingo:gemeentes</name><applayers><applayer><id>196</id><alias>Gemeenten 2011</alias></applayer></applayers></layer></layers></application><application><id>31</id><name>roy</name><version>1</version><layers><layer><serviceId>53</serviceId><name>Flamingo:gemeentes</name><applayers><applayer><id>465</id><alias>Gemeenten 2011</alias></applayer></applayers></layer></layers></application><application><id>12</id><name>gelderland_ol</name><version>1</version><layers><layer><serviceId>53</serviceId><name>Flamingo:gemeentes</name><applayers><applayer><id>208</id><alias>Gemeenten 2011</alias></applayer></applayers></layer></layers></application><application><id>14</id><name>boy</name><version>1</version><layers><layer><serviceId>53</serviceId><name>Flamingo:gemeentes</name><applayers><applayer><id>434</id><alias>Gemeenten 2011</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>534</id><name>wijken_2011</name><description/><applications><application><id>4</id><name>gelderland</name><version>1</version><layers><layer><serviceId>53</serviceId><name>Flamingo:wijken</name><applayers><applayer><id>197</id><alias>Wijken 2011</alias></applayer></applayers></layer></layers></application><application><id>12</id><name>gelderland_ol</name><version>1</version><layers><layer><serviceId>53</serviceId><name>Flamingo:wijken</name><applayers><applayer><id>207</id><alias>Wijken 2011</alias></applayer></applayers></layer></layers></application><application><id>14</id><name>boy</name><version>1</version><layers><layer><serviceId>53</serviceId><name>Flamingo:wijken</name><applayers><applayer><id>435</id><alias>Wijken 2011</alias></applayer></applayers></layer></layers></application></applications></featureType></featureSource><featureSource><id>34</id><name>test</name><protocol>jdbc</protocol><url>{\"port\":\"5432\",\"dbtype\":\"postgis\",\"host\":\"localhost\",\"database\":\"flamingo-gis\"}</url><featureType><id>535</id><name>buurten_2011</name><description/><applications/></featureType><featureType><id>536</id><name>gemeentes_2011</name><description/><applications/></featureType><featureType><id>537</id><name>wijken_2011</name><description/><applications/></featureType></featureSource><featureSource><id>23</id><name>Bewerkbare gemeentegrenzen</name><protocol>wfs</protocol><url>http://flamingo4.b3p.nl/cgi-bin/mapserv?map=/srv/maps/flamingo/gemeentes_edit.map&amp;</url><featureType><id>387</id><name>gemeentes</name><description/><applications/></featureType></featureSource><featureSource><id>24</id><name>Bewerkbare gemeentegrenzen JDBC</name><protocol>jdbc</protocol><url>{\"port\":\"5432\",\"dbtype\":\"postgis\",\"host\":\"x13.b3p.nl\",\"database\":\"flamingo-gis\"}</url><featureType><id>388</id><name>buurten_2011</name><description/><applications/></featureType><featureType><id>389</id><name>gemeentes_2011</name><description/><applications><application><id>8</id><name>edit</name><version/><layers><layer><serviceId>44</serviceId><name>gemeentes</name><applayers><applayer><id>97</id><alias>Andere titel</alias></applayer></applayers></layer></layers></application><application><id>28</id><name>m_ol (kopie)</name><version/><layers><layer><serviceId>44</serviceId><name>gemeentes</name><applayers><applayer><id>431</id><alias>gemeentes met jdbc</alias></applayer></applayers></layer></layers></application><application><id>11</id><name>m_ol</name><version/><layers><layer><serviceId>44</serviceId><name>gemeentes</name><applayers><applayer><id>420</id><alias>gemeentes met jdbc</alias></applayer></applayers></layer></layers></application><application><id>23</id><name>edit_ol</name><version/><layers><layer><serviceId>44</serviceId><name>gemeentes</name><applayers><applayer><id>346</id><alias>Andere titel</alias></applayer></applayers></layer></layers></application><application><id>21</id><name>test_fl</name><version>4.2</version><layers><layer><serviceId>44</serviceId><name>gemeentes</name><applayers><applayer><id>329</id><alias>Andere titel</alias></applayer></applayers></layer></layers></application><application><id>22</id><name>3xfeiten</name><version>1</version><layers><layer><serviceId>44</serviceId><name>gemeentes</name><applayers><applayer><id>340</id><alias>Andere titel</alias></applayer></applayers></layer></layers></application><application><id>20</id><name>test_ol</name><version>4.2</version><layers><layer><serviceId>44</serviceId><name>gemeentes</name><applayers><applayer><id>327</id><alias>Andere titel</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>390</id><name>wijken_2011</name><description/><applications/></featureType></featureSource><featureSource><id>25</id><name>gemeente update test</name><protocol>wfs</protocol><url>http://flamingo4.b3p.nl/cgi-bin/mapserv?map=/srv/maps/flamingo/gemeentes1.map&amp;</url><featureType><id>391</id><name>gemeentes</name><description/><applications/></featureType></featureSource><featureSource><id>26</id><name>gemeente update test (1)</name><protocol>wfs</protocol><url>http://flamingo4.b3p.nl/cgi-bin/mapserv?map=/srv/maps/flamingo/gemeentes1.map&amp;</url><featureType><id>392</id><name>gemeentes</name><description/><applications><application><id>8</id><name>edit</name><version/><layers><layer><serviceId>46</serviceId><name>gemeentes</name><applayers><applayer><id>99</id><alias>Gemeentegrenzen</alias></applayer></applayers></layer></layers></application><application><id>23</id><name>edit_ol</name><version/><layers><layer><serviceId>46</serviceId><name>gemeentes</name><applayers><applayer><id>347</id><alias>Gemeentegrenzen</alias></applayer></applayers></layer></layers></application></applications></featureType></featureSource><featureSource><id>27</id><name>gemeente update test (2)</name><protocol>wfs</protocol><url>http://flamingo4.b3p.nl/cgi-bin/mapserv?map=/srv/maps/flamingo/gemeentes1.map&amp;</url><featureType><id>393</id><name>gemeentes</name><description/><applications/></featureType></featureSource><featureSource><id>28</id><name>Ondergrond_kleur (1)</name><protocol>arcgis</protocol><url>http://geowebtest.gelderland.nl/ArcGIS/rest/services/Algemeen/Ondergrond_kleur/MapServer</url><featureType><id>409</id><name>2</name><description>Provinciegrens Gelderland</description><applications/></featureType><featureType><id>394</id><name>3</name><description>Afdeklaag buiten Gelderland</description><applications/></featureType><featureType><id>395</id><name>4</name><description>Gemeenten</description><applications/></featureType><featureType><id>396</id><name>5</name><description>Gemeentegrenzen_Gelderland</description><applications/></featureType><featureType><id>397</id><name>7</name><description>Infrastructuur</description><applications/></featureType><featureType><id>398</id><name>8</name><description>Straatnamen</description><applications/></featureType><featureType><id>399</id><name>9</name><description>Huizen</description><applications/></featureType><featureType><id>400</id><name>10</name><description>Bodemgebruik_1</description><applications/></featureType><featureType><id>401</id><name>12</name><description>Infrastructuur_1</description><applications/></featureType><featureType><id>402</id><name>13</name><description>Infrastructuur_2</description><applications/></featureType><featureType><id>403</id><name>14</name><description>Infrastructuur_3</description><applications/></featureType><featureType><id>404</id><name>15</name><description>Bodemgebruik</description><applications/></featureType><featureType><id>405</id><name>17</name><description>Infrastructuur</description><applications/></featureType><featureType><id>406</id><name>18</name><description>Vlakken</description><applications/></featureType><featureType><id>407</id><name>19</name><description>Plaatsnamen</description><applications/></featureType><featureType><id>408</id><name>20</name><description>Bebouwde kommen</description><applications/></featureType></featureSource><featureSource><id>29</id><name>Ondergrond_Luchtfoto</name><protocol>arcgis</protocol><url>http://geowebtest.gelderland.nl/ArcGIS/rest/services/Algemeen/Ondergrond_Luchtfoto/MapServer</url><featureType><id>412</id><name>0</name><description>Provinciegrens</description><applications/></featureType></featureSource><featureSource><id>30</id><name>Ondergrond_kleur (2)</name><protocol>arcgis</protocol><url>http://geowebtest.gelderland.nl/ArcGIS/rest/services/Algemeen/Ondergrond_kleur/MapServer</url><featureType><id>428</id><name>2</name><description>Provinciegrens Gelderland</description><applications/></featureType><featureType><id>413</id><name>3</name><description>Afdeklaag buiten Gelderland</description><applications/></featureType><featureType><id>414</id><name>4</name><description>Gemeenten</description><applications/></featureType><featureType><id>415</id><name>5</name><description>Gemeentegrenzen_Gelderland</description><applications/></featureType><featureType><id>416</id><name>7</name><description>Infrastructuur</description><applications/></featureType><featureType><id>417</id><name>8</name><description>Straatnamen</description><applications/></featureType><featureType><id>418</id><name>9</name><description>Huizen</description><applications/></featureType><featureType><id>419</id><name>10</name><description>Bodemgebruik_1</description><applications/></featureType><featureType><id>420</id><name>12</name><description>Infrastructuur_1</description><applications/></featureType><featureType><id>421</id><name>13</name><description>Infrastructuur_2</description><applications/></featureType><featureType><id>422</id><name>14</name><description>Infrastructuur_3</description><applications/></featureType><featureType><id>423</id><name>15</name><description>Bodemgebruik</description><applications/></featureType><featureType><id>424</id><name>17</name><description>Infrastructuur</description><applications/></featureType><featureType><id>425</id><name>18</name><description>Vlakken</description><applications/></featureType><featureType><id>426</id><name>19</name><description>Plaatsnamen</description><applications/></featureType><featureType><id>427</id><name>20</name><description>Bebouwde kommen</description><applications/></featureType></featureSource><featureSource><id>31</id><name>Ondergrond_grijs</name><protocol>arcgis</protocol><url>http://geowebtest.gelderland.nl/ArcGIS/rest/services/Algemeen/Ondergrond_grijs/MapServer</url><featureType><id>444</id><name>2</name><description>Provinciegrens Gelderland</description><applications/></featureType><featureType><id>429</id><name>3</name><description>Afdeklaag buiten Gelderland</description><applications/></featureType><featureType><id>430</id><name>4</name><description>Gemeenten</description><applications/></featureType><featureType><id>431</id><name>5</name><description>Gemeentegrenzen_Gelderland</description><applications/></featureType><featureType><id>432</id><name>7</name><description>Infrastructuur</description><applications/></featureType><featureType><id>433</id><name>8</name><description>Straatnamen</description><applications/></featureType><featureType><id>434</id><name>9</name><description>Huizen</description><applications/></featureType><featureType><id>435</id><name>10</name><description>Bodemgebruik_1</description><applications/></featureType><featureType><id>436</id><name>12</name><description>Infrastructuur_1</description><applications/></featureType><featureType><id>437</id><name>13</name><description>Infrastructuur_2</description><applications/></featureType><featureType><id>438</id><name>14</name><description>Infrastructuur_3</description><applications/></featureType><featureType><id>439</id><name>15</name><description>Bodemgebruik</description><applications/></featureType><featureType><id>440</id><name>17</name><description>Infrastructuur</description><applications/></featureType><featureType><id>441</id><name>18</name><description>Vlakken</description><applications/></featureType><featureType><id>442</id><name>19</name><description>Plaatsnamen</description><applications/></featureType><featureType><id>443</id><name>20</name><description>Bebouwde kommen</description><applications/></featureType></featureSource><featureSource><id>32</id><name>Natuur</name><protocol>arcgis</protocol><url>http://geowebtest.gelderland.nl/ArcGIS/rest/services/Standaard/Natuur/MapServer</url><featureType><id>531</id><name>1</name><description>Dassen slachtoffers</description><applications/></featureType><featureType><id>445</id><name>2</name><description>Faunapassages</description><applications/></featureType><featureType><id>446</id><name>3</name><description>Geelsterren</description><applications/></featureType><featureType><id>447</id><name>4</name><description>Vegetatie-opnamen</description><applications/></featureType><featureType><id>448</id><name>6</name><description>Leefgebieden (punten)</description><applications/></featureType><featureType><id>449</id><name>8</name><description>Doelstelling wateren ven wiel kolk en bron</description><applications/></featureType><featureType><id>450</id><name>9</name><description>Ecologische doelstelling wateren HEN (vennen bronnen wielen kolken)</description><applications/></featureType><featureType><id>451</id><name>11</name><description>Leefgebieden (lijnen)</description><applications/></featureType><featureType><id>452</id><name>13</name><description>Ecologische_poorten</description><applications/></featureType><featureType><id>453</id><name>15</name><description>Sprengen en beken stand van zaken</description><applications/></featureType><featureType><id>454</id><name>17</name><description>Doeltype waardevolle wateren</description><applications/></featureType><featureType><id>455</id><name>18</name><description>Doelstelling wateren HEN-SED</description><applications/></featureType><featureType><id>456</id><name>20</name><description>Natte ecologische verbindingszones</description><applications/></featureType><featureType><id>457</id><name>22</name><description>Ecologische verbindingszones (Kernkwaliteit)</description><applications/></featureType><featureType><id>458</id><name>23</name><description>Ecologische Hoofdstructuur</description><applications/></featureType><featureType><id>459</id><name>25</name><description>Ganzen slaapgebieden</description><applications/></featureType><featureType><id>460</id><name>26</name><description>Ganzen winterpopulatie</description><applications/></featureType><featureType><id>461</id><name>27</name><description>Weidevogeltrend</description><applications/></featureType><featureType><id>462</id><name>28</name><description>Grutto</description><applications/></featureType><featureType><id>463</id><name>29</name><description>Waardering weidevogelgebieden</description><applications/></featureType><featureType><id>464</id><name>30</name><description>Beschermingszone natte landnatuur </description><applications/></featureType><featureType><id>465</id><name>31</name><description>Natte landnatuur</description><applications/></featureType><featureType><id>466</id><name>33</name><description>Beschermde natuurmonumenten</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>33</name><applayers><applayer><id>236</id><alias>Beschermde natuurmonumenten</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>33</name><applayers><applayer><id>275</id><alias>Beschermde natuurmonumenten</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>467</id><name>34</name><description>Aalscholver 1990 - 1999</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>34</name><applayers><applayer><id>237</id><alias>Aalscholver 1990 - 1999</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>34</name><applayers><applayer><id>276</id><alias>Aalscholver 1990 - 1999</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>468</id><name>35</name><description>Aalscholver 2000 - 2007</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>35</name><applayers><applayer><id>246</id><alias>Aalscholver 2000 - 2007</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>35</name><applayers><applayer><id>285</id><alias>Aalscholver 2000 - 2007</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>469</id><name>36</name><description>Blauwborst 1990 - 1999</description><applications/></featureType><featureType><id>470</id><name>37</name><description>Blauwborst 2000-2007</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>37</name><applayers><applayer><id>247</id><alias>Blauwborst 2000-2007</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>37</name><applayers><applayer><id>286</id><alias>Blauwborst 2000-2007</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>471</id><name>38</name><description>Dodaars 1990 - 1999</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>38</name><applayers><applayer><id>238</id><alias>Dodaars 1990 - 1999</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>38</name><applayers><applayer><id>277</id><alias>Dodaars 1990 - 1999</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>472</id><name>39</name><description>Dodaars 2000 - 2007</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>39</name><applayers><applayer><id>248</id><alias>Dodaars 2000 - 2007</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>39</name><applayers><applayer><id>287</id><alias>Dodaars 2000 - 2007</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>473</id><name>40</name><description>Grote Karekiet 1990 - 1999</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>40</name><applayers><applayer><id>239</id><alias>Grote Karekiet 1990 - 1999</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>40</name><applayers><applayer><id>278</id><alias>Grote Karekiet 1990 - 1999</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>474</id><name>41</name><description>Grote Karekiet 2000-2007</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>41</name><applayers><applayer><id>249</id><alias>Grote Karekiet 2000-2007</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>41</name><applayers><applayer><id>288</id><alias>Grote Karekiet 2000-2007</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>475</id><name>42</name><description>IJsvogel 1990 - 1999</description><applications/></featureType><featureType><id>476</id><name>43</name><description>IJsvogel 2000 - 2007</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>43</name><applayers><applayer><id>250</id><alias>IJsvogel 2000 - 2007</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>43</name><applayers><applayer><id>289</id><alias>IJsvogel 2000 - 2007</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>477</id><name>44</name><description>Kwartelkoning 1990 - 1999</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>44</name><applayers><applayer><id>240</id><alias>Kwartelkoning 1990 - 1999</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>44</name><applayers><applayer><id>279</id><alias>Kwartelkoning 1990 - 1999</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>478</id><name>45</name><description>Kwartelkoning 2000-2007</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>45</name><applayers><applayer><id>251</id><alias>Kwartelkoning 2000-2007</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>45</name><applayers><applayer><id>290</id><alias>Kwartelkoning 2000-2007</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>479</id><name>46</name><description>Oeverzwaluw 1990 - 1999</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>46</name><applayers><applayer><id>241</id><alias>Oeverzwaluw 1990 - 1999</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>46</name><applayers><applayer><id>280</id><alias>Oeverzwaluw 1990 - 1999</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>480</id><name>47</name><description>Oeverzwaluw 2000 - 2007</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>47</name><applayers><applayer><id>252</id><alias>Oeverzwaluw 2000 - 2007</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>47</name><applayers><applayer><id>291</id><alias>Oeverzwaluw 2000 - 2007</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>481</id><name>48</name><description>Porseleinhoen 1990 - 1999</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>48</name><applayers><applayer><id>242</id><alias>Porseleinhoen 1990 - 1999</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>48</name><applayers><applayer><id>281</id><alias>Porseleinhoen 1990 - 1999</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>482</id><name>49</name><description>Porseleinhoen 2000-2007</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>49</name><applayers><applayer><id>253</id><alias>Porseleinhoen 2000-2007</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>49</name><applayers><applayer><id>292</id><alias>Porseleinhoen 2000-2007</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>483</id><name>50</name><description>Roerdomp 1990 - 1999</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>50</name><applayers><applayer><id>243</id><alias>Roerdomp 1990 - 1999</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>50</name><applayers><applayer><id>282</id><alias>Roerdomp 1990 - 1999</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>484</id><name>51</name><description>Roerdomp 2000-2007</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>51</name><applayers><applayer><id>254</id><alias>Roerdomp 2000-2007</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>51</name><applayers><applayer><id>293</id><alias>Roerdomp 2000-2007</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>485</id><name>52</name><description>Woudaap 1990 - 1999</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>52</name><applayers><applayer><id>244</id><alias>Woudaap 1990 - 1999</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>52</name><applayers><applayer><id>283</id><alias>Woudaap 1990 - 1999</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>486</id><name>53</name><description>Woudaap  2000 - 2007</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>53</name><applayers><applayer><id>255</id><alias>Woudaap  2000 - 2007</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>53</name><applayers><applayer><id>294</id><alias>Woudaap  2000 - 2007</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>487</id><name>54</name><description>Zwarte Stern 1990 - 1999</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>54</name><applayers><applayer><id>245</id><alias>Zwarte Stern 1990 - 1999</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>54</name><applayers><applayer><id>284</id><alias>Zwarte Stern 1990 - 1999</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>488</id><name>55</name><description>Zwarte Stern 2000-2007</description><applications/></featureType><featureType><id>489</id><name>56</name><description>Habitattypen intern</description><applications/></featureType><featureType><id>490</id><name>57</name><description>Habitattypen extern</description><applications/></featureType><featureType><id>491</id><name>58</name><description>Boomleeuwerik</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>58</name><applayers><applayer><id>256</id><alias>Boomleeuwerik</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>58</name><applayers><applayer><id>295</id><alias>Boomleeuwerik</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>492</id><name>59</name><description>Grauwe Klauwier</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>59</name><applayers><applayer><id>257</id><alias>Grauwe Klauwier</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>59</name><applayers><applayer><id>296</id><alias>Grauwe Klauwier</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>493</id><name>60</name><description>IJsvogel</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>60</name><applayers><applayer><id>258</id><alias>IJsvogel</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>60</name><applayers><applayer><id>297</id><alias>IJsvogel</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>494</id><name>61</name><description>Nachtzwaluw</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>61</name><applayers><applayer><id>259</id><alias>Nachtzwaluw</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>61</name><applayers><applayer><id>298</id><alias>Nachtzwaluw</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>495</id><name>62</name><description>Roodborsttapuit</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>62</name><applayers><applayer><id>260</id><alias>Roodborsttapuit</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>62</name><applayers><applayer><id>299</id><alias>Roodborsttapuit</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>496</id><name>63</name><description>Tapuit</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>63</name><applayers><applayer><id>261</id><alias>Tapuit</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>63</name><applayers><applayer><id>300</id><alias>Tapuit</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>497</id><name>64</name><description>Wespendief</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>64</name><applayers><applayer><id>262</id><alias>Wespendief</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>64</name><applayers><applayer><id>301</id><alias>Wespendief</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>498</id><name>65</name><description>Zwarte Specht</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>65</name><applayers><applayer><id>263</id><alias>Zwarte Specht</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>65</name><applayers><applayer><id>302</id><alias>Zwarte Specht</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>499</id><name>66</name><description>Natura 2000- Vegetatietypen</description><applications/></featureType><featureType><id>500</id><name>67</name><description>Natura 2000 gebieden</description><applications><application><id>16</id><name>gelderland_natura_2000</name><version>1</version><layers><layer><serviceId>52</serviceId><name>67</name><applayers><applayer><id>235</id><alias>Natura 2000 gebieden</alias></applayer></applayers></layer></layers></application><application><id>18</id><name>gelderland_natura_2000_ol</name><version>1</version><layers><layer><serviceId>52</serviceId><name>67</name><applayers><applayer><id>274</id><alias>Natura 2000 gebieden</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>501</id><name>69</name><description>Subsidiekaart 2012</description><applications/></featureType><featureType><id>502</id><name>70</name><description>Beheergebied 2012</description><applications/></featureType><featureType><id>503</id><name>71</name><description>Beheergebied 2011</description><applications/></featureType><featureType><id>504</id><name>72</name><description>Beheergebied Ambitie 2012</description><applications/></featureType><featureType><id>505</id><name>73</name><description>Beheergebied Ambitie 2011</description><applications/></featureType><featureType><id>506</id><name>74</name><description>Bijzonder Gebied 2012</description><applications/></featureType><featureType><id>507</id><name>75</name><description>Bijzonder Gebied 2011</description><applications/></featureType><featureType><id>508</id><name>76</name><description>Collectief Beheerplan 2012</description><applications/></featureType><featureType><id>509</id><name>77</name><description>Collectief Beheerplan 2011</description><applications/></featureType><featureType><id>510</id><name>78</name><description>Investeringskaart 2012</description><applications/></featureType><featureType><id>511</id><name>79</name><description>Investeringskaart 2011</description><applications/></featureType><featureType><id>512</id><name>80</name><description>Landschapszoekgebied 2012</description><applications/></featureType><featureType><id>513</id><name>81</name><description>Landschapszoekgebied 2011</description><applications/></featureType><featureType><id>514</id><name>82</name><description>Landschapszoekgebied Ambitie 2012</description><applications/></featureType><featureType><id>515</id><name>83</name><description>Landschapszoekgebied Ambitie 2011</description><applications/></featureType><featureType><id>516</id><name>85</name><description>A-locaties bos</description><applications/></featureType><featureType><id>517</id><name>86</name><description>Wild - en Faunabeheerseenheden</description><applications/></featureType><featureType><id>518</id><name>88</name><description>Natuurbeschermingsorganisaties</description><applications/></featureType><featureType><id>519</id><name>90</name><description>BPL- Provinciale subsidie verdroging natte landnatuur</description><applications/></featureType><featureType><id>520</id><name>91</name><description>BPLWN- Provinciale subsidie verdroging waternatuur</description><applications/></featureType><featureType><id>521</id><name>92</name><description>GGOR Doelrealisatie natte landnatuur </description><applications/></featureType><featureType><id>522</id><name>93</name><description>GGOR Schijnspiegels</description><applications/></featureType><featureType><id>523</id><name>94</name><description>GGOR Verdroogde natte landnatuur NOG DOEN</description><applications/></featureType><featureType><id>524</id><name>95</name><description>GGOR Verdroogde natte landnatuur GVG plus 20 cm</description><applications/></featureType><featureType><id>525</id><name>96</name><description>BPL-Subsidie natte landnatuur</description><applications/></featureType><featureType><id>526</id><name>97</name><description>BPLWN-Subsidie waternatuur</description><applications/></featureType><featureType><id>527</id><name>98</name><description>Toplijst gebieden anti-verdroging</description><applications/></featureType><featureType><id>528</id><name>99</name><description>Toplijst gebied milieuherstel</description><applications/></featureType><featureType><id>529</id><name>101</name><description>Doeltype slotenstelsels en plassen</description><applications/></featureType><featureType><id>530</id><name>102</name><description>Ecologische doelstelling wateren slotenstelsels en plassen</description><applications/></featureType></featureSource><featureSource><id>35</id><name>GeoServer Web Map Service</name><protocol>wfs</protocol><url>http://flamingo4.b3p.nl:80/geoserver/wfs/WfsDispatcher?</url><featureType><id>540</id><name>Flamingo:buurten</name><description/><applications/></featureType><featureType><id>538</id><name>Flamingo:gemeentes</name><description/><applications/></featureType><featureType><id>539</id><name>Flamingo:wijken</name><description/><applications/></featureType></featureSource><featureSource><id>48</id><name>GeoServer Web Feature Service</name><protocol>wfs</protocol><url>http://flamingo4.b3p.nl:80/geoserver/wfs/WfsDispatcher?</url><featureType><id>558</id><name>Flamingo:buurten</name><description/><applications/></featureType><featureType><id>556</id><name>Flamingo:gemeentes</name><description/><applications/></featureType><featureType><id>557</id><name>Flamingo:wijken</name><description/><applications/></featureType></featureSource><featureSource><id>59</id><name>Gemeentes (CBS 2010)</name><protocol>wfs</protocol><url>http://mapserver.openwion.nl/cgi-bin/mapserv?map=/srv/b3p-wion/maps/gemeentes_cbs_2010_update_url.map&amp;pietje_puk=2</url><featureType><id>589</id><name>gemeentes</name><description/><applications/></featureType><featureType><id>586</id><name>nieuwe_layer4</name><description/><applications/></featureType><featureType><id>587</id><name>nieuwe_layer6</name><description/><applications/></featureType><featureType><id>588</id><name>nieuwe_layer7</name><description/><applications/></featureType><featureType><id>631</id><name>nieuwe_layer13</name><description/><applications/></featureType></featureSource><featureSource><id>65</id><name>Gemeentes (CBS 2010)</name><protocol>wfs</protocol><url>http://mapserver.openwion.nl/cgi-bin/mapserv?map=/srv/b3p-wion/maps/gemeentes_cbs_2010_update_url.map</url><featureType><id>620</id><name>gemeentes</name><description/><applications/></featureType><featureType><id>624</id><name>nieuwe_layer4</name><description/><applications/></featureType><featureType><id>621</id><name>nieuwe_layer6</name><description/><applications/></featureType><featureType><id>622</id><name>nieuwe_layer7</name><description/><applications/></featureType><featureType><id>633</id><name>nieuwe_layer13</name><description/><applications><application><id>13</id><name>m_update</name><version>1</version><layers><layer><serviceId>57</serviceId><name>nieuwe_layer13</name><applayers><applayer><id>217</id><alias>nieuwe layer added nogmaals #13</alias></applayer></applayers></layer></layers></application></applications></featureType></featureSource><featureSource><id>68</id><name>RO-Online: De landelijke voorziening voor digitale ruimtelijke ordeningsplannen</name><protocol>wfs</protocol><url>http://afnemers.ruimtelijkeplannen.nl:80/unregafnemers/services?</url><featureType><id>725</id><name>app:Gebiedsaanduiding</name><description/><applications/></featureType><featureType><id>726</id><name>app:ProvinciaalComplex</name><description/><applications/></featureType><featureType><id>727</id><name>app:ProvinciaalVerbinding</name><description/><applications/></featureType><featureType><id>728</id><name>app:Structuurvisiecomplex_R</name><description/><applications/></featureType><featureType><id>729</id><name>app:Structuurvisiecomplex_P</name><description/><applications/></featureType><featureType><id>767</id><name>app:Plangebied</name><description/><applications><application><id>6</id><name>m</name><version/><layers><layer><serviceId>32</serviceId><name>ROO:Plangebied</name><applayers><applayer><id>209</id><alias>ROO:Plangebied</alias></applayer></applayers></layer></layers></application><application><id>13</id><name>m_update</name><version>1</version><layers><layer><serviceId>32</serviceId><name>ROO:Plangebied</name><applayers><applayer><id>215</id><alias>ROO:Plangebied</alias></applayer></applayers></layer></layers></application><application><id>19</id><name>m</name><version>1</version><layers><layer><serviceId>32</serviceId><name>ROO:Plangebied</name><applayers><applayer><id>308</id><alias>ROO:Plangebied</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>730</id><name>app:Enkelbestemming</name><description/><applications/></featureType><featureType><id>731</id><name>app:Besluitgebied_P</name><description/><applications/></featureType><featureType><id>732</id><name>app:NationaalGebied</name><description/><applications/></featureType><featureType><id>733</id><name>app:Figuur</name><description/><applications/></featureType><featureType><id>734</id><name>app:Besluitgebied_X</name><description/><applications/></featureType><featureType><id>735</id><name>app:Plangebied_PCP</name><description/><applications/></featureType><featureType><id>736</id><name>app:Besluitvlak_A</name><description/><applications/></featureType><featureType><id>737</id><name>app:ProvinciaalPlangebied</name><description/><applications/></featureType><featureType><id>738</id><name>app:Structuurvisiecomplex_G</name><description/><applications/></featureType><featureType><id>739</id><name>app:Dubbelbestemming</name><description/><applications/></featureType><featureType><id>740</id><name>app:Besluitgebied</name><description/><applications/></featureType><featureType><id>741</id><name>app:PlangebiedDigitaalWaarmerk</name><description/><applications/></featureType><featureType><id>742</id><name>app:Besluitsubvlak_X</name><description/><applications/></featureType><featureType><id>743</id><name>app:Structuurvisiegebied_G</name><description/><applications/></featureType><featureType><id>744</id><name>app:Bouwvlak</name><description/><applications/></featureType><featureType><id>745</id><name>app:Bestemmingsplangebied</name><description/><applications/></featureType><featureType><id>746</id><name>app:Besluitvlak_X</name><description/><applications/></featureType><featureType><id>747</id><name>app:Structuurvisiegebied_R</name><description/><applications/></featureType><featureType><id>748</id><name>app:Structuurvisiegebied_P</name><description/><applications/></featureType><featureType><id>749</id><name>app:Besluitsubvlak_P</name><description/><applications/></featureType><featureType><id>750</id><name>app:NationaalVerbinding</name><description/><applications/></featureType><featureType><id>751</id><name>app:OnderdelenDigitaalWaarmerk</name><description/><applications/></featureType><featureType><id>752</id><name>app:Onthoudingsgebied</name><description/><applications/></featureType><featureType><id>753</id><name>app:Functieaanduiding</name><description/><applications/></featureType><featureType><id>754</id><name>app:Structuurvisieverklaring_P</name><description/><applications/></featureType><featureType><id>755</id><name>app:Besluitvlak_P</name><description/><applications/></featureType><featureType><id>756</id><name>app:NationaalComplex</name><description/><applications/></featureType><featureType><id>757</id><name>app:Maatvoering</name><description/><applications/></featureType><featureType><id>758</id><name>app:NationaalPlangebied</name><description/><applications/></featureType><featureType><id>759</id><name>app:Bouwaanduiding</name><description/><applications/></featureType><featureType><id>760</id><name>app:Besluitsubvlak_A</name><description/><applications/></featureType><featureType><id>761</id><name>app:Structuurvisieplangebied_G</name><description/><applications/></featureType><featureType><id>762</id><name>app:Lettertekenaanduiding</name><description/><applications/></featureType><featureType><id>763</id><name>app:Structuurvisieplangebied_R</name><description/><applications/></featureType><featureType><id>764</id><name>app:ProvinciaalGebied</name><description/><applications/></featureType><featureType><id>765</id><name>app:Structuurvisieplangebied_P</name><description/><applications/></featureType><featureType><id>766</id><name>app:Besluitgebied_A</name><description/><applications/></featureType></featureSource><featureSource><id>69</id><name>ondergrond_lf</name><protocol>arcxml</protocol><url>http://gisopenbaar.toverijs3.nl/GeoJuli2008/ims</url><featureType><id>768</id><name>1</name><description>weg_labels</description><applications/></featureType><featureType><id>770</id><name>3</name><description>wegen_smallscale_hoofdweg</description><applications/></featureType><featureType><id>771</id><name>4</name><description>wegen_largescale_hoofdweg</description><applications/></featureType><featureType><id>772</id><name>5</name><description>wegen_largescale_snelweg</description><applications/></featureType><featureType><id>773</id><name>6</name><description>autosnelwegen_smallscale</description><applications/></featureType><featureType><id>774</id><name>7</name><description>TOP50_NAMEN</description><applications/></featureType><featureType><id>775</id><name>8</name><description>provned_polygon</description><applications/></featureType><featureType><id>801</id><name>2</name><description>wegen_largescale_g</description><applications/></featureType></featureSource><featureSource><id>73</id><name>Bodemkaart</name><protocol>arcgis</protocol><url>http://gisopenbaar.toverijs3.nl/arcgis/rest/services/GISDATA/Bodemkaart/MapServer</url><featureType><id>803</id><name>0</name><description>Bodemkaart</description><applications/></featureType><featureType><id>805</id><name>1</name><description>Grondwatertrappen</description><applications/></featureType></featureSource><featureSource><id>75</id><name>Bestuurlijke_organisatie</name><protocol>arcgis</protocol><url>http://gisopenbaar.toverijs3.nl/arcgis/rest/services/ALGEMEEN_BESTUUR/Bestuurlijke_organisatie/MapServer</url><featureType><id>835</id><name>0</name><description>Gemeentegrenzen Nederland</description><applications/></featureType><featureType><id>821</id><name>1</name><description>Gemeentegrenzen Nederland lijnen</description><applications/></featureType><featureType><id>822</id><name>2</name><description>Gemeentegrenzen Overijssel</description><applications/></featureType><featureType><id>823</id><name>3</name><description>Gemeentegrenzen Overijssel lijnen</description><applications/></featureType><featureType><id>824</id><name>4</name><description>Grenzen Duitsland</description><applications/></featureType><featureType><id>825</id><name>5</name><description>Provinciegrenzen Nederland</description><applications/></featureType><featureType><id>826</id><name>6</name><description>Regios TV oost</description><applications/></featureType><featureType><id>827</id><name>7</name><description>Recreatie regios Overijssel</description><applications/></featureType><featureType><id>828</id><name>8</name><description>Rayonkantoren Wegen en Kanalen</description><applications/></featureType><featureType><id>829</id><name>9</name><description>Rayongrenzen Wegen en Kanalen</description><applications/></featureType><featureType><id>830</id><name>10</name><description>Rayongrenzen Wegen en Kanalen lijnen</description><applications/></featureType><featureType><id>831</id><name>11</name><description>Sectie indeling Wegen en Kanalen</description><applications/></featureType><featureType><id>832</id><name>12</name><description>Toerischtische regios Overijssel</description><applications/></featureType><featureType><id>833</id><name>13</name><description>WGR regio</description><applications/></featureType><featureType><id>834</id><name>14</name><description>WGR regio lijnen</description><applications/></featureType></featureSource><featureSource><id>76</id><name>Bodemkwaliteit</name><protocol>arcgis</protocol><url>http://gisopenbaar.toverijs3.nl/arcgis/rest/services/GISDATA/Bodemkwaliteit/MapServer</url><featureType><id>836</id><name>0</name><description>Asbestlocaties</description><applications><application><id>21</id><name>test_fl</name><version>4.2</version><layers><layer><serviceId>75</serviceId><name>0</name><applayers><applayer><id>326</id><alias>Asbestlocaties</alias></applayer></applayers></layer></layers></application><application><id>22</id><name>3xfeiten</name><version>1</version><layers><layer><serviceId>75</serviceId><name>0</name><applayers><applayer><id>344</id><alias>Asbestlocaties</alias></applayer></applayers></layer></layers></application><application><id>20</id><name>test_ol</name><version>4.2</version><layers><layer><serviceId>75</serviceId><name>0</name><applayers><applayer><id>321</id><alias>Asbestlocaties</alias></applayer></applayers></layer></layers></application></applications></featureType></featureSource><featureSource><id>89</id><name>AVO_algemeen</name><protocol>arcgis</protocol><url>http://testgisopenbaar.overijssel.nl/arcgis/rest/services/Overig/AVO_algemeen/MapServer</url><featureType><id>1204</id><name>0</name><description>Panden</description><applications/></featureType><featureType><id>1192</id><name>1</name><description>Standplaatsen</description><applications/></featureType><featureType><id>1193</id><name>2</name><description>Ligplaatsen</description><applications/></featureType><featureType><id>1194</id><name>4</name><description>Regio-indeling RTV-oost</description><applications/></featureType><featureType><id>1195</id><name>5</name><description>Wijkindeling</description><applications/></featureType><featureType><id>1196</id><name>6</name><description>Buurtindeling</description><applications/></featureType><featureType><id>1197</id><name>7</name><description>Provinciegrens</description><applications/></featureType><featureType><id>1198</id><name>8</name><description>Gemeentegrenzen</description><applications/></featureType><featureType><id>1199</id><name>9</name><description>Rayonindeling provincie Overijssel</description><applications/></featureType><featureType><id>1200</id><name>10</name><description>COROP-gebied</description><applications/></featureType><featureType><id>1201</id><name>11</name><description>Waterschappen</description><applications/></featureType><featureType><id>1202</id><name>13</name><description>Projecten Mobiliteit</description><applications/></featureType><featureType><id>1203</id><name>14</name><description>BAG.Adreslocatie_overijssel</description><applications/></featureType></featureSource><featureSource><id>78</id><name>WegenVerkeerVervoer</name><protocol>arcgis</protocol><url>http://ags.prvgld.nl/ArcGIS/rest/services/WegenVerkeerVervoer/WegenVerkeerVervoer/MapServer</url><featureType><id>1016</id><name>2</name><description>Telpunten</description><applications><application><id>22</id><name>3xfeiten</name><version>1</version><layers><layer><serviceId>78</serviceId><name>2</name><applayers><applayer><id>342</id><alias>Telpunten</alias></applayer></applayers></layer></layers></application><application><id>20</id><name>test_ol</name><version>4.2</version><layers><layer><serviceId>78</serviceId><name>2</name><applayers><applayer><id>332</id><alias>Telpunten</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>927</id><name>3</name><description>Fietsverkeer werkdagen 2011</description><applications/></featureType><featureType><id>928</id><name>4</name><description>Motorvoertuigen werkdagen 2011</description><applications/></featureType><featureType><id>929</id><name>5</name><description>Vrachtverkeer werkdagen 2011</description><applications/></featureType><featureType><id>930</id><name>6</name><description>Rijkswegen motorvoertuigen werkdagen 2011</description><applications/></featureType><featureType><id>931</id><name>7</name><description>Rijkswegen vrachtverkeer werkdagen 2011</description><applications/></featureType><featureType><id>932</id><name>9</name><description>VOC lijst 2008-2010</description><applications/></featureType><featureType><id>933</id><name>10</name><description>Ongevallenregistratie 2010</description><applications/></featureType><featureType><id>934</id><name>11</name><description>Ongevalsdichtheid 2008-2010</description><applications/></featureType><featureType><id>935</id><name>12</name><description>Ongevalssrisico 2008-2010</description><applications/></featureType><featureType><id>936</id><name>14</name><description>Snelheidsovertreders 2011</description><applications/></featureType><featureType><id>937</id><name>15</name><description>Gemeten snelheden (V85 percentiel) 2011</description><applications/></featureType><featureType><id>938</id><name>16</name><description>Maximum snelheid</description><applications/></featureType><featureType><id>939</id><name>18</name><description>Kruispunten</description><applications/></featureType><featureType><id>940</id><name>19</name><description>Rotonden</description><applications/></featureType><featureType><id>941</id><name>20</name><description>Wegobstakels (kruispunten)</description><applications/></featureType><featureType><id>942</id><name>21</name><description>Wegobstakels (wegvakken)</description><applications/></featureType><featureType><id>943</id><name>22</name><description>Spoorwegkruisingen</description><applications/></featureType><featureType><id>944</id><name>23</name><description>Bebouwde kommen</description><applications/></featureType><featureType><id>945</id><name>24</name><description>Fietspaden</description><applications/></featureType><featureType><id>946</id><name>25</name><description>Parallelwegen</description><applications/></featureType><featureType><id>947</id><name>26</name><description>Duurzaamveilig profielen</description><applications/></featureType><featureType><id>948</id><name>27</name><description>Verkeerskundige categorisering PVVP2</description><applications/></featureType><featureType><id>949</id><name>28</name><description>Wegtypen</description><applications/></featureType><featureType><id>950</id><name>29</name><description>Provinciale wegen</description><applications/></featureType><featureType><id>951</id><name>32</name><description>Geluidsreducerende verharding</description><applications/></featureType><featureType><id>952</id><name>34</name><description>Individuele bomen</description><applications/></featureType><featureType><id>953</id><name>36</name><description>Flora- en faunalijst 3</description><applications/></featureType><featureType><id>954</id><name>37</name><description>Flora- en faunalijst 2</description><applications/></featureType><featureType><id>955</id><name>38</name><description>Flora overige</description><applications/></featureType><featureType><id>956</id><name>39</name><description>Schadesoorten flora</description><applications/></featureType><featureType><id>957</id><name>40</name><description>Grofwild sporen</description><applications/></featureType><featureType><id>958</id><name>41</name><description>Fauna</description><applications/></featureType><featureType><id>959</id><name>42</name><description>Watergangen</description><applications/></featureType><featureType><id>960</id><name>43</name><description>Wildspiegels</description><applications/></featureType><featureType><id>961</id><name>44</name><description>Groepen bomen</description><applications/></featureType><featureType><id>962</id><name>46</name><description>Geluidreducerende voorzieningen</description><applications/></featureType><featureType><id>963</id><name>48</name><description>Lichtmasten</description><applications/></featureType><featureType><id>964</id><name>49</name><description>Armaturen</description><applications/></featureType><featureType><id>965</id><name>50</name><description>Schakelkasten</description><applications/></featureType><featureType><id>966</id><name>52</name><description>Gladheidmeldsysteem</description><applications/></featureType><featureType><id>967</id><name>53</name><description>Telpunten</description><applications/></featureType><featureType><id>968</id><name>54</name><description>VRI kasten</description><applications/></featureType><featureType><id>969</id><name>55</name><description>VRI geregelde kruispunten</description><applications/></featureType><featureType><id>970</id><name>56</name><description>Webcams op provinciale wegen</description><applications/></featureType><featureType><id>971</id><name>57</name><description>Kabels en leidingen WION punten</description><applications/></featureType><featureType><id>972</id><name>58</name><description>Kabels en leidingen WION lijnen</description><applications/></featureType><featureType><id>973</id><name>59</name><description>Kabels en leidingen WION vlakken</description><applications/></featureType><featureType><id>974</id><name>61</name><description>Bushaltes</description><applications/></featureType><featureType><id>975</id><name>62</name><description>Bushaltes toegankelijkheid</description><applications/></featureType><featureType><id>976</id><name>63</name><description>Artistieke kunstwerken</description><applications/></featureType><featureType><id>977</id><name>64</name><description>Welkomst- en mottoborden</description><applications/></featureType><featureType><id>978</id><name>66</name><description>Motorbrandstofverkooppunten</description><applications/></featureType><featureType><id>979</id><name>67</name><description>Carpoolplaatsen Gelderland</description><applications/></featureType><featureType><id>980</id><name>69</name><description>Palinggraatkaart</description><applications/></featureType><featureType><id>981</id><name>71</name><description>Bushaltes</description><applications/></featureType><featureType><id>982</id><name>72</name><description>Bushaltes Toegankelijkheid</description><applications/></featureType><featureType><id>983</id><name>73</name><description>Snelnetbuslijnen</description><applications/></featureType><featureType><id>984</id><name>74</name><description>Regiobuslijnen</description><applications/></featureType><featureType><id>985</id><name>75</name><description>Stadsbuslijnen</description><applications/></featureType><featureType><id>986</id><name>76</name><description>Buurtbuslijnen</description><applications/></featureType><featureType><id>987</id><name>77</name><description>Scholierenlijnen</description><applications/></featureType><featureType><id>988</id><name>78</name><description>Seizoenlijnen</description><applications/></featureType><featureType><id>989</id><name>79</name><description>Feederlijnen</description><applications/></featureType><featureType><id>990</id><name>80</name><description>Belbuslijnen</description><applications/></featureType><featureType><id>991</id><name>81</name><description>Regionale spoorlijnen</description><applications/></featureType><featureType><id>992</id><name>82</name><description>Spoorstations</description><applications/></featureType><featureType><id>993</id><name>84</name><description>Onderhoudsgebied</description><applications/></featureType><featureType><id>994</id><name>85</name><description>Eigendomsgebied</description><applications/></featureType><featureType><id>995</id><name>86</name><description>Beheergebied</description><applications/></featureType><featureType><id>996</id><name>87</name><description>Kadastrale percelen LKI</description><applications/></featureType><featureType><id>997</id><name>89</name><description>Kilometrering_1</description><applications/></featureType><featureType><id>998</id><name>90</name><description>Kilometrering_2</description><applications/></featureType><featureType><id>999</id><name>91</name><description>Kilometrering_3</description><applications/></featureType><featureType><id>1000</id><name>92</name><description>Kilometrering_4</description><applications/></featureType><featureType><id>1001</id><name>93</name><description>Provinciale wegen</description><applications/></featureType><featureType><id>1002</id><name>94</name><description>GBKN Teksten</description><applications/></featureType><featureType><id>1003</id><name>96</name><description>GBKN Bebouwing</description><applications/></featureType><featureType><id>1004</id><name>97</name><description>GTG Punten</description><applications/></featureType><featureType><id>1005</id><name>98</name><description>GTG Lijnen</description><applications/></featureType><featureType><id>1006</id><name>99</name><description>GTG Vlakken</description><applications/></featureType><featureType><id>1007</id><name>101</name><description>Trajectindeling</description><applications/></featureType><featureType><id>1008</id><name>102</name><description>Districtskantoren en steunpunten</description><applications/></featureType><featureType><id>1009</id><name>103</name><description>Kantons</description><applications/></featureType><featureType><id>1010</id><name>104</name><description>Rayons</description><applications/></featureType><featureType><id>1011</id><name>105</name><description>Wegendistricten</description><applications/></featureType><featureType><id>1012</id><name>106</name><description>Verkeer en vervoer regio</description><applications/></featureType><featureType><id>1013</id><name>107</name><description>Gemeenten</description><applications/></featureType><featureType><id>1014</id><name>108</name><description>Waterschappen</description><applications/></featureType><featureType><id>1015</id><name>109</name><description>Politieregios</description><applications/></featureType></featureSource><featureSource><id>79</id><name>atlasoverijssel</name><protocol>arcxml</protocol><url>http://gisopenbaar.toverijs3.nl/GeoJuli2008/ims</url><featureType><id>1131</id><name>dummy_layer</name><description>dummy_layer</description><applications/></featureType><featureType><id>1017</id><name>bag_pand</name><description>bag_pand</description><applications/></featureType><featureType><id>1018</id><name>bag_standplaats</name><description>bag_standplaats</description><applications/></featureType><featureType><id>1019</id><name>bag_ligplaats</name><description>bag_ligplaats</description><applications/></featureType><featureType><id>1020</id><name>bag_adres</name><description>bag_adres</description><applications/></featureType><featureType><id>1021</id><name>bag_adres_ligplaats</name><description>bag_adres_ligplaats</description><applications/></featureType><featureType><id>1022</id><name>bag_adres_standplaats</name><description>bag_adres_standplaats</description><applications/></featureType><featureType><id>1023</id><name>bag_verblijfsobject</name><description>bag_verblijfsobject</description><applications/></featureType><featureType><id>1024</id><name>regio_tvoost</name><description>B1.regio_tv_oost_polygon</description><applications/></featureType><featureType><id>1025</id><name>corop</name><description>COROP gebieden</description><applications/></featureType><featureType><id>1026</id><name>watschap_ned_polygon</name><description>B0.watschap_ned_polygon</description><applications/></featureType><featureType><id>1027</id><name>geomorfologie</name><description>Geomorfologische kaart</description><applications/></featureType><featureType><id>1028</id><name>grwbes_polygon</name><description>Grondwaterbeschermingsgebied</description><applications><application><id>21</id><name>test_fl</name><version>4.2</version><layers><layer><serviceId>79</serviceId><name>grwbes_polygon</name><applayers><applayer><id>334</id><alias>Grondwaterbeschermingsgebied</alias></applayer></applayers></layer></layers></application><application><id>22</id><name>3xfeiten</name><version>1</version><layers><layer><serviceId>79</serviceId><name>grwbes_polygon</name><applayers><applayer><id>343</id><alias>Grondwaterbeschermingsgebied</alias></applayer></applayers></layer></layers></application><application><id>20</id><name>test_ol</name><version>4.2</version><layers><layer><serviceId>79</serviceId><name>grwbes_polygon</name><applayers><applayer><id>333</id><alias>Grondwaterbeschermingsgebied</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>1029</id><name>salland</name><description>Boringsvrije zones</description><applications/></featureType><featureType><id>1030</id><name>boringvrij</name><description>Boringsvrije zones</description><applications/></featureType><featureType><id>1031</id><name>intrekgebied</name><description>Intrekgebied</description><applications/></featureType><featureType><id>1032</id><name>waterwin_polygon</name><description>Waterwingebied</description><applications/></featureType><featureType><id>1033</id><name>nat2000</name><description>Natura2000</description><applications/></featureType><featureType><id>1034</id><name>habitattypen_id</name><description>B4.habitattypen_polygon</description><applications/></featureType><featureType><id>1035</id><name>hemelhelderheid_polygon</name><description>Hemelhelderheid</description><applications/></featureType><featureType><id>1036</id><name>sterrenwachten</name><description>sterrenwachten</description><applications/></featureType><featureType><id>1037</id><name>overijssel_geluid_lden_rijksw_2006</name><description>Geluidsbelasting rijkswegen</description><applications/></featureType><featureType><id>1038</id><name>overijssel_geluid_lnight_rijksw_2006</name><description>Geluidsbelasting rijkswegen</description><applications/></featureType><featureType><id>1039</id><name>overijssel_geluid_lden_provw_2006</name><description>Geluidsbelasting provinciale wegen</description><applications/></featureType><featureType><id>1040</id><name>overijssel_geluid_lnight_provw_2006</name><description>Geluidsbelasting provinciale wegen</description><applications/></featureType><featureType><id>1041</id><name>recon_zone_polygon</name><description>Reconstructie zonering</description><applications/></featureType><featureType><id>1042</id><name>wbe_polygon</name><description>wbe_polygon</description><applications/></featureType><featureType><id>1043</id><name>natpark</name><description>natpark</description><applications/></featureType><featureType><id>1044</id><name>natlands</name><description>nationale_landschappen</description><applications/></featureType><featureType><id>1045</id><name>rayonwk_polygon</name><description>rayonwk</description><applications/></featureType><featureType><id>1046</id><name>ehs</name><description>EHS</description><applications/></featureType><featureType><id>1047</id><name>rvz</name><description>RVZ</description><applications/></featureType><featureType><id>1048</id><name>evz</name><description>EVZ</description><applications/></featureType><featureType><id>1049</id><name>wav_polygon</name><description>B4.wav_polygon</description><applications/></featureType><featureType><id>1050</id><name>ibis</name><description>ibis</description><applications/></featureType><featureType><id>1051</id><name>nb_wet</name><description>B4.nb_wet_polygon</description><applications/></featureType><featureType><id>1052</id><name>provwegen</name><description>provwegen</description><applications/></featureType><featureType><id>1053</id><name>rijkswegen</name><description>rijkswegen</description><applications/></featureType><featureType><id>1054</id><name>vaarwegen</name><description>vaarwegen</description><applications/></featureType><featureType><id>1055</id><name>froutenetwerk</name><description>froutenetwerk</description><applications/></featureType><featureType><id>1056</id><name>lfroute</name><description>lfroute_arc</description><applications/></featureType><featureType><id>1057</id><name>lawroute</name><description>lawroute_arc</description><applications/></featureType><featureType><id>1058</id><name>mtbroute</name><description>mtbroute</description><applications/></featureType><featureType><id>1059</id><name>raamplan</name><description>raamplan fietspaden</description><applications/></featureType><featureType><id>1060</id><name>kanoroute</name><description>kanoroute</description><applications/></featureType><featureType><id>1061</id><name>top</name><description>TOP</description><applications/></featureType><featureType><id>1062</id><name>law_knelpt</name><description>B5.law_knelpunten_arc</description><applications/></featureType><featureType><id>1063</id><name>lf_knelpt</name><description>lf_knelpunten_arc</description><applications/></featureType><featureType><id>1064</id><name>rec_camping</name><description>rec_camping</description><applications/></featureType><featureType><id>1065</id><name>rec_bungalowpark</name><description>rec_bungalowpark</description><applications/></featureType><featureType><id>1066</id><name>rec_jachthaven</name><description>rec_jachthaven</description><applications/></featureType><featureType><id>1067</id><name>rec_groepsaccommodatie</name><description>rec_groepsaccommodatie</description><applications/></featureType><featureType><id>1068</id><name>kulturhus_mfa</name><description>Kulturhus en MFA</description><applications/></featureType><featureType><id>1069</id><name>strooi_prov</name><description>B2.strooiroutes_provincie</description><applications/></featureType><featureType><id>1070</id><name>stortplaats</name><description>stpl</description><applications/></featureType><featureType><id>1071</id><name>asbest_loc</name><description>Locaties met informatie omtrent asbest</description><applications/></featureType><featureType><id>1072</id><name>bouwarchief_niet_gem</name><description>Bouwarchief niet rechtstreekse gemeenten (steekproef)</description><applications/></featureType><featureType><id>1073</id><name>bouwarchief_gem</name><description>Bouwarchief rechtstreekse gemeenten (steekproef)</description><applications/></featureType><featureType><id>1074</id><name>bodemarchief</name><description>Bodemarchief</description><applications/></featureType><featureType><id>1075</id><name>luchtkwaliteit_2008_P</name><description>B4.luchtkwaliteit_2008_point</description><applications/></featureType><featureType><id>1076</id><name>luchtkwaliteit_2008_N</name><description>B4.luchtkwaliteit_2008_point</description><applications/></featureType><featureType><id>1077</id><name>zwemwater_o</name><description>zwemwater_o</description><applications/></featureType><featureType><id>1078</id><name>zwemwater_o_krw</name><description>zwemwater_o_krw</description><applications/></featureType><featureType><id>1079</id><name>zwemwater_o_lbl</name><description>zwemwater_o_lbl</description><applications/></featureType><featureType><id>1080</id><name>zwemwater_no</name><description>zwemwater_no</description><applications/></featureType><featureType><id>1081</id><name>zwemwater_no_krw</name><description>zwemwater_no_krw</description><applications/></featureType><featureType><id>1082</id><name>zwemwater_no_lbl</name><description>zwemwater_no_lbl</description><applications/></featureType><featureType><id>1083</id><name>zwemwater_kand_o</name><description>zwemwater_kand_o</description><applications/></featureType><featureType><id>1084</id><name>zwemwater_kand_o_krw</name><description>zwemwater_kand_o_krw</description><applications/></featureType><featureType><id>1085</id><name>zwemwater_kand_o_lbl</name><description>zwemwater_kand_o_lbl</description><applications/></featureType><featureType><id>1086</id><name>zwemwater_kand_no</name><description>zwemwater_kand_no</description><applications/></featureType><featureType><id>1087</id><name>zwemwater_kand_no_krw</name><description>zwemwater_kand_no_krw</description><applications/></featureType><featureType><id>1088</id><name>zwemwater_kand_no_lbl</name><description>zwemwater_kand_no_lbl</description><applications/></featureType><featureType><id>1089</id><name>zwemwater_no_q</name><description>zwemwater_no_q</description><applications/></featureType><featureType><id>1090</id><name>zwemwater_o_q</name><description>zwemwater_o_q</description><applications/></featureType><featureType><id>1091</id><name>station</name><description>station</description><applications/></featureType><featureType><id>1092</id><name>kwo2</name><description>kwo</description><applications/></featureType><featureType><id>1093</id><name>kwo1</name><description>kwo</description><applications/></featureType><featureType><id>1094</id><name>rijksmonumenten</name><description>Rijksmonument</description><applications/></featureType><featureType><id>1095</id><name>gemeentelijkemonumenten</name><description>Gemeentelijk monument</description><applications/></featureType><featureType><id>1096</id><name>fknooppunt</name><description>fietsroute knooppunt</description><applications/></featureType><featureType><id>1097</id><name>N340_1</name><description>N340</description><applications/></featureType><featureType><id>1098</id><name>N340_2</name><description>N340</description><applications/></featureType><featureType><id>1099</id><name>N340_3</name><description>N340</description><applications/></featureType><featureType><id>1100</id><name>N340_4</name><description>N340</description><applications/></featureType><featureType><id>1101</id><name>N340_5</name><description>N340</description><applications/></featureType><featureType><id>1102</id><name>N340_6</name><description>N340</description><applications/></featureType><featureType><id>1103</id><name>N340_7</name><description>N340</description><applications/></featureType><featureType><id>1104</id><name>N340_8</name><description>N340</description><applications/></featureType><featureType><id>1105</id><name>N340_9</name><description>N340</description><applications/></featureType><featureType><id>1106</id><name>N340_10</name><description>N340</description><applications/></featureType><featureType><id>1107</id><name>N340_11</name><description>N340</description><applications/></featureType><featureType><id>1108</id><name>N340_12</name><description>N340</description><applications/></featureType><featureType><id>1109</id><name>N340_13</name><description>N340</description><applications/></featureType><featureType><id>1110</id><name>N340_14</name><description>N340</description><applications/></featureType><featureType><id>1111</id><name>N340_15</name><description>N340</description><applications/></featureType><featureType><id>1112</id><name>N340_16</name><description>N340</description><applications/></featureType><featureType><id>1113</id><name>N340_17</name><description>N340</description><applications/></featureType><featureType><id>1114</id><name>N340_18</name><description>N340</description><applications/></featureType><featureType><id>1115</id><name>N340_19</name><description>N340</description><applications/></featureType><featureType><id>1116</id><name>biro2010</name><description>werkgelegenheid_2010</description><applications/></featureType><featureType><id>1117</id><name>streetview</name><description>streetview</description><applications/></featureType><featureType><id>1118</id><name>streetview_prov</name><description>streetview_prov</description><applications/></featureType><featureType><id>1119</id><name>wegen_largescale_g</name><description>wegen_largescale_g</description><applications/></featureType><featureType><id>1120</id><name>wegen_largescale_hoofdweg</name><description>wegen_largescale_hoofdweg</description><applications/></featureType><featureType><id>1121</id><name>wegen_largescale_snelweg</name><description>wegen_largescale_snelweg</description><applications/></featureType><featureType><id>1122</id><name>wegen_smallscale_hoofdweg</name><description>wegen_smallscale_hoofdweg</description><applications/></featureType><featureType><id>1123</id><name>autosnelwegen_smallscale</name><description>autosnelwegen_smallscale</description><applications/></featureType><featureType><id>1124</id><name>buurten</name><description>B8.buurtindeling_polygon</description><applications/></featureType><featureType><id>1125</id><name>buurten_label</name><description>B8.buurtindeling_polygon</description><applications/></featureType><featureType><id>1126</id><name>gem_overlay</name><description>gem_overlay</description><applications/></featureType><featureType><id>1127</id><name>gem_label</name><description>gem_label</description><applications/></featureType><featureType><id>1128</id><name>prov_overlay</name><description>B1.prov_overlay</description><applications/></featureType><featureType><id>1129</id><name>weg_labels</name><description>weg_labels</description><applications/></featureType><featureType><id>1130</id><name>top50_namen</name><description>top50_namen</description><applications/></featureType></featureSource><featureSource><id>80</id><name>GeoServer Web Feature Service</name><protocol>wfs</protocol><url>http://flamingo4.b3p.nl:80/geoserver/wfs/WfsDispatcher?</url><featureType><id>1134</id><name>Flamingo:buurten</name><description/><applications/></featureType><featureType><id>1132</id><name>Flamingo:gemeentes</name><description/><applications/></featureType><featureType><id>1133</id><name>Flamingo:wijken</name><description/><applications/></featureType></featureSource><featureSource><id>81</id><name>GeoServer Web Feature Service</name><protocol>wfs</protocol><url>http://flamingo4.b3p.nl:80/geoserver/wfs/WfsDispatcher?</url><featureType><id>1137</id><name>Flamingo:buurten</name><description/><applications/></featureType><featureType><id>1135</id><name>Flamingo:gemeentes</name><description/><applications/></featureType><featureType><id>1136</id><name>Flamingo:wijken</name><description/><applications/></featureType></featureSource><featureSource><id>82</id><name>GeoServer Web Feature Service</name><protocol>wfs</protocol><url>http://flamingo4.b3p.nl:80/geoserver/wfs/WfsDispatcher?</url><featureType><id>1140</id><name>Flamingo:buurten</name><description/><applications/></featureType><featureType><id>1138</id><name>Flamingo:gemeentes</name><description/><applications><application><id>28</id><name>m_ol (kopie)</name><version/><layers><layer><serviceId>82</serviceId><name>Flamingo:gemeentes</name><applayers><applayer><id>428</id><alias>Gemeentes 2011</alias></applayer></applayers></layer></layers></application><application><id>11</id><name>m_ol</name><version/><layers><layer><serviceId>82</serviceId><name>Flamingo:gemeentes</name><applayers><applayer><id>403</id><alias>Gemeentes 2011</alias></applayer></applayers></layer></layers></application><application><id>19</id><name>m</name><version>1</version><layers><layer><serviceId>82</serviceId><name>Flamingo:gemeentes</name><applayers><applayer><id>402</id><alias>Gemeentes 2011</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>1139</id><name>Flamingo:wijken</name><description/><applications/></featureType><featureType><id>1141</id><name>Flamingo:states</name><description/><applications/></featureType></featureSource><featureSource><id>83</id><name>webbvb</name><protocol>arcgis</protocol><url>http://atlas.brabant.nl/ArcGIS/rest/services/webbvb/MapServer</url><featureType><id>1169</id><name>0</name><description>0 Veehouderijbedrijf</description><applications/></featureType><featureType><id>1142</id><name>1</name><description>1 Voormalig veehouderijbedrijf</description><applications/></featureType><featureType><id>1143</id><name>2</name><description>2 Stankcirkel 1996 cat. IV</description><applications/></featureType><featureType><id>1144</id><name>3</name><description>3 Stankcirkel 1996 cat. III</description><applications/></featureType><featureType><id>1145</id><name>4</name><description>4 Stankcirkel 1996 cat. II</description><applications/></featureType><featureType><id>1146</id><name>5</name><description>5 Stankcirkel 1996 cat. I</description><applications/></featureType><featureType><id>1147</id><name>6</name><description>6 Stankcirkel 2003 cat. IV</description><applications/></featureType><featureType><id>1148</id><name>7</name><description>7 Stankcirkel 2003 cat. III</description><applications/></featureType><featureType><id>1149</id><name>8</name><description>8 Stankcirkel 2003 cat. II</description><applications/></featureType><featureType><id>1150</id><name>9</name><description>9 Stankcirkel 2003 cat. I</description><applications/></featureType><featureType><id>1151</id><name>10</name><description>10 Provinciegrens</description><applications/></featureType><featureType><id>1152</id><name>11</name><description>11 Gemeentegrenzen_2010</description><applications/></featureType><featureType><id>1153</id><name>12</name><description>12 Reconstructiegrenzen</description><applications/></featureType><featureType><id>1154</id><name>13</name><description>13 RNLE Interimstructuurvisie</description><applications/></featureType><featureType><id>1155</id><name>14</name><description>14 Landbouwontwikkelingsgebied</description><applications/></featureType><featureType><id>1156</id><name>15</name><description>15 Straatnamen</description><applications/></featureType><featureType><id>1157</id><name>16</name><description>16 IZ Rconstructieplan Integrale zonering</description><applications/></featureType><featureType><id>1158</id><name>17</name><description>17 IZ Gebiedsplan Integrale zonering GP</description><applications/></featureType><featureType><id>1159</id><name>18</name><description>18 Natura 2000 Nationaal Park</description><applications/></featureType><featureType><id>1160</id><name>19</name><description>19 Natura 2000 Vogelgebied</description><applications/></featureType><featureType><id>1161</id><name>20</name><description>20 Natura 2000 Vogelgebied_Belgie</description><applications/></featureType><featureType><id>1162</id><name>21</name><description>21 Natura 2000 Habitatrichtlijn03</description><applications/></featureType><featureType><id>1163</id><name>22</name><description>22 Natura 2000 Habitatrichtlijn_Belgie</description><applications/></featureType><featureType><id>1164</id><name>23</name><description>23 Natura 2000 Natuurbeschermingswet05</description><applications/></featureType><featureType><id>1165</id><name>24</name><description>24 Kwetsbare gebieden WAV 2008</description><applications/></featureType><featureType><id>1166</id><name>25</name><description>25 250m-zone  rondom WAV-gebied</description><applications/></featureType><featureType><id>1167</id><name>26</name><description>26 Ecologische Hoofdstructuur VR 2010</description><applications/></featureType><featureType><id>1168</id><name>27</name><description>27 Gemeentegrens tbv identify-scherm</description><applications/></featureType></featureSource><featureSource><id>84</id><name>Coastal_Dams</name><protocol>arcgis</protocol><url>http://arcserve.lawr.ucdavis.edu/arcgis/rest/services/CSMW/Coastal_Dams/MapServer</url><featureType><id>1170</id><name>0</name><description>Coastal Dams - NID 2010</description><applications/></featureType></featureSource><featureSource><id>85</id><name>GeoServer Web Feature Service</name><protocol>wfs</protocol><url>http://flamingo4.b3p.nl:80/geoserver/wfs/WfsDispatcher?</url><featureType><id>1174</id><name>Flamingo:buurten</name><description>Buurten</description><applications><application><id>32</id><name>demo</name><version>1</version><layers><layer><serviceId>91</serviceId><name>Flamingo:buurten</name><applayers><applayer><id>484</id><alias>Buurten</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>1171</id><name>Flamingo:gemeentes</name><description>Gemeentes 2011</description><applications/></featureType><featureType><id>1172</id><name>Flamingo:wijken</name><description>Wijken 2011</description><applications/></featureType><featureType><id>1173</id><name>Flamingo:states</name><description>states</description><applications/></featureType></featureSource><featureSource><id>86</id><name>Bodemkaart</name><protocol>arcgis</protocol><url>http://gisopenbaar.toverijs3.nl/ArcGIS/rest/services/GISDATA/Bodemkaart/MapServer</url><featureType><id>1176</id><name>0</name><description>Bodemkaart</description><applications/></featureType><featureType><id>1175</id><name>1</name><description>Grondwatertrappen</description><applications/></featureType></featureSource><featureSource><id>87</id><name>Bodemkaart</name><protocol>arcgis</protocol><url>http://gisopenbaar.toverijs3.nl/ArcGIS/rest/services/GISDATA/Bodemkaart/MapServer</url><featureType><id>1178</id><name>0</name><description>Bodemkaart</description><applications><application><id>28</id><name>m_ol (kopie)</name><version/><layers><layer><serviceId>93</serviceId><name>0</name><applayers><applayer><id>430</id><alias>Bodemkaart arcgis</alias></applayer></applayers></layer></layers></application><application><id>11</id><name>m_ol</name><version/><layers><layer><serviceId>93</serviceId><name>0</name><applayers><applayer><id>419</id><alias>Bodemkaart arcgis</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>1177</id><name>1</name><description>Grondwatertrappen</description><applications/></featureType></featureSource><featureSource><id>88</id><name>AVO_algemeen</name><protocol>arcgis</protocol><url>http://testgisopenbaar.overijssel.nl/arcgis/rest/services/Overig/AVO_algemeen/MapServer</url><featureType><id>1191</id><name>0</name><description>Panden</description><applications/></featureType><featureType><id>1179</id><name>1</name><description>Standplaatsen</description><applications/></featureType><featureType><id>1180</id><name>2</name><description>Ligplaatsen</description><applications/></featureType><featureType><id>1181</id><name>4</name><description>Regio-indeling RTV-oost</description><applications/></featureType><featureType><id>1182</id><name>5</name><description>Wijkindeling</description><applications/></featureType><featureType><id>1183</id><name>6</name><description>Buurtindeling</description><applications/></featureType><featureType><id>1184</id><name>7</name><description>Provinciegrens</description><applications/></featureType><featureType><id>1185</id><name>8</name><description>Gemeentegrenzen</description><applications/></featureType><featureType><id>1186</id><name>9</name><description>Rayonindeling provincie Overijssel</description><applications/></featureType><featureType><id>1187</id><name>10</name><description>COROP-gebied</description><applications/></featureType><featureType><id>1188</id><name>11</name><description>Waterschappen</description><applications/></featureType><featureType><id>1189</id><name>13</name><description>Projecten Mobiliteit</description><applications><application><id>28</id><name>m_ol (kopie)</name><version/><layers><layer><serviceId>95</serviceId><name>13</name><applayers><applayer><id>432</id><alias>Projecten Mobiliteit</alias></applayer></applayers></layer></layers></application><application><id>11</id><name>m_ol</name><version/><layers><layer><serviceId>95</serviceId><name>13</name><applayers><applayer><id>422</id><alias>Projecten Mobiliteit</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>1190</id><name>14</name><description>BAG.Adreslocatie_overijssel</description><applications/></featureType></featureSource><featureSource><id>90</id><name>a_Flamingo_test_roy</name><protocol>jdbc</protocol><url>{\"port\":\"5432\",\"dbtype\":\"postgis\",\"host\":\"b3p-roy\",\"database\":\"flamingo_test\"}</url><featureType><id>1205</id><name>table1</name><description/><applications/></featureType></featureSource><featureSource><id>91</id><name>Flamingo test</name><protocol>wfs</protocol><url>http://localhost:8888/cgi-bin/mapserv.exe?map=C:/maps/flamingo_test.map&amp;</url><featureType><id>1208</id><name>feature1</name><description>feature 1</description><applications/></featureType></featureSource><featureSource><id>92</id><name>x13 beursgisdata</name><protocol>jdbc</protocol><url>{\"port\":\"5432\",\"dbtype\":\"postgis\",\"host\":\"x13.b3p.nl\",\"database\":\"beurs_gisdata\"}</url><featureType><id>1209</id><name>BAG_Adressen</name><description/><applications/></featureType><featureType><id>1210</id><name>BAG_LIGPLAATSEN</name><description/><applications/></featureType><featureType><id>1211</id><name>BAG_PANDEN</name><description/><applications/></featureType><featureType><id>1212</id><name>BAG_VERBLIJFSOBJECTEN</name><description/><applications/></featureType><featureType><id>1213</id><name>DRONTEN_BAG_Adres</name><description/><applications/></featureType><featureType><id>1214</id><name>DRONTEN_BAG_PAND</name><description/><applications/></featureType><featureType><id>1215</id><name>DRONTEN_BAG_WOONPLAATS</name><description/><applications/></featureType><featureType><id>1216</id><name>DRONTEN_GBKD_Lijnen</name><description/><applications/></featureType><featureType><id>1217</id><name>DRONTEN_GBKD_Punten</name><description/><applications/></featureType><featureType><id>1218</id><name>DRONTEN_GBKD_Teksten</name><description/><applications/></featureType><featureType><id>1219</id><name>DRONTEN_Groen_Bomen</name><description/><applications/></featureType><featureType><id>1220</id><name>DRONTEN_KAD_REEKS</name><description/><applications/></featureType><featureType><id>1221</id><name>Huizen_Aardkundig_Monument</name><description/><applications/></featureType><featureType><id>1222</id><name>Huizen_Aardkundig_Waardevol</name><description/><applications/></featureType><featureType><id>1223</id><name>Huizen_Deel_BG</name><description/><applications/></featureType><featureType><id>1224</id><name>Huizen_Deel_OG</name><description/><applications/></featureType><featureType><id>1225</id><name>Huizen_Grondwaterbescherming</name><description/><applications/></featureType><featureType><id>1226</id><name>NO_Polder_Object</name><description/><applications/></featureType><featureType><id>1227</id><name>Test_meldingen_p</name><description/><applications/></featureType><featureType><id>1228</id><name>cbs_buurt_2010</name><description/><applications/></featureType><featureType><id>1229</id><name>cbs_gem_2010</name><description/><applications/></featureType><featureType><id>1230</id><name>cbs_wijk_2010</name><description/><applications/></featureType><featureType><id>1231</id><name>gng_test</name><description/><applications/></featureType><featureType><id>1232</id><name>groen</name><description/><applications/></featureType><featureType><id>1233</id><name>meldingen</name><description/><applications/></featureType><featureType><id>1234</id><name>redlining_object</name><description/><applications/></featureType><featureType><id>1235</id><name>test_b3p</name><description/><applications/></featureType><featureType><id>1236</id><name>wz_complexen</name><description/><applications/></featureType><featureType><id>1237</id><name>wz_inkomen_dh</name><description/><applications/></featureType><featureType><id>1238</id><name>wz_voorzieningen</name><description/><applications/></featureType><featureType><id>1239</id><name>wz_zorgvraag_dh</name><description/><applications/></featureType><featureType><id>1240</id><name>bag_panden_demo</name><description/><applications/></featureType><featureType><id>1241</id><name>view_cbs_buurt_2010_ink_zorg</name><description/><applications/></featureType></featureSource><featureSource><id>93</id><name>Water</name><protocol>arcgis</protocol><url>http://ags101.prvgld.nl/arcgis/rest/services/Water/MapServer</url><featureType><id>1287</id><name>1</name><description>Maximale grondwaterstand - GHG</description><applications/></featureType><featureType><id>1242</id><name>3</name><description>Meetnet- Grondwaterkwantiteit- TNO</description><applications/></featureType><featureType><id>1243</id><name>4</name><description>Meetnet- Grondwaterkwantiteit- Primair</description><applications/></featureType><featureType><id>1244</id><name>5</name><description>Meetnet- Grondwaterkwantiteit- Selectie</description><applications/></featureType><featureType><id>1245</id><name>7</name><description>KRW monitoring grondwaterkwantiteit</description><applications/></featureType><featureType><id>1246</id><name>8</name><description>KRW monitoring grondwaterkwaliteit</description><applications/></featureType><featureType><id>1247</id><name>10</name><description>Meetlocaties grote rivieren</description><applications/></featureType><featureType><id>1248</id><name>11</name><description>Meetnet waterstanden afvoeren WS WRIJ</description><applications/></featureType><featureType><id>1249</id><name>13</name><description>Drinkwateronttrekkingen</description><applications/></featureType><featureType><id>1250</id><name>14</name><description>Register grondwater onttrekkingen landbouw</description><applications/></featureType><featureType><id>1251</id><name>15</name><description>Register grondwater onttrekkingen beheersmaatregelen</description><applications/></featureType><featureType><id>1252</id><name>16</name><description>Register grondwater onttrekkingen kwo</description><applications/></featureType><featureType><id>1253</id><name>17</name><description>Register grondwater onttrekkingen sanering</description><applications/></featureType><featureType><id>1254</id><name>19</name><description>Locaties weidevogels</description><applications/></featureType><featureType><id>1255</id><name>21</name><description>bescherming oppervlaktewater tbv drinkwater</description><applications><application><id>32</id><name>demo</name><version>1</version><layers><layer><serviceId>102</serviceId><name>21</name><applayers><applayer><id>485</id><alias>bescherming oppervlaktewater tbv drinkwater</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>1256</id><name>23</name><description>Isohypsen GVG 1e WVP TNO mnap</description><applications/></featureType><featureType><id>1257</id><name>25</name><description>KRW oppervlaktewaterlichamen</description><applications/></featureType><featureType><id>1258</id><name>27</name><description>Bescherming oppervlaktewater voor drinkwater</description><applications/></featureType><featureType><id>1259</id><name>29</name><description>Waterwingebieden</description><applications><application><id>32</id><name>demo</name><version>1</version><layers><layer><serviceId>102</serviceId><name>29</name><applayers><applayer><id>486</id><alias>Waterwingebieden</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>1260</id><name>30</name><description>Grondwaterbeschermingsgebieden</description><applications><application><id>32</id><name>demo</name><version>1</version><layers><layer><serviceId>102</serviceId><name>30</name><applayers><applayer><id>487</id><alias>Grondwaterbeschermingsgebieden</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>1261</id><name>31</name><description>Intrekgebieden </description><applications><application><id>32</id><name>demo</name><version>1</version><layers><layer><serviceId>102</serviceId><name>31</name><applayers><applayer><id>488</id><alias>Intrekgebieden </alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>1262</id><name>32</name><description>Boringsvrije zones grondwater</description><applications><application><id>32</id><name>demo</name><version>1</version><layers><layer><serviceId>102</serviceId><name>32</name><applayers><applayer><id>489</id><alias>Boringsvrije zones grondwater</alias></applayer></applayers></layer></layers></application></applications></featureType><featureType><id>1263</id><name>34</name><description>Kwelgebieden</description><applications/></featureType><featureType><id>1264</id><name>35</name><description>Hydrologische beinvloedingsgebieden</description><applications/></featureType><featureType><id>1265</id><name>36</name><description>Kwel-infiltratie</description><applications/></featureType><featureType><id>1266</id><name>37</name><description>Gemiddelde Hoogste grondwaterstand</description><applications/></featureType><featureType><id>1267</id><name>38</name><description>Gemiddelde Laagste grondwaterstand</description><applications/></featureType><featureType><id>1268</id><name>39</name><description>Gemiddelde Voorjaars grondwaterstand</description><applications/></featureType><featureType><id>1269</id><name>40</name><description>Waterkansenkaart</description><applications/></featureType><featureType><id>1270</id><name>41</name><description>Waterkansenkaart klimaat 2050</description><applications/></featureType><featureType><id>1271</id><name>42</name><description>Grondwatertrappen</description><applications/></featureType><featureType><id>1272</id><name>43</name><description>Grondwatertrappen Historisch</description><applications/></featureType><featureType><id>1273</id><name>45</name><description>KRW stroomgebied indeling</description><applications/></featureType><featureType><id>1274</id><name>46</name><description>KRW grondwaterlichamen</description><applications/></featureType><featureType><id>1275</id><name>48</name><description>Stroomgebieden Substroom</description><applications/></featureType><featureType><id>1276</id><name>49</name><description>Stroomgebieden Deelstroom</description><applications/></featureType><featureType><id>1277</id><name>50</name><description>Uiterwaarden</description><applications/></featureType><featureType><id>1278</id><name>51</name><description>Stroomgebieden Hoofdstroom</description><applications/></featureType><featureType><id>1279</id><name>53</name><description>Waterberging</description><applications/></featureType><featureType><id>1280</id><name>54</name><description>Fluctuatiezones rivierkwel en grondwaterstand </description><applications/></featureType><featureType><id>1281</id><name>56</name><description>Natte landnatuur structuurvisie</description><applications/></featureType><featureType><id>1282</id><name>57</name><description>Gebieden met hoge grondwaterstand</description><applications/></featureType><featureType><id>1283</id><name>58</name><description>Basisfunctie functiekaart</description><applications/></featureType><featureType><id>1284</id><name>59</name><description>Optimaliseringsgebieden grondwateronttrekkingen</description><applications/></featureType><featureType><id>1285</id><name>60</name><description>Waterschapsgrenzen </description><applications/></featureType><featureType><id>1286</id><name>61</name><description>Provinciaal MeerJaren Programma</description><applications/></featureType></featureSource><featureSource><id>94</id><name>GelderlandOverviewmap</name><protocol>arcgis</protocol><url>http://ags101.prvgld.nl/arcgis/rest/services/Algemeen/GelderlandOverviewmap/MapServer</url><featureType><id>1294</id><name>0</name><description>Afdeklaag buiten Gelderland</description><applications/></featureType><featureType><id>1288</id><name>3</name><description>Gemeentegrenzen</description><applications/></featureType><featureType><id>1289</id><name>5</name><description>Plaatsnamen</description><applications/></featureType><featureType><id>1290</id><name>6</name><description>Infrastructuur3</description><applications/></featureType><featureType><id>1291</id><name>7</name><description>Infrastructuur2</description><applications/></featureType><featureType><id>1292</id><name>8</name><description>Infrastructuur</description><applications/></featureType><featureType><id>1293</id><name>9</name><description>Vlakken</description><applications/></featureType></featureSource><featureSource><id>95</id><name>Ondergrond_grijs</name><protocol>arcgis</protocol><url>http://ags101.prvgld.nl/arcgis/rest/services/Algemeen/Ondergrond_grijs/MapServer</url><featureType><id>1313</id><name>2</name><description>Provinciegrens Gelderland</description><applications/></featureType><featureType><id>1295</id><name>3</name><description>Afdeklaag buiten Gelderland</description><applications/></featureType><featureType><id>1296</id><name>4</name><description>Gemeenten</description><applications/></featureType><featureType><id>1297</id><name>5</name><description>Gemeentegrenzen_Gelderland</description><applications/></featureType><featureType><id>1298</id><name>8</name><description>Spoorbaan</description><applications/></featureType><featureType><id>1299</id><name>9</name><description>Hoogspanningsleidingen</description><applications/></featureType><featureType><id>1300</id><name>10</name><description>Straatnamen</description><applications/></featureType><featureType><id>1301</id><name>11</name><description>Huizen</description><applications/></featureType><featureType><id>1302</id><name>13</name><description>Wegvak uitgesplits</description><applications/></featureType><featureType><id>1303</id><name>14</name><description>Terrein</description><applications/></featureType><featureType><id>1304</id><name>15</name><description>Water</description><applications/></featureType><featureType><id>1305</id><name>17</name><description>Infrastructuur_1</description><applications/></featureType><featureType><id>1306</id><name>18</name><description>Infrastructuur_2</description><applications/></featureType><featureType><id>1307</id><name>19</name><description>Infrastructuur_3</description><applications/></featureType><featureType><id>1308</id><name>20</name><description>Bodemgebruik</description><applications/></featureType><featureType><id>1309</id><name>22</name><description>Infrastructuur</description><applications/></featureType><featureType><id>1310</id><name>23</name><description>Vlakken</description><applications/></featureType><featureType><id>1311</id><name>24</name><description>Plaatsnamen</description><applications/></featureType><featureType><id>1312</id><name>25</name><description>Bebouwde kommen</description><applications/></featureType></featureSource></featureSources></root>";
        String x="<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><featureSources><featureSource><id>2</id><name>Gemeentes (CBS 2010)</name><protocol>wfs</protocol><url>http://mapserver.openwion.nl/cgi-bin/mapserv?map=/srv/b3p-wion/maps/gemeentes_cbs_2010.map</url><featureType><id>1</id><name>gemeentes</name><description/><applications><application><id>3</id><name>ol</name><version>2</version><layers><layer><serviceId>2</serviceId><name>gemeentes</name><applayers><applayer><id>48</id><alias>gemeentes</alias></applayer></applayers></layer></layers></application><application><id>1</id><name>default</name><version/><layers><layer><serviceId>2</serviceId><name>gemeentes</name><applayers><applayer><id>3</id><alias>gemeentes</alias></applayer></applayers></layer></layers></application><application><id>5</id><name>ol</name><version>3</version><layers><layer><serviceId>2</serviceId><name>gemeentes</name><applayers><applayer><id>71</id><alias>gemeentes</alias></applayer></applayers></layer></layers></application><application><id>2</id><name>ol</name><version/><layers><layer><serviceId>2</serviceId><name>gemeentes</name><applayers><applayer><id>31</id><alias>gemeentes</alias></applayer></applayers></layer></layers></application><application><id>30</id><name>ol22</name><version/><layers><layer><serviceId>2</serviceId><name>gemeentes</name><applayers><applayer><id>443</id><alias>gemeentes</alias></applayer></applayers></layer></layers></application></applications></featureType></featureSource></featureSources></root>";
        ServiceUsageMatrixActionBean.createWorkBook(x);

    }

}
