/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.admin.monitoring;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import nl.b3p.mail.Mailer;
import nl.b3p.viewer.config.security.User;
import nl.b3p.viewer.config.services.GeoService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.stripesstuff.stripersist.Stripersist;

public class MonitorJob
implements Job,
InterruptableJob {
    private static final Log log = LogFactory.getLog(MonitorJob.class);
    private boolean interrupted = false;

    public void interrupt() throws UnableToInterruptJobException {
        log.info((Object)"Setting interrupt flag");
        this.interrupted = true;
    }

    private boolean isInterrupted() {
        return this.interrupted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext jec) throws JobExecutionException {
        try {
            Stripersist.requestInit();
            EntityManager em = Stripersist.getEntityManager();
            StringBuilder monitoringFailures = new StringBuilder();
            int online = 0;
            int offline = 0;
            for (GeoService gs : em.createQuery("from GeoService").getResultList()) {
                String debugMsg;
                block15: {
                    debugMsg = String.format("%s service %s (#%d) with URL: %s", gs.getProtocol(), gs.getName(), gs.getId(), gs.getUrl());
                    if (!this.isInterrupted()) break block15;
                    log.info((Object)"Interrupted, ending monitoring job");
                    return;
                }
                try {
                    gs.checkOnline(em);
                    ++online;
                    gs.setMonitoringStatusOK(true);
                    log.debug((Object)("ONLINE: " + debugMsg));
                }
                catch (Exception e) {
                    gs.setMonitoringStatusOK(false);
                    ++offline;
                    log.debug((Object)("OFFLINE: " + debugMsg));
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Exception", (Throwable)e);
                    }
                    String message = e.toString();
                    for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                        message = message + "; " + cause.toString();
                    }
                    monitoringFailures.append(String.format("%s service %s (#%d)\nURL: %s\nFout: %s\n\n", gs.getProtocol(), gs.getName(), gs.getId(), gs.getUrl(), message));
                }
            }
            em.getTransaction().commit();
            log.info((Object)String.format("Total services %d, online: %d, offline: %d, runtime: %d s", online + offline, online, offline, jec.getJobRunTime() / 1000L));
            if (offline > 0) {
                HashSet emails = new HashSet();
                for (User admin : em.createQuery("select u from User u join u.groups g where g.name = 'ServiceAdmin' ").getResultList()) {
                    emails.add(admin.getDetails().get("email"));
                }
                emails.remove(null);
                if (!emails.isEmpty()) {
                    StringBuilder mail = new StringBuilder();
                    SimpleDateFormat f = new SimpleDateFormat("dd-MM-yyy HH:mm:ss");
                    mail.append(String.format("Bij een controle op %s zijn in het gegevensregister %d services gevonden waarbij fouten zijn geconstateerd.\n\nDe volgende controle zal worden uitgevoerd op %s.\nHieronder staat de lijst met probleemservices:\n\n", f.format(jec.getFireTime()), offline, f.format(jec.getNextFireTime())));
                    mail.append((CharSequence)monitoringFailures);
                    this.mail(jec, emails, offline + " services zijn offline bij controle", mail.toString());
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error", (Throwable)e);
        }
        finally {
            Stripersist.requestComplete();
        }
    }

    private void mail(JobExecutionContext jec, Set emails, String subject, String mail) {
        try {
            log.info((Object)("Sending mail to service admins: " + Arrays.toString(emails.toArray())));
            for (String email : emails) {
                if (this.isInterrupted()) {
                    log.info((Object)"Interrupted, ending monitoring job");
                    return;
                }
                try {
                    Mailer.sendMail((String)((String)jec.getJobDetail().getJobDataMap().get((Object)"from.name")), (String)((String)jec.getJobDetail().getJobDataMap().get((Object)"from.email")), (String)email, (String)subject, (String)mail);
                }
                catch (Exception e) {
                    log.error((Object)("Error sending mail to service admin " + email), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error sending mail to service admins", (Throwable)e);
        }
    }
}

