/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.admin.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationError;
import nl.b3p.viewer.admin.stripes.ApplicationActionBean;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.app.ConfiguredAttribute;
import nl.b3p.viewer.config.services.AttributeDescriptor;
import nl.b3p.viewer.config.services.FeatureSource;
import nl.b3p.viewer.config.services.FeatureTypeRelation;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.config.services.StyleLibrary;
import nl.b3p.viewer.util.SelectedContentCache;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/applicationtreelayer")
@StrictBinding
@RolesAllowed(value={"Admin", "ApplicationAdmin"})
public class ApplicationTreeLayerActionBean
extends ApplicationActionBean {
    private static final String JSP = "/WEB-INF/jsp/application/applicationTreeLayer.jsp";
    @Validate
    private ApplicationLayer applicationLayer;
    @Validate
    private List<String> groupsRead = new ArrayList();
    @Validate
    private List<String> groupsWrite = new ArrayList();
    @Validate
    private Map<String, String> details = new HashMap();
    @Validate
    private List<String> selectedAttributes = new ArrayList();
    private Map<String, String> attributeAliases = new HashMap();
    private List<Map> styles = new ArrayList();
    private JSONObject stylesTitleJson = new JSONObject();
    private boolean editable;
    private Long appLayerFeatureType;
    @Validate
    private JSONArray attributesJSON = new JSONArray();
    @Validate(on={"getUniqueValues"})
    private String attribute;
    private String displayName;

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution(JSP);
    }

    @Before
    public void loadInfo() throws JSONException {
        Layer layer = this.applicationLayer.getService().getSingleLayer(this.applicationLayer.getLayerName());
        if (layer == null) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Laag niet gevonden bij originele service - verwijder deze laag uit niveau", new Object[0]));
            return;
        }
        for (StyleLibrary sld : layer.getService().getStyleLibraries()) {
            JSONObject sldNamedLayerJson;
            HashMap<String, String> style = new HashMap<String, String>();
            JSONObject styleTitleJson = new JSONObject();
            style.put("id", "sld:" + sld.getId());
            style.put("title", "SLD stijl: " + sld.getTitle() + (sld.isDefaultStyle() ? " (standaard)" : ""));
            if (sld.getNamedLayerUserStylesJson() != null && (sldNamedLayerJson = new JSONObject(sld.getNamedLayerUserStylesJson())).has(layer.getName())) {
                JSONObject userStyle;
                JSONArray userStyles;
                JSONObject namedLayer = sldNamedLayerJson.getJSONObject(layer.getName());
                if (namedLayer.has("title")) {
                    styleTitleJson.put("namedLayerTitle", namedLayer.get("title"));
                }
                if ((userStyles = namedLayer.getJSONArray("styles")).length() > 0 && (userStyle = userStyles.getJSONObject(0)).has("title")) {
                    styleTitleJson.put("styleTitle", userStyle.get("title"));
                }
            }
            this.styles.add(style);
            this.stylesTitleJson.put((String)style.get("id"), (Object)styleTitleJson);
        }
        if (layer.getDetails().containsKey("wms.styles")) {
            JSONArray wmsStyles = new JSONArray(((ClobElement)layer.getDetails().get("wms.styles")).getValue());
            for (int i = 0; i < wmsStyles.length(); ++i) {
                JSONObject wmsStyle = wmsStyles.getJSONObject(i);
                HashMap<String, String> style = new HashMap<String, String>();
                style.put("id", "wms:" + wmsStyle.getString("name"));
                style.put("title", "WMS server stijl: " + wmsStyle.getString("name") + (wmsStyle.has("title") ? " (" + wmsStyle.getString("title") + ")" : ""));
                JSONObject styleTitleJson = new JSONObject();
                styleTitleJson.put("styleTitle", (Object)(wmsStyle.has("title") ? wmsStyle.getString("title") : wmsStyle.getString("name")));
                this.styles.add(style);
                this.stylesTitleJson.put((String)style.get("id"), (Object)styleTitleJson);
            }
        }
        if (!this.styles.isEmpty()) {
            ArrayList temp = new ArrayList();
            HashMap<String, String> s = new HashMap<String, String>();
            s.put("id", "registry_default");
            s.put("title", "In gegevensregister als standaard ingestelde SLD");
            temp.add(s);
            s = new HashMap();
            s.put("id", "none");
            s.put("title", "Geen: standaard stijl van WMS service zelf");
            temp.add(s);
            temp.addAll(this.styles);
            this.styles = temp;
        }
        if (layer.getFeatureType() != null && !layer.getFeatureType().getAttributes().isEmpty()) {
            SimpleFeatureType sft = layer.getFeatureType();
            this.editable = sft.isWriteable();
            this.appLayerFeatureType = sft.getId();
        }
    }

    @Before
    public void synchronizeFeatureType() throws JSONException {
        Layer layer = this.applicationLayer.getService().getSingleLayer(this.applicationLayer.getLayerName());
        if (layer.getFeatureType() == null || layer.getFeatureType().getAttributes().isEmpty()) {
            this.applicationLayer.getAttributes().clear();
        } else {
            List attributesToRetain = new ArrayList();
            SimpleFeatureType sft = layer.getFeatureType();
            attributesToRetain = this.rebuildAttributes(sft);
            ArrayList<ConfiguredAttribute> attributesToRemove = new ArrayList<ConfiguredAttribute>();
            for (ConfiguredAttribute ca : this.applicationLayer.getAttributes()) {
                if (ca.getFeatureType() == null) {
                    ca.setFeatureType(layer.getFeatureType());
                }
                if (attributesToRetain.contains(ca.getFullName())) continue;
                attributesToRemove.add(ca);
                if ("save".equals(this.getContext().getEventName())) continue;
                this.getContext().getMessages().add(new SimpleMessage("Attribuut \"{0}\" niet meer beschikbaar in attribuutbron: wordt verwijderd na opslaan", new Object[]{ca.getAttributeName()}));
            }
            for (ConfiguredAttribute ca : attributesToRemove) {
                this.applicationLayer.getAttributes().remove(ca);
                Stripersist.getEntityManager().remove((Object)ca);
            }
            this.makeAttributeJSONArray(layer.getFeatureType());
        }
    }

    @DontValidate
    public Resolution edit() throws JSONException {
        if (this.applicationLayer != null) {
            this.details = new HashMap();
            for (Map.Entry e : this.applicationLayer.getDetails().entrySet()) {
                this.details.put(e.getKey(), ((ClobElement)e.getValue()).getValue());
            }
            this.groupsRead.addAll(this.applicationLayer.getReaders());
            this.groupsWrite.addAll(this.applicationLayer.getWriters());
            for (ConfiguredAttribute ca : this.applicationLayer.getAttributes()) {
                if (!ca.isVisible()) continue;
                this.selectedAttributes.add(ca.getFullName());
            }
        }
        return new ForwardResolution(JSP);
    }

    private List<String> rebuildAttributes(SimpleFeatureType sft) {
        Layer layer = this.applicationLayer.getService().getSingleLayer(this.applicationLayer.getLayerName());
        ArrayList<String> attributesToRetain = new ArrayList<String>();
        for (AttributeDescriptor ad : sft.getAttributes()) {
            String name = ad.getName();
            String fullName = sft.getId() + ":" + name;
            if (attributesToRetain.contains(fullName)) {
                return attributesToRetain;
            }
            attributesToRetain.add(fullName);
            if (StringUtils.isNotBlank((CharSequence)ad.getAlias())) {
                this.attributeAliases.put(fullName, ad.getAlias());
            }
            if (this.applicationLayer.getAttribute(sft, name) != null) continue;
            ConfiguredAttribute ca = new ConfiguredAttribute();
            boolean defaultVisible = true;
            if (layer.getFeatureType().getId() != sft.getId() || AttributeDescriptor.GEOMETRY_TYPES.contains(ad.getType())) {
                defaultVisible = false;
            }
            ca.setVisible(defaultVisible);
            ca.setAttributeName(name);
            ca.setFeatureType(sft);
            this.applicationLayer.getAttributes().add(ca);
            Stripersist.getEntityManager().persist((Object)ca);
            if ("save".equals(this.getContext().getEventName())) continue;
            String message = "Nieuw attribuut \"{0}\" gevonden in ";
            if (layer.getFeatureType().getId() != sft.getId()) {
                message = message + "gekoppelde ";
            }
            message = message + "attribuutbron";
            if (layer.getFeatureType().getId() == sft.getId()) {
                message = message + ": wordt zichtbaar na opslaan";
            }
            this.getContext().getMessages().add(new SimpleMessage(message, new Object[]{name}));
        }
        if (sft.getRelations() != null) {
            for (FeatureTypeRelation rel : sft.getRelations()) {
                attributesToRetain.addAll(this.rebuildAttributes(rel.getForeignFeatureType()));
            }
        }
        return attributesToRetain;
    }

    private void sortPerFeatureType(SimpleFeatureType layerSft, List<ConfiguredAttribute> cas) {
        List relations = layerSft.getRelations();
        for (FeatureTypeRelation relation : relations) {
            SimpleFeatureType foreign = relation.getForeignFeatureType();
            this.sortPerFeatureType(foreign, cas);
        }
        Collections.sort(cas, new /* Unavailable Anonymous Inner Class!! */);
    }

    public Resolution attributes() throws JSONException {
        this.attributesJSON = new JSONArray();
        Layer layer = this.applicationLayer.getService().getSingleLayer(this.applicationLayer.getLayerName());
        this.makeAttributeJSONArray(layer.getFeatureType());
        return new StreamingResolution("application/json", (Reader)new StringReader(this.attributesJSON.toString()));
    }

    private void makeAttributeJSONArray(SimpleFeatureType layerSft) throws JSONException {
        List cas = this.applicationLayer.getAttributes();
        Collections.sort(cas, new /* Unavailable Anonymous Inner Class!! */);
        if (layerSft != null) {
            this.sortPerFeatureType(layerSft, cas);
        }
        for (ConfiguredAttribute ca : cas) {
            JSONObject j = ca.toJSONObject();
            SimpleFeatureType sft = ca.getFeatureType();
            if (sft == null) {
                sft = layerSft;
            }
            AttributeDescriptor ad = sft.getAttribute(ca.getAttributeName());
            j.put("alias", (Object)ad.getAlias());
            j.put("featureTypeAttribute", (Object)ad.toJSONObject());
            this.attributesJSON.put((Object)j);
        }
    }

    public Resolution getUniqueValues() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        try {
            Layer layer = this.applicationLayer.getService().getSingleLayer(this.applicationLayer.getLayerName());
            if (layer != null && layer.getFeatureType() != null) {
                SimpleFeatureType sft = layer.getFeatureType();
                List beh = sft.calculateUniqueValues(this.attribute);
                json.put("uniqueValues", (Object)new JSONArray((Collection)beh));
                json.put("success", (Object)Boolean.TRUE);
            }
        }
        catch (Exception e) {
            json.put("msg", (Object)e.toString());
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    public Resolution save() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        this.applicationLayer.getDetails().keySet().removeAll(Arrays.asList("titleAlias", "legendImageUrl", "transparency", "influenceradius", "summary.title", "summary.image", "summary.texteditor", "summary.description", "summary.link", "editfunction.title", "style", "summary.noHtmlEncode", "summary.nl2br", "editfeature.usernameAttribute"));
        for (Map.Entry e : this.details.entrySet()) {
            if (e.getValue() == null) continue;
            this.applicationLayer.getDetails().put(e.getKey(), new ClobElement((String)e.getValue()));
        }
        this.applicationLayer.getReaders().clear();
        for (String groupName : this.groupsRead) {
            this.applicationLayer.getReaders().add(groupName);
        }
        this.applicationLayer.getWriters().clear();
        for (String groupName : this.groupsWrite) {
            this.applicationLayer.getWriters().add(groupName);
        }
        if (this.applicationLayer.getAttributes() != null && this.applicationLayer.getAttributes().size() > 0) {
            List appAttributes = this.applicationLayer.getAttributes();
            int i = 0;
            for (ConfiguredAttribute appAttribute : appAttributes) {
                if (this.selectedAttributes.contains(appAttribute.getFullName())) {
                    appAttribute.setVisible(true);
                } else {
                    appAttribute.setVisible(false);
                }
                if (this.attributesJSON.length() > i) {
                    Long id;
                    JSONObject attribute = this.attributesJSON.getJSONObject(i);
                    if (attribute.has("editable")) {
                        appAttribute.setEditable(new Boolean(attribute.get("editable").toString()).booleanValue());
                    }
                    if (attribute.has("editAlias")) {
                        appAttribute.setEditAlias(attribute.get("editAlias").toString());
                    }
                    if (attribute.has("editvalues")) {
                        appAttribute.setEditValues(attribute.get("editvalues").toString());
                    }
                    if (attribute.has("editHeight")) {
                        appAttribute.setEditHeight(attribute.get("editHeight").toString());
                    }
                    if (attribute.has("selectable")) {
                        appAttribute.setSelectable(new Boolean(attribute.get("selectable").toString()).booleanValue());
                    }
                    if (attribute.has("filterable")) {
                        appAttribute.setFilterable(new Boolean(attribute.get("filterable").toString()).booleanValue());
                    }
                    if (attribute.has("defaultValue")) {
                        appAttribute.setDefaultValue(attribute.get("defaultValue").toString());
                    }
                    if (attribute.has("valueListFeatureSource") && !attribute.isNull("valueListFeatureSource")) {
                        id = attribute.getLong("valueListFeatureSource");
                        FeatureSource fs = (FeatureSource)em.find(FeatureSource.class, (Object)id);
                        appAttribute.setValueListFeatureSource(fs);
                    }
                    if (attribute.has("valueListFeatureType") && !attribute.isNull("valueListFeatureType")) {
                        id = attribute.getLong("valueListFeatureType");
                        SimpleFeatureType ft = (SimpleFeatureType)em.find(SimpleFeatureType.class, (Object)id);
                        appAttribute.setValueListFeatureType(ft);
                    }
                    if (attribute.has("valueListValueAttribute") && !attribute.isNull("valueListValueAttribute")) {
                        appAttribute.setValueListValueName(attribute.getString("valueListValueAttribute"));
                    }
                    if (attribute.has("valueListLabelAttribute") && !attribute.isNull("valueListLabelAttribute")) {
                        appAttribute.setValueListLabelName(attribute.getString("valueListLabelAttribute"));
                    }
                    if (attribute.has("valueList") && !attribute.isNull("valueList")) {
                        appAttribute.setValueList(attribute.getString("valueList"));
                    }
                    if (attribute.has("allowValueListOnly")) {
                        appAttribute.setAllowValueListOnly(new Boolean(attribute.get("allowValueListOnly").toString()).booleanValue());
                    }
                    if (attribute.has("disallowNullValue")) {
                        appAttribute.setDisallowNullValue(new Boolean(attribute.get("disallowNullValue").toString()).booleanValue());
                    }
                    if (attribute.has("disableUserEdit")) {
                        appAttribute.setDisableUserEdit(new Boolean(attribute.get("disableUserEdit").toString()).booleanValue());
                    }
                }
                ++i;
            }
        }
        em.persist((Object)this.applicationLayer);
        this.application.authorizationsModified();
        this.displayName = this.applicationLayer.getDisplayName(em);
        SelectedContentCache.setApplicationCacheDirty((Application)this.application, (Boolean)true, (Boolean)false, (EntityManager)em);
        em.getTransaction().commit();
        this.attributesJSON = new JSONArray();
        Layer layer = this.applicationLayer.getService().getSingleLayer(this.applicationLayer.getLayerName());
        this.makeAttributeJSONArray(layer.getFeatureType());
        this.getContext().getMessages().add(new SimpleMessage("De kaartlaag is opgeslagen", new Object[0]));
        return this.edit();
    }

    public ApplicationLayer getApplicationLayer() {
        return this.applicationLayer;
    }

    public void setApplicationLayer(ApplicationLayer applicationLayer) {
        this.applicationLayer = applicationLayer;
    }

    public Map<String, String> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, String> details) {
        this.details = details;
    }

    public List<String> getSelectedAttributes() {
        return this.selectedAttributes;
    }

    public void setSelectedAttributes(List<String> selectedAttributes) {
        this.selectedAttributes = selectedAttributes;
    }

    public JSONArray getAttributesJSON() {
        return this.attributesJSON;
    }

    public void setAttributesJSON(JSONArray attributesJSON) {
        this.attributesJSON = attributesJSON;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public List<String> getGroupsWrite() {
        return this.groupsWrite;
    }

    public void setGroupsWrite(List<String> groupsWrite) {
        this.groupsWrite = groupsWrite;
    }

    public List<String> getGroupsRead() {
        return this.groupsRead;
    }

    public void setGroupsRead(List<String> groupsRead) {
        this.groupsRead = groupsRead;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public Map<String, String> getAttributeAliases() {
        return this.attributeAliases;
    }

    public void setAttributeAliases(Map<String, String> attributeAliases) {
        this.attributeAliases = attributeAliases;
    }

    public List<Map> getStyles() {
        return this.styles;
    }

    public void setStyles(List<Map> styles) {
        this.styles = styles;
    }

    public JSONObject getStylesTitleJson() {
        return this.stylesTitleJson;
    }

    public void setStylesTitleJson(JSONObject stylesTitleJson) {
        this.stylesTitleJson = stylesTitleJson;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Long getAppLayerFeatureType() {
        return this.appLayerFeatureType;
    }

    public void setAppLayerFeatureType(Long appLayerFeatureType) {
        this.appLayerFeatureType = appLayerFeatureType;
    }
}

