/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.admin.stripes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.security.Group;
import nl.b3p.viewer.config.services.GeoService;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.util.SelectedContentCache;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/layer")
@StrictBinding
@RolesAllowed(value={"Admin", "RegistryAdmin"})
public class LayerActionBean
implements ActionBean {
    private static final String JSP = "/WEB-INF/jsp/services/layer.jsp";
    private ActionBeanContext context;
    @Validate
    @ValidateNestedProperties(value={@Validate(field="titleAlias", label="Naam"), @Validate(field="legendImageUrl", label="Legenda"), @Validate(field="exception_type")})
    private Layer layer;
    @Validate
    private String parentId;
    private List<Group> allGroups;
    private SortedSet<String> applicationsUsedIn = new TreeSet();
    @Validate
    private List<String> groupsRead = new ArrayList();
    @Validate
    private List<String> groupsWrite = new ArrayList();
    @Validate
    private List<String> groupsPreventGeomEdit = new ArrayList();
    @Validate
    private Map<String, String> details = new HashMap();
    @Validate
    private SimpleFeatureType simpleFeatureType;
    @Validate
    private Long featureSourceId;
    private List featureSources;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public Map<String, String> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, String> details) {
        this.details = details;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public List<Group> getAllGroups() {
        return this.allGroups;
    }

    public void setAllGroups(List<Group> allGroups) {
        this.allGroups = allGroups;
    }

    public List<String> getGroupsRead() {
        return this.groupsRead;
    }

    public void setGroupsRead(List<String> groupsRead) {
        this.groupsRead = groupsRead;
    }

    public List<String> getGroupsWrite() {
        return this.groupsWrite;
    }

    public void setGroupsWrite(List<String> groupsWrite) {
        this.groupsWrite = groupsWrite;
    }

    public List<String> getGroupsPreventGeomEdit() {
        return this.groupsPreventGeomEdit;
    }

    public void setGroupsPreventGeomEdit(List<String> groupsPreventGeomEdit) {
        this.groupsPreventGeomEdit = groupsPreventGeomEdit;
    }

    public SortedSet<String> getApplicationsUsedIn() {
        return this.applicationsUsedIn;
    }

    public void setApplicationsUsedIn(SortedSet<String> applicationsUsedIn) {
        this.applicationsUsedIn = applicationsUsedIn;
    }

    public SimpleFeatureType getSimpleFeatureType() {
        return this.simpleFeatureType;
    }

    public void setSimpleFeatureType(SimpleFeatureType simpleFeatureType) {
        this.simpleFeatureType = simpleFeatureType;
    }

    public Long getFeatureSourceId() {
        return this.featureSourceId;
    }

    public void setFeatureSourceId(Long featureSourceId) {
        this.featureSourceId = featureSourceId;
    }

    public List getFeatureSources() {
        return this.featureSources;
    }

    public void setFeatureSources(List featureSources) {
        this.featureSources = featureSources;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Before(stages={LifecycleStage.BindingAndValidation})
    public void load() {
        this.allGroups = Stripersist.getEntityManager().createQuery("from Group").getResultList();
        this.featureSources = Stripersist.getEntityManager().createQuery("from FeatureSource").getResultList();
    }

    @DefaultHandler
    public Resolution edit() {
        if (this.layer != null) {
            this.details = new HashMap();
            for (Map.Entry e : this.layer.getDetails().entrySet()) {
                this.details.put(e.getKey(), ((ClobElement)e.getValue()).getValue());
            }
            this.groupsRead.addAll(this.layer.getReaders());
            this.groupsWrite.addAll(this.layer.getWriters());
            this.groupsPreventGeomEdit.addAll(this.layer.getPreventGeomEditors());
            if (this.layer.getFeatureType() != null) {
                this.simpleFeatureType = this.layer.getFeatureType();
                this.featureSourceId = this.simpleFeatureType.getFeatureSource().getId();
            }
            this.findApplicationsUsedIn();
        }
        return new ForwardResolution(JSP);
    }

    private void findApplicationsUsedIn() {
        List applications = this.findApplications();
        for (Application application : applications) {
            this.applicationsUsedIn.add(application.getNameWithVersion());
        }
    }

    private List<Application> findApplications() {
        ArrayList<Application> apps = new ArrayList<Application>();
        GeoService service = this.layer.getService();
        String layerName = this.layer.getName();
        List applicationLayers = Stripersist.getEntityManager().createQuery("from ApplicationLayer where service = :service and layerName = :layerName").setParameter("service", (Object)service).setParameter("layerName", (Object)layerName).getResultList();
        for (ApplicationLayer appLayer : applicationLayers) {
            List applications = Stripersist.getEntityManager().createQuery("from Application").getResultList();
            for (Application app : applications) {
                if (!app.getRoot().containsLayerInSubtree(appLayer)) continue;
                apps.add(app);
            }
        }
        return apps;
    }

    public Resolution save() {
        this.layer.getDetails().keySet().removeAll(Arrays.asList("metadata.stylesheet", "download.url", "filterable", "alternateLegendImageUrl"));
        for (Map.Entry e : this.details.entrySet()) {
            if (e.getValue() == null) continue;
            this.layer.getDetails().put(e.getKey(), new ClobElement((String)e.getValue()));
        }
        this.layer.getReaders().clear();
        for (String groupName : this.groupsRead) {
            this.layer.getReaders().add(groupName);
        }
        this.layer.getWriters().clear();
        for (String groupName : this.groupsWrite) {
            this.layer.getWriters().add(groupName);
        }
        this.layer.getPreventGeomEditors().clear();
        for (String groupName : this.groupsPreventGeomEdit) {
            this.layer.getPreventGeomEditors().add(groupName);
        }
        this.layer.setFeatureType(this.simpleFeatureType);
        Stripersist.getEntityManager().persist((Object)this.layer);
        this.layer.getService().authorizationsModified();
        List apps = this.findApplications();
        EntityManager em = Stripersist.getEntityManager();
        for (Application application : apps) {
            SelectedContentCache.setApplicationCacheDirty((Application)application, (Boolean)true, (Boolean)false, (EntityManager)em);
        }
        Stripersist.getEntityManager().getTransaction().commit();
        this.getContext().getMessages().add(new SimpleMessage("De kaartlaag is opgeslagen", new Object[0]));
        return new ForwardResolution(JSP);
    }
}

