/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.admin.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.config.services.Category;
import nl.b3p.viewer.config.services.GeoService;
import nl.b3p.viewer.config.services.Layer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/geoserviceregistry")
@StrictBinding
@RolesAllowed(value={"Admin", "RegistryAdmin"})
public class GeoServiceRegistryActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(GeoServiceRegistryActionBean.class);
    private static final String JSP = "/WEB-INF/jsp/services/geoserviceregistry.jsp";
    private ActionBeanContext context;
    @Validate
    private String nodeId;
    @Validate
    private String name;
    private Category category;

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    @DefaultHandler
    public Resolution view() {
        this.category = Category.getRootCategory();
        return new ForwardResolution(JSP);
    }

    @After(on={"addSubcategory", "saveCategory", "removeCategory"}, stages={LifecycleStage.BindingAndValidation})
    public void loadCategory() {
        EntityManager em = Stripersist.getEntityManager();
        if (this.nodeId != null) {
            Long id = this.nodeId.equals("0") ? Long.valueOf(0L) : Long.valueOf(Long.parseLong(this.nodeId.substring(1)));
            this.category = (Category)em.find(Category.class, (Object)id);
        }
    }

    private String checkCategoryAndNameError() {
        if (this.category == null) {
            return "Categorie niet gevonden";
        }
        if (this.name == null) {
            return "Naam is niet ingevuld";
        }
        return null;
    }

    public Resolution addSubcategory() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        String error = this.checkCategoryAndNameError();
        if (error == null) {
            for (Category child : this.category.getChildren()) {
                if (!this.name.equals(child.getName())) continue;
                error = "Categorie met dezelfde naam bestaat al";
            }
        }
        if (error == null) {
            try {
                Category c = new Category();
                c.setName(this.name);
                c.setParent(this.category);
                this.category.getChildren().add(c);
                em.persist((Object)c);
                em.getTransaction().commit();
                JSONObject node = new JSONObject();
                node.put("id", (Object)("c" + c.getId()));
                node.put("name", (Object)c.getName());
                node.put("type", (Object)"category");
                node.put("isLeaf", true);
                node.put("parentid", (Object)this.nodeId);
                json.put("node", (Object)node);
                json.put("success", (Object)Boolean.TRUE);
            }
            catch (Exception e) {
                log.error((Object)"Fout bij toevoegen categorie", (Throwable)e);
                error = "Kan categorie niet toevoegen: " + e;
                Throwable t = e;
                while (t.getCause() != null) {
                    t = t.getCause();
                    error = error + "; " + t;
                }
            }
        }
        if (error != null) {
            json.put("error", (Object)error);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    public Resolution saveCategory() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        String error = this.checkCategoryAndNameError();
        if (error == null && this.category.getParent() != null) {
            for (Category sibling : this.category.getParent().getChildren()) {
                if (sibling == this.category || !this.name.equals(sibling.getName())) continue;
                error = "Categorie met dezelfde naam bestaat al";
            }
        }
        if (error == null) {
            try {
                this.category.setName(this.name);
                Stripersist.getEntityManager().getTransaction().commit();
                json.put("success", (Object)Boolean.TRUE);
                json.put("name", (Object)this.category.getName());
            }
            catch (Exception e) {
                log.error((Object)"Fout bij wijzigen naam categorie", (Throwable)e);
                error = "Kan naam niet wijzigen: " + e;
                Throwable t = e;
                while (t.getCause() != null) {
                    t = t.getCause();
                    error = error + "; " + t;
                }
            }
        }
        if (error != null) {
            json.put("error", (Object)error);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    public Resolution removeCategory() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        String error = null;
        if (this.category == null) {
            error = "Categorie niet gevonden";
        } else if (this.category.getParent() == null) {
            error = "Bovenste categorie kan niet worden verwijderd";
        } else if (this.category.getChildren().size() > 0) {
            error = "De categorie bevat nog andere categorie\u00ebn en kan niet verwijderd worden";
        } else if (this.category.getServices().size() > 0) {
            error = "De categorie bevat services en kan niet verwijderd worden";
        }
        if (error == null) {
            try {
                Category p = this.category.getParent();
                p.getChildren().remove(this.category);
                Stripersist.getEntityManager().remove((Object)this.category);
                Stripersist.getEntityManager().getTransaction().commit();
                json.put("success", (Object)Boolean.TRUE);
            }
            catch (Exception e) {
                log.error((Object)"Fout verwijderen categorie", (Throwable)e);
                error = "Kan categorie niet verwijderen: " + e;
                Throwable t = e;
                while (t.getCause() != null) {
                    t = t.getCause();
                    error = error + "; " + t;
                }
            }
        }
        if (error != null) {
            json.put("error", (Object)error);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    public Resolution tree() throws JSONException {
        GeoService gs;
        JSONObject j;
        EntityManager em = Stripersist.getEntityManager();
        JSONArray children = new JSONArray();
        String type = this.nodeId.substring(0, 1);
        int id = Integer.parseInt(this.nodeId.substring(1));
        if (type.equals("c")) {
            Category c = (Category)em.find(Category.class, (Object)new Long(id));
            for (Category sub : c.getChildren()) {
                j = new JSONObject();
                j.put("id", (Object)("c" + sub.getId()));
                j.put("name", (Object)sub.getName());
                j.put("type", (Object)"category");
                j.put("isLeaf", sub.getChildren().isEmpty() && sub.getServices().isEmpty());
                if (sub.getParent() != null) {
                    j.put("parentid", (Object)sub.getParent().getId());
                }
                children.put((Object)j);
            }
            for (Object service : c.getServices()) {
                j = new JSONObject();
                j.put("id", (Object)("s" + service.getId()));
                j.put("name", (Object)service.getName());
                j.put("type", (Object)"service");
                j.put("isLeaf", service.getTopLayer() == null);
                j.put("status", (Object)(service.isMonitoringStatusOK() ? "ok" : "error"));
                j.put("parentid", (Object)this.nodeId);
                children.put((Object)j);
            }
        } else if (type.equals("s") && (gs = (GeoService)em.find(GeoService.class, (Object)new Long(id))).getTopLayer() != null) {
            List layers = !gs.getTopLayer().isVirtual() ? Collections.singletonList(gs.getTopLayer()) : gs.getTopLayer().getChildren();
            for (Layer sublayer : layers) {
                JSONObject j2 = new JSONObject();
                j2.put("id", (Object)("l" + sublayer.getId()));
                if (sublayer.getTitleAlias() != null) {
                    j2.put("name", (Object)sublayer.getTitleAlias());
                } else if (sublayer.getTitle() != null) {
                    j2.put("name", (Object)sublayer.getTitle());
                } else {
                    j2.put("name", (Object)sublayer.getName());
                }
                j2.put("type", (Object)"layer");
                j2.put("isLeaf", sublayer.getChildren().isEmpty());
                j2.put("parentid", (Object)this.nodeId);
                j2.put("isVirtual", sublayer.isVirtual());
                children.put((Object)j2);
            }
        }
        if (type.equals("l")) {
            Layer layer = (Layer)em.find(Layer.class, (Object)new Long(id));
            for (Layer sublayer : layer.getChildren()) {
                j = new JSONObject();
                j.put("id", (Object)("l" + sublayer.getId()));
                if (sublayer.getTitleAlias() != null) {
                    j.put("name", (Object)sublayer.getTitleAlias());
                } else if (sublayer.getTitle() != null) {
                    j.put("name", (Object)sublayer.getTitle());
                } else {
                    j.put("name", (Object)sublayer.getName());
                }
                j.put("type", (Object)"layer");
                j.put("isLeaf", sublayer.getChildren().isEmpty());
                j.put("parentid", (Object)this.nodeId);
                j.put("isVirtual", sublayer.isVirtual());
                children.put((Object)j);
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

