/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.admin.stripes;

import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.persistence.NoResultException;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontBind;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import nl.b3p.viewer.config.app.Level;
import nl.b3p.viewer.config.security.Group;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@StrictBinding
@UrlBinding(value="/action/group/{$event}/{service}")
@RolesAllowed(value={"Admin", "UserAdmin"})
public class GroupActionBean
implements ActionBean {
    private static final String JSP = "/WEB-INF/jsp/security/group.jsp";
    private static final String EDITJSP = "/WEB-INF/jsp/security/editgroup.jsp";
    private ActionBeanContext context;
    @Validate
    private int page;
    @Validate
    private int start;
    @Validate
    private int limit;
    @Validate
    private String sort;
    @Validate
    private String dir;
    @Validate
    private JSONArray filter;
    @Validate
    private Group group;
    @Validate
    private String name;
    @Validate
    private String description;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public JSONArray getFilter() {
        return this.filter;
    }

    public void setFilter(JSONArray filter) {
        this.filter = filter;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    @DefaultHandler
    @HandlesEvent(value="default")
    @DontValidate
    public Resolution defaultResolution() {
        return new ForwardResolution(JSP);
    }

    @DontValidate
    public Resolution edit() {
        if (this.group != null) {
            this.name = this.group.getName();
            this.description = this.group.getDescription();
        }
        return new ForwardResolution(EDITJSP);
    }

    @DontBind
    public Resolution cancel() {
        return new ForwardResolution(EDITJSP);
    }

    public Resolution save() {
        if (this.group == null) {
            this.group = new Group();
            this.group.setName(this.name);
            this.group.setDescription(this.description);
        } else {
            this.group.setDescription(this.description);
        }
        Stripersist.getEntityManager().persist((Object)this.group);
        Stripersist.getEntityManager().getTransaction().commit();
        this.getContext().getMessages().add(new SimpleMessage("Gebruikersgroep is opgeslagen", new Object[0]));
        return new ForwardResolution(EDITJSP);
    }

    @ValidationMethod(on={"save"})
    public void validate(ValidationErrors errors) throws Exception {
        if (this.group == null) {
            if (this.name == null) {
                errors.add("name", (ValidationError)new SimpleError("Naam is verplicht", new Object[0]));
                return;
            }
            try {
                Object o = Stripersist.getEntityManager().createQuery("select 1 from Group where name = :name").setMaxResults(1).setParameter("name", (Object)this.name).getSingleResult();
                errors.add("name", (ValidationError)new SimpleError("Naam moet uniek zijn", new Object[0]));
                return;
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
        }
    }

    @DontValidate
    public Resolution delete() {
        if (!this.group.getMembers().isEmpty()) {
            this.getContext().getValidationErrors().add("group", (ValidationError)new SimpleError("De groep kan niet worden verwijderd omdat deze nog gebruikers heeft.", new Object[0]));
            return new ForwardResolution(EDITJSP);
        }
        if (this.groupInUse()) {
            this.getContext().getValidationErrors().add("group", (ValidationError)new SimpleError("De groep kan niet worden verwijderd omdat deze nog in gebruik is.", new Object[0]));
            return new ForwardResolution(EDITJSP);
        }
        Stripersist.getEntityManager().remove((Object)this.group);
        Stripersist.getEntityManager().getTransaction().commit();
        this.getContext().getMessages().add(new SimpleMessage("Gebruikersgroep is verwijderd", new Object[0]));
        return new ForwardResolution(EDITJSP);
    }

    @DontValidate
    public Resolution getGridData() throws JSONException {
        JSONArray jsonData = new JSONArray();
        String filterName = "";
        String filterDescription = "";
        if (this.getFilter() != null) {
            for (int k = 0; k < this.getFilter().length(); ++k) {
                JSONObject j = this.getFilter().getJSONObject(k);
                String property = j.getString("property");
                String value = j.getString("value");
                if (property.equals("name")) {
                    filterName = value;
                }
                if (!property.equals("description")) continue;
                filterDescription = value;
            }
        }
        Session sess = (Session)Stripersist.getEntityManager().getDelegate();
        Criteria c = sess.createCriteria(Group.class);
        if (this.sort != null && this.dir != null) {
            Order order = null;
            order = this.dir.equals("ASC") ? Order.asc((String)this.sort) : Order.desc((String)this.sort);
            order.ignoreCase();
            c.addOrder(order);
        }
        if (filterName != null && filterName.length() > 0) {
            Criterion nameCrit = Restrictions.ilike((String)"name", (String)filterName, (MatchMode)MatchMode.ANYWHERE);
            c.add(nameCrit);
        }
        if (filterDescription != null && filterDescription.length() > 0) {
            Criterion urlCrit = Restrictions.ilike((String)"description", (String)filterDescription, (MatchMode)MatchMode.ANYWHERE);
            c.add(urlCrit);
        }
        int rowCount = c.list().size();
        c.setMaxResults(this.limit);
        c.setFirstResult(this.start);
        List groups = c.list();
        for (Group gr : groups) {
            JSONObject j = this.getGridRow(gr.getName(), gr.getDescription());
            jsonData.put((Object)j);
        }
        JSONObject grid = new JSONObject();
        grid.put("totalCount", rowCount);
        grid.put("gridrows", (Object)jsonData);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private boolean groupInUse() {
        boolean inUse = false;
        List levels = Stripersist.getEntityManager().createQuery("from Level").getResultList();
        for (Level level : levels) {
            if (!level.getReaders().contains(this.group.getName())) continue;
            inUse = true;
            break;
        }
        return inUse;
    }

    private JSONObject getGridRow(String name, String description) throws JSONException {
        JSONObject j = new JSONObject();
        j.put("name", (Object)name);
        j.put("description", (Object)description);
        if (Group.DEFAULT_GROUPS.contains(name)) {
            j.put("editable", false);
        } else {
            j.put("editable", true);
        }
        return j;
    }
}

