/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.admin.stripes;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.util.HtmlUtil;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.admin.stripes.ApplicationActionBean;
import nl.b3p.viewer.config.app.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/imageupload")
@StrictBinding
@RolesAllowed(value={"Admin", "ApplicationAdmin"})
public class ImageUploadActionBean
extends ApplicationActionBean {
    private static final Log log = LogFactory.getLog(ImageUploadActionBean.class);
    private static final String IMAGE_ACTIONBEAN_URL = "/action/image/";
    private static final String VIEWER_URL_PARAM = "viewer.url";
    @Validate
    private FileBean upload;
    @Validate
    private String action;
    @Validate
    private Integer page;
    @Validate
    private Integer start;
    @Validate
    private Integer limit;
    @Validate
    private String image;

    public FileBean getUpload() {
        return this.upload;
    }

    public void setUpload(FileBean upload) {
        this.upload = upload;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getStart() {
        return this.start;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    private String url(Resource r) {
        return this.getContext().getServletContext().getInitParameter(VIEWER_URL_PARAM) + IMAGE_ACTIONBEAN_URL + r.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DefaultHandler
    public Resolution upload() throws JSONException {
        JSONObject j = new JSONObject();
        j.put("success", false);
        j.put("message", (Object)"Fout");
        if (this.upload == null) {
            j.put("errors", (Object)"Upload is null");
        } else if (Stripersist.getEntityManager().find(Resource.class, (Object)this.upload.getFileName()) != null) {
            j.put("errors", (Object)"Afbeelding met dezelfde naam bestaat al. Kies een andere naam of verwijder eerst de oude afbeelding.");
        } else {
            try {
                Resource r = new Resource();
                r.setName(this.upload.getFileName());
                r.setContentType(this.upload.getContentType());
                r.setDataContent(this.upload.getInputStream(), this.upload.getSize());
                r.setSize(this.upload.getSize());
                r.setModified(new Date());
                Stripersist.getEntityManager().persist((Object)r);
                Stripersist.getEntityManager().getTransaction().commit();
                j.put("message", (Object)("Afbeelding \"" + r.getName() + "\" is geupload"));
                JSONObject data = new JSONObject();
                data.put("src", (Object)this.url(r));
                j.put("data", (Object)data);
                j.put("total", 1);
                j.put("success", true);
            }
            catch (Exception e) {
                j.put("errors", (Object)e.toString());
            }
            finally {
                try {
                    this.upload.delete();
                }
                catch (IOException e) {
                    log.error((Object)"Error deleting upload", (Throwable)e);
                }
            }
        }
        return new StreamingResolution("text/html", HtmlUtil.encode((String)j.toString(4)));
    }

    public Resolution manage() throws JSONException {
        if ("imagesList".equals(this.action)) {
            return this.imagesList();
        }
        if ("delete".equals(this.action)) {
            return this.delete();
        }
        JSONObject j = new JSONObject();
        j.put("success", false);
        j.put("message", (Object)"Fout");
        j.put("errors", (Object)("Actie niet ondersteund: " + this.action));
        return new StreamingResolution("application/json", j.toString(4));
    }

    public Resolution imagesList() throws JSONException {
        JSONObject j = new JSONObject();
        try {
            JSONArray data = new JSONArray();
            j.put("data", (Object)data);
            j.put("total", Stripersist.getEntityManager().createQuery("select count(*) from Resource").getSingleResult());
            List resources = Stripersist.getEntityManager().createQuery("from Resource order by name").setFirstResult(this.start.intValue()).setMaxResults(this.limit.intValue()).getResultList();
            for (Resource r : resources) {
                JSONObject file = new JSONObject();
                file.put("src", (Object)this.url(r));
                file.put("name", (Object)r.getName());
                file.put("fullname", (Object)r.getName());
                data.put((Object)file);
            }
            j.put("success", true);
            j.put("message", (Object)"Success");
        }
        catch (Exception e) {
            j.put("success", false);
            j.put("message", (Object)"Fout");
            j.put("errors", (Object)e.toString());
        }
        return new StreamingResolution("application/json", j.toString(4));
    }

    public Resolution delete() throws JSONException {
        JSONObject j = new JSONObject();
        j.put("success", false);
        j.put("message", (Object)"Fout");
        try {
            Resource r = (Resource)Stripersist.getEntityManager().find(Resource.class, (Object)this.image);
            if (r == null) {
                j.put("errors", (Object)("Kan afbeelding \"" + this.image + "\" niet vinden"));
            } else {
                Stripersist.getEntityManager().remove((Object)r);
                Stripersist.getEntityManager().getTransaction().commit();
            }
            j.put("success", true);
            j.put("message", (Object)"Verwijderd");
        }
        catch (Exception e) {
            j.put("errors", (Object)e.toString());
        }
        return new StreamingResolution("application/json", j.toString(4));
    }
}

