/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.admin.stripes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.LocalizableError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.services.AttributeDescriptor;
import nl.b3p.viewer.config.services.FeatureSource;
import nl.b3p.viewer.config.services.LayarService;
import nl.b3p.viewer.config.services.LayarSource;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@StrictBinding
@UrlBinding(value="/action/layarsource/{$event}")
@RolesAllowed(value={"Admin", "RegistryAdmin"})
public class LayarSourceActionBean
implements ActionBean {
    private static final String JSP = "/WEB-INF/jsp/services/layarsource.jsp";
    private static final String EDITJSP = "/WEB-INF/jsp/services/editlayarsource.jsp";
    private ActionBeanContext context;
    private List<LayarService> layarServices;
    private List<SimpleFeatureType> featureTypes;
    private List<FeatureSource> featureSources;
    @Validate
    private Long layarServiceId;
    @Validate
    private JSONArray filter;
    @Validate
    private int page;
    @Validate
    private int start;
    @Validate
    private int limit;
    @Validate
    private String sort;
    @Validate
    private String dir;
    @Validate
    private Map<String, ClobElement> details = new HashMap();
    @Validate
    @ValidateNestedProperties(value={@Validate(field="featureType"), @Validate(field="layarService")})
    private LayarSource layarSource = null;
    @Validate
    private Long featureTypeId;

    @DefaultHandler
    public Resolution view() {
        this.layarServices = Stripersist.getEntityManager().createQuery("from LayarService").getResultList();
        return new ForwardResolution(JSP);
    }

    public Resolution save() {
        this.layarSource.getDetails().clear();
        this.layarSource.getDetails().putAll(this.details);
        Stripersist.getEntityManager().persist((Object)this.layarSource);
        Stripersist.getEntityManager().getTransaction().commit();
        this.getContext().getMessages().add(new SimpleMessage("Layarsource is opgeslagen", new Object[0]));
        return new ForwardResolution(EDITJSP);
    }

    public Resolution edit() {
        if (this.layarSource != null) {
            this.details = this.layarSource.getDetails();
        }
        this.layarServices = Stripersist.getEntityManager().createQuery("from LayarService").getResultList();
        this.featureTypes = Stripersist.getEntityManager().createQuery("from SimpleFeatureType").getResultList();
        this.featureSources = Stripersist.getEntityManager().createQuery("from FeatureSource").getResultList();
        Stripersist.getEntityManager().getTransaction().commit();
        return new ForwardResolution(EDITJSP);
    }

    public Resolution cancel() {
        return new ForwardResolution(EDITJSP);
    }

    public Resolution delete() {
        Stripersist.getEntityManager().remove((Object)this.layarSource);
        Stripersist.getEntityManager().getTransaction().commit();
        this.getContext().getMessages().add(new SimpleMessage("Layar bron is verwijderd", new Object[0]));
        return new ForwardResolution(EDITJSP);
    }

    public Resolution getGridData() throws JSONException {
        JSONArray jsonData = new JSONArray();
        Session sess = (Session)Stripersist.getEntityManager().getDelegate();
        Criteria c = sess.createCriteria(LayarSource.class);
        c.createAlias("featureType", "f");
        c.createAlias("layarService", "l");
        if (this.getFilter() != null) {
            for (int k = 0; k < this.getFilter().length(); ++k) {
                JSONObject j = this.getFilter().getJSONObject(k);
                String property = j.getString("property");
                String value = j.getString("value");
                if (value == null || value.length() <= 0) continue;
                if (property.equals("featureType")) {
                    c.add(Restrictions.ilike((String)"f.typeName", (String)value, (MatchMode)MatchMode.ANYWHERE));
                }
                if (!property.equals("layarService")) continue;
                c.add(Restrictions.ilike((String)"l.name", (String)value, (MatchMode)MatchMode.ANYWHERE));
            }
        }
        if (this.getSort() != null && this.getDir() != null) {
            Order order = null;
            if (this.getSort().equals("featureType")) {
                this.setSort("f.typeName");
            } else if (this.getSort().equals("layarService")) {
                this.setSort("l.name");
            }
            order = this.getDir().equals("ASC") ? Order.asc((String)this.getSort()) : Order.desc((String)this.getSort());
            order.ignoreCase();
            c.addOrder(order);
        }
        if (this.layarServiceId != null && this.layarServiceId != -1L) {
            SimpleExpression attrCrit = Restrictions.eq((String)"l.id", (Object)this.layarServiceId);
            c.add((Criterion)attrCrit);
        }
        List sources = c.list();
        int rowCount = sources.size();
        c.setMaxResults(this.getLimit());
        c.setFirstResult(this.getStart());
        for (LayarSource source : sources) {
            JSONObject j = new JSONObject();
            j.put("id", (Object)source.getId());
            j.put("featureType", (Object)source.getFeatureType().getTypeName());
            j.put("layarService", (Object)source.getLayarService().getName());
            jsonData.put((Object)j);
        }
        JSONObject grid = new JSONObject();
        grid.put("totalCount", rowCount);
        grid.put("gridrows", (Object)jsonData);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Resolution getAttributes() throws JSONException {
        JSONObject json = new JSONObject();
        boolean success = false;
        SimpleFeatureType featureType = (SimpleFeatureType)Stripersist.getEntityManager().find(SimpleFeatureType.class, (Object)this.featureTypeId);
        if (featureType != null) {
            JSONArray array = new JSONArray();
            List attributes = featureType.getAttributes();
            for (AttributeDescriptor attr : attributes) {
                if (!AttributeDescriptor.GEOMETRY_TYPES.contains(attr.getType())) {
                    array.put((Object)attr.getName());
                }
                json.put("attributes", (Object)array);
            }
            success = true;
        } else {
            json.put("error", (Object)"No featureType found");
        }
        json.put("success", success);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @ValidationMethod(on={"save"})
    public void validateParams(ValidationErrors errors) {
        if (this.layarSource == null || this.layarSource.getLayarService() == null) {
            errors.add("layarService", (ValidationError)new LocalizableError("validation.required.valueNotPresent", new Object[0]));
        }
        if (this.layarSource == null || this.layarSource.getFeatureType() == null) {
            errors.add("featureType", (ValidationError)new LocalizableError("validation.required.valueNotPresent", new Object[0]));
        }
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public List<LayarService> getLayarServices() {
        return this.layarServices;
    }

    public void setLayarServices(List<LayarService> layarServices) {
        this.layarServices = layarServices;
    }

    public Long getLayarServiceId() {
        return this.layarServiceId;
    }

    public void setLayarServiceId(Long layarServiceId) {
        this.layarServiceId = layarServiceId;
    }

    public JSONArray getFilter() {
        return this.filter;
    }

    public void setFilter(JSONArray filter) {
        this.filter = filter;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public LayarSource getLayarSource() {
        return this.layarSource;
    }

    public void setLayarSource(LayarSource layarSource) {
        this.layarSource = layarSource;
    }

    public List<SimpleFeatureType> getFeatureTypes() {
        return this.featureTypes;
    }

    public void setFeatureTypes(List<SimpleFeatureType> featureTypes) {
        this.featureTypes = featureTypes;
    }

    public Map<String, ClobElement> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, ClobElement> details) {
        this.details = details;
    }

    public Long getFeatureType() {
        return this.featureTypeId;
    }

    public void setFeatureTypeId(Long featureTypeId) {
        this.featureTypeId = featureTypeId;
    }

    public List<FeatureSource> getFeatureSources() {
        return this.featureSources;
    }

    public void setFeatureSources(List<FeatureSource> featureSources) {
        this.featureSources = featureSources;
    }
}

