/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.admin.stripes;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontBind;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import nl.b3p.viewer.admin.stripes.ApplicationActionBean;
import nl.b3p.viewer.admin.stripes.ChooseApplicationActionBean;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.Level;
import nl.b3p.viewer.config.security.User;
import nl.b3p.viewer.config.services.BoundingBox;
import nl.b3p.viewer.util.SelectedContentCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

/*
 * Exception performing whole class analysis ignored.
 */
@UrlBinding(value="/action/applicationsettings/")
@StrictBinding
@RolesAllowed(value={"Admin", "ApplicationAdmin"})
public class ApplicationSettingsActionBean
extends ApplicationActionBean {
    private static final Log log = LogFactory.getLog(ApplicationSettingsActionBean.class);
    private static final String JSP = "/WEB-INF/jsp/application/applicationSettings.jsp";
    private static final String DEFAULT_SPRITE = "/resources/images/default_sprite.png";
    @Validate
    private String name;
    @Validate
    private String version;
    @Validate
    private String owner;
    @Validate
    private boolean authenticatedRequired;
    @Validate
    private boolean mashupMustPointToPublishedVersion = false;
    @Validate
    private String mashupName;
    @Validate
    private boolean mustUpdateComponents;
    @Validate
    private Map<String, ClobElement> details = new HashMap();
    @ValidateNestedProperties(value={@Validate(field="minx", maxlength=255), @Validate(field="miny", maxlength=255), @Validate(field="maxx", maxlength=255), @Validate(field="maxy", maxlength=255)})
    private BoundingBox startExtent;
    @ValidateNestedProperties(value={@Validate(field="minx", maxlength=255), @Validate(field="miny", maxlength=255), @Validate(field="maxx", maxlength=255), @Validate(field="maxy", maxlength=255)})
    private BoundingBox maxExtent;
    @Validate
    private List<String> groupsRead = new ArrayList();

    public Map<String, ClobElement> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, ClobElement> details) {
        this.details = details;
    }

    public boolean getAuthenticatedRequired() {
        return this.authenticatedRequired;
    }

    public void setAuthenticatedRequired(boolean authenticatedRequired) {
        this.authenticatedRequired = authenticatedRequired;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public BoundingBox getStartExtent() {
        return this.startExtent;
    }

    public void setStartExtent(BoundingBox startExtent) {
        this.startExtent = startExtent;
    }

    public BoundingBox getMaxExtent() {
        return this.maxExtent;
    }

    public void setMaxExtent(BoundingBox maxExtent) {
        this.maxExtent = maxExtent;
    }

    public String getMashupName() {
        return this.mashupName;
    }

    public void setMashupName(String mashupName) {
        this.mashupName = mashupName;
    }

    public boolean isMashupMustPointToPublishedVersion() {
        return this.mashupMustPointToPublishedVersion;
    }

    public void setMashupMustPointToPublishedVersion(boolean mashupMustPointToPublishedVersion) {
        this.mashupMustPointToPublishedVersion = mashupMustPointToPublishedVersion;
    }

    public boolean isMustUpdateComponents() {
        return this.mustUpdateComponents;
    }

    public void setMustUpdateComponents(boolean mustUpdateComponents) {
        this.mustUpdateComponents = mustUpdateComponents;
    }

    public List<String> getGroupsRead() {
        return this.groupsRead;
    }

    public void setGroupsRead(List<String> groupsRead) {
        this.groupsRead = groupsRead;
    }

    @DefaultHandler
    @DontValidate
    public Resolution view() {
        if (this.application != null) {
            this.details = this.application.getDetails();
            if (this.application.getOwner() != null) {
                this.owner = this.application.getOwner().getUsername();
            }
            this.startExtent = this.application.getStartExtent();
            this.maxExtent = this.application.getMaxExtent();
            this.name = this.application.getName();
            this.version = this.application.getVersion();
            this.authenticatedRequired = this.application.isAuthenticatedRequired();
            this.groupsRead.addAll(this.application.getReaders());
        }
        if (!this.details.containsKey("iconSprite")) {
            this.details.put("iconSprite", new ClobElement("/resources/images/default_sprite.png"));
        }
        if (!this.details.containsKey("stylesheetMetadata")) {
            this.details.put("stylesheetMetadata", new ClobElement(""));
        }
        if (!this.details.containsKey("stylesheetPrint")) {
            this.details.put("stylesheetPrint", new ClobElement(""));
        }
        return new ForwardResolution("/WEB-INF/jsp/application/applicationSettings.jsp");
    }

    @DontValidate
    public Resolution newApplication() {
        this.application = null;
        this.applicationId = -1L;
        this.details.put("iconSprite", new ClobElement("/resources/images/default_sprite.png"));
        this.details.put("stylesheetMetadata", new ClobElement(""));
        this.details.put("stylesheetPrint", new ClobElement(""));
        return new ForwardResolution("/WEB-INF/jsp/application/applicationSettings.jsp");
    }

    @DontBind
    public Resolution cancel() {
        return new ForwardResolution("/WEB-INF/jsp/application/applicationSettings.jsp");
    }

    public Resolution save() {
        if (this.application == null) {
            this.application = new Application();
            Level root = new Level();
            root.setName("Applicatie");
            Level background = new Level();
            background.setName("Achtergrond");
            background.setBackground(true);
            root.getChildren().add(background);
            background.setParent(root);
            Stripersist.getEntityManager().persist((Object)background);
            Stripersist.getEntityManager().persist((Object)root);
            this.application.setRoot(root);
        }
        this.bindAppProperties();
        Stripersist.getEntityManager().persist((Object)this.application);
        Stripersist.getEntityManager().getTransaction().commit();
        this.getContext().getMessages().add(new SimpleMessage("Applicatie is opgeslagen", new Object[0]));
        this.setApplication(this.application);
        return new ForwardResolution("/WEB-INF/jsp/application/applicationSettings.jsp");
    }

    private void bindAppProperties() {
        this.application.setName(this.name);
        this.application.setVersion(this.version);
        if (this.owner != null) {
            User appOwner = (User)Stripersist.getEntityManager().find(User.class, (Object)this.owner);
            this.application.setOwner(appOwner);
        }
        this.application.setStartExtent(this.startExtent);
        this.application.setMaxExtent(this.maxExtent);
        this.application.setAuthenticatedRequired(this.authenticatedRequired);
        this.application.getReaders().clear();
        for (String group : this.groupsRead) {
            this.application.getReaders().add(group);
        }
        this.application.authorizationsModified();
        HashMap backupDetails = new HashMap();
        for (Map.Entry e : this.application.getDetails().entrySet()) {
            if (!Application.preventClearDetails.contains(e.getKey())) continue;
            this.details.put(e.getKey(), e.getValue());
        }
        this.application.getDetails().clear();
        this.application.getDetails().putAll(this.details);
    }

    @ValidationMethod(on={"save"})
    public void validate(ValidationErrors errors) throws Exception {
        if (this.name == null) {
            errors.add("name", (ValidationError)new SimpleError("Naam is verplicht", new Object[0]));
            return;
        }
        try {
            Long foundId = null;
            foundId = this.version == null ? (Long)Stripersist.getEntityManager().createQuery("select id from Application where name = :name and version is null").setMaxResults(1).setParameter("name", (Object)this.name).getSingleResult() : (Long)Stripersist.getEntityManager().createQuery("select id from Application where name = :name and version = :version").setMaxResults(1).setParameter("name", (Object)this.name).setParameter("version", (Object)this.version).getSingleResult();
            if (this.application != null && this.application.getId() != null) {
                if (!foundId.equals(this.application.getId())) {
                    errors.add("name", (ValidationError)new SimpleError("Naam en versie moeten een unieke combinatie vormen.", new Object[0]));
                }
            } else {
                errors.add("name", (ValidationError)new SimpleError("Naam en versie moeten een unieke combinatie vormen.", new Object[0]));
            }
        }
        catch (NoResultException foundId) {
            // empty catch block
        }
        if (this.owner != null) {
            try {
                User appOwner = (User)Stripersist.getEntityManager().find(User.class, (Object)this.owner);
                if (appOwner == null) {
                    errors.add("owner", (ValidationError)new SimpleError("Gebruiker met deze naam bestaat niet.", new Object[0]));
                }
            }
            catch (NoResultException nre) {
                errors.add("owner", (ValidationError)new SimpleError("Gebruiker met deze naam bestaat niet.", new Object[0]));
            }
        }
        if (this.startExtent != null && (this.startExtent.getMinx() == null || this.startExtent.getMiny() == null || this.startExtent.getMaxx() == null || this.startExtent.getMaxy() == null)) {
            errors.add("startExtent", (ValidationError)new SimpleError("Alle velden van de start extentie moeten ingevuld worden.", new Object[0]));
        }
        if (this.maxExtent != null && (this.maxExtent.getMinx() == null || this.maxExtent.getMiny() == null || this.maxExtent.getMaxx() == null || this.maxExtent.getMaxy() == null)) {
            errors.add("maxExtent", (ValidationError)new SimpleError("Alle velden van de max extentie moeten ingevuld worden.", new Object[0]));
        }
    }

    public Resolution copy() throws Exception {
        EntityManager em = Stripersist.getEntityManager();
        try {
            Object o = em.createQuery("select 1 from Application where name = :name").setMaxResults(1).setParameter("name", (Object)this.name).getSingleResult();
            this.getContext().getMessages().add(new SimpleMessage("Kan niet kopieren; applicatie met naam \"{0}\" bestaat al", new Object[]{this.name}));
            return new RedirectResolution(this.getClass());
        }
        catch (NoResultException o) {
            try {
                this.copyApplication(em);
                this.getContext().getMessages().add(new SimpleMessage("Applicatie is gekopieerd", new Object[0]));
                return new RedirectResolution(this.getClass());
            }
            catch (Exception e) {
                log.error((Object)String.format("Error copying application #%d named %s %swith new name %s", this.application.getId(), this.application.getName(), this.application.getVersion() == null ? "" : "v" + this.application.getVersion() + " ", this.name), (Throwable)e);
                String ex = e.toString();
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    ex = ex + ";\n<br>" + cause.toString();
                }
                this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Fout bij kopieren applicatie: " + ex, new Object[0]));
                return new ForwardResolution("/WEB-INF/jsp/application/applicationSettings.jsp");
            }
        }
    }

    protected void copyApplication(EntityManager em) throws Exception {
        Application copy = null;
        if (this.application.isMashup().booleanValue()) {
            copy = this.application.createMashup(this.name, em, false);
            SelectedContentCache.setApplicationCacheDirty((Application)copy, (Boolean)Boolean.TRUE, (Boolean)true, (EntityManager)em);
        } else {
            this.bindAppProperties();
            copy = this.application.deepCopy();
            em.detach((Object)this.application);
            em.persist((Object)copy);
            em.persist((Object)copy);
            em.flush();
            SelectedContentCache.setApplicationCacheDirty((Application)copy, (Boolean)Boolean.TRUE, (Boolean)false, (EntityManager)em);
        }
        em.getTransaction().commit();
        this.setApplication(copy);
    }

    public Resolution mashup() {
        ValidationErrors errors = this.context.getValidationErrors();
        try {
            EntityManager em = Stripersist.getEntityManager();
            Application mashup = this.application.createMashup(this.mashupName, em, this.mustUpdateComponents);
            em.persist((Object)mashup);
            em.getTransaction().commit();
            this.setApplication(mashup);
        }
        catch (Exception ex) {
            log.error((Object)"Error creating mashup", (Throwable)ex);
            errors.add("Fout", (ValidationError)new SimpleError("De mashup kan niet worden gemaakt.", new Object[0]));
        }
        return new RedirectResolution(ApplicationSettingsActionBean.class);
    }

    public Resolution publish() {
        EntityManager em = Stripersist.getEntityManager();
        try {
            Application oldPublished = (Application)em.createQuery("from Application where name = :name AND version IS null").setMaxResults(1).setParameter("name", (Object)this.name).getSingleResult();
            Date nowDate = new Date(System.currentTimeMillis());
            SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
            sdf.applyPattern("HH-mm_dd-MM-yyyy");
            String now = sdf.format(nowDate);
            String uniqueVersion = ApplicationSettingsActionBean.findUniqueVersion((String)this.name, (String)("B_" + now));
            oldPublished.setVersion(uniqueVersion);
            em.persist((Object)oldPublished);
            if (this.mashupMustPointToPublishedVersion) {
                for (Application mashup : oldPublished.getMashups(em)) {
                    mashup.setRoot(this.application.getRoot());
                    SelectedContentCache.setApplicationCacheDirty((Application)mashup, (Boolean)true, (Boolean)false, (EntityManager)em);
                    mashup.transferMashup(oldPublished, em);
                    em.persist((Object)mashup);
                }
            }
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        this.application.setVersion(null);
        em.persist((Object)this.application);
        em.getTransaction().commit();
        this.setApplication(null);
        return new RedirectResolution(ChooseApplicationActionBean.class);
    }

    public static String findUniqueVersion(String name, String version) {
        int uniqueCounter = 0;
        while (true) {
            String testVersion = uniqueCounter == 0 ? version : version + " (" + uniqueCounter + ")";
            try {
                Stripersist.getEntityManager().createQuery("select 1 from Application where name = :name AND version = :version").setParameter("name", (Object)name).setParameter("version", (Object)testVersion).setMaxResults(1).getSingleResult();
                ++uniqueCounter;
            }
            catch (NoResultException nre) {
                version = testVersion;
                return version;
            }
        }
    }
}

