/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.admin.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.admin.stripes.ApplicationActionBean;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.app.Level;
import nl.b3p.viewer.config.app.StartLayer;
import nl.b3p.viewer.config.app.StartLevel;
import nl.b3p.viewer.util.SelectedContentCache;
import nl.b3p.web.stripes.ErrorMessageResolution;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

/*
 * Exception performing whole class analysis ignored.
 */
@UrlBinding(value="/action/applicationstartmap/{$event}")
@StrictBinding
@RolesAllowed(value={"Admin", "ApplicationAdmin"})
public class ApplicationStartMapActionBean
extends ApplicationActionBean {
    private static final String JSP = "/WEB-INF/jsp/application/applicationStartMap.jsp";
    @Validate
    private String selectedContent;
    private JSONArray jsonContent;
    @Validate
    private String contentToBeSelected;
    @Validate
    private String checkedLayersString;
    private JSONArray jsonCheckedLayers;
    private JSONArray allCheckedLayers = new JSONArray();
    @Validate
    private String nodeId;
    @Validate
    private String levelId;
    private Level rootlevel;
    @Validate
    private String removedRecordsString = new String();
    private Set<Long> levelsToBeRemoved = new HashSet();
    private Set<Long> layersToBeRemoved = new HashSet();

    @DefaultHandler
    @DontValidate
    public Resolution view() throws JSONException {
        if (this.application == null) {
            this.getContext().getMessages().add(new SimpleError("Er moet eerst een bestaande applicatie geactiveerd of een nieuwe applicatie gemaakt worden.", new Object[0]));
            return new ForwardResolution("/WEB-INF/jsp/application/chooseApplication.jsp");
        }
        this.rootlevel = this.application.getRoot();
        ApplicationStartMapActionBean.getCheckedLayerList((JSONArray)this.allCheckedLayers, (Level)this.rootlevel, (Application)this.application);
        return new ForwardResolution("/WEB-INF/jsp/application/applicationStartMap.jsp");
    }

    public Resolution save() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        this.saveStartMap(em);
        this.getContext().getMessages().add(new SimpleMessage("Het startkaartbeeld is opgeslagen", new Object[0]));
        ApplicationStartMapActionBean.getCheckedLayerList((JSONArray)this.allCheckedLayers, (Level)this.rootlevel, (Application)this.application);
        return new ForwardResolution("/WEB-INF/jsp/application/applicationStartMap.jsp");
    }

    protected void saveStartMap(EntityManager em) {
        this.rootlevel = this.application.getRoot();
        this.jsonContent = new JSONArray(this.selectedContent);
        this.jsonCheckedLayers = new JSONArray(this.checkedLayersString);
        JSONArray objToRemove = new JSONArray();
        if (this.removedRecordsString != null) {
            objToRemove = new JSONArray(this.removedRecordsString);
        }
        for (Object obj : objToRemove) {
            JSONObject o = (JSONObject)obj;
            String type = o.getString("type");
            if (type.equals("layer")) {
                this.layersToBeRemoved.add(o.getLong("id"));
                continue;
            }
            if (!type.equals("level")) continue;
            this.levelsToBeRemoved.add(o.getLong("id"));
        }
        this.walkAppTreeForSave(this.rootlevel, em, false);
        SelectedContentCache.setApplicationCacheDirty((Application)this.application, (Boolean)true, (Boolean)false, (Boolean)true, (EntityManager)em);
        em.getTransaction().commit();
    }

    public Resolution canContentBeSelected() {
        try {
            this.jsonContent = new JSONArray(this.selectedContent);
            if (this.jsonContent.length() == 0) {
                JSONObject obj = new JSONObject();
                obj.put("result", true);
                return new StreamingResolution("application/json", (Reader)new StringReader(obj.toString()));
            }
            JSONObject o = new JSONObject(this.contentToBeSelected);
            Boolean result = true;
            String message = null;
            String id = o.getString("id");
            if (o.get("type").equals("layer")) {
                message = "Kaartlagen kunnen niet los worden geselecteerd, alleen als onderdeel van een kaart of kaartlaaggroep";
                result = false;
            } else {
                Level level = (Level)Stripersist.getEntityManager().find(Level.class, (Object)new Long(id));
                if (level == null) {
                    result = false;
                    message = "Niveau met id " + id + " is onbekend!";
                } else if (!level.hasLayerInSubtree()) {
                    message = "Niveau is geen kaart";
                    result = false;
                } else {
                    for (int i = 0; i < this.jsonContent.length(); ++i) {
                        JSONObject content = this.jsonContent.getJSONObject(i);
                        if (content.getString("type").equals("level")) {
                            if (id.equals(content.getString("id"))) {
                                result = false;
                                message = "Niveau is al geselecteerd";
                                break;
                            }
                            Level l = (Level)Stripersist.getEntityManager().find(Level.class, (Object)new Long(content.getString("id")));
                            if (l == null || !l.isInSubtreeOf(level)) continue;
                            result = false;
                            message = "Niveau kan niet worden geselecteerd omdat een subniveau al geselecteerd is";
                            break;
                        }
                        ApplicationLayer appLayer = (ApplicationLayer)Stripersist.getEntityManager().find(ApplicationLayer.class, (Object)new Long(content.getString("id")));
                        if (!level.containsLayerInSubtree(appLayer)) continue;
                        result = false;
                        message = "Niveau kan niet worden geselecteerd omdat een kaartlaag uit dit (of onderliggend) niveau al is geselecteerd";
                        break;
                    }
                }
            }
            JSONObject obj = new JSONObject();
            obj.put("result", (Object)result);
            obj.put("message", (Object)message);
            return new StreamingResolution("application/json", (Reader)new StringReader(obj.toString()));
        }
        catch (Exception e) {
            return new ErrorMessageResolution("Exception " + e.getClass() + ": " + e.getMessage());
        }
    }

    protected void walkAppTreeForSave(Level l, EntityManager em, boolean unremove) throws JSONException {
        if (this.shouldBeRemoved((Object)l)) {
            this.removeStartLevel(l, em);
        } else {
            boolean unremoveChilds;
            boolean wasNew = false;
            StartLevel sl = (StartLevel)l.getStartLevels().get(this.application);
            if (sl == null) {
                wasNew = true;
                sl = new StartLevel();
                sl.setApplication(this.application);
                sl.setLevel(l);
                l.getStartLevels().put(this.application, sl);
            }
            sl.setSelectedIndex(this.getSelectedContentIndex(l));
            boolean bl = unremoveChilds = sl.isRemoved() && sl.getSelectedIndex() != null || unremove;
            if (unremoveChilds) {
                sl.setRemoved(false);
            }
            for (ApplicationLayer al : l.getLayers()) {
                StartLayer startLayer = (StartLayer)al.getStartLayers().get(this.application);
                if (this.shouldBeRemoved((Object)al)) {
                    startLayer.setRemoved(true);
                    continue;
                }
                if (!wasNew && startLayer == null) continue;
                if (startLayer == null) {
                    startLayer = new StartLayer();
                    startLayer.setApplication(this.application);
                    startLayer.setApplicationLayer(al);
                    al.getStartLayers().put(this.application, startLayer);
                }
                startLayer.setSelectedIndex(this.getSelectedContentIndex(al));
                startLayer.setChecked(this.getCheckedForLayerId(al.getId()));
                if (!unremoveChilds) continue;
                startLayer.setRemoved(false);
            }
            for (Level child : l.getChildren()) {
                this.walkAppTreeForSave(child, em, unremoveChilds);
            }
        }
    }

    private boolean shouldBeRemoved(Object l) {
        if (l instanceof Level) {
            Level level = (Level)l;
            return this.levelsToBeRemoved.contains(level.getId());
        }
        if (l instanceof ApplicationLayer) {
            ApplicationLayer al = (ApplicationLayer)l;
            return this.layersToBeRemoved.contains(al.getId());
        }
        return false;
    }

    private boolean getCheckedForLayerId(Long levelid) throws JSONException {
        for (int i = 0; i < this.jsonCheckedLayers.length(); ++i) {
            if (!levelid.equals(new Long(this.jsonCheckedLayers.getInt(i)))) continue;
            return true;
        }
        return false;
    }

    private Integer getSelectedContentIndex(Level l) throws JSONException {
        Integer index = null;
        for (int i = 0; i < this.jsonContent.length(); ++i) {
            JSONObject js = this.jsonContent.getJSONObject(i);
            String id = js.get("id").toString();
            String type = js.get("type").toString();
            if (!id.equals(l.getId().toString()) || !type.equals("level")) continue;
            index = i;
        }
        return index;
    }

    private Integer getSelectedContentIndex(ApplicationLayer al) throws JSONException {
        Integer index = null;
        for (int i = 0; i < this.jsonContent.length(); ++i) {
            JSONObject js = this.jsonContent.getJSONObject(i);
            String id = js.get("id").toString();
            String type = js.get("type").toString();
            if (!id.equals(al.getId().toString()) || !type.equals("layer")) continue;
            index = i;
        }
        return index;
    }

    public Resolution loadApplicationTree() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        JSONArray children = new JSONArray();
        if (!this.nodeId.equals("n")) {
            String type = this.nodeId.substring(0, 1);
            int id = Integer.parseInt(this.nodeId.substring(1));
            if (type.equals("n")) {
                JSONObject j;
                Level l = (Level)em.find(Level.class, (Object)new Long(id));
                List levels = l.getChildren();
                Collections.sort(levels);
                for (Level sub : levels) {
                    j = new JSONObject();
                    j.put("id", (Object)("n" + sub.getId()));
                    j.put("name", (Object)sub.getName());
                    j.put("type", (Object)"level");
                    j.put("isLeaf", sub.getChildren().isEmpty() && sub.getLayers().isEmpty());
                    if (sub.getParent() != null) {
                        j.put("parentid", (Object)sub.getParent().getId());
                    }
                    children.put((Object)j);
                }
                for (ApplicationLayer layer : l.getLayers()) {
                    j = new JSONObject();
                    j.put("id", (Object)("s" + layer.getId()));
                    j.put("name", (Object)layer.getDisplayName(em));
                    j.put("type", (Object)"layer");
                    j.put("isLeaf", true);
                    j.put("parentid", (Object)this.nodeId);
                    children.put((Object)j);
                }
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Resolution loadSelectedLayers() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        JSONArray children = this.loadSelectedLayers(em);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected JSONArray loadSelectedLayers(EntityManager em) {
        JSONArray children;
        block7: {
            block6: {
                children = new JSONArray();
                this.rootlevel = this.application.getRoot();
                if (this.levelId == null || !this.levelId.substring(1).equals(this.rootlevel.getId().toString())) break block6;
                ArrayList selectedObjects = new ArrayList();
                ApplicationStartMapActionBean.walkAppTreeForStartMap(selectedObjects, (Level)this.rootlevel, (Application)this.application);
                Collections.sort(selectedObjects, new /* Unavailable Anonymous Inner Class!! */);
                if (selectedObjects == null) break block7;
                for (Object map : selectedObjects) {
                    if (map instanceof StartLayer) {
                        StartLayer startLayer = (StartLayer)map;
                        ApplicationLayer layer = startLayer.getApplicationLayer();
                        JSONObject j = new JSONObject();
                        j.put("id", (Object)("s" + layer.getId()));
                        j.put("name", (Object)layer.getDisplayName(em));
                        j.put("type", (Object)"layer");
                        j.put("isLeaf", true);
                        j.put("parentid", (Object)"");
                        j.put("checked", startLayer.isChecked());
                        children.put((Object)j);
                        continue;
                    }
                    if (!(map instanceof StartLevel)) continue;
                    StartLevel startLevel = (StartLevel)map;
                    Level level = startLevel.getLevel();
                    JSONArray checked = new JSONArray();
                    ApplicationStartMapActionBean.getCheckedLayerList((JSONArray)checked, (Level)level, (Application)this.application);
                    JSONObject j = new JSONObject();
                    j.put("id", (Object)("n" + level.getId()));
                    j.put("name", (Object)startLevel.getLevel().getName());
                    j.put("type", (Object)"level");
                    j.put("isLeaf", level.getChildren().isEmpty() && level.getLayers().isEmpty());
                    j.put("parentid", (Object)"");
                    j.put("checkedlayers", (Object)checked);
                    children.put((Object)j);
                }
                break block7;
            }
            String type = this.levelId.substring(0, 1);
            int id = Integer.parseInt(this.levelId.substring(1));
            if (type.equals("n")) {
                JSONObject j;
                Level l = (Level)em.find(Level.class, (Object)new Long(id));
                for (Level sub : l.getChildren()) {
                    StartLevel sl = (StartLevel)sub.getStartLevels().get(this.application);
                    if (sl == null && l.getStartLevels().containsKey(this.application) || sl != null && sl.isRemoved()) continue;
                    j = new JSONObject();
                    j.put("id", (Object)("n" + sub.getId()));
                    j.put("name", (Object)sub.getName());
                    j.put("type", (Object)"level");
                    j.put("isLeaf", sub.getChildren().isEmpty() && sub.getLayers().isEmpty());
                    if (sub.getParent() != null) {
                        j.put("parentid", (Object)sub.getParent().getId());
                    }
                    children.put((Object)j);
                }
                for (ApplicationLayer layer : l.getLayers()) {
                    StartLayer startLayer = (StartLayer)layer.getStartLayers().get(this.application);
                    if (startLayer == null && l.getStartLevels().containsKey(this.application) || startLayer != null && startLayer.isRemoved()) continue;
                    j = new JSONObject();
                    j.put("id", (Object)("s" + layer.getId()));
                    j.put("name", (Object)layer.getDisplayName(em));
                    j.put("type", (Object)"layer");
                    j.put("isLeaf", true);
                    j.put("parentid", (Object)this.levelId);
                    j.put("checked", startLayer != null ? startLayer.isChecked() : false);
                    children.put((Object)j);
                }
            }
        }
        return children;
    }

    protected static void walkAppTreeForStartMap(List selectedContent, Level l, Application app) {
        StartLevel sl = (StartLevel)l.getStartLevels().get(app);
        if (sl != null && sl.getSelectedIndex() != null && !sl.isRemoved()) {
            selectedContent.add(sl);
        }
        for (ApplicationLayer al : l.getLayers()) {
            StartLayer startLayer = (StartLayer)al.getStartLayers().get(app);
            if (startLayer == null || startLayer.getSelectedIndex() == null || startLayer.isRemoved()) continue;
            selectedContent.add(al);
        }
        for (Level child : l.getChildren()) {
            ApplicationStartMapActionBean.walkAppTreeForStartMap((List)selectedContent, (Level)child, (Application)app);
        }
    }

    private static void getCheckedLayerList(JSONArray layers, Level l, Application app) throws JSONException {
        for (ApplicationLayer al : l.getLayers()) {
            StartLayer startLayer = (StartLayer)al.getStartLayers().get(app);
            if (startLayer == null || !startLayer.isChecked()) continue;
            layers.put((Object)al.getId());
        }
        for (Level child : l.getChildren()) {
            ApplicationStartMapActionBean.getCheckedLayerList((JSONArray)layers, (Level)child, (Application)app);
        }
    }

    protected void removeStartLevel(Level l, EntityManager em) {
        StartLevel sl = (StartLevel)l.getStartLevels().get(this.application);
        if (sl != null) {
            List als = l.getLayers();
            for (ApplicationLayer al : als) {
                StartLayer startLayer = (StartLayer)al.getStartLayers().get(this.application);
                if (startLayer == null) continue;
                startLayer.setRemoved(true);
            }
            sl.setRemoved(true);
            List children = l.getChildren();
            for (Level child : children) {
                this.removeStartLevel(child, em);
            }
        }
    }

    public String getCheckedLayersString() {
        return this.checkedLayersString;
    }

    public void setCheckedLayersString(String checkedLayersString) {
        this.checkedLayersString = checkedLayersString;
    }

    public String getSelectedContent() {
        return this.selectedContent;
    }

    public void setSelectedContent(String selectedContent) {
        this.selectedContent = selectedContent;
    }

    public Level getRootlevel() {
        return this.rootlevel;
    }

    public void setRootlevel(Level rootlevel) {
        this.rootlevel = rootlevel;
    }

    public String getLevelId() {
        return this.levelId;
    }

    public void setLevelId(String levelId) {
        this.levelId = levelId;
    }

    public JSONArray getAllCheckedLayers() {
        return this.allCheckedLayers;
    }

    public void setAllCheckedLayers(JSONArray allCheckedLayers) {
        this.allCheckedLayers = allCheckedLayers;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getContentToBeSelected() {
        return this.contentToBeSelected;
    }

    public void setContentToBeSelected(String contentToBeSelected) {
        this.contentToBeSelected = contentToBeSelected;
    }

    public String getRemovedRecordsString() {
        return this.removedRecordsString;
    }

    public void setRemovedRecordsString(String removedRecordsString) {
        this.removedRecordsString = removedRecordsString;
    }
}

