/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.admin.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationError;
import nl.b3p.viewer.admin.stripes.ApplicationActionBean;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.app.ConfiguredAttribute;
import nl.b3p.viewer.config.app.Level;
import nl.b3p.viewer.config.app.StartLayer;
import nl.b3p.viewer.config.app.StartLevel;
import nl.b3p.viewer.config.services.AttributeDescriptor;
import nl.b3p.viewer.config.services.Document;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.util.SelectedContentCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/applicationtreelevel")
@StrictBinding
@RolesAllowed(value={"Admin", "ApplicationAdmin"})
public class ApplicationTreeLevelActionBean
extends ApplicationActionBean {
    private static final Log log = LogFactory.getLog(ApplicationTreeLevelActionBean.class);
    private static final String JSP = "/WEB-INF/jsp/application/applicationTreeLevel.jsp";
    @Validate
    @ValidateNestedProperties(value={@Validate(field="info", label="Info"), @Validate(field="name", label="Naam"), @Validate(field="url", label="url")})
    private Level level;
    private boolean layersAllowed;
    @Validate
    private List<String> groupsRead = new ArrayList();
    @Validate
    private String selectedlayers;
    @Validate
    private String selecteddocs;

    @DefaultHandler
    @DontValidate
    public Resolution view() {
        return new ForwardResolution(JSP);
    }

    public Resolution delete() {
        EntityManager em = Stripersist.getEntityManager();
        String error = this.deleteLevel(em, this.level);
        if (error != null) {
            this.getContext().getValidationErrors().add("niveau", (ValidationError)new SimpleError(error, new Object[0]));
        } else {
            Level parent = this.level.getParent();
            parent.getChildren().remove(this.level);
            em.persist((Object)parent);
            em.remove((Object)this.level);
            this.getContext().getMessages().add(new SimpleMessage("Het niveau is verwijderd", new Object[0]));
        }
        this.application.authorizationsModified();
        SelectedContentCache.setApplicationCacheDirty((Application)this.application, (Boolean)true, (Boolean)false, (EntityManager)em);
        em.getTransaction().commit();
        return new ForwardResolution(JSP);
    }

    @DontValidate
    public Resolution edit() {
        Level rootLevel = this.application.getRoot();
        if (this.level != null) {
            this.groupsRead.addAll(this.level.getReaders());
            this.layersAllowed = this.level.isBackground() ? false : this.level.getParent() != null && !this.level.getParent().getId().equals(rootLevel.getId());
        }
        return new ForwardResolution(JSP);
    }

    @DontValidate
    public Resolution saveName() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        String error = null;
        if (this.level == null) {
            error = "Niveau niet gevonden";
        } else if (this.level.getName() == null) {
            error = "Naam moet zijn ingevuld";
        } else {
            try {
                EntityManager em = Stripersist.getEntityManager();
                em.persist((Object)this.level);
                SelectedContentCache.setApplicationCacheDirty((Application)this.application, (Boolean)true, (Boolean)false, (EntityManager)em);
                em.getTransaction().commit();
                json.put("name", (Object)this.level.getName());
                json.put("success", (Object)Boolean.TRUE);
            }
            catch (Exception e) {
                log.error((Object)"Fout bij opslaan niveau", (Throwable)e);
                error = "Kan niveau niet opslaan: " + e;
                Throwable t = e;
                while (t.getCause() != null) {
                    t = t.getCause();
                    error = error + "; " + t;
                }
            }
        }
        if (error != null) {
            json.put("error", (Object)error);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    @DontValidate
    public Resolution deleteAjax() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        String error = this.deleteLevel(Stripersist.getEntityManager(), this.level);
        if (error != null) {
            json.put("error", (Object)error);
        } else {
            json.put("success", (Object)Boolean.TRUE);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    protected String deleteLevel(EntityManager em, Level level) {
        String error = null;
        StartLevel sl = (StartLevel)level.getStartLevels().get(this.application);
        if (level == null) {
            error = "Niveau niet gevonden";
        } else if (level.getParent() == null) {
            error = "Bovenste niveau kan niet worden verwijderd";
        } else if (level.getChildren().size() > 0) {
            error = "Het niveau kan niet worden verwijderd omdat deze sub-niveau's heeft.";
        } else if (sl != null && sl.getSelectedIndex() != null) {
            error = "Het niveau kan niet worden verwijderd omdat deze kaart in de TOC is opgenomen";
        } else if (level.getLayers().size() > 0) {
            error = "Het niveau kan niet worden verwijderd omdat deze kaartlagen bevat.";
        } else {
            try {
                Level parent = level.getParent();
                parent.getChildren().remove(level);
                List mashups = this.application.getMashups(em);
                mashups.add(this.application);
                for (Application mashup : mashups) {
                    List startlevels = mashup.getStartLevels();
                    Iterator iterator = startlevels.iterator();
                    while (iterator.hasNext()) {
                        StartLevel next = (StartLevel)iterator.next();
                        if (sl == null || !next.getLevel().getId().equals(sl.getLevel().getId())) continue;
                        iterator.remove();
                    }
                }
                em.remove((Object)level);
                this.application.authorizationsModified();
                SelectedContentCache.setApplicationCacheDirty((Application)this.application, (Boolean)true, (Boolean)false, (EntityManager)em);
                em.getTransaction().commit();
            }
            catch (Exception e) {
                log.error((Object)"Fout bij verwijderen niveau", (Throwable)e);
                error = "Kan niveau niet verwijderen: " + e;
                Throwable t = e;
                while (t.getCause() != null) {
                    t = t.getCause();
                    error = error + "; " + t;
                }
            }
        }
        return error;
    }

    public Resolution save() {
        EntityManager em = Stripersist.getEntityManager();
        this.saveLevel(em);
        this.getContext().getMessages().add(new SimpleMessage("Het niveau is opgeslagen", new Object[0]));
        return this.edit();
    }

    protected void saveLevel(EntityManager em) {
        this.level.getReaders().clear();
        for (String groupName : this.groupsRead) {
            this.level.getReaders().add(groupName);
        }
        this.updateApplayersInLevel(this.selectedlayers, this.level, em);
        this.level.getDocuments().clear();
        if (this.selecteddocs != null && this.selecteddocs.length() > 0) {
            String[] docIds = this.selecteddocs.split(",");
            for (int i = 0; i < docIds.length; ++i) {
                Long id = new Long(docIds[i].substring(1));
                Document doc = (Document)em.find(Document.class, (Object)id);
                this.level.getDocuments().add(doc);
            }
        }
        if (this.level.getStartLevels().isEmpty()) {
            List apps = this.application.getMashups(em);
            apps.add(this.application);
            for (Application app : apps) {
                StartLevel sl = new StartLevel();
                sl.setApplication(app);
                sl.setLevel(this.level);
                sl.setSelectedIndex(null);
                app.getStartLevels().add(sl);
                this.level.getStartLevels().put(app, sl);
            }
        }
        em.persist((Object)this.level);
        this.application.authorizationsModified();
        SelectedContentCache.setApplicationCacheDirty((Application)this.application, (Boolean)true, (Boolean)false, (EntityManager)em);
        em.getTransaction().commit();
    }

    protected void updateApplayersInLevel(String selectedLayers, Level level, EntityManager em) {
        ArrayList layersToBeRemoved = new ArrayList(level.getLayers());
        List apps = this.application.getMashups(em);
        apps.add(this.application);
        level.getLayers().clear();
        if (selectedLayers != null && selectedLayers.length() > 0) {
            String[] layerIds = selectedLayers.split(",");
            for (int i = 0; i < layerIds.length; ++i) {
                Layer layer;
                Long id;
                ApplicationLayer appLayer = null;
                if (layerIds[i].startsWith("al")) {
                    id = new Long(layerIds[i].substring(2));
                    appLayer = (ApplicationLayer)em.find(ApplicationLayer.class, (Object)id);
                    layersToBeRemoved.remove(appLayer);
                } else if (layerIds[i].startsWith("l") && (layer = (Layer)em.find(Layer.class, (Object)(id = new Long(layerIds[i].substring(1))))) != null && !layer.isVirtual()) {
                    appLayer = new ApplicationLayer();
                    appLayer.setService(layer.getService());
                    appLayer.setLayerName(layer.getName());
                    StartLayer sl = new StartLayer();
                    sl.setApplication(this.application);
                    sl.setApplicationLayer(appLayer);
                    appLayer.getStartLayers().put(this.application, sl);
                    this.application.getStartLayers().add(sl);
                    if (layer.getFeatureType() != null) {
                        SimpleFeatureType sft = layer.getFeatureType();
                        for (AttributeDescriptor ad : sft.getAttributes()) {
                            ConfiguredAttribute confAttribute = new ConfiguredAttribute();
                            confAttribute.setAttributeName(ad.getName());
                            confAttribute.setVisible(!AttributeDescriptor.GEOMETRY_TYPES.contains(ad.getType()));
                            appLayer.getAttributes().add(confAttribute);
                        }
                    }
                }
                level.getLayers().add(appLayer);
            }
        }
        for (Application app : apps) {
            List startlayers = app.getStartLayers();
            Iterator iterator = startlayers.iterator();
            while (iterator.hasNext()) {
                StartLayer next = (StartLayer)iterator.next();
                for (ApplicationLayer applicationLayer : layersToBeRemoved) {
                    if (!Objects.equals(next.getApplicationLayer().getId(), applicationLayer.getId())) continue;
                    iterator.remove();
                }
            }
        }
    }

    public List<String> getGroupsRead() {
        return this.groupsRead;
    }

    public void setGroupsRead(List<String> groupsRead) {
        this.groupsRead = groupsRead;
    }

    public boolean isLayersAllowed() {
        return this.layersAllowed;
    }

    public void setLayersAllowed(boolean layersAllowed) {
        this.layersAllowed = layersAllowed;
    }

    public String getSelectedlayers() {
        return this.selectedlayers;
    }

    public void setSelectedlayers(String selectedlayers) {
        this.selectedlayers = selectedlayers;
    }

    public String getSelecteddocs() {
        return this.selecteddocs;
    }

    public void setSelecteddocs(String selecteddocs) {
        this.selecteddocs = selecteddocs;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }
}

