/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.admin.monitoring;

import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import nl.b3p.mail.Mailer;
import nl.b3p.viewer.admin.monitoring.MonitorJob;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class GeoServiceMonitoringListener
implements ServletContextListener {
    private static final String PARAM_INTERVAL = "monitoring.schedule.minutes";
    private static final String PARAM_MAIL_FROM_EMAIL = "monitoring.mail.from.email";
    private static final String PARAM_MAIL_FROM_NAME = "monitoring.mail.from.name";
    private static final Log log = LogFactory.getLog(GeoServiceMonitoringListener.class);
    private ServletContext context;
    private Scheduler scheduler;

    public void contextInitialized(ServletContextEvent sce) {
        this.context = sce.getServletContext();
        String interval = this.context.getInitParameter(PARAM_INTERVAL);
        if (interval == null || "-1".equals(interval)) {
            return;
        }
        try {
            Mailer.getMailSession();
        }
        catch (Exception e) {
            log.error((Object)"Error getting mail session, monitoring disabled! Please configure the JNDI JavaMail Session resource correctly.", (Throwable)e);
            return;
        }
        try {
            this.setupQuartz();
        }
        catch (Exception e) {
            log.error((Object)"Error setting up Quartz, monitoring disabled!", (Throwable)e);
            return;
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        try {
            this.stopQuartz();
        }
        catch (Exception e) {
            log.error((Object)"Error stopping Quartz monitoring", (Throwable)e);
        }
    }

    private void setupQuartz() throws SchedulerException {
        Properties props = new Properties();
        props.put("org.quartz.scheduler.instanceName", "MonitoringScheduler");
        props.put("org.quartz.threadPool.threadCount", "3");
        props.put("org.quartz.scheduler.interruptJobsOnShutdownWithWait", "true");
        props.put("org.quartz.jobStore.class", "org.quartz.simpl.RAMJobStore");
        int minutes = 15;
        try {
            minutes = Integer.parseInt(this.context.getInitParameter(PARAM_INTERVAL));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.scheduler = new StdSchedulerFactory(props).getScheduler();
        this.scheduler.startDelayed(60);
        JobDetail job = JobBuilder.newJob(MonitorJob.class).withIdentity("monitorjob", "monitorgroup").usingJobData("from.email", this.context.getInitParameter(PARAM_MAIL_FROM_EMAIL)).usingJobData("from.name", this.context.getInitParameter(PARAM_MAIL_FROM_NAME)).build();
        log.info((Object)("Scheduling monitoring job for every " + minutes + " minutes"));
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("monitorjobtrigger", "monitorgroup").startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatMinutelyForever((int)minutes)).build();
        this.scheduler.scheduleJob(job, trigger);
    }

    private void stopQuartz() throws SchedulerException {
        if (this.scheduler != null) {
            this.scheduler.shutdown(true);
        }
    }
}

