/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.admin.stripes;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationError;
import nl.b3p.i18n.LocalizableActionBean;
import nl.b3p.viewer.config.CycloramaAccount;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/cyclorama/{$event}")
@StrictBinding
@RolesAllowed(value={"Admin", "RegistryAdmin"})
public class CycloramaConfigurationActionBean
extends LocalizableActionBean {
    private static final Log log = LogFactory.getLog(CycloramaConfigurationActionBean.class);
    private final String CERT_TYPE = "PKCS12";
    private final String KEY_FORMAT = "PKCS#8";
    private ActionBeanContext context;
    private final String JSP = "/WEB-INF/jsp/services/cyclorama.jsp";
    @Validate
    private FileBean key;
    private List<CycloramaAccount> accounts = new ArrayList();
    @Validate
    @ValidateNestedProperties(value={@Validate(field="username"), @Validate(field="password")})
    private CycloramaAccount account;

    public void setContext(ActionBeanContext abc) {
        this.context = abc;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public FileBean getKey() {
        return this.key;
    }

    public void setKey(FileBean key) {
        this.key = key;
    }

    public List<CycloramaAccount> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<CycloramaAccount> accounts) {
        this.accounts = accounts;
    }

    public CycloramaAccount getAccount() {
        return this.account;
    }

    public void setAccount(CycloramaAccount account) {
        this.account = account;
    }

    @DefaultHandler
    public Resolution view() {
        this.accounts = this.getAccountList();
        return new ForwardResolution("/WEB-INF/jsp/services/cyclorama.jsp");
    }

    public Resolution save() throws KeyStoreException {
        try {
            if (this.key != null) {
                String privateBase64Key = this.getBase64EncodedPrivateKeyFromPfxUpload(this.key.getInputStream(), this.account.getPassword());
                this.account.setPrivateBase64Key(privateBase64Key);
                this.account.setFilename(this.key.getFileName());
                this.key.delete();
            } else if (this.account.getPrivateBase64Key() == null) {
                this.context.getValidationErrors().add("Key", (ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.cycloramaconfigurationactionbean.pfx"), new Object[0]));
            }
            EntityManager em = Stripersist.getEntityManager();
            em.persist((Object)this.account);
            em.getTransaction().commit();
        }
        catch (Exception ex) {
            this.context.getValidationErrors().add("Key", (ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.cycloramaconfigurationactionbean.keywrong"), new Object[0]));
            log.error((Object)"Something went wrong with reading the key", (Throwable)ex);
        }
        return this.view();
    }

    public Resolution removeKey() {
        EntityManager em = Stripersist.getEntityManager();
        em.remove((Object)this.account);
        em.getTransaction().commit();
        this.account = new CycloramaAccount();
        this.context.getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.cycloramaconfigurationactionbean.keyrem"), new Object[0]));
        return this.view();
    }

    public Resolution accountList() throws JSONException {
        List list = this.getAccountList();
        JSONArray accountArray = new JSONArray();
        for (CycloramaAccount account : list) {
            JSONObject accountObj = account.toJSON();
            accountArray.put((Object)accountObj);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(accountArray.toString()));
    }

    private String getBase64EncodedPrivateKeyFromPfxUpload(InputStream in, String password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        String base64 = null;
        Key privateKey = null;
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(new BufferedInputStream(in), password.toCharArray());
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Key ksKey = ks.getKey(alias, password.toCharArray());
            String keyFormat = ksKey.getFormat();
            if (!(ksKey instanceof RSAPrivateCrtKey) || !keyFormat.equals("PKCS#8")) continue;
            privateKey = (PrivateKey)ksKey;
        }
        if (privateKey != null) {
            Base64 encoder = new Base64();
            base64 = new String(encoder.encode(privateKey.getEncoded()));
        }
        return base64;
    }

    public List<CycloramaAccount> getAccountList() {
        EntityManager em = Stripersist.getEntityManager();
        List list = em.createQuery("FROM CycloramaAccount", CycloramaAccount.class).getResultList();
        return list;
    }
}

