/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.admin.stripes;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import nl.b3p.i18n.LocalizableActionBean;
import nl.b3p.viewer.config.services.AttributeDescriptor;
import nl.b3p.viewer.config.services.FeatureSource;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/attribute/{$event}")
@StrictBinding
@RolesAllowed(value={"Admin", "RegistryAdmin"})
public class AttributeActionBean
extends LocalizableActionBean {
    private ActionBeanContext context;
    private static final String JSP = "/WEB-INF/jsp/services/attribute.jsp";
    private static final String EDITJSP = "/WEB-INF/jsp/services/editattribute.jsp";
    @Validate
    private int page;
    @Validate
    private int start;
    @Validate
    private int limit;
    @Validate
    private String sort;
    @Validate
    private String dir;
    @Validate
    private JSONArray filter;
    @Validate
    private Long featureSourceId;
    @Validate
    private Long simpleFeatureTypeId;
    private List featureSources;
    @Validate
    @ValidateNestedProperties(value={@Validate(field="alias", maxlength=255, label="Alias")})
    private AttributeDescriptor attribute;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public AttributeDescriptor getAttribute() {
        return this.attribute;
    }

    public void setAttribute(AttributeDescriptor attribute) {
        this.attribute = attribute;
    }

    public List getFeatureSources() {
        return this.featureSources;
    }

    public void setFeatureSources(List featureSources) {
        this.featureSources = featureSources;
    }

    public Long getSimpleFeatureTypeId() {
        return this.simpleFeatureTypeId;
    }

    public void setSimpleFeatureTypeId(Long simpleFeatureTypeId) {
        this.simpleFeatureTypeId = simpleFeatureTypeId;
    }

    public Long getFeatureSourceId() {
        return this.featureSourceId;
    }

    public void setFeatureSourceId(Long featureSourceId) {
        this.featureSourceId = featureSourceId;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public JSONArray getFilter() {
        return this.filter;
    }

    public void setFilter(JSONArray filter) {
        this.filter = filter;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution(JSP);
    }

    public Resolution edit() {
        return new ForwardResolution(EDITJSP);
    }

    public Resolution cancel() {
        return new ForwardResolution(EDITJSP);
    }

    public Resolution save() {
        Stripersist.getEntityManager().persist((Object)this.attribute);
        Stripersist.getEntityManager().getTransaction().commit();
        this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.attributeactionbean.attsaved"), new Object[0]));
        return new ForwardResolution(EDITJSP);
    }

    @Before(stages={LifecycleStage.BindingAndValidation})
    public void load() {
        this.featureSources = Stripersist.getEntityManager().createQuery("from FeatureSource").getResultList();
    }

    public Resolution getFeatureTypes() throws JSONException {
        JSONArray simpleFeatureTypes = new JSONArray();
        if (this.featureSourceId != null) {
            FeatureSource fc = (FeatureSource)Stripersist.getEntityManager().find(FeatureSource.class, (Object)this.featureSourceId);
            List sftList = fc.getFeatureTypes();
            for (SimpleFeatureType sft : sftList) {
                JSONObject j = new JSONObject();
                j.put("id", (Object)sft.getId());
                Object name = sft.getTypeName();
                if (!StringUtils.isBlank((CharSequence)sft.getDescription())) {
                    name = (String)name + " (" + sft.getDescription() + ")";
                }
                j.put("name", name);
                simpleFeatureTypes.put((Object)j);
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Resolution getGridData() throws JSONException {
        JSONArray jsonData = new JSONArray();
        List featureTypes = new ArrayList<SimpleFeatureType>();
        if (this.simpleFeatureTypeId != null && this.simpleFeatureTypeId != -1L) {
            SimpleFeatureType sft = (SimpleFeatureType)Stripersist.getEntityManager().find(SimpleFeatureType.class, (Object)this.simpleFeatureTypeId);
            if (sft != null) {
                featureTypes.add(sft);
            }
        } else if (this.featureSourceId != null && this.featureSourceId != -1L) {
            FeatureSource fc = (FeatureSource)Stripersist.getEntityManager().find(FeatureSource.class, (Object)this.featureSourceId);
            featureTypes = fc.getFeatureTypes();
        }
        String filterAlias = "";
        String filterAttribuut = "";
        String filterType = "";
        if (this.getFilter() != null) {
            for (int k = 0; k < this.getFilter().length(); ++k) {
                JSONObject j = this.getFilter().getJSONObject(k);
                String property = j.getString("property");
                String value = j.getString("value");
                if (property.equals("alias")) {
                    filterAlias = value;
                }
                if (property.equals("attribute")) {
                    filterAttribuut = value;
                }
                if (!property.equals("type")) continue;
                filterType = value;
            }
        }
        Session sess = (Session)Stripersist.getEntityManager().getDelegate();
        Criteria c = sess.createCriteria(AttributeDescriptor.class);
        if (this.sort != null && this.dir != null) {
            Order order = null;
            if (this.sort.equals("attribute")) {
                this.sort = "name";
            }
            order = this.dir.equals("ASC") ? Order.asc((String)this.sort) : Order.desc((String)this.sort);
            order.ignoreCase();
            c.addOrder(order);
        }
        if (filterAlias != null && filterAlias.length() > 0) {
            Criterion aliasCrit = Restrictions.ilike((String)"alias", (String)filterAlias, (MatchMode)MatchMode.ANYWHERE);
            c.add(aliasCrit);
        }
        if (filterAttribuut != null && filterAttribuut.length() > 0) {
            Criterion attribuutCrit = Restrictions.ilike((String)"name", (String)filterAttribuut, (MatchMode)MatchMode.ANYWHERE);
            c.add(attribuutCrit);
        }
        if (filterType != null && filterType.length() > 0) {
            Criterion typeCrit = Restrictions.ilike((String)"type", (String)filterType, (MatchMode)MatchMode.ANYWHERE);
            c.add(typeCrit);
        }
        if (featureTypes != null && featureTypes.size() > 0) {
            DetachedCriteria c2 = DetachedCriteria.forClass(SimpleFeatureType.class);
            ArrayList<Long> ftIds = new ArrayList<Long>();
            for (SimpleFeatureType sft : featureTypes) {
                ftIds.add(sft.getId());
            }
            c2.add(Restrictions.in((String)"id", ftIds));
            c2.createAlias("attributes", "attr");
            c2.setProjection((Projection)Projections.property((String)"attr.id"));
            c.add(Property.forName((String)"id").in(c2));
        }
        int rowCount = c.list().size();
        if (this.limit > 0) {
            c.setMaxResults(this.limit);
        }
        c.setFirstResult(this.start);
        List attributes = c.list();
        for (AttributeDescriptor attr : attributes) {
            JSONObject j = this.getGridRow(attr.getId().intValue(), attr.getAlias(), attr.getName(), attr.getType());
            jsonData.put((Object)j);
        }
        JSONObject grid = new JSONObject();
        grid.put("totalCount", rowCount);
        grid.put("gridrows", (Object)jsonData);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private JSONObject getGridRow(int i, String alias, String attribute, String type) throws JSONException {
        JSONObject j = new JSONObject();
        j.put("id", i);
        j.put("alias", (Object)alias);
        j.put("attribute", (Object)attribute);
        j.put("type", (Object)type);
        return j;
    }
}

