/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.admin.stripes;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.persistence.NoResultException;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontBind;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import nl.b3p.i18n.LocalizableActionBean;
import nl.b3p.viewer.config.services.LayarService;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@StrictBinding
@UrlBinding(value="/action/layarservice/{$event}/{service}")
@RolesAllowed(value={"Admin", "RegistryAdmin"})
public class LayarServiceActionBean
extends LocalizableActionBean {
    private static final String JSP = "/WEB-INF/jsp/services/layarservice.jsp";
    private static final String EDITJSP = "/WEB-INF/jsp/services/editlayarservice.jsp";
    private ActionBeanContext context;
    @Validate
    private int page;
    @Validate
    private int start;
    @Validate
    private int limit;
    @Validate
    private String sort;
    @Validate
    private String dir;
    @Validate
    private JSONArray filter;
    @Validate
    private LayarService layarservice;
    @Validate
    private String name;
    private static final String LAYAR_ACTIONBEAN_URL = "/action/layar";
    private static final String VIEWER_URL_PARAM = "viewer.url";

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public JSONArray getFilter() {
        return this.filter;
    }

    public void setFilter(JSONArray filter) {
        this.filter = filter;
    }

    public LayarService getLayarservice() {
        return this.layarservice;
    }

    public void setLayarservice(LayarService layarservice) {
        this.layarservice = layarservice;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    @DefaultHandler
    @HandlesEvent(value="default")
    @DontValidate
    public Resolution defaultResolution() {
        return new ForwardResolution(JSP);
    }

    public String getUrl() throws UnsupportedEncodingException, MalformedURLException {
        Object url = this.getContext().getServletContext().getInitParameter(VIEWER_URL_PARAM) + LAYAR_ACTIONBEAN_URL;
        if (((String)url).indexOf("://") == -1) {
            HttpServletRequest request = this.getContext().getRequest();
            boolean needPort = "http".equals(request.getScheme()) && request.getServerPort() != 80 || "https".equals(request.getScheme()) && request.getServerPort() != 443;
            url = needPort ? new URL(request.getScheme(), request.getServerName(), request.getServerPort(), (String)url).toString() : new URL(request.getScheme(), request.getServerName(), (String)url).toString();
        }
        return url;
    }

    @DontValidate
    public Resolution edit() {
        if (this.layarservice != null) {
            this.name = this.layarservice.getName();
        }
        return new ForwardResolution(EDITJSP);
    }

    @DontBind
    public Resolution cancel() {
        return new ForwardResolution(EDITJSP);
    }

    @DontValidate
    public Resolution delete() {
        Stripersist.getEntityManager().remove((Object)this.layarservice);
        Stripersist.getEntityManager().getTransaction().commit();
        this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.layarserviceactionbean.lyarrem"), new Object[0]));
        return new ForwardResolution(EDITJSP);
    }

    public Resolution save() {
        if (this.layarservice == null) {
            this.layarservice = new LayarService();
        }
        this.layarservice.setName(this.name);
        Stripersist.getEntityManager().persist((Object)this.layarservice);
        Stripersist.getEntityManager().getTransaction().commit();
        this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.layarserviceactionbean.lyarsaved"), new Object[0]));
        return new ForwardResolution(EDITJSP);
    }

    @ValidationMethod(on={"save"})
    public void validate(ValidationErrors errors) throws Exception {
        if (this.name == null) {
            errors.add("name", (ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.layarserviceactionbean.nameobl"), new Object[0]));
            return;
        }
        try {
            Long foundId = (Long)Stripersist.getEntityManager().createQuery("select id from LayarService where name = :name").setMaxResults(1).setParameter("name", (Object)this.name).getSingleResult();
            if (this.layarservice != null && this.layarservice.getId() != null) {
                if (!foundId.equals(this.layarservice.getId())) {
                    errors.add("name", (ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.layarserviceactionbean.namedup"), new Object[0]));
                }
            } else {
                errors.add("name", (ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.layarserviceactionbean.namedup"), new Object[0]));
            }
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
    }

    @DontValidate
    public Resolution getGridData() throws JSONException {
        JSONArray jsonData = new JSONArray();
        String filterName = "";
        if (this.getFilter() != null) {
            for (int k = 0; k < this.getFilter().length(); ++k) {
                JSONObject j = this.getFilter().getJSONObject(k);
                String property = j.getString("property");
                String value = j.getString("value");
                if (!property.equals("name")) continue;
                filterName = value;
            }
        }
        Session sess = (Session)Stripersist.getEntityManager().getDelegate();
        Criteria c = sess.createCriteria(LayarService.class);
        if (this.sort != null && this.dir != null) {
            Order order = null;
            order = this.dir.equals("ASC") ? Order.asc((String)this.sort) : Order.desc((String)this.sort);
            order.ignoreCase();
            c.addOrder(order);
        }
        if (filterName != null && filterName.length() > 0) {
            Criterion nameCrit = Restrictions.ilike((String)"name", (String)filterName, (MatchMode)MatchMode.ANYWHERE);
            c.add(nameCrit);
        }
        int rowCount = c.list().size();
        c.setMaxResults(this.limit);
        c.setFirstResult(this.start);
        List layarservices = c.list();
        for (LayarService layar : layarservices) {
            JSONObject j = this.getGridRow(layar.getId().intValue(), layar.getName());
            jsonData.put((Object)j);
        }
        JSONObject grid = new JSONObject();
        grid.put("totalCount", rowCount);
        grid.put("gridrows", (Object)jsonData);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private JSONObject getGridRow(int i, String name) throws JSONException {
        JSONObject j = new JSONObject();
        j.put("id", i);
        j.put("name", (Object)name);
        return j;
    }
}

