/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.admin.stripes;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.i18n.LocalizableActionBean;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.app.Level;
import nl.b3p.viewer.config.services.FeatureSource;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.stripesstuff.stripersist.Stripersist;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
@StrictBinding
@UrlBinding(value="/action/serviceUsageMatrix/{$event}")
@RolesAllowed(value={"Admin", "RegistryAdmin"})
public class ServiceUsageMatrixActionBean
extends LocalizableActionBean {
    private static final Log log = LogFactory.getLog(ServiceUsageMatrixActionBean.class);
    private static final String JSP = "/WEB-INF/jsp/services/serviceusagematrix.jsp";
    private static final String xslPath = "/WEB-INF/classes/xsl/ServiceUsageMatrix.xsl";
    private ActionBeanContext context;
    @Validate
    private String xml;
    @Validate
    private ApplicationLayer applicationLayer;
    @Validate
    private Application application;
    @Validate
    private FeatureSource featureSource;
    @Validate
    private String changedFeatureTypes;
    @Validate
    private String output_format;
    private JSONObject data;

    private void createData() throws Exception {
        List<FeatureSource> featureSources;
        List applications = Stripersist.getEntityManager().createQuery("FROM Application order by name,version").getResultList();
        JSONArray jsonApps = new JSONArray();
        EntityManager em = Stripersist.getEntityManager();
        for (Application app : applications) {
            JSONObject json = new JSONObject((Object)app.toJSON(this.context.getRequest(), true, true, em));
            jsonApps.put((Object)json);
        }
        if (this.featureSource == null) {
            featureSources = em.createQuery("FROM FeatureSource").getResultList();
        } else {
            featureSources = new ArrayList();
            featureSources.add(this.featureSource);
        }
        JSONArray featureSourcesJson = new JSONArray();
        for (FeatureSource fs : featureSources) {
            JSONObject fsJson = fs.toJSONObject();
            featureSourcesJson.put((Object)fsJson);
            JSONObject featuretypesRoot = new JSONObject();
            JSONArray ftJsonArray = new JSONArray();
            featuretypesRoot.put("featureType", (Object)ftJsonArray);
            fsJson.put("featuretypes", (Object)featuretypesRoot);
            List featureTypes = fs.getFeatureTypes();
            for (SimpleFeatureType sft : featureTypes) {
                JSONObject ftJson = new JSONObject();
                ftJson.put("id", (Object)sft.getId());
                ftJson.put("name", (Object)sft.getTypeName());
                ftJson.put("description", (Object)sft.getDescription());
                ftJsonArray.put((Object)ftJson);
            }
        }
        JSONObject fs = new JSONObject();
        fs.put("featureSource", (Object)featureSourcesJson);
        JSONObject appl = new JSONObject();
        appl.put("application", (Object)jsonApps);
        JSONObject firstChild = new JSONObject();
        firstChild.put("applications", (Object)appl);
        firstChild.put("featureSources", (Object)fs);
        this.data = new JSONObject();
        this.data.put("root", (Object)firstChild);
    }

    @DefaultHandler
    public Resolution view() throws JSONException, TransformerConfigurationException, TransformerException, Exception {
        this.createData();
        String rawXml = XML.toString((Object)this.data);
        this.xml = this.transformXml(rawXml);
        Date nowDate = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
        sdf.applyPattern("HH-mm_dd-MM-yyyy");
        String now = sdf.format(nowDate);
        String fileName = "UsageMatrix_" + now;
        if (this.output_format != null || "XLS".equalsIgnoreCase(this.output_format)) {
            XSSFWorkbook workbook = ServiceUsageMatrixActionBean.createWorkBook((String)this.xml);
            return new /* Unavailable Anonymous Inner Class!! */.setAttachment(true).setFilename(fileName + ".xls");
        }
        return new ForwardResolution("/WEB-INF/jsp/services/serviceusagematrix.jsp");
    }

    public Resolution json() throws Exception {
        this.createData();
        return new StreamingResolution("application/json", (Reader)new StringReader(this.data.toString(4)));
    }

    public Resolution xml() throws Exception {
        this.createData();
        return new StreamingResolution("text/xml", (Reader)new StringReader(XML.toString((Object)this.data)));
    }

    public Resolution xmlTransformed() throws Exception {
        this.createData();
        return new StreamingResolution("text/xml", (Reader)new StringReader(this.transformXml(XML.toString((Object)this.data))));
    }

    public Resolution deleteApplicationLayer() throws JSONException {
        JSONObject json = new JSONObject();
        try {
            json.put("success", false);
            if (this.applicationLayer != null && this.application != null) {
                json.put("id", (Object)this.applicationLayer.getId());
                json.put("name", (Object)this.applicationLayer.getDisplayName(Stripersist.getEntityManager()));
                Level parent = this.application.getRoot().getParentInSubtree(this.applicationLayer);
                if (parent == null) {
                    json.put("message", (Object)MessageFormat.format(this.getBundle().getString("viewer.serviceusagematrixactionbean.noparent"), this.applicationLayer.getId(), this.getApplication().getId()));
                } else {
                    parent.getLayers().remove(this.applicationLayer);
                    Stripersist.getEntityManager().remove((Object)this.applicationLayer);
                    Stripersist.getEntityManager().getTransaction().commit();
                    json.put("success", true);
                }
            } else {
                json.put("message", (Object)this.getBundle().getString("viewer.serviceusagematrixactionbean.noappl"));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while deleting applicationlayer", (Throwable)e);
            json.put("message", (Object)e.getLocalizedMessage());
        }
        return new StreamingResolution("text/html", (Reader)new StringReader(json.toString()));
    }

    private String transformXml(String rawXml) throws TransformerConfigurationException, TransformerException {
        StringReader reader = new StringReader(rawXml);
        StringWriter writer = new StringWriter();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(new StreamSource(this.getContext().getServletContext().getRealPath("/WEB-INF/classes/xsl/ServiceUsageMatrix.xsl")));
        transformer.transform(new StreamSource(reader), new StreamResult(writer));
        return writer.toString();
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public ApplicationLayer getApplicationLayer() {
        return this.applicationLayer;
    }

    public void setApplicationLayer(ApplicationLayer applicationLayer) {
        this.applicationLayer = applicationLayer;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public FeatureSource getFeatureSource() {
        return this.featureSource;
    }

    public void setFeatureSource(FeatureSource featureSource) {
        this.featureSource = featureSource;
    }

    public String getChangedFeatureTypes() {
        return this.changedFeatureTypes;
    }

    public void setChangedFeatureTypes(String changedFeatureTypes) {
        this.changedFeatureTypes = changedFeatureTypes;
    }

    public String getOutput_format() {
        return this.output_format;
    }

    public void setOutput_format(String output_format) {
        this.output_format = output_format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XSSFWorkbook createWorkBook(String theXml) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException, XPathFactoryConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(theXml)));
        XSSFWorkbook workbook = new XSSFWorkbook();
        String tempProperty = null;
        try {
            Element root = doc.getDocumentElement();
            tempProperty = System.getProperty("javax.xml.xpath.XPathFactory:http://java.sun.com/jaxp/xpath/dom");
            if (tempProperty != null) {
                System.clearProperty("javax.xml.xpath.XPathFactory:http://java.sun.com/jaxp/xpath/dom");
            }
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            XPathExpression exprFeatureSource = xpath.compile("//featureSource");
            XPathExpression exprFeatureType = xpath.compile("featureType");
            XPathExpression exprApplication = xpath.compile("applications/application");
            XPathExpression exprLayer = xpath.compile("layers/layer");
            XPathExpression exprAppLayer = xpath.compile("applayers/applayer");
            XPathExpression exprId = xpath.compile("id/text()");
            XPathExpression exprAlias = xpath.compile("alias/text()");
            XPathExpression exprName = xpath.compile("name/text()");
            XPathExpression exprVersion = xpath.compile("version/text()");
            XPathExpression exprProtocol = xpath.compile("protocol/text()");
            XPathExpression exprUrl = xpath.compile("url/text()");
            XSSFSheet sheet = workbook.createSheet("Sheet 1");
            int rowNum = 0;
            XSSFRow head = sheet.createRow(rowNum++);
            String[] headValues = new String[]{"Bron", "Featuretype", "Applicatie", "Layernaam van service", "Application layer (kaart)"};
            for (int c = 0; c < headValues.length; ++c) {
                Cell cell = head.createCell(c);
                cell.setCellValue(headValues[c]);
            }
            ArrayList<Object> columns = new ArrayList<Object>();
            for (int i = 0; i < headValues.length; ++i) {
                columns.add("");
            }
            NodeList featureSources = (NodeList)exprFeatureSource.evaluate(root, XPathConstants.NODESET);
            for (int fs = 0; fs < featureSources.getLength(); ++fs) {
                Node featureSource = featureSources.item(fs);
                Object fsString = (String)exprName.evaluate(featureSource, XPathConstants.STRING);
                fsString = (String)fsString + " (" + (String)exprProtocol.evaluate(featureSource, XPathConstants.STRING);
                fsString = (String)fsString + ":: " + (String)exprUrl.evaluate(featureSource, XPathConstants.STRING);
                fsString = (String)fsString + " id: " + (String)exprId.evaluate(featureSource, XPathConstants.STRING);
                fsString = (String)fsString + ")";
                columns.set(0, fsString);
                NodeList featureTypes = (NodeList)exprFeatureType.evaluate(featureSource, XPathConstants.NODESET);
                for (int ft = 0; ft < featureTypes.getLength(); ++ft) {
                    Node featureType = featureTypes.item(ft);
                    String ftName = (String)exprName.evaluate(featureType, XPathConstants.STRING);
                    columns.set(1, ftName);
                    NodeList applications = (NodeList)exprApplication.evaluate(featureType, XPathConstants.NODESET);
                    for (int app = 0; app < applications.getLength(); ++app) {
                        Node application = applications.item(app);
                        String appVersion = (String)exprVersion.evaluate(application, XPathConstants.STRING);
                        Object appString = (String)exprName.evaluate(application, XPathConstants.STRING);
                        if (appVersion != null) {
                            appString = (String)appString + ", version: " + appVersion;
                        }
                        appString = (String)appString + " (" + (String)exprId.evaluate(application, XPathConstants.STRING) + ")";
                        columns.set(2, appString);
                        NodeList layers = (NodeList)exprLayer.evaluate(application, XPathConstants.NODESET);
                        for (int lay = 0; lay < layers.getLength(); ++lay) {
                            Node layer = layers.item(lay);
                            Object layerString = "";
                            layerString = (String)layerString + (String)exprName.evaluate(layer, XPathConstants.STRING);
                            columns.set(3, layerString);
                            NodeList appLayers = (NodeList)exprAppLayer.evaluate(layer, XPathConstants.NODESET);
                            for (int al = 0; al < appLayers.getLength(); ++al) {
                                Node appLayer = appLayers.item(al);
                                Object alString = (String)exprAlias.evaluate(appLayer, XPathConstants.STRING);
                                alString = (String)alString + " (" + (String)exprId.evaluate(appLayer, XPathConstants.STRING) + ")";
                                columns.set(4, alString);
                                XSSFRow row = sheet.createRow(rowNum++);
                                for (int c = 0; c < columns.size(); ++c) {
                                    Cell cell = row.createCell(c);
                                    cell.setCellValue((String)columns.get(c));
                                }
                            }
                        }
                    }
                }
            }
        }
        finally {
            if (tempProperty != null) {
                System.setProperty("javax.xml.xpath.XPathFactory:http://java.sun.com/jaxp/xpath/dom", tempProperty);
            }
        }
        return workbook;
    }

    public static void main(String[] args) throws Exception {
        String x = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><featureSources><featureSource><id>2</id><name>Gemeentes (CBS 2010)</name><protocol>wfs</protocol><url>http://mapserver.openwion.nl/cgi-bin/mapserv?map=/srv/b3p-wion/maps/gemeentes_cbs_2010.map</url><featureType><id>1</id><name>gemeentes</name><description/><applications><application><id>3</id><name>ol</name><version>2</version><layers><layer><serviceId>2</serviceId><name>gemeentes</name><applayers><applayer><id>48</id><alias>gemeentes</alias></applayer></applayers></layer></layers></application><application><id>1</id><name>default</name><version/><layers><layer><serviceId>2</serviceId><name>gemeentes</name><applayers><applayer><id>3</id><alias>gemeentes</alias></applayer></applayers></layer></layers></application><application><id>5</id><name>ol</name><version>3</version><layers><layer><serviceId>2</serviceId><name>gemeentes</name><applayers><applayer><id>71</id><alias>gemeentes</alias></applayer></applayers></layer></layers></application><application><id>2</id><name>ol</name><version/><layers><layer><serviceId>2</serviceId><name>gemeentes</name><applayers><applayer><id>31</id><alias>gemeentes</alias></applayer></applayers></layer></layers></application><application><id>30</id><name>ol22</name><version/><layers><layer><serviceId>2</serviceId><name>gemeentes</name><applayers><applayer><id>443</id><alias>gemeentes</alias></applayer></applayers></layer></layers></application></applications></featureType></featureSource></featureSources></root>";
        ServiceUsageMatrixActionBean.createWorkBook((String)x);
    }
}

