/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.admin.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.csw.client.CswClient;
import nl.b3p.csw.client.InputBySearch;
import nl.b3p.csw.client.OutputBySearch;
import nl.b3p.csw.server.CswServable;
import nl.b3p.csw.server.GeoNetworkCswServer;
import nl.b3p.csw.util.OnlineResource;
import nl.b3p.i18n.LocalizableActionBean;
import nl.b3p.viewer.config.services.Category;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@UrlBinding(value="/action/csw/search")
@StrictBinding
@RolesAllowed(value={"Admin", "RegistryAdmin"})
public class CatalogServiceActionBean
extends LocalizableActionBean {
    private static final Log log = LogFactory.getLog(CatalogServiceActionBean.class);
    private static final String JSP = "/WEB-INF/jsp/services/cswservice.jsp";
    private static final String SELECT_SERVICE = "/WEB-INF/jsp/services/selectCswServices.jsp";
    private ActionBeanContext context;
    @Validate
    private String searchTerm;
    @Validate
    private String url;
    @Validate(required=true)
    private Category category;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public void setSearchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Resolution addForm() {
        return new ForwardResolution(JSP);
    }

    public Resolution search() throws JSONException {
        String error;
        JSONObject json;
        block5: {
            json = new JSONObject();
            json.put("success", (Object)Boolean.FALSE);
            error = null;
            try {
                JSONArray results = new JSONArray();
                GeoNetworkCswServer server = new GeoNetworkCswServer(null, this.url, null, null);
                CswClient client = new CswClient((CswServable)server);
                InputBySearch input = new InputBySearch(this.searchTerm);
                OutputBySearch output = client.search(input);
                Map map = output.getResourcesMap();
                for (List resourceList : map.values()) {
                    for (OnlineResource resource : resourceList) {
                        String protocol;
                        String title = output.getTitle(resource.getMetadata());
                        String rurl = resource.getUrl() != null ? resource.getUrl().toString() : null;
                        String layer = resource.getName();
                        String string = protocol = resource.getProtocol() != null ? resource.getProtocol().getName() : null;
                        if (title == null || rurl == null || protocol == null || protocol.toLowerCase().indexOf("wms") == -1) continue;
                        JSONObject result = new JSONObject();
                        result.put("label", (Object)title);
                        result.put("url", (Object)rurl);
                        result.put("protocol", (Object)"wms");
                        results.put((Object)result);
                    }
                }
                json.put("results", (Object)results);
                json.put("success", (Object)Boolean.TRUE);
            }
            catch (Exception e) {
                error = MessageFormat.format(this.getBundle().getString("viewer_admin.catalogserviceactionbean.cswerr"), e.toString());
                if (e.getCause() == null) break block5;
                error = error + MessageFormat.format(this.getBundle().getString("viewer_admin.catalogserviceactionbean.cdwerrc"), e.getCause().toString());
            }
        }
        if (error != null) {
            json.put("error", (Object)error);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
    }
}

