/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.admin.processes;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.persistence.EntityManager;
import nl.b3p.viewer.config.app.ConfiguredComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.stripesstuff.stripersist.Stripersist;

public class SPOTinfoTokenRefresher {
    private static final Log LOG = LogFactory.getLog(SPOTinfoTokenRefresher.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTokens() {
        Stripersist.requestInit();
        try {
            EntityManager entityManager = Stripersist.getEntityManager();
            LOG.debug((Object)"Looking for access tokens to refresh");
            for (ConfiguredComponent c : entityManager.createQuery("from ConfiguredComponent c where c.className = 'viewer.components.MapboxGL'").getResultList()) {
                JSONObject config = c.toJSON(false).getJSONObject("config");
                String adminOnlyapiAccount = config.optString("adminOnlyapiAccount");
                String adminOnlyapiUser = config.optString("adminOnlyapiUser");
                String adminOnlyapiPass = config.optString("adminOnlyapiPass");
                String adminOnlyapiDatasets = config.optString("adminOnlyapiDatasets");
                if (!(adminOnlyapiPass.isEmpty() || adminOnlyapiUser.isEmpty() || adminOnlyapiDatasets.isEmpty() || adminOnlyapiAccount.isEmpty())) {
                    LOG.info((Object)("Refreshing SPOTinfo access token for " + c.getName()));
                    LOG.debug((Object)("old token " + config.optString("apiKey")));
                    String request = String.format("{\"username\":\"%s\",\"password\":\"%s\",\"account\":\"%s\",\"datasets\":[\"%s\"]}", adminOnlyapiUser, adminOnlyapiPass, adminOnlyapiAccount, adminOnlyapiDatasets);
                    byte[] out = request.getBytes(StandardCharsets.UTF_8);
                    URL url = new URL("https://beheer.omgevingsserver.nl/api/token/");
                    HttpURLConnection http = (HttpURLConnection)url.openConnection();
                    http.setRequestMethod("POST");
                    http.setFixedLengthStreamingMode(out.length);
                    http.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                    http.setRequestProperty("Accept", "application/json");
                    http.setDoOutput(true);
                    http.connect();
                    try (OutputStream os = http.getOutputStream();){
                        os.write(out);
                    }
                    if (http.getResponseCode() == 200) {
                        BufferedReader br = new BufferedReader(new InputStreamReader(http.getInputStream(), StandardCharsets.UTF_8));
                        try {
                            String responseLine;
                            StringBuilder response = new StringBuilder();
                            while ((responseLine = br.readLine()) != null) {
                                response.append(responseLine.trim());
                            }
                            JSONTokener resp = new JSONTokener(response.toString());
                            JSONObject newKeys = new JSONObject(resp);
                            config.put("apiKey", (Object)newKeys.getString("access"));
                            LOG.debug((Object)("new token " + config.optString("apiKey")));
                            c.setConfig(config.toString());
                            entityManager.persist((Object)c);
                            continue;
                        }
                        finally {
                            br.close();
                            continue;
                        }
                    }
                    LOG.error((Object)("Unexpected HTTP status code " + http.getResponseCode() + "after requesting access token."));
                    continue;
                }
                LOG.debug((Object)("Skipping component " + c.getName() + " one or more required SPOTinfo parameters is missing."));
            }
            entityManager.getTransaction().commit();
        }
        catch (IOException e) {
            LOG.error((Object)"A Problem occurred while trying to refresh the SPOTinfo access token.", (Throwable)e);
        }
        finally {
            Stripersist.requestComplete();
        }
    }
}

