/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.admin.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationError;
import nl.b3p.viewer.admin.stripes.ApplicationActionBean;
import nl.b3p.viewer.admin.stripes.ApplicationSettingsActionBean;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ConfiguredComponent;
import nl.b3p.viewer.config.metadata.Metadata;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/chooseapplication/{$event}")
@StrictBinding
@RolesAllowed(value={"Admin", "ApplicationAdmin"})
public class ChooseApplicationActionBean
extends ApplicationActionBean {
    private static final Log log = LogFactory.getLog(ChooseApplicationActionBean.class);
    private static final String JSP = "/WEB-INF/jsp/application/chooseApplication.jsp";
    private static final String EDITJSP = "/WEB-INF/jsp/application/chooseApplicationEdit.jsp";
    private static final String VIEWER_URL_PARAM = "viewer.url";
    @Validate
    private int page;
    @Validate
    private int start;
    @Validate
    private int limit;
    @Validate
    private String sort;
    @Validate
    private String dir;
    @Validate
    private JSONArray filter;
    @Validate
    private String name;
    @Validate
    private String version;
    @Validate
    private Application applicationWorkversion;
    @Validate
    private Application applicationToDelete;
    private List<Application> apps;
    private String defaultAppId;
    @Validate
    private Application defaultApplication;

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public JSONArray getFilter() {
        return this.filter;
    }

    public void setFilter(JSONArray filter) {
        this.filter = filter;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public Application getApplicationToDelete() {
        return this.applicationToDelete;
    }

    public void setApplicationToDelete(Application applicationToDelete) {
        this.applicationToDelete = applicationToDelete;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Application getApplicationWorkversion() {
        return this.applicationWorkversion;
    }

    public void setApplicationWorkversion(Application applicationWorkversion) {
        this.applicationWorkversion = applicationWorkversion;
    }

    public List<Application> getApps() {
        return this.apps;
    }

    public void setApps(List<Application> apps) {
        this.apps = apps;
    }

    public String getDefaultAppId() {
        return this.defaultAppId;
    }

    public void setDefaultAppId(String defaultAppId) {
        this.defaultAppId = defaultAppId;
    }

    public Application getDefaultApplication() {
        return this.defaultApplication;
    }

    public void setDefaultApplication(Application defaultApplication) {
        this.defaultApplication = defaultApplication;
    }

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution(JSP);
    }

    public Resolution viewEdit() {
        return new ForwardResolution(EDITJSP);
    }

    public Resolution deleteApplication() {
        EntityManager em = Stripersist.getEntityManager();
        try {
            this.deleteApplication(em);
        }
        catch (Exception e) {
            log.error((Object)String.format("Error deleting application #%d named %s", this.applicationToDelete.getId(), this.applicationToDelete.getName(), this.applicationToDelete.getVersion() == null ? "" : "v" + this.applicationToDelete.getVersion() + " "), (Throwable)e);
            String ex = e.toString();
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                ex = ex + ";\n<br>" + cause.toString();
            }
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.chooseapplicationactionbean.errorremapp"), new Object[]{ex}));
        }
        return new ForwardResolution(EDITJSP);
    }

    protected void deleteApplication(EntityManager em) {
        if (this.applicationToDelete.isMashup().booleanValue()) {
            this.applicationToDelete.setRoot(null);
            Set comps = this.applicationToDelete.getComponents();
            for (ConfiguredComponent comp : comps) {
                List linked = comp.getLinkedComponents();
                for (ConfiguredComponent cc : linked) {
                    cc.setMotherComponent(null);
                    em.persist((Object)cc);
                }
            }
            em.remove((Object)this.applicationToDelete);
            em.getTransaction().commit();
            this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.chooseapplicationactionbean.murem"), new Object[0]));
        } else if (this.applicationToDelete.getVersion() == null) {
            Date nowDate = new Date(System.currentTimeMillis());
            SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
            sdf.applyPattern("HH-mm_dd-MM-yyyy");
            String now = sdf.format(nowDate);
            String uniqueVersion = ApplicationSettingsActionBean.findUniqueVersion((String)this.applicationToDelete.getName(), (String)("B_" + now), (EntityManager)em);
            this.applicationToDelete.setVersion(uniqueVersion);
            em.getTransaction().commit();
        } else {
            List mashups = this.applicationToDelete.getMashups(em);
            if (!mashups.isEmpty()) {
                ArrayList<String> list = new ArrayList<String>();
                for (Application mashup : mashups) {
                    list.add(mashup.getNameWithVersion());
                }
                String mashupList = StringUtils.join(list, (String)", ");
                this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.chooseapplicationactionbean.noremapp"), new Object[]{mashupList}));
            } else {
                em.remove((Object)this.applicationToDelete);
                em.getTransaction().commit();
                this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.chooseapplicationactionbean.remapp"), new Object[0]));
            }
        }
        if (this.applicationToDelete.equals(this.application)) {
            this.setApplication(null);
        }
    }

    public Resolution getGridData() throws JSONException {
        JSONArray jsonData = new JSONArray();
        EntityManager em = Stripersist.getEntityManager();
        String filterName = "";
        String filterPublished = "";
        String filterOwner = "";
        if (this.getFilter() != null) {
            for (int k = 0; k < this.getFilter().length(); ++k) {
                JSONObject j = this.getFilter().getJSONObject(k);
                String property = j.getString("property");
                String value = j.getString("value");
                if (property.equals("name")) {
                    filterName = value;
                }
                if (property.equals("published")) {
                    filterPublished = value;
                }
                if (!property.equals("owner")) continue;
                filterOwner = value;
            }
        }
        Session sess = (Session)em.getDelegate();
        Criteria c = sess.createCriteria(Application.class);
        if (this.sort != null && this.dir != null) {
            Order order = null;
            if (this.sort.equals("published")) {
                this.sort = "version";
            }
            order = this.dir.equals("ASC") ? Order.asc((String)this.sort) : Order.desc((String)this.sort);
            order.ignoreCase();
            c.addOrder(order);
            if (!this.sort.equals("version")) {
                c.addOrder(Order.desc((String)"version"));
            }
        }
        if (filterName != null && filterName.length() > 0) {
            Criterion nameCrit = Restrictions.ilike((String)"name", (String)filterName, (MatchMode)MatchMode.ANYWHERE);
            c.add(nameCrit);
        }
        if (filterPublished != null && filterPublished.length() > 0) {
            Criterion publishedCrit;
            if (filterPublished.equalsIgnoreCase("nee")) {
                publishedCrit = Restrictions.isNotNull((String)"version");
                c.add(publishedCrit);
            } else if (filterPublished.equalsIgnoreCase("ja")) {
                publishedCrit = Restrictions.isNull((String)"version");
                c.add(publishedCrit);
            }
        }
        if (filterOwner != null && filterOwner.length() > 0) {
            Criterion ownerCrit = Restrictions.ilike((String)"owner.username", (String)filterOwner, (MatchMode)MatchMode.ANYWHERE);
            c.add(ownerCrit);
        }
        int rowCount = c.list().size();
        c.setMaxResults(this.limit);
        c.setFirstResult(this.start);
        List applications = c.list();
        String baseUrl = this.getContext().getServletContext().getInitParameter(VIEWER_URL_PARAM);
        for (Application app : applications) {
            String appName = app.getName();
            if (app.getVersion() != null) {
                appName = appName + " v" + app.getVersion();
            }
            String ownername = "";
            if (app.getOwner() != null) {
                ownername = app.getOwner().getUsername();
            }
            String published = this.getBundle().getString("viewer_admin.general.no");
            if (app.getVersion() == null) {
                published = this.getBundle().getString("viewer_admin.general.yes");
            }
            JSONObject j = new JSONObject();
            j.put("id", app.getId().intValue());
            j.put("name", (Object)appName);
            j.put("published", (Object)published);
            j.put("owner", (Object)ownername);
            j.put("baseName", (Object)app.getName());
            j.put("version", (Object)app.getVersion());
            j.put("baseUrl", (Object)baseUrl);
            boolean isMashup = app.isMashup(sess);
            if (isMashup) {
                List linkedApps = em.createQuery("from Application where root = :level and id <> :oldId").setParameter("level", (Object)app.getRoot()).setParameter("oldId", (Object)app.getId()).getResultList();
                for (Application linkedApp : linkedApps) {
                    if (linkedApp.isMashup(sess).booleanValue()) continue;
                    j.put("motherapplication", (Object)linkedApp.getNameWithVersion());
                    break;
                }
            }
            j.put("mashup", (Object)(isMashup ? this.getBundle().getString("viewer_admin.general.yes") : this.getBundle().getString("viewer_admin.general.no")));
            jsonData.put((Object)j);
        }
        JSONObject grid = new JSONObject();
        grid.put("totalCount", rowCount);
        grid.put("gridrows", (Object)jsonData);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Resolution makeWorkVersion() {
        EntityManager em = Stripersist.getEntityManager();
        try {
            Object o = em.createQuery("select 1 from Application where name = :name AND version = :version").setMaxResults(1).setParameter("name", (Object)this.name).setParameter("version", (Object)this.version).getSingleResult();
            this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.chooseapplicationactionbean.nocopy"), new Object[]{this.name, this.version}));
            return new RedirectResolution(this.getClass());
        }
        catch (NoResultException o) {
            try {
                Application copy = this.createWorkversion(this.applicationWorkversion, em, this.version);
                this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.chooseapplicationactionbean.wvcreate"), new Object[0]));
                this.setApplication(copy);
                return new RedirectResolution(ApplicationSettingsActionBean.class);
            }
            catch (Exception e) {
                log.error((Object)String.format("Error copying application #%d named %s %swith new name %s", this.applicationWorkversion.getId(), this.applicationWorkversion.getName(), this.applicationWorkversion.getVersion() == null ? "" : "v" + this.applicationWorkversion.getVersion() + " ", this.name), (Throwable)e);
                String ex = e.toString();
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    ex = ex + ";\n<br>" + cause.toString();
                }
                this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.chooseapplicationactionbean.wverror"), new Object[]{ex}));
                return new ForwardResolution(JSP);
            }
        }
    }

    Application createWorkversion(Application base, EntityManager em, String version) throws Exception {
        if (base.isMashup().booleanValue()) {
            Application mashup = base.createMashup(version, em, true);
            String appName = mashup.getName();
            appName = appName.substring(0, appName.lastIndexOf("_" + version));
            mashup.setName(appName);
            mashup.setVersion(version);
            em.persist((Object)mashup);
            em.getTransaction().commit();
            return mashup;
        }
        Application copy = base.createWorkVersion(em, version, this.context);
        return copy;
    }

    public Resolution saveDefaultApplication() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        try {
            EntityManager em = Stripersist.getEntityManager();
            Metadata md = null;
            try {
                md = (Metadata)em.createQuery("from Metadata where configKey = :key", Metadata.class).setParameter("key", (Object)"default_application").getSingleResult();
            }
            catch (NoResultException e) {
                md = new Metadata();
                md.setConfigKey("default_application");
            }
            if (this.defaultApplication != null) {
                md.setConfigValue(this.defaultApplication.getId().toString());
            } else {
                md.setConfigValue(null);
            }
            this.defaultAppId = md.getConfigValue();
            em.persist((Object)md);
            em.getTransaction().commit();
            json.put("success", (Object)Boolean.TRUE);
        }
        catch (Exception ex) {
            log.error((Object)"Error during setting the default application: ", (Throwable)ex);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    @After(stages={LifecycleStage.BindingAndValidation})
    public void createLists() {
        EntityManager em = Stripersist.getEntityManager();
        this.apps = em.createQuery("from Application").getResultList();
        try {
            Metadata md = (Metadata)em.createQuery("from Metadata where configKey = :key", Metadata.class).setParameter("key", (Object)"default_application").getSingleResult();
            this.defaultAppId = md.getConfigValue();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
    }
}

