/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.admin.stripes;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationError;
import nl.b3p.i18n.LocalizableActionBean;
import nl.b3p.viewer.config.services.AttributeDescriptor;
import nl.b3p.viewer.config.services.FeatureSource;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.config.services.SolrConf;
import nl.b3p.viewer.solr.SolrInitializer;
import nl.b3p.viewer.solr.SolrUpdateJob;
import nl.b3p.web.WaitPageStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.plugin.waitpage.WaitPage;
import org.stripesstuff.stripersist.Stripersist;

/*
 * Exception performing whole class analysis ignored.
 */
@UrlBinding(value="/action/configuresolr")
@StrictBinding
@RolesAllowed(value={"Admin", "RegistryAdmin"})
public class ConfigureSolrActionBean
extends LocalizableActionBean {
    private static final Log log = LogFactory.getLog(ConfigureSolrActionBean.class);
    private static final String JSP = "/WEB-INF/jsp/services/solrconfig.jsp";
    private static final String EDIT_JSP = "/WEB-INF/jsp/services/editsolrsource.jsp";
    private static final String PROTOTYPE_JSP = "/WEB-INF/jsp/services/searchPrototype.jsp";
    private List<FeatureSource> featureSources = new ArrayList();
    private List<SimpleFeatureType> featureTypes = new ArrayList();
    private ActionBeanContext context;
    @Validate
    @ValidateNestedProperties(value={@Validate(field="simpleFeatureType"), @Validate(field="name", required=true, on={"save"})})
    private SolrConf solrConfiguration;
    @Validate
    private Long simpleFeatureTypeId;
    @Validate
    private Long[] indexAttributes;
    @Validate
    private Long[] resultAttributes;
    private WaitPageStatus status;
    @Validate
    private String term;
    @Validate
    private Integer page;
    @Validate
    private Integer start;
    @Validate
    private Integer limit;
    @Validate
    private JSONArray filter;
    private Boolean solrInitialized = true;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public SolrConf getSolrConfiguration() {
        return this.solrConfiguration;
    }

    public void setSolrConfiguration(SolrConf solrConfiguration) {
        this.solrConfiguration = solrConfiguration;
    }

    public List<FeatureSource> getFeatureSources() {
        return this.featureSources;
    }

    public void setFeatureSources(List<FeatureSource> featureSources) {
        this.featureSources = featureSources;
    }

    public Long[] getIndexAttributes() {
        return this.indexAttributes;
    }

    public void setIndexAttributes(Long[] indexAttributes) {
        this.indexAttributes = indexAttributes;
    }

    public Long[] getResultAttributes() {
        return this.resultAttributes;
    }

    public void setResultAttributes(Long[] resultAttributes) {
        this.resultAttributes = resultAttributes;
    }

    public List<SimpleFeatureType> getFeatureTypes() {
        return this.featureTypes;
    }

    public void setFeatureTypes(List<SimpleFeatureType> featureTypes) {
        this.featureTypes = featureTypes;
    }

    public Long getSimpleFeatureTypeId() {
        return this.simpleFeatureTypeId;
    }

    public void setSimpleFeatureTypeId(Long simpleFeatureTypeId) {
        this.simpleFeatureTypeId = simpleFeatureTypeId;
    }

    public WaitPageStatus getStatus() {
        return this.status;
    }

    public void setStatus(WaitPageStatus status) {
        this.status = status;
    }

    public String getTerm() {
        return this.term;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public Boolean getSolrInitialized() {
        return this.solrInitialized;
    }

    public void setSolrInitialized(Boolean solrInitialized) {
        this.solrInitialized = solrInitialized;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getStart() {
        return this.start;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public JSONArray getFilter() {
        return this.filter;
    }

    public void setFilter(JSONArray filter) {
        this.filter = filter;
    }

    @DefaultHandler
    public Resolution view() throws SolrServerException {
        SolrServer server = SolrInitializer.getServerInstance();
        try {
            SolrPingResponse solrPingResponse = server.ping();
        }
        catch (Exception e) {
            log.error((Object)"Solr ping exception", (Throwable)e);
            this.context.getValidationErrors().addGlobalError((ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.configuresolractionbean.solrnoconfig"), new Object[0]));
            this.solrInitialized = false;
        }
        return new ForwardResolution("/WEB-INF/jsp/services/solrconfig.jsp");
    }

    public Resolution edit() {
        return new ForwardResolution("/WEB-INF/jsp/services/editsolrsource.jsp");
    }

    @WaitPage(path="/WEB-INF/jsp/waitpage.jsp", delay=2000, refresh=1000, ajax="/WEB-INF/jsp/waitpageajax.jsp")
    public Resolution addToIndex() throws InterruptedException {
        this.removeFromIndex();
        this.status = new WaitPageStatus();
        EntityManager em = Stripersist.getEntityManager();
        SolrServer server = SolrInitializer.getServerInstance();
        this.solrConfiguration = (SolrConf)em.find(SolrConf.class, (Object)this.solrConfiguration.getId());
        SolrUpdateJob.insertSolrConfigurationIntoIndex((SolrConf)this.solrConfiguration, (EntityManager)em, (WaitPageStatus)this.status, (SolrServer)server);
        em.getTransaction().commit();
        return new ForwardResolution("/WEB-INF/jsp/services/editsolrsource.jsp");
    }

    public Resolution removeFromIndex() {
        EntityManager em = Stripersist.getEntityManager();
        SolrServer server = SolrInitializer.getServerInstance();
        ConfigureSolrActionBean.removeConfigurationFromIndex((EntityManager)em, (SolrConf)this.solrConfiguration, (SolrServer)server);
        em.getTransaction().commit();
        return new ForwardResolution("/WEB-INF/jsp/services/editsolrsource.jsp");
    }

    public static void removeConfigurationFromIndex(EntityManager em, SolrConf conf, SolrServer server) {
        conf = (SolrConf)em.find(SolrConf.class, (Object)conf.getId());
        SolrUpdateJob.removeSolrConfigurationFromIndex((SolrConf)conf, (EntityManager)em, (SolrServer)server);
    }

    public Resolution cancel() {
        return new ForwardResolution("/WEB-INF/jsp/services/editsolrsource.jsp");
    }

    public Resolution save() {
        AttributeDescriptor attribute;
        Long attributeId;
        int i;
        EntityManager em = Stripersist.getEntityManager();
        this.solrConfiguration.getIndexAttributes().clear();
        this.solrConfiguration.getResultAttributes().clear();
        for (i = 0; i < this.indexAttributes.length; ++i) {
            attributeId = this.indexAttributes[i];
            attribute = (AttributeDescriptor)em.find(AttributeDescriptor.class, (Object)attributeId);
            this.solrConfiguration.getIndexAttributes().add(attribute.getName());
        }
        for (i = 0; i < this.resultAttributes.length; ++i) {
            attributeId = this.resultAttributes[i];
            attribute = (AttributeDescriptor)em.find(AttributeDescriptor.class, (Object)attributeId);
            this.solrConfiguration.getResultAttributes().add(attribute.getName());
        }
        em.persist((Object)this.solrConfiguration);
        em.getTransaction().commit();
        return new ForwardResolution("/WEB-INF/jsp/services/editsolrsource.jsp");
    }

    public Resolution newSearchConfig() {
        this.solrConfiguration = new SolrConf();
        return new ForwardResolution("/WEB-INF/jsp/services/editsolrsource.jsp");
    }

    @After(on={"edit", "save", "newSearchConfig"}, stages={LifecycleStage.BindingAndValidation})
    public void loadLists() {
        this.featureSources = Stripersist.getEntityManager().createQuery("from FeatureSource").getResultList();
        if (this.solrConfiguration != null && this.solrConfiguration.getSimpleFeatureType() != null) {
            this.featureTypes = this.solrConfiguration.getSimpleFeatureType().getFeatureSource().getFeatureTypes();
        }
    }

    public Resolution delete() {
        EntityManager em = Stripersist.getEntityManager();
        ConfigureSolrActionBean.deleteSolrConfiguration((EntityManager)em, (SolrConf)this.solrConfiguration, (SolrServer)SolrInitializer.getServerInstance());
        em.getTransaction().commit();
        return new ForwardResolution("/WEB-INF/jsp/services/editsolrsource.jsp");
    }

    public static void deleteSolrConfiguration(EntityManager em, SolrConf conf, SolrServer server) {
        ConfigureSolrActionBean.removeConfigurationFromIndex((EntityManager)em, (SolrConf)conf, (SolrServer)server);
        em.remove((Object)conf);
    }

    public Resolution getGridData() throws JSONException {
        JSONArray jsonData = new JSONArray();
        String filterName = "";
        String lastUpdated = "";
        if (this.getFilter() != null) {
            for (int k = 0; k < this.getFilter().length(); ++k) {
                JSONObject j = this.getFilter().getJSONObject(k);
                String property = j.getString("property");
                String value = j.getString("value");
                if (property.equals("name")) {
                    filterName = value;
                }
                if (!property.equals("lastUpdated")) continue;
                lastUpdated = value;
            }
        }
        Session sess = (Session)Stripersist.getEntityManager().getDelegate();
        Criteria c = sess.createCriteria(SolrConf.class);
        if (filterName != null && filterName.length() > 0) {
            Criterion nameCrit = Restrictions.ilike((String)"name", (String)filterName, (MatchMode)MatchMode.ANYWHERE);
            c.add(nameCrit);
        }
        if (lastUpdated != null && lastUpdated.length() > 0) {
            Criterion lastUpdatedCrit = Restrictions.ilike((String)"lastUpdated", (String)lastUpdated, (MatchMode)MatchMode.ANYWHERE);
            c.add(lastUpdatedCrit);
        }
        int rowCount = c.list().size();
        c.setMaxResults(this.limit.intValue());
        c.setFirstResult(this.start.intValue());
        List sources = c.list();
        for (SolrConf config : sources) {
            JSONObject j = config.toJSON();
            jsonData.put((Object)j);
        }
        JSONObject grid = new JSONObject();
        grid.put("totalCount", rowCount);
        grid.put("gridrows", (Object)jsonData);
        return new StreamingResolution("application/json", grid.toString());
    }

    public Resolution getSearchconfigData() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        List configs = em.createQuery("FROM SolrConf").getResultList();
        JSONArray searchconfigs = new JSONArray();
        for (SolrConf solrConfig : configs) {
            JSONObject config = new JSONObject();
            config.put("id", (Object)solrConfig.getId());
            config.put("name", (Object)solrConfig.getName());
            searchconfigs.put((Object)config);
        }
        return new StreamingResolution("application/json", searchconfigs.toString(4));
    }

    public Resolution getAttributesList() throws JSONException {
        JSONArray jsonData = new JSONArray();
        ArrayList<SimpleFeatureType> featureTypes = new ArrayList<SimpleFeatureType>();
        if (this.simpleFeatureTypeId != null && this.simpleFeatureTypeId != -1L) {
            SimpleFeatureType sft = (SimpleFeatureType)Stripersist.getEntityManager().find(SimpleFeatureType.class, (Object)this.simpleFeatureTypeId);
            if (sft != null) {
                featureTypes.add(sft);
            }
        } else {
            throw new IllegalArgumentException("No simpleFeatureType id provided");
        }
        Session sess = (Session)Stripersist.getEntityManager().getDelegate();
        Criteria c = sess.createCriteria(AttributeDescriptor.class);
        DetachedCriteria c2 = DetachedCriteria.forClass(SimpleFeatureType.class);
        ArrayList<Long> ftIds = new ArrayList<Long>();
        for (SimpleFeatureType sft : featureTypes) {
            ftIds.add(sft.getId());
        }
        c2.add(Restrictions.in((String)"id", ftIds));
        c2.createAlias("attributes", "attr");
        c2.setProjection((Projection)Projections.property((String)"attr.id"));
        c.add(Property.forName((String)"id").in(c2));
        int rowCount = c.list().size();
        List attrs = c.list();
        for (AttributeDescriptor attr : attrs) {
            boolean indexChecked = false;
            boolean resultChecked = false;
            if (this.solrConfiguration != null) {
                for (String configAttribute : this.solrConfiguration.getIndexAttributes()) {
                    if (!configAttribute.equals(attr.getName())) continue;
                    indexChecked = true;
                    break;
                }
                for (String resultAttribute : this.solrConfiguration.getResultAttributes()) {
                    if (!resultAttribute.equals(attr.getName())) continue;
                    resultChecked = true;
                    break;
                }
            }
            JSONObject j = new JSONObject();
            j.put("id", attr.getId().intValue());
            j.put("alias", (Object)attr.getAlias());
            j.put("attribute", (Object)attr.getName());
            j.put("indexChecked", indexChecked);
            j.put("resultChecked", resultChecked);
            jsonData.put((Object)j);
        }
        JSONObject grid = new JSONObject();
        grid.put("totalCount", rowCount);
        grid.put("gridrows", (Object)jsonData);
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

