/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.admin.stripes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontBind;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import nl.b3p.i18n.LocalizableActionBean;
import nl.b3p.viewer.config.services.AttributeDescriptor;
import nl.b3p.viewer.config.services.FeatureSource;
import nl.b3p.viewer.config.services.FeatureTypeRelation;
import nl.b3p.viewer.config.services.FeatureTypeRelationKey;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/featuretyperelation/{$event}")
public class FeatureTypeRelationActionBean
extends LocalizableActionBean {
    private ActionBeanContext context;
    private static final String JSP = "/WEB-INF/jsp/services/featuretyperelation.jsp";
    private static final String EDITJSP = "/WEB-INF/jsp/services/editfeaturetyperelation.jsp";
    private List<FeatureTypeRelation> relations = new ArrayList();
    private List<SimpleFeatureType> featureTypes = new ArrayList();
    private List<SimpleFeatureType> foreignFeatureTypes = new ArrayList();
    private List<FeatureSource> featureSources = new ArrayList();
    private Long featureSourceId;
    private Long featureTypeId;
    @Validate
    private Map<Integer, Long> leftSide = new HashMap();
    private Map<Integer, Long> rightSide = new HashMap();
    @Validate
    private int page;
    @Validate
    private int start;
    @Validate
    private int limit;
    @Validate
    private String sort;
    @Validate
    private String dir;
    @Validate
    private JSONArray filter;
    @Validate
    @ValidateNestedProperties(value={@Validate(field="featureType", required=true, on={"save"}), @Validate(field="foreignFeatureType", required=true, on={"save"}), @Validate(field="type", required=true, on={"save"})})
    private FeatureTypeRelation relation;

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution(JSP);
    }

    public Resolution save() {
        Iterator it = this.leftSide.keySet().iterator();
        this.relation.getRelationKeys().clear();
        while (it.hasNext()) {
            Integer i = (Integer)it.next();
            Long leftId = (Long)this.leftSide.get(i);
            Long rightId = (Long)this.rightSide.get(i);
            if (leftId == null || rightId == null || leftId == -1L || rightId == -1L) {
                this.getContext().getMessages().add(new SimpleError(this.getBundle().getString("viewer_admin.featuretyperelationactionbean.relmissing"), new Object[0]));
                return new ForwardResolution(EDITJSP);
            }
            AttributeDescriptor left = (AttributeDescriptor)Stripersist.getEntityManager().find(AttributeDescriptor.class, (Object)leftId);
            AttributeDescriptor right = (AttributeDescriptor)Stripersist.getEntityManager().find(AttributeDescriptor.class, (Object)rightId);
            FeatureTypeRelationKey key = new FeatureTypeRelationKey(this.relation, left, right);
            this.relation.getRelationKeys().add(key);
        }
        Stripersist.getEntityManager().persist((Object)this.relation);
        Stripersist.getEntityManager().getTransaction().commit();
        this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.featuretyperelationactionbean.relsaved"), new Object[0]));
        return new ForwardResolution(EDITJSP);
    }

    public Resolution edit() {
        this.featureSources = Stripersist.getEntityManager().createQuery("from FeatureSource").getResultList();
        if (this.relation != null && this.relation.getFeatureType() != null) {
            this.featureTypes = Stripersist.getEntityManager().createQuery("from SimpleFeatureType s where s.featureSource = :f").setParameter("f", (Object)this.relation.getFeatureType().getFeatureSource()).getResultList();
        }
        if (this.relation != null && this.relation.getForeignFeatureType() != null) {
            this.foreignFeatureTypes = Stripersist.getEntityManager().createQuery("from SimpleFeatureType s where s.featureSource = :f").setParameter("f", (Object)this.relation.getForeignFeatureType().getFeatureSource()).getResultList();
        }
        Stripersist.getEntityManager().getTransaction().commit();
        return new ForwardResolution(EDITJSP);
    }

    @DontBind
    public Resolution cancel() {
        return new ForwardResolution(EDITJSP);
    }

    public Resolution delete() {
        Stripersist.getEntityManager().remove((Object)this.relation);
        Stripersist.getEntityManager().getTransaction().commit();
        this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.featuretyperelationactionbean.relrem"), new Object[0]));
        return new ForwardResolution(EDITJSP);
    }

    @DontValidate
    public Resolution getGridData() throws JSONException {
        JSONArray jsonData = new JSONArray();
        String filterFeaturetype = "";
        String filterForeignFeaturetype = "";
        Session sess = (Session)Stripersist.getEntityManager().getDelegate();
        Criteria c = sess.createCriteria(FeatureTypeRelation.class);
        c.createAlias("featureType", "f");
        c.createAlias("f.featureSource", "fs");
        c.createAlias("foreignFeatureType", "ff");
        c.createAlias("ff.featureSource", "ffs");
        if (this.sort != null && this.dir != null) {
            Object order = null;
            if (this.sort.equals("featuretype") || this.sort.equals("foreignFeaturetype")) {
                this.sort = "f";
                if (this.sort.equals("foreignFeaturetype")) {
                    this.sort = "ff";
                }
                String sort1 = this.sort + "s.name";
                String sort2 = this.sort + ".typeName";
                String sort3 = this.sort + ".description";
                if (this.dir.equals("ASC")) {
                    c.addOrder(Order.asc((String)sort1).ignoreCase());
                    c.addOrder(Order.asc((String)sort2).ignoreCase());
                    c.addOrder(Order.asc((String)sort3).ignoreCase());
                } else {
                    c.addOrder(Order.desc((String)sort1).ignoreCase());
                    c.addOrder(Order.desc((String)sort2).ignoreCase());
                    c.addOrder(Order.desc((String)sort3).ignoreCase());
                }
            }
        }
        if (this.getFilter() != null) {
            for (int k = 0; k < this.getFilter().length(); ++k) {
                JSONObject j = this.getFilter().getJSONObject(k);
                String property = j.getString("property");
                String value = j.getString("value");
                if (!property.equals("featuretype") && !property.equals("foreignFeaturetype")) continue;
                if (property.equals("featuretype")) {
                    property = "f";
                } else if (property.equals("foreignFeaturetype")) {
                    property = "ff";
                }
                String filt1 = property + "s.name";
                String filt2 = property + ".typeName";
                String filt3 = property + ".description";
                c.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)filt1, (String)value, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)filt2, (String)value, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.ilike((String)filt3, (String)value, (MatchMode)MatchMode.ANYWHERE))));
            }
        }
        int rowCount = c.list().size();
        c.setMaxResults(this.limit);
        c.setFirstResult(this.start);
        List relations = c.list();
        for (FeatureTypeRelation relation : relations) {
            JSONObject j = this.getGridRow(relation.getId().intValue(), relation.getFeatureType(), relation.getForeignFeatureType());
            jsonData.put((Object)j);
        }
        JSONObject grid = new JSONObject();
        grid.put("totalCount", rowCount);
        grid.put("gridrows", (Object)jsonData);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Resolution getAttributesForFeaturetype() throws JSONException {
        JSONObject json = new JSONObject();
        boolean success = false;
        SimpleFeatureType featureType = (SimpleFeatureType)Stripersist.getEntityManager().find(SimpleFeatureType.class, (Object)this.featureTypeId);
        if (featureType != null) {
            JSONArray array = new JSONArray();
            List attributes = featureType.getAttributes();
            for (AttributeDescriptor attr : attributes) {
                if (AttributeDescriptor.GEOMETRY_TYPES.contains(attr.getType())) continue;
                JSONObject ob = new JSONObject();
                ob.put("id", (Object)attr.getId());
                if (attr.getAlias() != null) {
                    ob.put("name", (Object)attr.getAlias());
                } else {
                    ob.put("name", (Object)attr.getName());
                }
                array.put((Object)ob);
            }
            json.put("attributes", (Object)array);
            success = true;
        } else {
            json.put("error", (Object)this.getBundle().getString("viewer_admin.featuretyperelationactionbean.noftfound"));
        }
        json.put("success", success);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Resolution getFeatureTypesForSource() throws JSONException {
        JSONObject json = new JSONObject();
        boolean success = false;
        if (this.featureSourceId == null) {
            json.put("error", (Object)"No featureSourceId found");
        } else {
            FeatureSource featureSource = (FeatureSource)Stripersist.getEntityManager().find(FeatureSource.class, (Object)this.featureSourceId);
            if (featureSource != null) {
                JSONArray array = new JSONArray();
                List featureTypes = featureSource.getFeatureTypes();
                for (SimpleFeatureType ft : featureTypes) {
                    JSONObject ob = new JSONObject();
                    ob.put("id", (Object)ft.getId());
                    String name = ft.getTypeName();
                    if (!StringUtils.isBlank((CharSequence)ft.getDescription())) {
                        name = name + " (" + ft.getDescription() + ")";
                    }
                    ob.put("name", (Object)name);
                    array.put((Object)ob);
                }
                json.put("featuretypes", (Object)array);
                success = true;
            } else {
                json.put("error", (Object)this.getBundle().getString("viewer_admin.featuretyperelationactionbean.noftfound"));
            }
        }
        json.put("success", success);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private JSONObject getGridRow(int i, SimpleFeatureType featuretype, SimpleFeatureType foreignFeaturetype) throws JSONException {
        JSONObject j = new JSONObject();
        j.put("id", i);
        String typeName = featuretype.getFeatureSource().getName() + ": " + featuretype.getTypeName();
        if (featuretype.getDescription() != null) {
            typeName = typeName + " (" + featuretype.getDescription() + ")";
        }
        j.put("featuretype", (Object)typeName);
        String foreignTypeName = foreignFeaturetype.getFeatureSource().getName() + ": " + foreignFeaturetype.getTypeName();
        if (foreignFeaturetype.getDescription() != null) {
            foreignTypeName = foreignTypeName + " (" + foreignFeaturetype.getDescription() + ")";
        }
        j.put("foreignFeaturetype", (Object)foreignTypeName);
        return j;
    }

    @ValidationMethod(on={"save"})
    public void validate(ValidationErrors errors) {
        if (this.relation != null && (this.leftSide.isEmpty() || this.rightSide.isEmpty())) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.featuretyperelationactionbean.relmiss"), new Object[0]));
            return;
        }
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public List<FeatureTypeRelation> getRelations() {
        return this.relations;
    }

    public void setRelations(List<FeatureTypeRelation> relations) {
        this.relations = relations;
    }

    public FeatureTypeRelation getRelation() {
        return this.relation;
    }

    public void setRelation(FeatureTypeRelation relation) {
        this.relation = relation;
    }

    public void setFeatureTypes(List<SimpleFeatureType> featureTypes) {
        this.featureTypes = featureTypes;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public JSONArray getFilter() {
        return this.filter;
    }

    public void setFilter(JSONArray filter) {
        this.filter = filter;
    }

    public List<SimpleFeatureType> getForeignFeatureTypes() {
        return this.foreignFeatureTypes;
    }

    public void setForeignFeatureTypes(List<SimpleFeatureType> foreignFeatureTypes) {
        this.foreignFeatureTypes = foreignFeatureTypes;
    }

    public List<FeatureSource> getFeatureSources() {
        return this.featureSources;
    }

    public void setFeatureSources(List<FeatureSource> featureSources) {
        this.featureSources = featureSources;
    }

    public Long getFeatureSourceId() {
        return this.featureSourceId;
    }

    public void setFeatureSourceId(Long featureSourceId) {
        this.featureSourceId = featureSourceId;
    }

    public Long getFeatureTypeId() {
        return this.featureTypeId;
    }

    public void setFeatureTypeId(Long featureTypeId) {
        this.featureTypeId = featureTypeId;
    }

    public List<SimpleFeatureType> getFeatureTypes() {
        return this.featureTypes;
    }

    public Map<Integer, Long> getLeftSide() {
        return this.leftSide;
    }

    public void setLeftSide(Map<Integer, Long> leftSide) {
        this.leftSide = leftSide;
    }

    public Map<Integer, Long> getRightSide() {
        return this.rightSide;
    }

    public void setRightSide(Map<Integer, Long> rightSide) {
        this.rightSide = rightSide;
    }
}

