/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.audit;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import nl.b3p.viewer.audit.LoggingService;
import nl.b3p.viewer.audit.impl.DefaultLoggingService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public interface LoggingServiceFactory {
    public static final Log LOG = LogFactory.getLog(LoggingServiceFactory.class);

    public static List<LoggingService> getInstances() {
        ServiceLoader<LoggingService> services = ServiceLoader.load(LoggingService.class);
        ArrayList<LoggingService> loggingServices = new ArrayList<LoggingService>();
        services.iterator().forEachRemaining(loggingServices::add);
        return loggingServices;
    }

    public static LoggingService getInstance() {
        List<LoggingService> loggingServices = LoggingServiceFactory.getInstances();
        LoggingService service = null;
        if (loggingServices.size() == 1) {
            service = loggingServices.get(0);
        } else {
            while (loggingServices.iterator().hasNext()) {
                service = loggingServices.iterator().next();
                LOG.debug((Object)("found audit log provider: " + service));
                if (service instanceof DefaultLoggingService) continue;
            }
        }
        LOG.debug((Object)("using audit log provider: " + service));
        return service;
    }
}

