/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.arcims;

import java.io.IOException;
import nl.b3p.geotools.data.arcims.ArcIMSDataStore;
import nl.b3p.geotools.data.arcims.ArcIMSFeatureReader;
import nl.b3p.geotools.data.arcims.axl.AxlFClass;
import nl.b3p.geotools.data.arcims.axl.AxlFieldInfo;
import nl.b3p.geotools.data.arcims.axl.AxlLayerInfo;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.sort.SortBy;

public class ArcIMSFeatureSource
extends ContentFeatureSource {
    public ArcIMSFeatureSource(ContentEntry ce) {
        super(ce, null);
    }

    public QueryCapabilities buildQueryCapabilities() {
        return new QueryCapabilities(){

            public boolean isJoiningSupported() {
                return false;
            }

            public boolean isOffsetSupported() {
                return true;
            }

            public boolean isReliableFIDSupported() {
                return true;
            }

            public boolean isVersionSupported() {
                return false;
            }

            public boolean supportsSorting(SortBy[] attributes) {
                return false;
            }
        };
    }

    protected boolean canFilter() {
        return true;
    }

    protected boolean canLimit() {
        return true;
    }

    protected boolean canOffset() {
        return true;
    }

    protected ArcIMSDataStore getArcIMSDataStore() {
        return (ArcIMSDataStore)this.getDataStore();
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected int getCountInternal(Query query) throws IOException {
        return new ArcIMSFeatureReader(this, query).getCount();
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return new ArcIMSFeatureReader(this, query);
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        AxlLayerInfo al = this.getArcIMSDataStore().getAxlLayerInfo(this.entry.getTypeName());
        AxlFClass fc = al.getFclass();
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName(al.getId());
        for (AxlFieldInfo f : fc.getFields()) {
            if (f.getType() == -98) {
                b.add(f.getName(), f.getBinding(fc), this.getArcIMSDataStore().getCRS());
                continue;
            }
            b.add(f.getName(), f.getBinding(fc));
        }
        return b.buildFeatureType();
    }

    protected String findRowIdAttribute() throws IOException {
        AxlLayerInfo al = this.getArcIMSDataStore().getAxlLayerInfo(this.entry.getTypeName());
        AxlFClass fc = al.getFclass();
        for (AxlFieldInfo f : fc.getFields()) {
            if (-99 != f.getType()) continue;
            return f.getName();
        }
        return null;
    }
}

