/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.arcims;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import nl.b3p.geotools.data.arcims.axl.ArcXML;
import nl.b3p.geotools.data.arcims.axl.AxlRequest;
import nl.b3p.geotools.data.arcims.axl.AxlResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.ows.AbstractRequest;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.ows.Response;
import org.geotools.ows.ServiceException;

public class ArcXMLRequest
extends AbstractRequest {
    private static final Log log = LogFactory.getLog(ArcXMLRequest.class);
    AxlRequest request;

    public ArcXMLRequest(URL onlineResource, String serviceName, AxlRequest request) {
        super(onlineResource, new Properties());
        this.request = request;
        if (serviceName != null) {
            this.properties.setProperty("ServiceName", serviceName);
        }
        this.properties.setProperty("ClientVersion", "4.0");
        this.properties.setProperty("Form", "false");
        this.properties.setProperty("Encode", "false");
    }

    protected void initRequest() {
    }

    protected void initService() {
    }

    protected void initVersion() {
    }

    protected String processKey(String key) {
        if ("SERVICENAME".equals(key)) {
            return "ServiceName";
        }
        return key;
    }

    public void performPostOutput(OutputStream out) throws IOException {
        try {
            ArcXML.getJaxbContext().createMarshaller().marshal((Object)new ArcXML(this.request), out);
        }
        catch (JAXBException ex) {
            throw new IOException("Cannot marshal request", ex);
        }
    }

    public Response createResponse(HTTPResponse httpr) throws ServiceException, IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    public AxlResponse parseResponse(HTTPResponse httpr) throws Exception {
        long startTime = System.currentTimeMillis();
        ArcXML axl = (ArcXML)ArcXML.getJaxbContext().createUnmarshaller().unmarshal(httpr.getResponseStream());
        if (log.isDebugEnabled()) {
            log.debug((Object)("ArcXML unmarshal time (includes server time): " + (System.currentTimeMillis() - startTime) + " ms"));
        }
        return axl.getResponse();
    }
}

