/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.arcims.axl;

import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import nl.b3p.geotools.data.arcims.ArcXMLUtils;
import nl.b3p.geotools.data.arcims.axl.AxlFeature;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class AxlField {
    public static final int TYPE_ROW_ID = -99;
    public static final int TYPE_SHAPE = -98;
    public static final int TYPE_BOOLEAN = -7;
    public static final int TYPE_BIG_INTEGER = -5;
    public static final int TYPE_CHAR = 1;
    public static final int TYPE_INTEGER = 4;
    public static final int TYPE_SMALL_INTEGER = 5;
    public static final int TYPE_FLOAT = 6;
    public static final int TYPE_DOUBLE = 8;
    public static final int TYPE_STRING = 12;
    public static final int TYPE_DATE = 91;
    @XmlAttribute
    private String name;
    @XmlAttribute
    private String value;
    @XmlTransient
    private AxlFeature feature;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static DateFormat createDateFormat() {
        return new SimpleDateFormat("{ts 'YYYY-MM-dd HH:mm:ss'}");
    }

    public Object getConvertedValue(Class binding, GeometryFactory geometryFactory) throws ParseException, IOException {
        if (this.value == null) {
            return null;
        }
        if (binding.equals(String.class)) {
            return this.value;
        }
        if (binding.equals(Boolean.class)) {
            return "true".equals(this.value);
        }
        if (this.value.trim().length() == 0) {
            return null;
        }
        if (binding.equals(Integer.class)) {
            return Integer.parseInt(this.value);
        }
        if (binding.equals(BigInteger.class)) {
            return new BigInteger(this.value);
        }
        if (binding.equals(Character.class)) {
            return Character.valueOf(this.value.charAt(0));
        }
        if (binding.equals(Float.class)) {
            return Float.valueOf(Float.parseFloat(this.value.replace(',', '.')));
        }
        if (binding.equals(Double.class)) {
            return Double.parseDouble(this.value.replace(',', '.'));
        }
        if (binding.equals(Date.class)) {
            return new Date(Long.parseLong(this.value));
        }
        if (binding.getName().startsWith("com.vividsolutions.jts.geom.")) {
            if (this.feature == null) {
                return null;
            }
            return ArcXMLUtils.convertToJTSGeometry(this.feature.getGeometry(), geometryFactory);
        }
        return null;
    }

    void afterUnmarshal(Unmarshaller u, Object parent) {
        if (parent instanceof AxlFeature) {
            this.feature = (AxlFeature)parent;
        }
    }
}

