/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ProxySelector;
import java.net.URL;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;

public class HttpClientConfigured {
    private static final Log log = LogFactory.getLog(HttpClientConfigured.class);
    private static int maxResponseTime = 20000;
    private static boolean allowSelfSignedCerts = false;
    private HttpClient httpClient;
    private HttpClientContext httpContext;

    public HttpClientConfigured(String username, String password, String url) {
        this(username, password, url, -1);
    }

    public HttpClientConfigured(String username, String password, String url, int timeout) {
        if (timeout < 0) {
            timeout = maxResponseTime;
        }
        boolean preemptive = false;
        RequestConfig defaultRequestConfig = RequestConfig.custom().setStaleConnectionCheckEnabled(false).setTargetPreferredAuthSchemes(Arrays.asList("Basic")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).setConnectionRequestTimeout(timeout).build();
        HttpClientBuilder hcb = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig);
        if (allowSelfSignedCerts) {
            try {
                SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                hcb.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
                log.info((Object)"SSL init for selfsigned certs successful.");
            }
            catch (Exception ex) {
                log.info((Object)("SSL init for selfsigned certs failed: " + ex.getLocalizedMessage()));
            }
        }
        HttpClientContext context = HttpClientContext.create();
        if (username != null && password != null) {
            String hostname = null;
            int port = -1;
            try {
                URL aURL = new URL(url);
                hostname = aURL.getHost();
                port = aURL.getPort();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(username, password);
            AuthScope authScope = new AuthScope(hostname, port);
            credentialsProvider.setCredentials(authScope, (Credentials)defaultcreds);
            hcb = hcb.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            if (preemptive && hostname != null) {
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                HttpHost targetHost = new HttpHost(hostname, port);
                authCache.put(targetHost, (AuthScheme)basicAuth);
                context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
                context.setAuthCache((AuthCache)authCache);
                log.debug((Object)("Preemptive credentials: hostname: " + hostname + ", port: " + port + ", username: " + username + ", password: ****."));
            }
        }
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        hcb.setRoutePlanner((HttpRoutePlanner)routePlanner);
        this.httpClient = hcb.build();
        this.httpContext = context;
    }

    public HttpResponse execute(HttpUriRequest method) throws IOException {
        return this.httpClient.execute(method, (HttpContext)this.httpContext);
    }

    public void close() {
        if (this.httpClient instanceof CloseableHttpClient) {
            try {
                ((CloseableHttpClient)this.httpClient).close();
            }
            catch (IOException ex) {
                log.info((Object)("Error closing HttpClient: " + ex.getLocalizedMessage()));
            }
        }
    }

    public void close(HttpResponse response) {
        if (response instanceof CloseableHttpResponse) {
            try {
                ((CloseableHttpResponse)response).close();
            }
            catch (IOException ex) {
                log.info((Object)("Error closing HttpResponse: " + ex.getLocalizedMessage()));
            }
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public HttpClientContext getContext() {
        return this.httpContext;
    }

    public void setContext(HttpClientContext context) {
        this.httpContext = context;
    }

    public static void setMaxResponseTime(int aMaxResponseTime) {
        maxResponseTime = aMaxResponseTime;
    }

    public static void setAllowSelfSignedCerts(boolean assc) {
        allowSelfSignedCerts = assc;
    }
}

