/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.arcims;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.io.Writer;
import nl.b3p.geotools.data.arcims.ArcXMLUtils;
import nl.b3p.geotools.data.arcims.axl.AxlBuffer;
import nl.b3p.geotools.data.arcims.axl.AxlSpatialFilter;
import nl.b3p.geotools.data.arcims.axl.AxlSpatialQuery;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.IsNullImpl;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Intersects;

public class FilterToArcXMLSQL
extends FilterToSQL {
    protected AxlSpatialQuery axlQuery;
    boolean spatialOperatorAllowed = true;

    public FilterToArcXMLSQL(AxlSpatialQuery query) {
        this(null, query);
    }

    public FilterToArcXMLSQL(Writer w, AxlSpatialQuery axlQuery) {
        super(w);
        this.axlQuery = axlQuery;
        this.setInline(true);
    }

    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities caps = new FilterCapabilities();
        caps.addAll(FilterCapabilities.LOGICAL_OPENGIS);
        caps.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
        caps.addType(IsNullImpl.class);
        caps.addType(PropertyIsBetween.class);
        caps.addType(PropertyIsLike.class);
        caps.addType(Id.class);
        caps.addType(BBOX.class);
        caps.addType(Intersects.class);
        caps.addType(DWithin.class);
        caps.addType(16384L);
        return caps;
    }

    protected Object visit(BinaryLogicOperator filter, Object extraData) {
        String op = (String)extraData;
        boolean saveSpatialOpAllowed = this.spatialOperatorAllowed;
        if ("OR".equals(op)) {
            this.spatialOperatorAllowed = false;
        }
        Object r = super.visit(filter, extraData);
        this.spatialOperatorAllowed = saveSpatialOpAllowed;
        return r;
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        if (this.axlQuery.getSpatialFilter() != null) {
            throw new RuntimeException("Only a single spatial operator is supported");
        }
        if (!this.spatialOperatorAllowed) {
            throw new RuntimeException("Spatial operator not allowed in this position in filter");
        }
        if (this.featureType != null && property.getPropertyName() != null && !this.featureType.getGeometryDescriptor().getLocalName().equals(property.getPropertyName())) {
            throw new RuntimeException("Spatial operator only supported on default geometry property");
        }
        Geometry geom = (Geometry)geometry.getValue();
        AxlSpatialFilter axlFilter = new AxlSpatialFilter();
        this.axlQuery.setSpatialFilter(axlFilter);
        if (filter instanceof BBOX) {
            axlFilter.setGeometryOrEnvelope(ArcXMLUtils.convertToAxlEnvelope((Polygon)geom));
            axlFilter.setRelation("envelope_intersection");
        } else if (filter instanceof Intersects) {
            axlFilter.setGeometryOrEnvelope(ArcXMLUtils.convertToAxlGeometry(geom));
            axlFilter.setRelation("area_intersection");
        } else if (filter instanceof DWithin) {
            axlFilter.setGeometryOrEnvelope(ArcXMLUtils.convertToAxlGeometry(geom));
            axlFilter.setRelation("area_intersection");
            axlFilter.setBuffer(new AxlBuffer(((DWithin)filter).getDistance()));
        }
        try {
            this.out.write("1=1");
        }
        catch (IOException ex) {
            throw new RuntimeException("io problem writing filter", ex);
        }
        return null;
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, Object extraData) {
        throw new RuntimeException("ArcXML spatial operators only supported for default geometry and a literal operand");
    }
}

